/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;
import net.sf.jaxodraw.util.JaxoLanguage;

public abstract class JaxoEditPanel
extends JPanel {
    private transient GridLayout panelLayout = new GridLayout(1, 2, 10, 0);
    private transient GridLayout oneColumnPanelLayout = new GridLayout(1, 1, 10, 0);
    private transient Dimension checkBoxPanelSize = new Dimension(110, 60);

    protected JaxoEditPanel() {
        this(null);
    }

    protected JaxoEditPanel(LayoutManager l) {
        super(l, false);
    }

    protected void setLineBoxLayout() {
        this.setLayout(new BoxLayout(this, 2));
    }

    protected TitledBorder createI18NBorder(String key) {
        return new JaxoTitledBorder(JaxoLanguage.translate(key));
    }

    protected JLabel createI18NLabel(String key) {
        return new JLabel(JaxoLanguage.label(key), 11);
    }

    protected TitledBorder createBorder(String title) {
        return new JaxoTitledBorder(title);
    }

    protected JLabel createLabel(String title) {
        return new JLabel(title, 11);
    }

    protected JSpinner getSpinner(float value, float min, float max, float step, String name) {
        SpinnerNumberModel modelstin = new SpinnerNumberModel(value, min, max, step);
        JaxoFixedJSpinner spstin = new JaxoFixedJSpinner(modelstin);
        spstin.setName(name);
        return spstin;
    }

    protected JSpinner getSpinner(int value, int min, int max, int step, String name) {
        SpinnerNumberModel modelstin = new SpinnerNumberModel(value, min, max, step);
        JaxoFixedJSpinner spstin = new JaxoFixedJSpinner(modelstin);
        spstin.setName(name);
        return spstin;
    }

    public abstract void addEditPanelListener(JaxoEditPanelListener var1);

    protected GridLayout getPanelLayout() {
        return this.panelLayout;
    }

    protected void setPanelLayout(GridLayout newLayout) {
        this.panelLayout = newLayout;
    }

    protected GridLayout getOneColumnPanelLayout() {
        return this.oneColumnPanelLayout;
    }

    protected void setOneColumnPanelLayout(GridLayout newLayout) {
        this.oneColumnPanelLayout = newLayout;
    }

    protected Dimension getCheckBoxPanelSize() {
        return this.checkBoxPanelSize;
    }

    protected void setCheckBoxPanelSize(Dimension newSize) {
        this.checkBoxPanelSize = newSize;
    }
}

