/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.fill;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoExtendedObject;
import net.sf.jaxodraw.object.JaxoFillColorObject;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoGeometry;

public abstract class JaxoFillObject
extends JaxoExtendedObject
implements JaxoFillColorObject {
    private static final long serialVersionUID = 2L;
    private Color fillColor;
    private boolean filled = true;

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color color) {
        Color old = this.fillColor;
        this.fillColor = color;
        this.firePropertyChange("fillColor", old, this.fillColor);
    }

    public final boolean isFilled() {
        return this.filled;
    }

    public final void setFilled(boolean value) {
        Boolean old = this.filled;
        this.filled = value;
        this.firePropertyChange("filled", old, this.filled);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoFillObject tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoFillObject && (tmp = (JaxoFillObject)comp).getFillColor().equals(this.getFillColor()) && tmp.isFilled() == this.isFilled() && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoFillObject temp) {
        super.copyFrom(temp);
        this.setFillColor(temp.getFillColor());
        this.setFilled(temp.isFilled());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoFillObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoFillObject)o);
    }

    public void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        this.setLocation((int)Math.round(newP.getX()), (int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    public void setPreferences() {
        super.setPreferences();
        this.setFilled(true);
        this.setFillColor(JaxoColor.getDefaultFillColor(this.getColor()));
    }
}

