/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.jaxodraw.util.JaxoLog;

public class JaxoSoundsHandler
implements Runnable {
    private static final int EXTERNAL_BUFFER_SIZE = 524288;
    private final String filename;
    private final int curPosition;

    public JaxoSoundsHandler(String wavfile) {
        this.filename = wavfile;
        this.curPosition = 0;
    }

    public JaxoSoundsHandler(String wavfile, int curP) {
        this.filename = wavfile;
        this.curPosition = curP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(Thread.currentThread().getContextClassLoader().getResource(this.filename));
        }
        catch (UnsupportedAudioFileException e1) {
            JaxoLog.debug(e1);
            return;
        }
        catch (IOException e1) {
            JaxoLog.debug(e1);
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        SourceDataLine auline = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            auline = (SourceDataLine)AudioSystem.getLine(info);
            auline.open(format);
        }
        catch (LineUnavailableException e) {
            JaxoLog.debug(e);
            return;
        }
        catch (Exception e) {
            JaxoLog.debug(e);
            return;
        }
        if (auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl pan = (FloatControl)auline.getControl(FloatControl.Type.PAN);
            if (this.curPosition == 1) {
                pan.setValue(1.0f);
            } else if (this.curPosition == -1) {
                pan.setValue(-1.0f);
            }
        }
        auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead < 0) continue;
                auline.write(abData, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            JaxoLog.debug(e);
            return;
        }
        finally {
            auline.drain();
            auline.close();
        }
    }
}

