/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic.pages;

import java.net.*;
import java.util.*;

import org.apache.log4j.*;
import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.util.*;

public class MultipleAlbumsPage
{
	private static Logger logger = Logger.getLogger(MultipleAlbumsPage.class);

	private String html = null;

	/**
	 * Constructor
	 */
	public MultipleAlbumsPage(String html)
		throws Exception
	{
		this.html = html;
	}

	/**
	 * Process multiple albums listing page
	 * @param album DOCUMENT ME!
	 * @param html DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Album getAlbum(Album album)
		throws Exception
	{
		//Multiple album pages will have at the top: "albums with titles like"
		//If the page is missing this phrase, dont bother processing.
		RE check = new RE("Album Search Results for");
		if (check.match(html) == false)
		{
			return album;
		}

		Vector albumNames = new Vector();
		Vector albumUrls = new Vector();
		Vector artistNames = new Vector();

		/*
			<tr class="visible" id="trlink" onclick="z('10:y2j97iajg74r')">
		 <td class="sorted-cell"><div class="bar" style="width:56px;">&nbsp;</div></td>
			 <td class="cell">1977</TD>
		 <td class="cell" style="width:172px;word-wrap:break-word;">Aerosmith</TD>
			 <td class="cell-img"><a href="/cg/amg.dll?p=amg&sql=60: ">
			  <img src="/i/pages/site/icons/speaker.gif" border="0" alt="Listen Now!" title="Listen Now!" style="padding-top:1px;padding-right:2px;" /></a></TD>
			 <td class="cell" style="width:172px;word-wrap:break-word;">
		 <a href="/cg/amg.dll?p=amg&sql=10:xt4uakok5m3n">Draw the Line</a></TD>
			 <td class="cell-img"><a href="http://service.bfast.com/bfast/click?bfmid=2181&sourceid=40140226&bfpid=074645736426&bfmtype=music" target="_blank"><img src="/i/pages/site/icons/cart.gif" alt="Buy Now!" title="Buy Now!" style="padding-top:1px;padding-right:2px;" border="0" /></a></td>
		 <td class="cell" style="width:69px;word-wrap:break-word;">Columbia</TD>
			 <td class="cell" style="width:55px;word-wrap:break-word;"><a href="/cg/amg.dll?p=amg&sql=73:20">Rock</a></td>
			</tr>
		 */

		//Get a list of all the albums
		RE hits = new RE("<tr class=\"visible\" .*?<td .*?<td .*?<td .*?>(.*?)</TD><td .*?<td .*?sql=(.*?)\">(.*?)</a></TD><td .*?<td .*?<td .*?</tr>");

		//Dont match against the artist name if it contains "various"
		RE findVariousRE = new RE("various", RE.MATCH_CASEINDEPENDENT);
		boolean skipArtistName = findVariousRE.match(album.getSearchArtistName());
		int index = 0;

		while (hits.match(html, index))
		{
			artistNames.add(hits.getParen(1));
			albumNames.add(hits.getParen(3));
			albumUrls.add("/cg/amg.dll?p=amg&token=&sql=" + hits.getParen(2));
			index = hits.getParenEnd(3);

			//logger.debug("artistName = " + artistNames.lastElement() +
			//	", albumName = " + albumNames.lastElement() +
			//   ", albumUrl = " + albumUrls.lastElement());
		}

		//If no hits found, just return
		if (albumNames.size() == 0)
		{
			return album;
		}

		//Now we have to decide which is the CORRECT album!
		Vector indexScores;

		//Match against either the artist name or album name
		if (skipArtistName)
		{
			indexScores = CompareStrings.findBestMatchingOrder(albumNames,
				album.getSearchAlbumName());
		}
		else
		{
			indexScores = CompareStrings.findBestMatchingOrder(artistNames,
				album.getSearchArtistName());
		}

		Iterator iter = indexScores.iterator();

		while (iter.hasNext())
		{
			int bestMatch = ( (IndexScore) iter.next()).getIndex();
			Album bestMatchAlbum = new Album(album.getAlbumDir());
			bestMatchAlbum.setFoundArtistName( (String) artistNames.elementAt(
				bestMatch));
			bestMatchAlbum.setFoundAlbumName( (String) albumNames.elementAt(
				bestMatch));
			bestMatchAlbum.setAlbumUrl( (String) albumUrls.elementAt(bestMatch));

			//Get the URL to the album page
			URL url = new URL("http://www.allmusic.com" +
									bestMatchAlbum.getAlbumUrl());
			html = NetUtil.doGet(url, null);

			AlbumPage albumPage = new AlbumPage(html);
			bestMatchAlbum = albumPage.getAlbum(bestMatchAlbum);

			if (bestMatchAlbum.isFound())
			{
				return bestMatchAlbum;
			}
		}

		return album;
	}
}
