package typecontrol.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

import typecontrol.CTypeControl;
import typecontrol.IdksTypeControl;

public class JdksColorChooser extends JLabel implements IdksTypeControl {

	private static final long serialVersionUID = 1L;

	private GUI _gui;
	private Action _action; 
	private CTypeControl _typeControl; 
	
	public JdksColorChooser(String label, String info) {
		super();
		initialize(label, info);
	}
	
	public JdksColorChooser(String label) {
		super();
		initialize(label, "");
	}
	
	private void initialize(String label, String info) {
		_typeControl = new CTypeControl();
		_typeControl.setLabel(label);
		_typeControl.setInfo(info);
		_action = new Action();
		_gui = new GUI();
	}
		
	public String getValue() {
		Color color = _gui.getLabControl().getBackground();
		return "RGB(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + ")";
	}

	public void setValue(String value) {
		String temp = value.replace("RGB(", "");
		temp = temp.replace(")", "");
		String values[] = temp.split(",");
		if (values.length != 4) {
			return;
		}
		_gui.getLabControl().setBackground(new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3])));
		raiseChangeListener(this);
	}
	
	public void setInfo(String info) {
		_typeControl.setInfo(info);
		_gui.rebuildGUI();
	}
	
	public void setLabel(String label) {
		_typeControl.setLabel(label);
		_gui.rebuildGUI();
	}
	
	public void setNormalBackground(Color background) {}
	
	public void setEnabled(Boolean enabled) {
		_gui.getLabControl().setEnabled(enabled);
	}
	
	public boolean isEnabled() {
		return _gui.getLabControl().isEnabled();
	}
	
	private void labControl_Click() {
		Color result = JColorChooser.showDialog(this, "Slectionnez une couleur", _gui.getLabControl().getBackground());
		if (result != null) {
			_gui.getLabControl().setBackground(result);
		}
		raiseChangeListener(this);
	}
	
	private class GUI {
		protected static final String LAB_CONTROL_NAME = "labControl";
		
		private JLabel _labControl;
		private JPanel _panButtons;
		
		public GUI() {
			rebuildGUI();
		}
		
		protected void rebuildGUI() {
			setLayout(new BorderLayout());
			removeAll();
			if (_typeControl.isLabelled()) {
				add(getLabLabel(), BorderLayout.WEST);
			}
			
			add(getLabControl(), BorderLayout.CENTER);

			_panButtons = null;
			add(getPanButtons(), BorderLayout.EAST);
			updateUI();
		}
				
		protected JPanel getPanButtons() {
			if (_panButtons == null) {
				_panButtons = new JPanel();
				_panButtons.setLayout(new BorderLayout());
				if (_typeControl.getInfo() != null && !_typeControl.getInfo().equals("")) {
					_panButtons.add(getBtnInfo(), BorderLayout.EAST);
				}
			}
			return _panButtons;
		}

		protected JLabel getLabControl() {
			if (_labControl == null) {
				_labControl = new JLabel();
				_labControl.setOpaque(true);
				_labControl.setBorder(BorderFactory.createEtchedBorder());
				_labControl.setName(LAB_CONTROL_NAME);
				_labControl.addMouseListener(_action);
			}
			return _labControl;
		}
	
	}
	
	private class Action implements MouseListener {
		public void mouseClicked(MouseEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(GUI.LAB_CONTROL_NAME)) {
				labControl_Click();
			}
		}

		public void mouseEntered(MouseEvent arg0) {}

		public void mouseExited(MouseEvent arg0) {}

		public void mousePressed(MouseEvent arg0) {}

		public void mouseReleased(MouseEvent arg0) {}
	}

	public void addChangeListener(ChangeListener changeListener) {
		_typeControl.addChangeListener(changeListener);
	}

	public JButton getBtnInfo() {
		return _typeControl.getBtnInfo();
	}

	public Color getFocusBackground() {
		return _typeControl.getFocusBackground();
	}

	public String getInfo() {
		return _typeControl.getInfo();
	}

	public String getLabel() {
		return _typeControl.getLabel();
	}

	public JLabel getLabLabel() {
		return _typeControl.getLabLabel();
	}

	public void raiseChangeListener(IdksTypeControl source) {
		_typeControl.raiseChangeListener(source);
	}

	public void removeChangeListener(ChangeListener changeListener) {
		_typeControl.removeChangeListener(changeListener);
	}

	public void setFocusBackground(Color focusBackground) {
		_typeControl.setFocusBackground(focusBackground);
	}

	public void setLabelAlignment(int alignment) {
		_typeControl.setLabelAlignment(alignment);
	}

	public void setLabelWidth(int width) {
		_typeControl.setLabelWidth(width);
	}
}
