package dks.src.gradientEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;

/**
 * This panel is an PropertySheet for modify a gradient <br> date : 3 sept. 07
 * @author   DarK Sidious
 */
public class JdksGradientEditor extends JPanel {

	private static final long serialVersionUID = 5266234090677877424L;

	protected static final String PROPERTY_COLOR_DESCRIPTION = "Dfinit la couleur du dgrad";
	protected static final String SUBPROPERTY_POSITION_DESCRIPTION = "Dfinit la position de la couleur en pourcentage";
	protected static final String SUBPROPERTY_COLOR_DESCRIPTION = "Dfinit la couleur";
	protected static final String PROPERTY_COLOR_TITLE = "Couleur ";
	protected static final String SUBPROPERTY_POSITION_TITLE = "position";
	protected static final String SUBPROPERTY_COLOR_TITLE = "couleur";

	public static final String PROPERTY_COLOR_NAME = "Couleur ";
	public static final String SUBPROPERTY_POSITION_NAME = "position";
	public static final String SUBPROPERTY_COLOR_NAME = "couleur";

	public static final String GRADIENT_EDITOR_NAME = "grdEditor";

	public static final String ANGLE_PROPERTY_NAME = "AngleProperty";
	public static final String RADIAL_PROPERTY_NAME = "RadialProperty";
	public static final String BTN_ADD_COLOR_NAME = "btnAddColor";
	public static final String BTN_REMOVE_COLOR_NAME = "btnRemoveColor";
	public static final String TAB_COLOR_NAME = "tabColors";

	protected static final String ANGLE_PROPERTY_TITLE = "Angle";
	protected static final String ANGLE_PROPERTY_DESCRIPTION = "Angle du dgrad par rapport  l'horizontale (en )";

	protected static final String RADIAL_PROPERTY_TITLE = "Dgrad radial";
	protected static final String RADIAL_PROPERTY_DESCRIPTION = "Dfinit s'il s'agit d'un dgrad arrondit";

	protected transient GUI _gui;
	protected transient Action _actionListener;
	protected transient PropertyChange _propertyChangeListener;
	protected transient List<ChangeListener> _changeListener;

	protected CGradient _gradient;

	public JdksGradientEditor() {
		initialize();
	}

	/**
	 * @param changeListener the ChangeListener to add
	 */
	public void addChangeListener(ChangeListener changeListener) {
		_changeListener.add(changeListener);
	}

	/**
	 * @param changeListener the ChangeListener to remove
	 */
	public void removeChangeListener(ChangeListener changeListener) {
		_changeListener.remove(changeListener);
	}

	/**
	 * Reload the PropertySheet with the properties of the gradient
	 */
	public void reloadModel() {
		_gui.getTabColors().setProperties(new DefaultProperty[0]);
		for (int i = 0; i < _gradient.size(); ++i) {
			final DefaultProperty colorProperty = (DefaultProperty) createProperty(SUBPROPERTY_COLOR_TITLE, SUBPROPERTY_COLOR_DESCRIPTION, Color.class, _gradient.get(i).getColor(), SUBPROPERTY_COLOR_NAME + Integer.valueOf(i).toString());
			final DefaultProperty colorPosition = (DefaultProperty) createProperty(SUBPROPERTY_POSITION_TITLE, SUBPROPERTY_POSITION_DESCRIPTION, Double.class, _gradient.get(i).getPosition(), SUBPROPERTY_POSITION_NAME + Integer.valueOf(i).toString());
			final DefaultProperty colorRoot = (DefaultProperty) createProperty(PROPERTY_COLOR_TITLE + (i + 1), PROPERTY_COLOR_DESCRIPTION, null, null, PROPERTY_COLOR_NAME + Integer.valueOf(i).toString());
			colorRoot.addSubProperty(colorProperty);
			colorRoot.addSubProperty(colorPosition);
			_gui.getTabColors().addProperty(colorRoot);
		}
		final DefaultProperty angleProperty = (DefaultProperty) createProperty(ANGLE_PROPERTY_TITLE, ANGLE_PROPERTY_DESCRIPTION, Integer.class, _gradient.getAngle(), ANGLE_PROPERTY_NAME);
		_gui.getTabColors().addProperty(angleProperty);
		final DefaultProperty radialProperty = (DefaultProperty) createProperty(RADIAL_PROPERTY_TITLE, RADIAL_PROPERTY_DESCRIPTION, Boolean.class, _gradient.isRadial(), RADIAL_PROPERTY_NAME);
		_gui.getTabColors().addProperty(radialProperty);
		refreshGradient(null);
	}

	/**
	 * @return the gradient to use
	 */
	public CGradient getGradient() {
		return _gradient;
	}

	/**
	 * @param gradient the gradient to use
	 */
	public void setGradient(CGradient gradient) {
		_gradient = gradient;
	}

	protected void initialize() {
		_changeListener = new LinkedList<ChangeListener>();
		_gradient = new CGradient();
		_gradient.add(new CGradientColor(new Color(0, 0, 0), 0));
		_gradient.add(new CGradientColor(new Color(255, 255, 255), 100));
		_actionListener = new Action();
		_propertyChangeListener = new PropertyChange();
		_gui = new GUI();
		reloadModel();
	}

	@SuppressWarnings("unchecked")
	protected Property createProperty(String displayName, String shortDescription, Class type, Object value, String name) {
		DefaultProperty property = new DefaultProperty();
		property.setDisplayName(displayName);
		property.setShortDescription(shortDescription);
		property.setType(type);
		property.setValue(value);
		property.setName(name);
		return property;
	}

	protected void btnAddColor_Click() {
		_gradient.add(new CGradientColor(new Color(255, 255, 255), 50));
		for (ChangeListener change : _changeListener) {
			change.stateChanged(new ChangeEvent(this));
		}
		reloadModel();
	}

	protected void btnRemoveColor_Click() {
		if (_gradient.size() > 2) {
			_gradient.remove(_gradient.size() - 1);
		}
		for (ChangeListener change : _changeListener) {
			change.stateChanged(new ChangeEvent(this));
		}
		reloadModel();
	}

	protected void tabColors_Change(Property property) {
		String name = property.getName();
		try {
			name = name.replace(SUBPROPERTY_COLOR_NAME, "");
			name = name.replace(SUBPROPERTY_POSITION_NAME, "");
			final Integer index = Integer.parseInt(name);
			final Object value = property.getValue();
			if (value != null) {
				if (value instanceof Color) {
					_gradient.get(index).setColor((Color) value);
				} else {
					_gradient.get(index).setPosition((Integer) value);
				}
			} else {
				_gradient.remove(index);
			}
			for (ChangeListener change : _changeListener) {
				change.stateChanged(new ChangeEvent(this));
			}
			reloadModel();
			return;
		} catch (NumberFormatException e) {
//			e.printStackTrace();
		}
		if (ANGLE_PROPERTY_NAME.equals(name)) {
			_gradient.setAngle((Integer) property.getValue());
		} else if (RADIAL_PROPERTY_NAME.equals(name)) {
			_gradient.setRadial((Boolean) property.getValue());
		}
		for (ChangeListener change : _changeListener) {
			change.stateChanged(new ChangeEvent(this));
		}
		reloadModel();
	}

	protected void refreshGradient(Graphics g) {
		Graphics2D g2d = null;
		if (g == null) {
			g2d = (Graphics2D) _gui.getPanGradient().getGraphics();
		} else {
			g2d = (Graphics2D) g;
		}
		if (_gui != null) {
			if (_gui.getPanGradient().getWidth() != 0) {
				g2d.setPaint(_gradient.getPaint(new Rectangle(0, 0, _gui.getPanGradient().getWidth(), _gui.getPanGradient().getHeight())));
				g2d.fillRect(0, 0, _gui.getPanGradient().getWidth(), _gui.getPanGradient().getHeight());
			}
		}
	}

	protected class GUI {

		private static final transient String BTN_ADD_COLOR_CAPTION = "Ajouter une couleur";
		private static final transient String BTN_REMOVE_COLOR_CAPTION = "Supprimer une couleur";

		protected transient JPanel _panGradient;
		protected transient JPanel _panColors;
		protected transient JSplitPane _panMain;
		protected transient PropertySheetPanel _tabColors;
		protected transient JButton _btnAddColor;
		protected transient JButton _btnRemoveColor;
		protected transient JPanel _panButtons;

		protected JPanel getPanButtons() {
			if (_panButtons == null) {
				_panButtons = new JPanel();
				_panButtons.setLayout(new BorderLayout());
				_panButtons.add(getBtnAddColor(), BorderLayout.NORTH);
				_panButtons.add(getBtnRemoveColor(), BorderLayout.SOUTH);
			}
			return _panButtons;
		}

		protected JButton getBtnRemoveColor() {
			if (_btnRemoveColor == null) {
				_btnRemoveColor = new JButton(BTN_REMOVE_COLOR_CAPTION);
				_btnRemoveColor.setName(BTN_REMOVE_COLOR_NAME);
				_btnRemoveColor.addActionListener(_actionListener);
			}
			return _btnRemoveColor;
		}

		public GUI() {
			this.init();
		}

		protected final void init() {
			add(getPanMain());
		}

		protected JPanel getPanColors() {
			if (_panColors == null) {
				_panColors = new JPanel();
				_panColors.setLayout(new BorderLayout());
				_panColors.add(getPanButtons(), BorderLayout.NORTH);
				_panColors.add(getTabColors(), BorderLayout.CENTER);
			}
			return _panColors;
		}

		protected JPanel getPanGradient() {
			if (_panGradient == null) {
				_panGradient = new JPanel() {

					private static final long serialVersionUID = 1L;

					public void paintComponent(Graphics g) {
						super.paintComponent(g);
						refreshGradient(g);
					}
				};
				_panGradient.setName(GRADIENT_EDITOR_NAME);
			}
			return _panGradient;
		}

		protected JSplitPane getPanMain() {
			if (_panMain == null) {
				_panMain = new JSplitPane();
				_panMain.setOrientation(JSplitPane.VERTICAL_SPLIT);
				_panMain.add(getPanColors(), JSplitPane.BOTTOM);
				_panMain.add(getPanGradient(), JSplitPane.TOP);
				_panMain.setDividerLocation(100);
			}
			return _panMain;
		}

		protected PropertySheetPanel getTabColors() {
			if (_tabColors == null) {
				_tabColors = new PropertySheetPanel();
				_tabColors.setName(TAB_COLOR_NAME);
				_tabColors.addPropertySheetChangeListener(_propertyChangeListener);
			}
			return _tabColors;
		}

		protected JButton getBtnAddColor() {
			if (_btnAddColor == null) {
				_btnAddColor = new JButton(BTN_ADD_COLOR_CAPTION);
				_btnAddColor.setName(JdksGradientEditor.BTN_ADD_COLOR_NAME);
				_btnAddColor.addActionListener(_actionListener);
			}
			return _btnAddColor;
		}
	}

	protected class Action implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {
			final String name = ((JComponent) arg0.getSource()).getName();
			if (JdksGradientEditor.BTN_ADD_COLOR_NAME.equals(name)) {
				btnAddColor_Click();
			} else if (BTN_REMOVE_COLOR_NAME.equals(name)) {
				btnRemoveColor_Click();
			}
		}
	}

	protected class PropertyChange implements PropertyChangeListener {

		public void propertyChange(PropertyChangeEvent arg0) {
			tabColors_Change((Property) arg0.getSource());
		}
	}

	public String toString() {
		return "src.dks.gradientEditor.JdksGradientEditor[gradient=" + _gradient + "]";
	}
}
