/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.antlr.works.ate.ATETextPane;
import org.antlr.xjlib.foundation.XJSystem;

public class ATEKeyBindings {
    private ATETextPane textComponent;

    public ATEKeyBindings(ATETextPane textComponent) {
        this.textComponent = textComponent;
        this.textComponent.setKeyBindings(this);
        if (XJSystem.isMacOS()) {
            this.addEmacsKeyBindings();
        }
        this.addStandardKeyBindings();
    }

    public void close() {
        this.textComponent.getActionMap().clear();
        this.textComponent.getInputMap().clear();
        this.textComponent = null;
    }

    public void addStandardKeyBindings() {
        InputMap inputMap = this.textComponent.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(36, 0);
        inputMap.put(key, "caret-begin-line");
        key = KeyStroke.getKeyStroke(36, 1);
        inputMap.put(key, "selection-begin-line");
        key = KeyStroke.getKeyStroke(35, 0);
        inputMap.put(key, "caret-end-line");
        key = KeyStroke.getKeyStroke(35, 1);
        inputMap.put(key, "selection-end-line");
        this.addKeyBinding("SHIFT_DELETE", KeyStroke.getKeyStroke(127, 1), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                ATEKeyBindings.this.textComponent.getActionMap().get("delete-next").actionPerformed(actionEvent);
            }
        });
    }

    public void addEmacsKeyBindings() {
        InputMap inputMap = this.textComponent.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(key, "caret-backward");
        key = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(key, "caret-forward");
        key = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(key, "caret-up");
        key = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(key, "caret-down");
        key = KeyStroke.getKeyStroke(65, 2);
        inputMap.put(key, "caret-begin-line");
        key = KeyStroke.getKeyStroke(69, 2);
        inputMap.put(key, "caret-end-line");
        this.addKeyBinding("CONTROL_D", KeyStroke.getKeyStroke(68, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                ATEKeyBindings.this.textComponent.getActionMap().get("delete-next").actionPerformed(actionEvent);
            }
        });
        this.addKeyBinding("CONTROL_K", KeyStroke.getKeyStroke(75, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int end;
                String t;
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                int start = ATEKeyBindings.this.textComponent.getCaretPosition();
                Document doc = ATEKeyBindings.this.textComponent.getDocument();
                try {
                    t = doc.getText(start, doc.getLength() - start);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                    return;
                }
                for (end = 0; end < t.length() && t.charAt(end) != '\n' && t.charAt(end) != '\r'; ++end) {
                }
                try {
                    end = Math.max(1, end);
                    String content = doc.getText(start, end);
                    doc.remove(start, end);
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cb.setContents(new StringSelection(content), null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.addKeyBinding("CONTROL_T", KeyStroke.getKeyStroke(84, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                int p = ATEKeyBindings.this.textComponent.getCaretPosition();
                Document doc = ATEKeyBindings.this.textComponent.getDocument();
                if (p < 1 || p >= doc.getLength()) {
                    return;
                }
                try {
                    String before = doc.getText(p - 1, 1);
                    doc.remove(p - 1, 1);
                    doc.insertString(p, before, null);
                    ATEKeyBindings.this.textComponent.setCaretPosition(p);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public void addKeyBinding(String name, KeyStroke keystroke, AbstractAction action) {
        this.textComponent.getActionMap().put(name, action);
        this.textComponent.getInputMap().put(keystroke, name);
    }
}

