/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tivo;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.RemoteDebugEventSocketListener;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventFactory;
import org.antlr.works.debugger.tivo.DBRecorder;
import org.antlr.works.debugger.tree.DBTreeToken;

public class DBRecorderEventListener
implements DebugEventListener {
    public DBRecorder recorder;

    public DBRecorderEventListener(DBRecorder recorder) {
        this.recorder = recorder;
    }

    public void event(DBEvent event) {
        this.recorder.listenerEvent(event);
    }

    public void commence() {
        this.event(DBEventFactory.createCommence());
    }

    public void terminate() {
        this.event(DBEventFactory.createTerminate());
    }

    public void enterRule(String grammarFileName, String ruleName) {
        this.event(DBEventFactory.createEnterRule(grammarFileName, ruleName));
    }

    public void exitRule(String grammarFileName, String ruleName) {
        this.event(DBEventFactory.createExitRule(grammarFileName, ruleName));
    }

    public void enterSubRule(int decisionNumber) {
        this.event(DBEventFactory.createEnterSubRule(decisionNumber));
    }

    public void exitSubRule(int decisionNumber) {
        this.event(DBEventFactory.createExitSubRule(decisionNumber));
    }

    public void enterDecision(int decisionNumber, boolean couldBacktrack) {
        this.event(DBEventFactory.createEnterDecision(decisionNumber));
    }

    public void exitDecision(int decisionNumber) {
        this.event(DBEventFactory.createExitDecision(decisionNumber));
    }

    public void enterAlt(int alt) {
        this.event(DBEventFactory.createEnterAlt(alt));
    }

    public void location(int line, int pos) {
        this.event(DBEventFactory.createLocation(line, pos));
    }

    public void consumeToken(Token token) {
        this.event(DBEventFactory.createConsumeToken(token));
    }

    public void consumeHiddenToken(Token token) {
        this.event(DBEventFactory.createConsumeHiddenToken(token));
    }

    public void LT(int i, Token token) {
        this.event(DBEventFactory.createLT(i, token));
    }

    public void mark(int i) {
        this.event(DBEventFactory.createMark(i));
    }

    public void rewind(int i) {
        this.event(DBEventFactory.createRewind(i));
    }

    public void rewind() {
        this.event(DBEventFactory.createRewind());
    }

    public void beginBacktrack(int level) {
        this.event(DBEventFactory.createBeginBacktrack(level));
    }

    public void endBacktrack(int level, boolean successful) {
        this.event(DBEventFactory.createEndBacktrack(level, successful));
    }

    public void recognitionException(RecognitionException e) {
        this.event(DBEventFactory.createRecognitionException(e));
    }

    public void beginResync() {
        this.event(DBEventFactory.createBeginResync());
    }

    public void endResync() {
        this.event(DBEventFactory.createEndResync());
    }

    public void semanticPredicate(boolean result, String predicate) {
    }

    public void nilNode(Object t) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createNilNode(p.ID));
    }

    public void errorNode(Object t) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createErrorNode(p.ID, p.text, p.type));
    }

    public void createNode(Object t) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createCreateNode(p.ID, p.text, p.type));
    }

    public void createNode(Object node, Token token) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)node;
        this.event(DBEventFactory.createCreateNode(p.ID, token.getTokenIndex()));
    }

    public void becomeRoot(Object newRoot, Object oldRoot) {
        RemoteDebugEventSocketListener.ProxyTree n = (RemoteDebugEventSocketListener.ProxyTree)newRoot;
        RemoteDebugEventSocketListener.ProxyTree o = (RemoteDebugEventSocketListener.ProxyTree)oldRoot;
        this.event(DBEventFactory.createBecomeRoot(n.ID, o.ID));
    }

    public void addChild(Object root, Object child) {
        RemoteDebugEventSocketListener.ProxyTree r = (RemoteDebugEventSocketListener.ProxyTree)root;
        RemoteDebugEventSocketListener.ProxyTree c = (RemoteDebugEventSocketListener.ProxyTree)child;
        this.event(DBEventFactory.createAddChild(r.ID, c.ID));
    }

    public void setTokenBoundaries(Object t, int tokenStartIndex, int tokenStopIndex) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createSetTokenBoundaries(p.ID, tokenStartIndex, tokenStopIndex));
    }

    public void consumeNode(Object t) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createConsumeToken(new DBTreeToken(p)));
    }

    public void LT(int i, Object t) {
        RemoteDebugEventSocketListener.ProxyTree p = (RemoteDebugEventSocketListener.ProxyTree)t;
        this.event(DBEventFactory.createLT(i, new DBTreeToken(p)));
    }
}

