/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.tree.DBTreeToken;
import org.antlr.works.utils.awtree.AWTreeNode;

public class DBTreeNode
extends AWTreeNode {
    protected Token token;
    protected DBEventLocation location;
    protected Color color = Color.black;

    public DBTreeNode() {
    }

    public DBTreeNode(Token token, DBEventLocation location) {
        this.token = token;
        this.location = location;
    }

    public DBEventLocation getLocation() {
        return this.location;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Token getToken() {
        return this.token;
    }

    public DBTreeNode findNodeWithToken(Token t) {
        return this.findNodeWithToken(t, null);
    }

    public DBTreeNode findNodeWithToken(Token t, DBTreeNode lastNodeSoFar) {
        if (t == null) {
            return lastNodeSoFar;
        }
        if (this.token != null) {
            if (this.token instanceof DBTreeToken && t instanceof DBTreeToken) {
                DBTreeToken t1 = (DBTreeToken)this.token;
                DBTreeToken t2 = (DBTreeToken)t;
                if (t1.ID == t2.ID) {
                    lastNodeSoFar = this;
                }
            } else if (t.getTokenIndex() == this.token.getTokenIndex() && t.getType() == this.token.getType()) {
                lastNodeSoFar = this;
            }
        }
        Enumeration<TreeNode> childrenEnumerator = this.children();
        while (childrenEnumerator.hasMoreElements()) {
            DBTreeNode node = (DBTreeNode)childrenEnumerator.nextElement();
            DBTreeNode candidate = node.findNodeWithToken(t, lastNodeSoFar);
            if (candidate == null) continue;
            lastNodeSoFar = candidate;
        }
        return lastNodeSoFar;
    }

    public String toString() {
        if (this.token != null) {
            return this.getTokenDisplayString(this.token);
        }
        return "?";
    }

    protected String getTokenDisplayString(Token token) {
        if (token.getType() == -1) {
            return "EOF";
        }
        String t = token.getText();
        if (t.equals("\n")) {
            return "\\n";
        }
        if (t.equals("\r")) {
            return "\\r";
        }
        if (t.equals("\t")) {
            return "\\t";
        }
        return t;
    }

    public String getInfoString() {
        return this.toString();
    }
}

