/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.interpreter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.interpreter.EditorInterpreterTreeModel;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.TextUtils;
import org.antlr.works.utils.Toolbar;
import org.antlr.works.utils.Utils;
import org.antlr.works.utils.awtree.AWTreePanel;
import org.antlr.works.utils.awtree.AWTreePanelDelegate;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterTab
extends GrammarWindowTab
implements Runnable,
AWTreePanelDelegate {
    protected JPanel panel;
    protected JSplitPane splitPane;
    protected JTextPane textPane;
    protected JScrollPane textScrollPane;
    protected EditorInterpreterTreeModel treeModel;
    protected AWTreePanel awTreePanel;
    protected JComboBox rulesCombo;
    protected JComboBox eolCombo;
    protected JLabel tokensToIgnoreLabel;
    protected XJDialogProgress progress;
    protected String startSymbol = null;

    public InterpreterTab(GrammarWindow window) {
        super(window);
    }

    public void close() {
        this.awTreePanel.setDelegate(null);
    }

    public void awake() {
        this.panel = new JPanel(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setBackground(Color.white);
        this.textPane.setBorder(null);
        this.textPane.setPreferredSize(new Dimension(300, 100));
        this.textPane.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        TextUtils.createTabs(this.textPane);
        TextUtils.setDefaultTextPaneProperties(this.textPane);
        this.textScrollPane = new JScrollPane(this.textPane);
        this.textScrollPane.setWheelScrollingEnabled(true);
        this.treeModel = new EditorInterpreterTreeModel();
        this.awTreePanel = new AWTreePanel(this.treeModel);
        this.awTreePanel.setDelegate(this);
        this.splitPane = new JSplitPane();
        this.splitPane.setBorder(null);
        this.splitPane.setOrientation(1);
        this.splitPane.setLeftComponent(this.textScrollPane);
        this.splitPane.setRightComponent(this.awTreePanel);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.panel.add((Component)this.createControlPanel(), "North");
        this.panel.add((Component)this.splitPane, "Center");
        this.window.registerUndo(null, this.textPane);
    }

    public Box createControlPanel() {
        Toolbar box = Toolbar.createHorizontalToolbar();
        box.addElement(this.createRunButton());
        box.addElement(this.createRulesPopUp());
        box.addGroupSeparator();
        box.addElement(new JLabel("Line Endings:"));
        box.addElement(this.createEOLCombo());
        box.addGroupSeparator();
        this.createTokensToIgnoreField(box);
        return box;
    }

    public JButton createRunButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconRun());
        button.setToolTipText("Run");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AWPrefs.isAlertInterpreterLimitation()) {
                    XJAlert alert = XJAlert.createInstance();
                    alert.setDisplayDoNotShowAgainButton(true);
                    alert.showSimple(InterpreterTab.this.getContainer(), "Warning", "The interpreterTab does not run actions nor evaluate syntactic predicates.\nUse the debugger if you want to use these ANTLR features.");
                    AWPrefs.setAlertInterpreterLimitation(!alert.isDoNotShowAgain());
                }
                StatisticsAW.shared().recordEvent(91);
                InterpreterTab.this.interpret();
            }
        });
        return button;
    }

    public JComboBox createRulesPopUp() {
        this.rulesCombo = new JComboBox();
        this.rulesCombo.setFocusable(false);
        this.rulesCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, this.rulesCombo.getPreferredSize().height));
        this.rulesCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String rule = (String)InterpreterTab.this.rulesCombo.getSelectedItem();
                if (rule != null) {
                    InterpreterTab.this.startSymbol = rule;
                }
            }
        });
        return this.rulesCombo;
    }

    public JComboBox createEOLCombo() {
        this.eolCombo = new JComboBox();
        this.eolCombo.setFocusable(false);
        this.eolCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, this.eolCombo.getPreferredSize().height));
        Utils.fillComboWithEOL(this.eolCombo);
        return this.eolCombo;
    }

    public Box createTokensToIgnoreField(Toolbar box) {
        box.addElement(new JLabel("Ignore rules:"));
        this.tokensToIgnoreLabel = new JLabel();
        this.tokensToIgnoreLabel.setFont(this.tokensToIgnoreLabel.getFont().deriveFont(2));
        box.addElement(this.tokensToIgnoreLabel);
        JButton button = new JButton("Guess");
        button.setFocusable(false);
        button.setToolTipText("Find the name of all rules containing an action with channel=99");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InterpreterTab.this.window.findTokensToIgnore(true);
            }
        });
        box.add(Box.createHorizontalGlue());
        box.addElement(button);
        return box;
    }

    public Container getContainer() {
        return this.panel;
    }

    public void setRules(List<ElementRule> rules) {
        this.updateRulesCombo(rules);
        this.updateIgnoreTokens(rules);
    }

    public void updateRulesCombo(List<ElementRule> rules) {
        Object selectedItem = this.rulesCombo.getSelectedItem();
        this.rulesCombo.removeAllItems();
        if (rules != null) {
            for (ElementRule rule : rules) {
                this.rulesCombo.addItem(rule.toString());
            }
        }
        if (selectedItem != null) {
            this.rulesCombo.setSelectedItem(selectedItem);
        }
    }

    public void updateIgnoreTokens(List<ElementRule> rules) {
        StringBuilder sb = new StringBuilder();
        if (rules != null) {
            for (ElementRule r : rules) {
                if (!r.ignored) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(r.name);
            }
        }
        if (sb.length() == 0) {
            this.tokensToIgnoreLabel.setText("-");
        } else {
            this.tokensToIgnoreLabel.setText(sb.toString());
        }
    }

    public void interpret() {
        this.window.consoleTab.makeCurrent();
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.window);
        }
        this.progress.setInfo("Interpreting...");
        this.window.findTokensToIgnore(false);
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.window.getGrammarEngine().analyze();
            this.process();
        }
        catch (Exception e) {
            this.window.consoleTab.println(e);
        }
        finally {
            this.runEnded();
        }
    }

    public void runEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InterpreterTab.this.progress.close();
            }
        });
    }

    protected void process() {
        this.progress.setInfo("Interpreting...");
        this.window.consoleTab.println("Interpreting...");
        ANTLRStringStream input = new ANTLRStringStream(Utils.convertRawTextWithEOL(this.textPane.getText(), this.eolCombo));
        ANTLRGrammarEngine eg = this.window.getGrammarEngine().getANTLRGrammarEngine();
        try {
            eg.createGrammars();
        }
        catch (Exception e) {
            this.window.consoleTab.println(e);
            return;
        }
        Grammar parser = eg.getParserGrammar();
        Grammar lexer = eg.getLexerGrammar();
        if (lexer == null) {
            throw new RuntimeException("Lexer is null. Check the grammar before running the interpreterTab.");
        }
        CustomInterpreter lexEngine = new CustomInterpreter(lexer, input);
        FilteringTokenStream tokens = new FilteringTokenStream(lexEngine);
        StringTokenizer tk = new StringTokenizer(this.tokensToIgnoreLabel.getText(), " ");
        while (tk.hasMoreTokens()) {
            String tokenName = tk.nextToken();
            tokens.setTokenTypeChannel(lexer.getTokenType(tokenName), 99);
        }
        CustomInterpreter parseEngine = new CustomInterpreter(parser, tokens);
        ParseTree t = null;
        try {
            t = ATEToken.isLexerName(this.startSymbol) ? lexEngine.parse(this.startSymbol) : parseEngine.parse(this.startSymbol);
        }
        catch (Exception e) {
            this.window.consoleTab.println(e);
        }
        if (parser != null && t != null) {
            SwingUtilities.invokeLater(new Refresh(parser, t));
        }
    }

    @Override
    public boolean canExportToBitmap() {
        return true;
    }

    @Override
    public boolean canExportToEPS() {
        return true;
    }

    @Override
    public GView getExportableGView() {
        return this.awTreePanel.getGraphView();
    }

    @Override
    public String getTabName() {
        return "Interpreter";
    }

    @Override
    public Component getTabComponent() {
        return this.getContainer();
    }

    @Override
    public void awTreeDidSelectTreeNode(TreeNode node, boolean shiftKey) {
    }

    @Override
    public JPopupMenu awTreeGetContextualMenu() {
        ContextualMenuFactory factory = this.window.createContextualMenuFactory();
        factory.addItem(111);
        factory.addItem(110);
        return factory.menu;
    }

    public class Refresh
    implements Runnable {
        Grammar g;
        ParseTree t;

        public Refresh(Grammar grammar, ParseTree t) {
            this.g = grammar;
            this.t = t;
        }

        public void run() {
            InterpreterTab.this.treeModel.setGrammar(this.g);
            InterpreterTab.this.treeModel.setTree(this.t);
            InterpreterTab.this.awTreePanel.setRoot((TreeNode)InterpreterTab.this.treeModel.getRoot());
            InterpreterTab.this.awTreePanel.refresh();
        }
    }

    public class CustomInterpreter
    extends Interpreter {
        public CustomInterpreter(Grammar grammar, IntStream input) {
            super(grammar, input);
        }

        public void reportScanError(RecognitionException re) {
            CharStream cs = (CharStream)this.input;
            ((InterpreterTab)InterpreterTab.this).window.consoleTab.println("problem matching token at " + cs.getLine() + ":" + cs.getCharPositionInLine() + " " + re);
        }
    }

    public static class FilteringTokenStream
    extends CommonTokenStream {
        Set<Integer> hide = new HashSet<Integer>();

        public FilteringTokenStream(TokenSource src) {
            super(src);
        }

        protected void sync(int i) {
            super.sync(i);
            if (this.hide.contains(this.get(i).getType())) {
                this.get(i).setChannel(99);
            }
        }

        public void setTokenTypeChannel(int ttype, int channel) {
            this.hide.add(ttype);
        }
    }
}

