/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.antlr.xjlib.appkit.XJControl;
import org.antlr.xjlib.appkit.app.XJApplication;

public class XJDialog
extends XJControl {
    public static final int BUTTON_CANCEL = 0;
    public static final int BUTTON_OK = 1;
    protected JDialog jDialog = null;
    protected JButton defaultButton = null;
    protected int returnCode = 0;
    protected Container parent;

    public static Container resolveOwner(Container owner) {
        Container parent;
        Container container = parent = owner == null ? XJApplication.getActiveContainer() : owner;
        if (owner instanceof Dialog || owner instanceof Frame) {
            return parent;
        }
        if (owner != null) {
            return SwingUtilities.getWindowAncestor(owner);
        }
        return null;
    }

    public XJDialog(Container owner, boolean modal) {
        this.parent = XJDialog.resolveOwner(owner);
        this.jDialog = this.parent instanceof Dialog ? new JDialog((Dialog)this.parent) : (this.parent instanceof Frame ? new JDialog((Frame)this.parent) : new JDialog());
        this.jDialog.setModal(modal);
        this.jDialog.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent event) {
                XJDialog.this.dialogActivated();
            }

            public void windowClosing(WindowEvent e) {
                XJDialog.this.dialogWillCloseCancel();
            }
        });
        this.addEscapeHandling();
        this.setDefaultSize();
    }

    public void setDefaultCloseOperation(int operation) {
        this.jDialog.setDefaultCloseOperation(operation);
    }

    public Container getContentPane() {
        return this.jDialog.getContentPane();
    }

    public void setTitle(String title) {
        this.jDialog.setTitle(title);
    }

    public String getTitle() {
        return this.jDialog.getTitle();
    }

    public void setSize(int dx, int dy) {
        this.jDialog.setSize(dx, dy);
    }

    public void setSize(Dimension size) {
        this.jDialog.setSize(size);
    }

    public Dimension getSize() {
        return this.jDialog.getSize();
    }

    public void setDefaultSize() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.jDialog.setSize((int)((double)dim.width * 0.5), (int)((double)dim.height * 0.5));
    }

    public void setResizable(boolean flag) {
        this.jDialog.setResizable(flag);
    }

    public void setDefaultButton(JButton button) {
        this.defaultButton = button;
    }

    public void setOKButton(JButton button) {
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (XJDialog.this.dialogCanCloseOK()) {
                    XJDialog.this.dialogWillCloseOK();
                    XJDialog.this.closeWithReturnCode(1);
                }
            }
        });
    }

    public void setCancelButton(JButton button) {
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                XJDialog.this.dialogWillCloseCancel();
                XJDialog.this.closeWithReturnCode(0);
            }
        });
    }

    public void addEscapeHandling() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0, true);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                XJDialog.this.closeWithReturnCode(0);
            }
        };
        this.jDialog.getRootPane().registerKeyboardAction(cancelAction, "CancelAction", ks, 2);
    }

    public void setReturnCode(int code) {
        this.returnCode = code;
    }

    public void bringToFront() {
        this.jDialog.toFront();
    }

    public void center() {
        this.jDialog.setLocationRelativeTo(this.parent);
    }

    public void setPosition(int x, int y) {
        this.jDialog.setLocation(x, y);
    }

    public void setPosition(Point p) {
        this.jDialog.setLocation(p);
    }

    public Point getPosition() {
        return this.jDialog.getLocation();
    }

    public void offsetPosition(int dx, int dy) {
        Point p = this.jDialog.getLocation();
        this.jDialog.setLocation(p.x + dx, p.y + dy);
    }

    public Component getJavaComponent() {
        return this.jDialog;
    }

    public void closeWithReturnCode(int code) {
        this.setReturnCode(code);
        this.close();
    }

    public void close() {
        this.jDialog.dispose();
    }

    public void pack() {
    }

    public boolean dialogCanCloseOK() {
        return true;
    }

    public void dialogWillDisplay() {
    }

    public void dialogActivated() {
    }

    public void dialogWillCloseCancel() {
    }

    public void dialogWillCloseOK() {
    }

    public void setVisible(boolean flag) {
        this.jDialog.setVisible(flag);
    }

    public void display() {
        this.center();
        this.jDialog.setVisible(true);
    }

    public int runModal() {
        this.center();
        this.dialogWillDisplay();
        if (this.defaultButton != null) {
            this.jDialog.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.jDialog.setVisible(true);
        return this.returnCode;
    }
}

