/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.appkit.gview.shape.SLinkBezier;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GLink
extends GElement
implements XJXMLSerializable {
    public static final int SHAPE_ARC = 0;
    public static final int SHAPE_ELBOW = 1;
    public static final int SHAPE_BEZIER = 2;
    public GElement source = null;
    public GElement target = null;
    public String sourceAnchorKey = null;
    public String targetAnchorKey = null;
    public String pattern = null;
    protected SLink link = null;
    protected int shape = 0;

    public GLink() {
    }

    public GLink(GElement source, String sourceAnchorKey, GElement target, String targetAnchorKey, int shape, String pattern, Point mouse, double flateness) {
        this.source = source;
        this.target = target;
        this.sourceAnchorKey = sourceAnchorKey;
        this.targetAnchorKey = targetAnchorKey;
        this.shape = shape;
        this.pattern = pattern;
        this.initializeLink(flateness);
        this.setSourceTangentOffset(source.getDefaultAnchorOffset(sourceAnchorKey));
        this.setTargetTangentOffset(target.getDefaultAnchorOffset(targetAnchorKey));
        this.link.setDirection(Vector2D.vector(mouse).sub(target.getPosition()));
    }

    public GLink(GElement source, String sourceAnchorKey, GElement target, String targetAnchorKey, int shape, String pattern, double flateness) {
        this.source = source;
        this.target = target;
        this.sourceAnchorKey = sourceAnchorKey;
        this.targetAnchorKey = targetAnchorKey;
        this.shape = shape;
        this.pattern = pattern;
        this.initializeLink(flateness);
        if (source == target) {
            this.link.setDirection(new Vector2D(0.0, 1.0));
        } else {
            this.link.setDirection(source.getPosition().sub(target.getPosition()));
        }
        this.setSourceTangentOffset(source.getDefaultAnchorOffset(sourceAnchorKey));
        this.setTargetTangentOffset(target.getDefaultAnchorOffset(targetAnchorKey));
    }

    public void setBezierControlPoints(Vector2D[] points) {
        if (this.link instanceof SLinkBezier) {
            SLinkBezier lb = (SLinkBezier)this.link;
            lb.setControlPoints(points);
        }
    }

    public void setBezierLabelPosition(Vector2D position) {
        if (this.link instanceof SLinkBezier) {
            SLinkBezier lb = (SLinkBezier)this.link;
            lb.setLabelPosition(position);
        }
    }

    protected SLink createLinkInstance() {
        switch (this.shape) {
            case 0: {
                return new SLinkArc();
            }
            case 1: {
                return new SLinkElbow();
            }
            case 2: {
                return new SLinkBezier();
            }
        }
        return null;
    }

    protected void initializeLink(double flateness) {
        if (this.link == null) {
            this.link = this.createLinkInstance();
            this.link.setFlateness(flateness);
        }
    }

    public void setSource(GElement source) {
        this.source = source;
    }

    public GElement getSource() {
        return this.source;
    }

    public void setTarget(GElement target) {
        this.target = target;
    }

    public GElement getTarget() {
        return this.target;
    }

    public void setSourceAnchorKey(String key) {
        this.sourceAnchorKey = key;
    }

    public String getSourceAnchorKey() {
        return this.sourceAnchorKey;
    }

    public void setTargetAnchorKey(String key) {
        this.targetAnchorKey = key;
    }

    public String getTargetAnchorKey() {
        return this.targetAnchorKey;
    }

    public void setSourceTangentOffset(double offset) {
        this.link.setStartTangentOffset(offset);
    }

    public void setTargetTangentOffset(double offset) {
        this.link.setEndTangentOffset(offset);
    }

    public void setSourceOffset(double x, double y) {
        this.setSourceOffset(new Vector2D(x, y));
    }

    public void setSourceOffset(Vector2D offset) {
        this.link.setStartOffset(offset);
    }

    public void setTargetOffset(double x, double y) {
        this.setTargetOffset(new Vector2D(x, y));
    }

    public void setTargetOffset(Vector2D offset) {
        this.link.setEndOffset(offset);
    }

    public void setLink(SLink link) {
        this.link = link;
    }

    public SLink getLink() {
        return this.link;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setLabel(String label) {
        this.pattern = label;
    }

    public void setLabelColor(Color color) {
        this.link.setLabelColor(color);
    }

    public void setLabelVisible(boolean flag) {
        if (this.link != null) {
            this.link.setLabelVisible(flag);
        }
    }

    public boolean isLabelVisible() {
        return this.link != null && this.link.isLabelVisible();
    }

    public void setShape(int type) {
        this.shape = type;
    }

    public int getShape() {
        return this.shape;
    }

    public void toggleShape() {
        switch (this.shape) {
            case 0: {
                this.shape = 1;
                break;
            }
            case 1: {
                this.shape = 0;
                break;
            }
            case 2: {
                return;
            }
        }
        double flateness = this.link.getFlateness();
        Vector2D direction = this.link.getDirection();
        this.link = this.createLinkInstance();
        this.link.setFlateness(flateness);
        this.link.setDirection(direction);
    }

    public void setMousePosition(Point mouse) {
        this.link.setDirection(Vector2D.vector(mouse).sub(this.target.getPosition()));
        this.link.setMousePosition(Vector2D.vector(mouse));
    }

    public Rect getFrame() {
        this.update();
        return this.link.getFrame();
    }

    public boolean isInside(Point p) {
        return this.link != null && this.link.contains(p.x, p.y);
    }

    public void update() {
        this.initializeLink(0.0);
        this.source.updateAnchors();
        this.target.updateAnchors();
        this.link.setStartAnchor(this.source.getAnchor(this.sourceAnchorKey));
        this.link.setEndAnchor(this.target.getAnchor(this.targetAnchorKey));
        this.link.setLabel(this.pattern);
        this.link.setSelfLoop(this.source == this.target);
        this.link.update();
    }

    public void draw(Graphics2D g) {
        this.update();
        if (this.isVisibleInClip(g)) {
            g.setStroke(new BasicStroke(this.penSize));
            if (this.color != null) {
                this.link.setColor(this.color);
            } else {
                this.link.setColor(Color.black);
            }
            this.link.draw(g);
        }
    }

    public void drawShape(Graphics2D g) {
        this.link.drawShape(g);
    }
}

