/*
 * Decompiled with CFR 0.152.
 */
package com.alphase.lic;

import com.alphase.Tools.aseTools;
import com.jaxfront.core.util.URLHelper;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class License {
    private String _fileLocation;
    public String ExDate = null;
    public String Line1 = null;
    public String Line2 = null;
    public String Product = null;
    public String Customer = null;
    public int LicenseVal = 0;
    public int SeedKey = 0;
    public int Version;
    public int SubVersion;
    public boolean Option1;
    public boolean Option2;
    public boolean Option3;
    public boolean Option4;

    public License() {
        String s = aseTools.getJavaHomeFile("lic.key");
        if (s != null) {
            this.SeedKey = -166563881;
            if (this.validateLicense(s, false) > 0) {
                this.SeedKey = aseTools.hashValue(this.Line2);
            } else {
                this.SeedKey = 0;
                if (this.validateLicense(s, false) > 0) {
                    this.SeedKey = aseTools.hashValue(this.Line2);
                }
            }
            this.Customer = null;
            this.Product = null;
            this.Line2 = null;
            this.Line1 = null;
            this.ExDate = null;
            this.SubVersion = 0;
            this.Version = 0;
            this.LicenseVal = 0;
            this.Option4 = false;
            this.Option3 = false;
            this.Option2 = false;
            this.Option1 = false;
        }
    }

    public License(int i) {
        this.SeedKey = i;
        this.Customer = null;
        this.Product = null;
        this.Line2 = null;
        this.Line1 = null;
        this.ExDate = null;
        this.SubVersion = 0;
        this.Version = 0;
        this.LicenseVal = 0;
        this.Option4 = false;
        this.Option3 = false;
        this.Option2 = false;
        this.Option1 = false;
    }

    public static void ReportLicense(String s, int i) {
        License license = new License(i);
        int j = license.validateLicense(s, true);
        if (j > 0) {
            String s1 = Integer.toHexString(j);
            s1 = s1.toUpperCase();
            System.out.println("\tVersion+Options(Hex/Dec): " + s1 + "/" + String.valueOf(j));
        }
    }

    private int validateLicense(String s, boolean flag) {
        int i1;
        int l;
        this._fileLocation = s;
        DataInputStream datainputstream = null;
        boolean flag1 = false;
        int i = 0;
        if (s == null) {
            if (flag) {
                System.out.println("Error #1: Missing File Specification.");
            }
            return -1;
        }
        try {
            datainputstream = URLHelper.isUrl(s) ? new DataInputStream(URLHelper.openStream(new URL(s))) : new DataInputStream(new FileInputStream(s));
        }
        catch (IOException _ex) {
            if (flag) {
                System.out.println("Error #2: Missing License File.");
            }
            return -2;
        }
        this.Line2 = null;
        this.Line1 = null;
        this.ExDate = null;
        this.LicenseVal = 0;
        String s1 = aseTools.readScrambledText(datainputstream, this.SeedKey);
        if (s1.length() < 1) {
            if (flag) {
                System.out.println("Error #3: Missing Line1.");
            }
            return -3;
        }
        int k = aseTools.hashValue(s1);
        this.Line1 = new String(s1);
        if (flag) {
            System.out.println("\tProduct : " + s1);
        }
        if (s1.endsWith("Temporary-License")) {
            flag1 = true;
        }
        if ((s1 = aseTools.readScrambledText(datainputstream, k)).length() < 1) {
            if (flag) {
                System.out.println("Error #4: Missing Line2.");
            }
            return -4;
        }
        int j = aseTools.hashValue(s1);
        this.Line2 = new String(s1);
        if (flag) {
            System.out.println("\tCustomer: " + s1);
        }
        if (flag1) {
            String s2 = aseTools.readScrambledText(datainputstream, k);
            if (flag) {
                System.out.println("\tLicense Expires: " + s2);
            }
            SimpleDateFormat simpledateformat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            Date date1 = null;
            try {
                date1 = simpledateformat.parse(s2);
            }
            catch (ParseException _ex) {
                date1 = new Date();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException _ex2) {
                    // empty catch block
                }
            }
            this.ExDate = new String(s2);
            if (date.after(date1)) {
                if (flag) {
                    System.out.println("Error #5: License has expired.");
                }
                return -5;
            }
        } else {
            this.ExDate = new String("none");
        }
        try {
            l = datainputstream.readInt();
        }
        catch (IOException _ex) {
            l = 0;
        }
        try {
            datainputstream.close();
        }
        catch (IOException _ex) {
            l = 0;
        }
        this.LicenseVal = i1 = j ^ l;
        if (flag) {
            System.out.println("\tRaw License: " + String.valueOf(i1));
        }
        if (i1 <= (k &= 0x7FFFF000) || i1 > (k | 0xFFF)) {
            if (flag) {
                System.out.println("Error #6: Invalid License.");
            }
            return -6;
        }
        i = i1 & 0xFFF;
        this.Product = this.Line1;
        this.Customer = this.Line2;
        this.Version = i >> 8;
        this.SubVersion = (0xF0 & i) >> 4;
        i1 = i & 0xF;
        if ((i1 & 1) > 0) {
            this.Option4 = true;
        }
        if ((i1 & 2) > 0) {
            this.Option3 = true;
        }
        if ((i1 & 4) > 0) {
            this.Option2 = true;
        }
        if ((i1 & 8) > 0) {
            this.Option1 = true;
        }
        return i;
    }

    public boolean verifyLicenseFile(String s) {
        this.LicenseVal = this.validateLicense(s, false);
        return this.LicenseVal > 0;
    }

    public String getFileLocation() {
        return this._fileLocation;
    }
}

