/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.clipboard;

import com.jaxfront.core.clipboard.CopyTypeWrapper;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

public class SimpleClipboardSelection
implements Transferable,
ClipboardOwner {
    protected Object selection;
    protected DataFlavor flavor;
    public static final DataFlavor dataFlavor = new DataFlavor(CopyTypeWrapper.class, "JAXFrontTypeCopy");

    public SimpleClipboardSelection(Object selection, DataFlavor flavor) {
        this.selection = selection;
        this.flavor = flavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.flavor};
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(this.flavor);
    }

    public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException {
        if (f.equals(this.flavor)) {
            return this.selection;
        }
        throw new UnsupportedFlavorException(f);
    }

    public void lostOwnership(Clipboard c, Transferable t) {
        this.selection = null;
    }

    public static void copy(Object source, DataFlavor dataFlavor) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        SimpleClipboardSelection s = new SimpleClipboardSelection(source, dataFlavor);
        c.setContents(s, s);
    }

    public static void paste() {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = c.getContents(null);
        if (t == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            Object newlines = t.getTransferData(dataFlavor);
        }
        catch (UnsupportedFlavorException e) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

