/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontLSInput;
import com.jaxfront.core.dom.NodeImporter;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TreeModel;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import com.jaxfront.core.xpath.XPNode;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.core.xpath.XPathNodeExtractor;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.NLS;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSObject;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMHelper {
    private static final String EQUALS = "=";
    private static final String XSD = "xsd".intern();
    private static final String HTTP_WWW_W3_ORG_2001_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema".intern();
    private static final String SCHEMA_LOCATION = "schemaLocation".intern();
    public static final String XMLNS = "xmlns".intern();
    public static final String DOCUMENTATION_START = "documentation>";
    private static final DOMParser parser = new DOMParser();
    public static final String XPATH_FORM_META_OWNER = "/Form/Meta/Owner";
    static /* synthetic */ Class class$com$jaxfront$core$dom$DOMHelper;

    private DOMHelper() {
    }

    public static org.w3c.dom.Document createDocument(URL url) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        InputStream is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(url);
        dom = DOMHelper.createDocument(is, "utf-8");
        if (dom != null) {
            dom.appendChild(dom.createProcessingInstruction("jaxfrontbase", url.getPath()));
        }
        return dom;
    }

    public static org.w3c.dom.Document createDocument(File file) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        InputStream is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(file.toURL());
        dom = DOMHelper.createDocument(is);
        if (dom != null) {
            dom.appendChild(dom.createProcessingInstruction("jaxfrontbase", file.toURL().getPath()));
        }
        return dom;
    }

    public static boolean isJAXFrontXSDSchema(URL xsdURL) {
        boolean isXSDSchema = false;
        try {
            org.w3c.dom.Document w3cDOM = DOMHelper.createDocument(xsdURL);
            String schemaLocationPI = DOMHelper.getProcessingInstructionValue(w3cDOM, "jaxfront", XSD);
            if (schemaLocationPI != null && schemaLocationPI.equals("jaxfront-xsd-schema.xsd")) {
                isXSDSchema = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isXSDSchema;
    }

    public static org.w3c.dom.Document createDocument(InputStream is) throws XMLParseException, SAXException, IOException {
        return DOMHelper.createDocument(new String(FileHelper.read(is)));
    }

    public static org.w3c.dom.Document createDocument(InputStream is, String enc) throws XMLParseException, SAXException, IOException {
        return DOMHelper.createDocument(new String(FileHelper.read(is), enc));
    }

    public static org.w3c.dom.Document createDocument(URL url, String enc) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        InputStream is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(url);
        dom = enc != null ? DOMHelper.createDocument(is, enc) : DOMHelper.createDocument(is);
        if (dom != null) {
            dom.appendChild(dom.createProcessingInstruction("jaxfrontbase", url.getPath()));
        }
        return dom;
    }

    public static org.w3c.dom.Document createDocument(LSInput xml) throws XMLParseException, SAXException, IOException {
        Reader aReader = xml.getCharacterStream();
        if (aReader == null) {
            throw new IOException(new StringBuffer().append(xml.getSystemId()).append(" not found.").toString());
        }
        return DOMHelper.createDocument(new InputSource(aReader));
    }

    public static org.w3c.dom.Document createDocument(InputSource is) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        DOMParser parser = new DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", false);
        parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        parser.parse(is);
        dom = parser.getDocument();
        return dom;
    }

    private static String makeRelative(String loadedFrom) {
        String schemaName = loadedFrom;
        if (URLHelper.isUrl(loadedFrom)) {
            try {
                schemaName = URLHelper.extractFileName(new URL(loadedFrom).getFile());
            }
            catch (Exception exception) {}
        } else {
            schemaName = URLHelper.extractFileName(loadedFrom);
        }
        return schemaName;
    }

    public static Type createFromEditingTypeXPath(Type start, String xpath) throws XPathError {
        XPNode xnode = null;
        if (xpath.startsWith("/")) {
            start = start.getDOM().getRootType();
        }
        boolean isFirst = true;
        while ((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, false, true)) != null) {
            if (start == null) {
                return null;
            }
            String nodeName = xnode.getNodeName();
            String nodeNS = xnode.getNodeNSPrefix();
            if (!(isFirst && nodeName.equals(start.getName()) || nodeName.equals(""))) {
                if (nodeName.equals("..")) {
                    start = start.getParent();
                } else if (!nodeName.equals(".")) {
                    Type tempStart = start.getDirectChild(nodeName, nodeNS);
                    if (tempStart == null) {
                        if (start.isList()) {
                            start = ((ListType)start).addNewChild();
                        }
                    } else {
                        Type tempStart2;
                        if (tempStart.isList() && (tempStart2 = tempStart.getDirectChild(nodeName, nodeNS)) == null) {
                            tempStart = start = ((ListType)tempStart).addNewChild();
                        }
                        start = tempStart;
                    }
                }
            }
            isFirst = false;
        }
        return start;
    }

    public static org.w3c.dom.Document createEmptyDocument() throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document doc = DOMHelper.createDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?><dummy/>");
        return doc;
    }

    public static org.w3c.dom.Document createDocument(String content) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        DOMParser parser = new DOMParser();
        parser.setErrorHandler(null);
        InputSource is = new InputSource(new StringReader(content));
        parser.parse(is);
        dom = parser.getDocument();
        return dom;
    }

    public static synchronized org.w3c.dom.Document createDocument(String content, ErrorHandler handler) throws XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = null;
        parser.setErrorHandler(handler);
        InputSource is = new InputSource(new StringReader(content));
        parser.parse(is);
        dom = parser.getDocument();
        return dom;
    }

    public static org.w3c.dom.Document createDocument(StringBuffer content) throws XMLParseException, SAXException, IOException {
        return DOMHelper.createDocument(content.toString());
    }

    public static void getTypeChildren(Type aType, String name, List result) {
        if (aType.getName().equals(name) && !aType.isList() && !aType.isEditingType()) {
            result.add(aType);
        }
        List directChilds = aType.getDirectChildren();
        for (int i = 0; i < directChilds.size(); ++i) {
            Type aChildType = (Type)directChilds.get(i);
            DOMHelper.getTypeChildren(aChildType, name, result);
        }
    }

    public static List getTypeChildren(Type aType, String name) {
        Vector result = new Vector();
        DOMHelper.getTypeChildren(aType, name, result);
        return result;
    }

    public static Type getTypeChild(Type aType, String name) {
        Vector result = new Vector();
        DOMHelper.getTypeChildren(aType, name, result);
        if (result.size() > 0) {
            return (Type)result.get(0);
        }
        return null;
    }

    public static String getXPathForRecursion(Type aType) {
        String xpath = aType.getPrefixedXPathLocation();
        Type recursiveParentType = aType;
        while ((recursiveParentType = DOMHelper.getRecursiveParent(recursiveParentType, false)) != null) {
            if (recursiveParentType == null || recursiveParentType.isList()) continue;
            String recursionParentXP = recursiveParentType.getPrefixedXPathLocation();
            String rptName = recursiveParentType.getSerializationName();
            recursionParentXP = recursionParentXP.substring(0, recursionParentXP.length() - rptName.length());
            String newxpath = xpath.substring(recursionParentXP.length(), xpath.length());
            xpath = new StringBuffer().append(recursionParentXP).append("/").append(newxpath).toString();
        }
        return xpath;
    }

    public static boolean hasAnonymousChildren(Type aType) {
        List childs = aType.getDirectChildren();
        int c = childs.size();
        for (int i = 0; i < c; ++i) {
            if (!((Type)childs.get(i)).isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public static Type getRecursiveParent(Type aType, boolean startWithCurrent) {
        if (aType == null) {
            return null;
        }
        if (startWithCurrent && aType.isRecursive()) {
            return aType;
        }
        return DOMHelper.getRecursiveParent(aType.getParent(), true);
    }

    public static boolean hasRecursiveParent(Type aType) {
        if (aType == null) {
            return false;
        }
        if (aType.isRecursive()) {
            return true;
        }
        return DOMHelper.hasRecursiveParent(aType.getParent());
    }

    public static Element getChild(XMLSchema schema, Element element, String[] name) {
        return DOMHelper.getChild(schema, element, name, -1);
    }

    public static Element getChild(XMLSchema schema, Element element, Type aType) {
        String tns = aType.getSchemaElement().getTargetNS();
        return DOMHelper.getChild(schema, element, tns, aType.getDOM().getDefaultNamespace(), aType.getName(), -1);
    }

    public static Element getChild(XMLSchema schema, Element element, String namespace, String defaultNS, String name, int index) {
        if (index != -1) {
            int locIndex = 0;
            NodeList nl = element.getChildNodes();
            int nlSize = nl.getLength();
            for (int ne = 0; ne < nlSize; ++ne) {
                Node nextElement = nl.item(ne);
                if (nextElement.getNodeType() != 1) continue;
                if (locIndex == index) {
                    return (Element)nextElement;
                }
                ++locIndex;
            }
            return null;
        }
        if (namespace == null) {
            namespace = defaultNS;
        }
        NodeList nl = element.getChildNodes();
        int nlSize = nl.getLength();
        Node found = null;
        for (int ne = 0; found == null && ne < nlSize; ++ne) {
            Node nextElement = nl.item(ne);
            if (!DOMHelper.equalsTypeElement(schema, defaultNS, nextElement, name, namespace, JAXFrontProperties.getInstance().ignoreNamespace())) continue;
            found = nextElement;
            break;
        }
        return (Element)found;
    }

    public static boolean equalsTypeElement(XMLSchema schema, Node instanceElement, Type aType, boolean ignoreNS) {
        String typeName = aType.getName();
        String typeNameSpace = aType.getNamespace();
        String defaultNS = schema.getTargetNamespace();
        return DOMHelper.equalsTypeElement(schema, defaultNS, instanceElement, typeName, typeNameSpace, ignoreNS);
    }

    public static boolean equalsTypeElement(XMLSchema schema, String defaultNS, Node instanceElement, String typeName, String typeNameSpace, boolean ignoreNS) {
        boolean isEqual = false;
        if (instanceElement.getNodeType() == 1) {
            String elementName = instanceElement.getLocalName();
            if (elementName == null) {
                elementName = instanceElement.getNodeName();
            }
            if (ignoreNS) {
                if (elementName.equals(typeName)) {
                    isEqual = true;
                }
            } else if (elementName.equals(typeName)) {
                String elementNS = instanceElement.getNamespaceURI();
                if (elementNS == null) {
                    elementNS = defaultNS;
                }
                if (typeNameSpace == null || schema.isDefaultNamespace(typeNameSpace)) {
                    typeNameSpace = defaultNS;
                }
                if (elementNS == typeNameSpace || elementNS.equals(typeNameSpace)) {
                    isEqual = true;
                } else if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("ns doesnt match:XML NS").append(elementNS).append(" typeNS:").append(typeNameSpace).toString());
                }
            }
        }
        return isEqual;
    }

    public static Element getChild(XMLSchema schema, Element element, String[] name, int index) {
        if (index != -1) {
            int locIndex = 0;
            NodeList nl = element.getChildNodes();
            int nlSize = nl.getLength();
            for (int ne = 0; ne < nlSize; ++ne) {
                Node nextElement = nl.item(ne);
                if (nextElement.getNodeType() != 1) continue;
                if (locIndex == index) {
                    return (Element)nextElement;
                }
                ++locIndex;
            }
            return null;
        }
        NodeList nl = element.getChildNodes();
        int nlSize = nl.getLength();
        Node found = null;
        for (int ne = 0; found == null && ne < nlSize; ++ne) {
            Node nextElement = nl.item(ne);
            if (nextElement == null || nextElement.getNodeType() != 1) continue;
            String elementName = nextElement.getLocalName();
            if (elementName == null) {
                elementName = nextElement.getNodeName();
            }
            for (int i = 0; i < name.length; ++i) {
                if (JAXFrontProperties.getInstance().ignoreNamespace()) {
                    if (!elementName.equals(name[i])) continue;
                    found = nextElement;
                    continue;
                }
                if (!elementName.equals(name[i])) continue;
                found = nextElement;
            }
        }
        return (Element)found;
    }

    public static Element getLastChild(XMLSchema schema, Element element, String[] name, int index) {
        if (index != -1) {
            int locIndex = 0;
            NodeList nl = element.getChildNodes();
            int nlSize = nl.getLength();
            for (int ne = nlSize - 1; ne >= 0; --ne) {
                Node nextElement = nl.item(ne);
                if (nextElement.getNodeType() != 1) continue;
                if (locIndex == index) {
                    return (Element)nextElement;
                }
                ++locIndex;
            }
            return null;
        }
        NodeList nl = element.getChildNodes();
        int nlSize = nl.getLength();
        Node found = null;
        for (int ne = nlSize - 1; found == null && ne >= 0; --ne) {
            Node nextElement = nl.item(ne);
            if (nextElement == null || nextElement.getNodeType() != 1) continue;
            String elementName = nextElement.getLocalName();
            if (elementName == null) {
                elementName = nextElement.getNodeName();
            }
            for (int i = 0; i < name.length; ++i) {
                if (JAXFrontProperties.getInstance().ignoreNamespace()) {
                    if (!elementName.equals(name[i])) continue;
                    found = nextElement;
                    continue;
                }
                if (!elementName.equals(name[i])) continue;
                found = nextElement;
            }
        }
        return (Element)found;
    }

    public static String getQualifiedElementName(XMLSchema schema, Element element) {
        String prefix;
        String elementName = element.getNodeName();
        String ns = element.getNamespaceURI();
        if (ns != null && ns.length() > 0 && (prefix = schema.getNamespacePrefix(ns)) != null && prefix.length() > 0) {
            elementName = new StringBuffer().append(prefix).append(":").append(element.getNodeName()).toString();
        }
        return elementName;
    }

    public static String getQualifiedElementName(XMLSchema schema, Node element) {
        String prefix;
        String elementName = element.getNodeName();
        String ns = element.getNamespaceURI();
        if (ns != null && ns.length() > 0 && (prefix = schema.getNamespacePrefix(ns)) != null && prefix.length() > 0) {
            elementName = new StringBuffer().append(prefix).append(":").append(element.getNodeName()).toString();
        }
        return elementName;
    }

    public static Element getChild(XMLSchema schema, Element element, String name) {
        return DOMHelper.getChild(schema, element, name, -1);
    }

    public static Element getChild(XMLSchema schema, Element element, String name, int index) {
        return DOMHelper.getChild(schema, element, new String[]{name}, index);
    }

    public static List getChildren(XMLSchema schema, Element element, Type aType) {
        return DOMHelper.getChildren(schema, element, aType.getNamespace(), aType.getDOM().getDefaultNamespace(), aType.getName());
    }

    public static List getChildren(XMLSchema schema, Element element, String namespace, String defaultNS, String name) {
        NodeList nl = element.getChildNodes();
        boolean ignoreNS = JAXFrontProperties.getInstance().ignoreNamespace();
        if (namespace == null) {
            namespace = defaultNS;
        }
        int nlSize = nl.getLength();
        ArrayList<Node> list = new ArrayList<Node>(nlSize);
        String elementName = null;
        for (int i = 0; i < nlSize; ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            elementName = node.getLocalName();
            if (elementName == null) {
                elementName = node.getNodeName();
            }
            if (ignoreNS) {
                if (!node.getLocalName().equals(name)) continue;
                list.add(node);
                continue;
            }
            if (!elementName.equals(name)) continue;
            String nxtNS = node.getNamespaceURI();
            if (nxtNS == null) {
                nxtNS = defaultNS;
            }
            if (namespace == null || schema.isDefaultNamespace(namespace)) {
                namespace = defaultNS;
            }
            if (nxtNS == namespace || nxtNS.equals(namespace)) {
                list.add(node);
                continue;
            }
            if (!JAXFrontProperties.LOG_ENABLED) continue;
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? DOMHelper.class$("com.jaxfront.core.dom.DOMHelper") : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("ns doesnt match:XML NS").append(node.getNamespaceURI()).append(" typeNS:").append(namespace).toString());
        }
        return list;
    }

    public static List getChildren(XMLSchema schema, Element element, String name) {
        NodeList nl = element.getChildNodes();
        boolean ignoreNS = JAXFrontProperties.getInstance().ignoreNamespace();
        int indexOfDP = name.indexOf(":");
        int nlSize = nl.getLength();
        Vector<Node> list = new Vector<Node>(nlSize);
        String elementName = null;
        for (int i = 0; i < nlSize; ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            elementName = node.getNodeName();
            if (schema != null && indexOfDP != -1 && elementName.indexOf(":") == -1) {
                elementName = DOMHelper.getQualifiedElementName(schema, node);
            }
            if (ignoreNS) {
                if (!node.getLocalName().equals(name)) continue;
                list.add(node);
                continue;
            }
            if (!elementName.equals(name)) continue;
            list.add(node);
        }
        return list;
    }

    public static List getAllChildren(Element element, String name) {
        Vector<Node> found = new Vector<Node>();
        NodeList nl = element.getElementsByTagName(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            found.add(nl.item(i));
        }
        return found;
    }

    public static String getChildText(XMLSchema schema, Element element, String name) {
        Element child = DOMHelper.getChild(schema, element, name);
        if (child != null) {
            return DOMHelper.getText(child);
        }
        return null;
    }

    public static Element getFirstChild(Element element) {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getText(Element element) {
        String text = DOMHelper.getTextNode(element).getNodeValue();
        if (text != null && text.length() == 0) {
            return null;
        }
        return text;
    }

    public static String getMixedContentText(Element element) {
        String text = DOMHelper.getMixedTextNode(element).getNodeValue();
        if (text != null && text.length() == 0) {
            return null;
        }
        text = text.trim();
        return text;
    }

    public static Node getTextNode(Element element) {
        Node textNode = element.getFirstChild();
        if (textNode == null || textNode.getNodeType() != 3) {
            textNode = element.getOwnerDocument().createTextNode("");
            if (textNode == null) {
                element.appendChild(textNode);
            } else {
                element.insertBefore(textNode, element.getFirstChild());
            }
        }
        if (textNode != null && textNode.getNextSibling() != null && textNode.getNextSibling().getNodeType() == 4) {
            textNode = textNode.getNextSibling();
        }
        return textNode;
    }

    public static Node getMixedTextNode(Element element) {
        String nodeValue;
        Node textNode = element.getFirstChild();
        if (textNode != null && textNode.getNodeValue() != null && (nodeValue = textNode.getNodeValue().trim()).length() == 0) {
            textNode = null;
        }
        if (!(textNode != null && textNode.getNodeType() == 3 || (textNode = element.getLastChild()) != null && textNode.getNodeType() == 3)) {
            textNode = element.getOwnerDocument().createTextNode("");
            if (textNode == null) {
                element.appendChild(textNode);
            } else {
                element.insertBefore(textNode, element.getFirstChild());
            }
        }
        if (textNode != null && textNode.getNextSibling() != null && textNode.getNextSibling().getNodeType() == 4) {
            textNode = textNode.getNextSibling();
        }
        return textNode;
    }

    public static String serializeElement(Element elmt) {
        String content = null;
        if (elmt != null) {
            try {
                OutputFormat format = new OutputFormat();
                format.setIndenting(true);
                format.setOmitComments(true);
                format.setOmitDocumentType(true);
                format.setOmitXMLDeclaration(true);
                format.setLineWidth(0);
                format.setPreserveSpace(true);
                StringWriter writer = new StringWriter();
                XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
                serializer.asDOMSerializer();
                serializer.serialize(elmt);
                content = writer.getBuffer().toString();
                writer.close();
            }
            catch (IOException ex) {
                LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("Unable to serialize document --> ").append(ex.getMessage()).toString());
            }
        }
        return content;
    }

    public static String serialize(org.w3c.dom.Document dom) {
        String content;
        block2: {
            content = null;
            try {
                OutputFormat format = new OutputFormat(dom);
                format.setLineSeparator("\r\n");
                format.setIndenting(true);
                format.setLineWidth(0);
                format.setPreserveSpace(true);
                StringWriter writer = new StringWriter();
                XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
                serializer.asDOMSerializer();
                serializer.serialize(dom);
                content = writer.getBuffer().toString();
                writer.close();
            }
            catch (IOException ex) {
                if (!LogRegistry.getInstance().logWarnings()) break block2;
                LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("Unable to serialize document --> ").append(ex.getMessage()).toString());
            }
        }
        return content;
    }

    public static void setText(Element element, String text) {
        DOMHelper.getTextNode(element).setNodeValue(text);
    }

    public static String getEncoding(org.w3c.dom.Document dom) {
        if (dom instanceof DeferredDocumentImpl) {
            try {
                return ((DeferredDocumentImpl)dom).getXmlEncoding();
            }
            catch (Throwable t) {
                try {
                    return ((DeferredDocumentImpl)dom).getEncoding();
                }
                catch (Throwable t1) {
                    return "UTF-8";
                }
            }
        }
        return null;
    }

    public static void write(StringBuffer buffer, Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        writer.write(buffer.toString());
        writer.close();
    }

    public static String[] getValues(ListType list) {
        ListType userList = list;
        String[] values = null;
        if (userList != null) {
            values = new String[list.size()];
            for (int u = 0; u < userList.size(); ++u) {
                values[u] = ((Type)userList.get(u)).getDisplayValue();
            }
        }
        return values;
    }

    public static int[] getIntValues(ListType list) {
        ListType userList = list;
        int[] values = null;
        if (userList != null) {
            values = new int[list.size()];
            for (int u = 0; u < userList.size(); ++u) {
                values[u] = Integer.valueOf(((Type)userList.get(u)).getDisplayValue());
            }
        }
        return values;
    }

    public static void write(StringBuffer buffer, File file) {
        try {
            DOMHelper.write(buffer, new OutputStreamWriter((OutputStream)new FileOutputStream(file), JAXFrontProperties.getDefaultXMLFileEncoding()));
        }
        catch (Exception e) {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("The file: ").append(file.getName()).append(" is saved to c:\\temp . Please update jaxfront.jar manually !").toString());
            }
            try {
                DOMHelper.write(buffer, new OutputStreamWriter(new FileOutputStream(file)));
            }
            catch (Exception ex) {
                LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, ex);
            }
        }
    }

    public static void write(StringBuffer buffer, File file, String encoding) throws IOException {
        try {
            DOMHelper.write(buffer, new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        }
        catch (IOException e) {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e.toString());
            }
            throw e;
        }
    }

    public static Node getProcessingInstructionTarget(Node startNode, String target) {
        NodeList children = startNode.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node node = children.item(i);
            if (!(node instanceof ProcessingInstruction) || !node.getNodeName().equals(target)) continue;
            return node;
        }
        return null;
    }

    public static String getNoNameSpaceSchemaLocation(org.w3c.dom.Document dom) {
        return DOMHelper.getDocElementValue(dom, "xsi:noNamespaceSchemaLocation");
    }

    public static String getNameSpaceSchemaLocation(org.w3c.dom.Document dom) {
        return DOMHelper.getDocElementValue(dom, "xsi:schemaLocation");
    }

    public static String getDocElementValue(org.w3c.dom.Document dom, String key) {
        NamedNodeMap attrs = dom.getDocumentElement().getAttributes();
        Node aNode = attrs.getNamedItem(key);
        if (aNode != null) {
            return aNode.getNodeValue();
        }
        return null;
    }

    public static String getProcessingInstructionValue(Node startNode, String target) {
        Node targetNode = DOMHelper.getProcessingInstructionTarget(startNode, target);
        if (targetNode != null) {
            return targetNode.getNodeValue();
        }
        return null;
    }

    public static Vector getProcessingInstructions(Node startNode) {
        Vector<String> pi = new Vector<String>();
        NodeList children = startNode.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node node = children.item(i);
            if (!(node instanceof ProcessingInstruction)) continue;
            pi.add(DOMHelper.formatPI(node));
        }
        return pi;
    }

    public static ProcessingInstruction getProcessingInstruction(Node node) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        Node subNode = null;
        for (int i = 0; i < childCount; ++i) {
            subNode = children.item(i);
            if (!(subNode instanceof ProcessingInstruction)) continue;
            return (ProcessingInstruction)subNode;
        }
        return null;
    }

    public static String formatPI(Node node) {
        String pi = new StringBuffer().append("<?").append(node.getNodeName()).append(" ").append(node.getNodeValue()).append("?>").toString();
        return pi;
    }

    public static String getProcessingInstructionValue(Node startNode, String target, String attribute) {
        String value = DOMHelper.getProcessingInstructionValue(startNode, target);
        if (value != null) {
            String searchString = new StringBuffer().append(attribute).append(EQUALS).toString();
            int index = value.indexOf(searchString);
            if (index != -1) {
                if ((index = (value = value.substring(index + searchString.length())).indexOf(";")) != -1) {
                    value = value.substring(0, index);
                }
            } else {
                value = null;
            }
        }
        return value;
    }

    public static String getXMLProcessingInstructionValue(org.w3c.dom.Document document, String target, String attribute) {
        String pInstructionValue;
        if (document != null && (pInstructionValue = DOMHelper.getProcessingInstructionValue(document, target)) != null && pInstructionValue.indexOf(attribute) != -1) {
            pInstructionValue = pInstructionValue.substring(pInstructionValue.indexOf(attribute) + attribute.length());
            pInstructionValue = pInstructionValue.replace('\"', '\'');
            for (int i = 0; i < pInstructionValue.length(); ++i) {
                if (pInstructionValue.charAt(i) != '\'') continue;
                int indexOfSingleQuote = pInstructionValue.indexOf("'", i + 1);
                return pInstructionValue.substring(i + 1, indexOfSingleQuote);
            }
            return null;
        }
        return null;
    }

    public static String getGlobalNameFromXPath(String xpath) {
        int startIndex = xpath.indexOf(":") + 1;
        int endIndex = xpath.length();
        String globalXPath = null;
        int slIndex = xpath.indexOf("/");
        if (slIndex != -1) {
            endIndex = slIndex;
        }
        if (xpath.length() > endIndex) {
            globalXPath = xpath.substring(endIndex, xpath.length());
        }
        globalXPath = globalXPath != null ? new StringBuffer().append(".").append(globalXPath).toString() : ".";
        String globalName = xpath.substring(startIndex, endIndex);
        return globalName;
    }

    public static String getGlobalAddressFromXPath(String xpath) {
        int endIndex = xpath.length();
        String globalXPath = null;
        int slIndex = xpath.indexOf("/");
        if (slIndex != -1) {
            endIndex = slIndex;
        }
        if (xpath.length() > endIndex) {
            globalXPath = xpath.substring(endIndex, xpath.length());
        }
        globalXPath = globalXPath != null ? new StringBuffer().append(".").append(globalXPath).toString() : ".";
        return globalXPath;
    }

    public static String getRelativeXPathLocation(Type type) {
        return DOMHelper.getRelativeXPathLocation(type, type.getXPathLocation());
    }

    public static Type getRoot(Type aType) {
        Type parent = aType.getParent();
        if (parent == null) {
            return aType;
        }
        return DOMHelper.getRoot(parent);
    }

    public static String getRelativeXPathLocation(Type type, String xpath) {
        StringTokenizer st = new StringTokenizer(xpath, "[]");
        String token = null;
        int counter = 0;
        String newXPath = null;
        while (st.hasMoreElements()) {
            token = st.nextToken();
            if (counter % 2 == 0) {
                newXPath = counter > 0 ? new StringBuffer().append(newXPath).append(token).toString() : token;
            }
            ++counter;
        }
        if (type != null && newXPath != null) {
            if (type.isList()) {
                newXPath = new StringBuffer().append(newXPath).append("[").append(token).append("]").toString();
            } else if (type.isSimple() && ((SimpleType)type).isSimpleContent()) {
                newXPath = new StringBuffer().append(newXPath).append("[").append(token).append("]").toString();
            }
        }
        return newXPath;
    }

    public static void getPlainXPath(Type type, StringBuffer px) {
        Type parent = type.getParent();
        if (parent != null) {
            DOMHelper.getPlainXPath(parent, px);
        }
        if (!type.isList()) {
            px.append("/");
            if (type.isAttribute()) {
                px.append("@");
            }
            px.append(type.getName());
        }
    }

    public static void getPlainXPath(SchemaNode node, StringBuffer px) {
        SchemaNode parent = node.getParent();
        if (parent != null) {
            DOMHelper.getPlainXPath(parent, px);
        }
        if (!node.getSchemaType().getType().isList()) {
            px.append("/");
            if (node.getSchemaType().getType().isAttribute()) {
                px.append("@");
            }
            px.append(node.getName());
        }
    }

    public static StringBuffer createInfoXPath(Type from, int level, boolean breakAtFirstList, boolean breakAtFirstComposite) {
        StringBuffer px = new StringBuffer();
        DOMHelper.createInfoXPath(from, px, level, breakAtFirstList, breakAtFirstComposite);
        return px;
    }

    public static void createInfoListXPath(Type from, StringBuffer px, int level) {
        if (level == 0) {
            return;
        }
        Type parent = from.getParent();
        if (parent != null) {
            DOMHelper.createInfoListXPath(parent, px, --level);
        }
        if (!from.isList()) {
            px.append("/");
            if (from.getParent() != null && from.getParent().isList()) {
                int index = ((ListType)from.getParent()).getList().indexOf(from);
                px.append(new StringBuffer().append(from.getName()).append("[").append(index).append("]").toString());
            }
        }
    }

    public static void createInfoXPath(Type from, StringBuffer px, int level, boolean breakAtFirstList, boolean breakAtFirstComposite) {
        if (level == 0) {
            return;
        }
        boolean bypass = false;
        if (breakAtFirstList && from.isList()) {
            DOMHelper.createInfoListXPath(from, px, -1);
            bypass = true;
        }
        if (breakAtFirstComposite && from.isComposite()) {
            DOMHelper.createInfoListXPath(from, px, -1);
            bypass = true;
        }
        Type parent = from.getParent();
        if (!bypass && parent != null) {
            DOMHelper.createInfoXPath(parent, px, --level, breakAtFirstList, breakAtFirstComposite);
        }
        if (!from.isList()) {
            px.append("/");
            if (from.isAttribute()) {
                px.append("@");
            }
            if (from.getParent() != null && from.getParent().isList()) {
                int index = ((ListType)from.getParent()).getList().indexOf(from);
                px.append(new StringBuffer().append(from.getName()).append("[").append(index).append("]").toString());
            } else {
                px.append(from.getName());
            }
        } else {
            px.append(new StringBuffer().append(from.getName()).append("[list]").toString());
        }
    }

    public static Type getComplexParent(Type aChildType) {
        Type result = null;
        if (aChildType.isComposite()) {
            return aChildType;
        }
        while (aChildType.getParent() != null) {
            if (!(aChildType = aChildType.getParent()).isComposite()) continue;
            result = aChildType;
            break;
        }
        return result;
    }

    public static String getValueFromXPath(String xpath, Type root) {
        Type foundType;
        List tempList;
        String value = null;
        if (xpath != null && xpath.length() > 0 && (tempList = TypePathExecuter.getInstance().processXPath(root, xpath)).size() > 0 && (foundType = (Type)tempList.get(0)).isSimple()) {
            value = ((SimpleType)foundType).getValue();
        }
        return value;
    }

    public static String getRelativeEditingTypeXPath(Type startType, Type editingType) {
        ListType parentList = startType.getParentList();
        if (parentList == null) {
            return null;
        }
        if (editingType == parentList.getEditingType()) {
            return ".";
        }
        String listXPath = DOMHelper.getRelativeXPathLocation(parentList.getEditingType());
        String sourceXPath = DOMHelper.getRelativeXPathLocation(editingType);
        if (listXPath.length() > sourceXPath.length()) {
            return null;
        }
        String relativeXPath = new StringBuffer().append(".").append(sourceXPath.substring(listXPath.length(), sourceXPath.length())).toString();
        return relativeXPath;
    }

    public static Hashtable extractAnnotation(XSAnnotation annotationObject) {
        Hashtable<String, String> annotations = null;
        String annotationString = annotationObject.getAnnotationString();
        if (annotationString != null && annotationString.length() > 0) {
            try {
                org.w3c.dom.Document dom = DOMHelper.createDocument(annotationString, null);
                List childNodes = DOMHelper.getChildren(null, dom.getDocumentElement());
                if (childNodes.size() > 0) {
                    annotations = new Hashtable<String, String>();
                }
                Element docNode = null;
                String text = null;
                String language = null;
                for (int i = 0; i < childNodes.size(); ++i) {
                    Node aNode;
                    docNode = (Element)childNodes.get(i);
                    text = DOMHelper.getText(docNode);
                    if (text == null) continue;
                    NamedNodeMap attrs = docNode.getAttributes();
                    if (attrs.getLength() > 0 && (aNode = attrs.item(0)) != null) {
                        language = aNode.getNodeValue();
                    }
                    if (language != null) {
                        annotations.put(language, text);
                        continue;
                    }
                    annotations.put("default", text);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return annotations;
    }

    public static Vector getGlobalTypes(Type type) {
        Vector<Type> globalTypes = new Vector<Type>();
        boolean startFromGlobal = DOMHelper.isDerivedFromGlobal(type);
        if (startFromGlobal) {
            if (!globalTypes.contains(type)) {
                globalTypes.add(type);
            }
            DOMHelper.getGlobalTypesFromGlobal(type, globalTypes);
        } else {
            DOMHelper.getGlobalTypes(type, globalTypes);
        }
        return globalTypes;
    }

    public static void evalGlobalTypes(Type type, Vector resultTypes, Vector resultXPaths) {
        Stack buff = new Stack();
        DOMHelper.evalGlobalTypes(type, resultTypes, type.getDOM().getSchema().getGlobalEntities(), buff, resultXPaths);
    }

    public static void evalGlobalTypes(Type type, Vector resultTypes, Map globalTypes, Stack buff, Vector resultXPaths) {
        SchemaNode schemaNode = type.getSchemaElement();
        if (schemaNode != null) {
            boolean isRef;
            String refName = schemaNode.getRefName();
            boolean bl = isRef = refName != null;
            if (buff.size() == 0 || !type.isList()) {
                String name = type.getSerializationName();
                if (type.isAttribute()) {
                    name = new StringBuffer().append("@").append(name).toString();
                }
                buff.add(name);
            }
            if (type.getSchemaElement().isGlobal() && type.isGlobal()) {
                resultXPaths.add(ArrayUtil.toXPath(buff));
                resultTypes.add(type.getSchemaElement());
            } else if (type.isDerived()) {
                resultXPaths.add(ArrayUtil.toXPath(buff));
                resultTypes.add(type.getSchemaElement());
            }
            if (isRef) {
                DOMHelper.evalGlobalTypesRefBased(schemaNode, resultTypes, globalTypes, buff, resultXPaths);
            }
            if (type.getParent() != null) {
                DOMHelper.evalGlobalTypes(type.getParent(), resultTypes, globalTypes, buff, resultXPaths);
            }
        }
    }

    public static void evalGlobalTypesGlobalRefBased(Type type, Vector resultTypes, Map globalTypes, Stack buff, Vector resultXPaths) {
        if (type.getParent() != null) {
            DOMHelper.evalGlobalTypes(type.getParent(), resultTypes, globalTypes, buff, resultXPaths);
        }
    }

    public static void evalGlobalTypesRefBased(SchemaNode schemaNode, Vector resultTypes, Map globalTypes, Stack buff, Vector resultXPaths) {
        if (schemaNode.getRefName() != null) {
            SchemaNode globalHashEntry = (SchemaNode)globalTypes.get(schemaNode.getRefName());
            if (globalHashEntry == null) {
                globalHashEntry = (SchemaNode)globalTypes.get(schemaNode.getSchemaType().getQName());
            }
            if (globalHashEntry != null && !resultTypes.contains(globalHashEntry)) {
                resultTypes.add(globalHashEntry);
                Object old = buff.pop();
                String name = null;
                name = schemaNode.isReferenceToGlobalType() ? (globalHashEntry.getNamespacePrefix() != null ? new StringBuffer().append(globalHashEntry.getNamespacePrefix()).append(":").append(globalHashEntry.getSchemaType().getName()).toString() : globalHashEntry.getSchemaType().getName()) : (globalHashEntry.getNamespacePrefix() != null ? new StringBuffer().append(globalHashEntry.getNamespacePrefix()).append(":").append(globalHashEntry.getName()).toString() : globalHashEntry.getName());
                buff.push(name);
                resultXPaths.add(ArrayUtil.toXPath(buff));
                buff.pop();
                if (globalHashEntry.isSimple()) {
                    XSObject stO = globalHashEntry.getNode();
                    switch (stO.getType()) {
                        case 3: {
                            SchemaNode restrictionBase;
                            XSSimpleType st = (XSSimpleType)stO;
                            if (st.getBaseType() == null || (restrictionBase = (SchemaNode)globalTypes.get(new StringBuffer().append(st.getBaseType().getNamespace()).append(":").append(st.getBaseType().getName()).toString())) == null || resultTypes.contains(restrictionBase)) break;
                            resultTypes.add(restrictionBase);
                            buff.push(restrictionBase.getNamespacePrefix() != null ? new StringBuffer().append(restrictionBase.getNamespacePrefix()).append(":").append(restrictionBase.getName()).toString() : restrictionBase.getName());
                            resultXPaths.add(ArrayUtil.toXPath(buff));
                            buff.pop();
                            break;
                        }
                        case 2: {
                            XSElementDecl eSt = (XSElementDecl)stO;
                            SchemaNode restrictionBase = (SchemaNode)globalTypes.get(new StringBuffer().append(eSt.getNamespace()).append(":").append(eSt.getName()).toString());
                            if (restrictionBase == null || resultTypes.contains(restrictionBase)) break;
                            resultTypes.add(restrictionBase);
                            buff.push(restrictionBase.getNamespacePrefix() != null ? new StringBuffer().append(restrictionBase.getNamespacePrefix()).append(":").append(restrictionBase.getName()).toString() : restrictionBase.getName());
                            resultXPaths.add(ArrayUtil.toXPath(buff));
                            buff.pop();
                            break;
                        }
                    }
                }
                buff.push(old);
                DOMHelper.evalGlobalTypesRefBased(globalHashEntry, resultTypes, globalTypes, buff, resultXPaths);
            }
        }
    }

    public static void evalGlobalTypesElementBased(Type type, Vector resultTypes, Map globalTypes, Stack buff, Vector resultXPaths) {
        if (type.getParent() != null) {
            DOMHelper.evalGlobalTypes(type.getParent(), resultTypes, globalTypes, buff, resultXPaths);
        }
    }

    private static boolean isDerivedFromGlobal(Type type) {
        if (type == null || type.getDOM() == null) {
            return false;
        }
        if (type.getParent() == null) {
            return type != type.getDOM().getRootType();
        }
        return DOMHelper.isDerivedFromGlobal(type.getParent());
    }

    private static Vector getGlobalTypesFromGlobal(Type type, Vector globalTypes) {
        SchemaNode node = null;
        if (type != null && (node = type.getSchemaElement()) != null) {
            SchemaNode global;
            if (node.getRefName() != null && (global = node.getSchema().getGlobalEntity(node.getNode().getType(), node.getRefName())) != null && !globalTypes.contains(type)) {
                globalTypes.add(type);
            }
            if (type.getParent() != null) {
                DOMHelper.getGlobalTypes(type.getParent(), globalTypes);
            }
        }
        return globalTypes;
    }

    private static Vector getGlobalTypes(Type type, Vector globalTypes) {
        SchemaNode scNode = null;
        if (type != null && (scNode = type.getSchemaElement()) != null) {
            if (!type.isList() && (scNode.isGlobalReference() || type.getDOM() != null && scNode.getSchema().isGlobalEntity(scNode.getNode().getType(), type.getQName())) && !globalTypes.contains(type)) {
                SchemaNode globalNode;
                globalTypes.add(type);
                if (type.getDOM() != null && (globalNode = type.getSchemaElement().getSchema().getGlobalEntity(scNode.getNode().getType(), type.getQName())) != null && globalNode.isGlobalReference()) {
                    SchemaNode refNode;
                    String lookupName = globalNode.getQName();
                    if (globalNode.getTargetNS() != null && globalNode.getTargetNS().length() > 0) {
                        lookupName = new StringBuffer().append(globalNode.getTargetNS()).append(":").append(globalNode.getSchemaType().getName()).toString();
                    }
                    if ((refNode = type.getSchemaElement().getSchema().getGlobalEntity(scNode.getNode().getType(), lookupName)) != null) {
                        DOMHelper.getGlobalTypes(refNode.getSchemaType().getType(), globalTypes);
                    }
                }
            }
            if (type.getParent() != null) {
                DOMHelper.getGlobalTypes(type.getParent(), globalTypes);
            }
        }
        return globalTypes;
    }

    private static int countEditingTypeSubNodes(Type type, Hashtable recursionHash) {
        int currentNo = 0;
        List list = type.getDirectChildren();
        if (type.isList()) {
            Type edType = ((ListType)type).getEditingType();
            currentNo += DOMHelper.countSubNodes(edType, recursionHash, true, false, false, false);
        }
        Iterator iterator = list.iterator();
        currentNo += type.getDirectChildren().size();
        while (iterator.hasNext()) {
            Type subType = (Type)iterator.next();
            DOMHelper.countEditingTypeSubNodes(subType, recursionHash);
        }
        return currentNo;
    }

    private static int countSubNodes(Type type, Hashtable recursionHash, boolean inclEditinType, boolean notEmpty, boolean onlySimple, boolean onlyUserChanged) {
        int currentNo = 0;
        if (onlySimple) {
            if (type.isSimple()) {
                SimpleType st = (SimpleType)type;
                if (notEmpty) {
                    String pVal = st.getPlainValue();
                    if (pVal != null && pVal.length() > 0 && !st.isUsingDefaultValue()) {
                        if (onlyUserChanged) {
                            if (st.hasChanged()) {
                                currentNo = 1;
                            }
                        } else {
                            currentNo = 1;
                        }
                    }
                } else if (onlyUserChanged) {
                    if (st.hasChanged()) {
                        currentNo = 1;
                    }
                } else {
                    currentNo = 1;
                }
            }
        } else if (notEmpty) {
            if (!type.isEmpty()) {
                currentNo = 1;
            }
        } else {
            currentNo = 1;
        }
        recursionHash.put(type, type);
        Vector<Type> tempList = new Vector<Type>();
        tempList.addAll(type.getDirectChildren());
        if (inclEditinType && type.isList()) {
            tempList.add(((ListType)type).getEditingType());
        }
        Iterator i$ = tempList.iterator();
        while (i$.hasNext()) {
            Type aType;
            Type subType = aType = (Type)i$.next();
            currentNo += DOMHelper.countSubNodes(subType, recursionHash, inclEditinType, notEmpty, onlySimple, onlyUserChanged);
        }
        return currentNo;
    }

    public static int countSubNodes(SchemaNode node) {
        return DOMHelper.countSubNodes(node, new Hashtable());
    }

    public static int countSubNodes(SchemaNode node, Hashtable recursionHash) {
        int currentNo = 0;
        if (recursionHash.contains(node)) {
            return currentNo;
        }
        recursionHash.put(node, node);
        ++currentNo;
        SchemaNode[] elements = node.getElementSet();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                SchemaNode aChildType = elements[i];
                currentNo += DOMHelper.countSubNodes(aChildType, recursionHash);
            }
        }
        return currentNo;
    }

    private static int countNodeDepth(Type type, Stack nodeStack) {
        int depth = 0;
        ++depth;
        if (!type.isSimple()) {
            if (nodeStack.contains(type)) {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("recursion detected for ").append(type.getName()).toString());
                }
                return 0;
            }
            nodeStack.push(type);
            List list = type.getDirectChildren();
            Iterator iterator = list.iterator();
            int tempDepth = 0;
            while (iterator.hasNext()) {
                Type subType = (Type)iterator.next();
                int leafDepth = DOMHelper.countNodeDepth(subType, nodeStack);
                tempDepth = tempDepth < leafDepth ? leafDepth : tempDepth;
            }
            depth += tempDepth;
            nodeStack.pop();
        }
        return depth;
    }

    public static int getNodeDepth(Type type) {
        int depth = 0;
        while ((type = type.getParent()) != null) {
            ++depth;
        }
        return depth;
    }

    public static int[] generateHierachyId(Type type) {
        int[] res = null;
        res = DOMHelper.generateId(type, res);
        return ArrayUtil.finalizeGrowArray(res);
    }

    private static int[] generateId(Type type, int[] id) {
        Type pt = null;
        if (type != null && (pt = type.getParent()) != null) {
            if (pt.isList()) {
                id = ArrayUtil.addToGrowArray(id, ((ListType)pt).indexOf(type), 10);
                DOMHelper.generateId(pt, id);
            } else {
                List composites = ((CompositeType)pt).getComposites();
                id = ArrayUtil.addToGrowArray(id, composites.indexOf(type), 10);
                DOMHelper.generateId(pt, id);
            }
        }
        return id;
    }

    public static int countSubNodes(Type type, boolean inclEditingType, boolean notEmpty, boolean onlySimple, boolean onlyUserChanged) {
        Hashtable nodeStack = new Hashtable();
        int count = DOMHelper.countSubNodes(type, nodeStack, inclEditingType, notEmpty, onlySimple, onlyUserChanged);
        return count;
    }

    public static int countEditingTypeSubNodes(Type type) {
        Hashtable nodeStack = new Hashtable();
        return DOMHelper.countEditingTypeSubNodes(type, nodeStack);
    }

    public static int countNodeDepth(Type type) {
        Stack nodeStack = new Stack();
        return DOMHelper.countNodeDepth(type, nodeStack);
    }

    public static String[] getGlobalParentXPathsUpTo(Type type) {
        Vector globalTypes = new Vector();
        Vector globalTypesXPaths = new Vector();
        DOMHelper.evalGlobalTypes(type, globalTypes, globalTypesXPaths);
        return ArrayUtil.toStringArray(globalTypesXPaths);
    }

    public static String getAbsoluteXPath(Type type) {
        String xpath = type.getXPathLocation();
        StringBuffer absoluteXPath = new StringBuffer();
        int l = xpath.length();
        boolean skip = false;
        for (int i = 0; i < l; ++i) {
            char c = xpath.charAt(i);
            if (c == '[') {
                skip = true;
            } else if (c == ']') {
                skip = false;
            }
            if (skip || c == ']') continue;
            absoluteXPath.append(c);
        }
        return absoluteXPath.toString();
    }

    public static void merge(XMLSchema schema, Node originalParentNode, Node nodeToMerge) {
        String data;
        org.w3c.dom.Document targetDoc = originalParentNode.getOwnerDocument();
        if (nodeToMerge.getNodeType() == 1) {
            Element origNode = DOMHelper.getChild(schema, (Element)originalParentNode, nodeToMerge.getNodeName());
            if (origNode == null) {
                Node nodeToImport = targetDoc.importNode(nodeToMerge, true);
                Node importedNode = originalParentNode.appendChild(nodeToImport);
                if (nodeToImport.getChildNodes().getLength() == 1) {
                    ((Element)importedNode).setAttributeNS("jaxfront", "included", "true");
                } else {
                    DOMHelper.markAsIncluded(importedNode);
                }
            } else {
                int i;
                if (nodeToMerge.hasAttributes()) {
                    String attributeName = null;
                    Node attribute = null;
                    for (i = 0; i < nodeToMerge.getAttributes().getLength(); ++i) {
                        Node foundAttribute;
                        attribute = nodeToMerge.getAttributes().item(i);
                        attributeName = attribute.getNodeName();
                        boolean found = false;
                        if (origNode.getAttributes() != null && (foundAttribute = origNode.getAttributes().getNamedItem(attributeName)) != null) {
                            found = true;
                        }
                        if (found) continue;
                        targetDoc.importNode(attribute, false);
                        origNode.appendChild(attribute);
                    }
                }
                NodeList nlist = nodeToMerge.getChildNodes();
                int nlength = nlist.getLength();
                for (i = 0; i < nlength; ++i) {
                    Node child = nlist.item(i);
                    DOMHelper.merge(schema, origNode, child);
                }
            }
        } else if (nodeToMerge.getNodeType() == 3 && (data = nodeToMerge.getNodeValue().trim()).length() > 0) {
            Text textNode = targetDoc.createTextNode(data);
            originalParentNode.appendChild(textNode);
        }
    }

    private static void markAsIncluded(Node node) {
        if (node.getChildNodes().getLength() == 1) {
            ((Element)node).setAttributeNS("jaxfront", "included", "true");
        }
        NodeList nlist = node.getChildNodes();
        int nlength = nlist.getLength();
        for (int i = 0; i < nlength; ++i) {
            Node child = nlist.item(i);
            DOMHelper.markAsIncluded(child);
        }
    }

    public static org.w3c.dom.Document createDocument(Reader reader) throws XMLParseException, SAXException, IOException {
        return DOMHelper.createDocument(new InputSource(reader));
    }

    public static String getConditionalXPathHolder(String xpath) {
        StringTokenizer st = new StringTokenizer(xpath, "]");
        String token = null;
        String bracketContent = "";
        int openBracketIndex = -1;
        String xpathRevised = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.length() > 0 && (openBracketIndex = token.lastIndexOf("[")) != -1 && !(bracketContent = token.substring(openBracketIndex + 1, token.length())).equals("list")) {
                try {
                    Integer.parseInt(bracketContent);
                }
                catch (NumberFormatException ex) {
                    xpathRevised = new StringBuffer().append(xpathRevised).append(token.substring(0, openBracketIndex)).toString();
                    return xpathRevised;
                }
            }
            xpathRevised = new StringBuffer().append(xpathRevised).append(token).append("]").toString();
        }
        return null;
    }

    public static Type getDerivedType(Type abstractType, String name, boolean makeCopy) {
        Type derivate2 = null;
        if (makeCopy && (derivate2 = abstractType.getDirectChild(name)) != null) {
            if (abstractType.getChoosenType() != null) {
                abstractType.getChoosenType().setSerializable(false);
            }
            derivate2.setSerializable(true);
            abstractType.setChoosenType(derivate2, true);
            return derivate2;
        }
        for (Type derivate2 : abstractType.getDerivedTypes()) {
            String derivationName = derivate2.getName();
            if (name != null && name.indexOf(":") == -1) {
                derivationName = derivate2.getName();
            }
            if (!derivationName.equals(name)) continue;
            if (makeCopy) {
                try {
                    AbstractType clone = (AbstractType)derivate2.deepClone(abstractType.getDOM(), false, false);
                    clone.setParent(abstractType);
                    clone.setAnonymous(true);
                    if (abstractType.isComposite()) {
                        CompositeType composite = (CompositeType)abstractType;
                        composite.getComposites().add(clone);
                        composite.setChoosenType(clone, true);
                    }
                    return clone;
                }
                catch (CloneNotSupportedException ex) {
                    if (!LogRegistry.getInstance().logWarnings()) continue;
                    LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? DOMHelper.class$("com.jaxfront.core.dom.DOMHelper") : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("Unable to deepclone: ").append(derivate2.getName()).toString());
                    continue;
                }
            }
            return derivate2;
        }
        return null;
    }

    public static List getLockedTypes(Type rootType, String xpath) {
        List tempFound = new Vector();
        Vector<Type> found = new Vector<Type>();
        tempFound = TypePathExecuter.getInstance().processXPath(rootType, xpath);
        Iterator iterator = tempFound.iterator();
        Type foundType = null;
        while (iterator.hasNext()) {
            foundType = (Type)iterator.next();
            if (!foundType.isSimple() && !foundType.isSerializable()) continue;
            found.add(foundType);
        }
        return found;
    }

    public static Document getXMLDBMappingDOM(String context, URL xsdURL, URL xuiURL) {
        Document xmlDBMapperDOM;
        block5: {
            xmlDBMapperDOM = null;
            try {
                ClassLoader cl = (class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper).getClassLoader();
                URL xmlDBMappingXSD = cl.getResource("xmlDBMapping.xsd");
                URL xmlDBMappingXUI = cl.getResource("xmlDBMapping.xui");
                URL xmlDBMappingXML = URLHelper.getXMLDBMappingURL(xsdURL, xuiURL);
                try {
                    if (xmlDBMappingXML != null) {
                        JAXFrontProperties.getInstance().getURLResolver().resolveURL(xmlDBMappingXML);
                    }
                }
                catch (IOException ex) {
                    xmlDBMappingXML = null;
                }
                xmlDBMapperDOM = DOMBuilder.getInstance().build(context, xmlDBMappingXSD, xmlDBMappingXML, xmlDBMappingXUI, "XMLDBMapping");
            }
            catch (Throwable t) {
                if (!LogRegistry.getInstance().logWarnings()) break block5;
                LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("Unable to create XML-DBMapping DOM for (xsd=").append(xsdURL.toExternalForm()).append(")").toString());
            }
        }
        return xmlDBMapperDOM;
    }

    public static Document updateJAXFormsDOM(Document jaxformsDOM, Document targetDOM, org.w3c.dom.Document xmlDataDOM, Document xuiDOM, Document pdfXUIDOM, URL xsdURL, URL xuiURL, NLS nls, URL xmlURL) {
        boolean isUsingEmbeddedNLS = JAXFrontProperties.getInstance().useEmbeddedNLS();
        try {
            Document targetDOMCopy = targetDOM.copy();
            String language = xuiDOM.getRootType().getDirectChild("global").getDirectChild("general").getDirectChildValue("language");
            CodeTables codeTables = targetDOMCopy.getSchema().getCodeTables();
            if (codeTables != null) {
                codeTables.setLanguage(language);
            }
            targetDOMCopy.setFingerPrint(xuiDOM.getFingerPrint());
            targetDOMCopy.refresh(xmlDataDOM, xuiDOM);
            if (!isUsingEmbeddedNLS) {
                NLS.storeEmbeddedNLS(xuiDOM, targetDOMCopy.getNLS());
            }
            if (jaxformsDOM != null) {
                org.w3c.dom.Document baseDom = DOMHelper.createDocument(xsdURL);
                DOMHelper.mergeSchemaWithIncludedSchemas(xsdURL, baseDom, true, null);
                String aSchema = DOMHelper.serialize(baseDom);
                if (aSchema != null) {
                    int endPos = TextTools.getNodeEndPos(aSchema, "?xml version", 0, '<', '>');
                    aSchema = aSchema.substring(endPos);
                }
                jaxformsDOM.getRootType().getChild("xsd-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", aSchema);
                if (pdfXUIDOM != null) {
                    jaxformsDOM.getRootType().getChild("pdfxui-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", pdfXUIDOM.serialize(true, false).toString());
                }
                if (xuiDOM != null) {
                    ListType componentListType = (ListType)xuiDOM.getRootType().getChild("component");
                    ListType resourceListType = (ListType)xuiDOM.getRootType().getChild("resources");
                    Vector allElements = new Vector();
                    allElements.addAll(componentListType.getList());
                    allElements.addAll(resourceListType.getList());
                    Iterator listTypeIterator = allElements.iterator();
                    Type includedXUIComponent2 = null;
                    Vector<Type> includedXUIComponents = new Vector<Type>();
                    while (listTypeIterator.hasNext()) {
                        includedXUIComponent2 = (Type)listTypeIterator.next();
                        if (includedXUIComponent2.isSerializable()) continue;
                        includedXUIComponents.add(includedXUIComponent2);
                        ((AbstractType)includedXUIComponent2).unmarkAsIncluded();
                    }
                    jaxformsDOM.getRootType().getChild("xui-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", xuiDOM.serialize(true, false).toString());
                    if (includedXUIComponents.size() > 0) {
                        for (Type includedXUIComponent2 : includedXUIComponents) {
                            ((AbstractType)includedXUIComponent2).markAsIncluded();
                        }
                    }
                } else {
                    jaxformsDOM.getRootType().getChild("xui-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", "");
                }
                if (xmlDataDOM != null) {
                    String xmlData = null;
                    try {
                        xmlData = FileHelper.readFileAsString(xmlURL);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    int endPos = TextTools.getNodeEndPos(xmlData, "?xml version", 0, '<', '>');
                    jaxformsDOM.getRootType().getChild("xml-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", xmlData.substring(endPos));
                } else {
                    jaxformsDOM.getRootType().getChild("xml-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", "");
                }
                if (xuiURL != null) {
                    String codeTableData = targetDOMCopy.getSchema().getCodeTables() != null ? targetDOMCopy.getSchema().getCodeTables().toXML() : "";
                    jaxformsDOM.getRootType().getChild("codeset-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", codeTableData);
                } else {
                    jaxformsDOM.getRootType().getChild("codeset-data", "http://www.jaxfront.com/jaxforms").setDirectChildValue("UNNAMED1", "");
                }
            }
            if (!isUsingEmbeddedNLS) {
                NLS.removeStoredEmbeddedNLS(xuiDOM);
            }
            JAXFrontProperties.getInstance().setUseEmbeddedNLS(isUsingEmbeddedNLS);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e);
        }
        return jaxformsDOM;
    }

    public static Document getJAXFormsDOM(String context, Hashtable metaInfo) {
        Document jaxformsDOM;
        block4: {
            jaxformsDOM = null;
            try {
                Type metaType;
                ClassLoader cl = (class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper).getClassLoader();
                URL jaxformsXSD = cl.getResource("jaxforms.xsd");
                URL jaxformsXUI = cl.getResource("jaxforms.xui");
                jaxformsDOM = DOMBuilder.getInstance().build(context, jaxformsXSD, (URL)null, jaxformsXUI, "jaxforms");
                if (metaInfo != null && metaInfo != null && (metaType = jaxformsDOM.getRootType().getDirectChild("http://www.jaxfront.com/jaxforms", "meta")) != null) {
                    Enumeration allKeys = metaInfo.keys();
                    String key = null;
                    String value = null;
                    while (allKeys.hasMoreElements()) {
                        key = (String)allKeys.nextElement();
                        value = (String)metaInfo.get(key);
                        metaType.setDirectChildValue(key, value);
                    }
                }
            }
            catch (Throwable t) {
                if (!LogRegistry.getInstance().logWarnings()) break block4;
                LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, "Unable to create JAXForms-DOM for (xsd=jaxforms.xsd)");
            }
        }
        return jaxformsDOM;
    }

    public static Hashtable getNameSpaces(org.w3c.dom.Document dom) {
        Hashtable<String, String> namespaces = new Hashtable<String, String>();
        if (dom != null) {
            NamedNodeMap nodeMap = dom.getDocumentElement().getAttributes();
            Node attributeNode = null;
            String prefix = null;
            String uri = null;
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                attributeNode = nodeMap.item(i);
                if (!attributeNode.getNodeName().startsWith("xmlns:")) continue;
                Attr attr = (Attr)attributeNode;
                prefix = attr.getLocalName();
                uri = attr.getNodeValue();
                namespaces.put(prefix, uri);
            }
        }
        return namespaces;
    }

    public static Hashtable getNameSpaceToPrefixMapping(org.w3c.dom.Document dom) {
        Hashtable<String, String> namespaces = null;
        NamedNodeMap nodeMap = dom.getDocumentElement().getAttributes();
        Node attributeNode = null;
        String prefix = null;
        String uri = null;
        if (nodeMap.getLength() > 0) {
            namespaces = new Hashtable<String, String>();
        }
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            attributeNode = nodeMap.item(i);
            if (!attributeNode.getNodeName().startsWith("xmlns:")) continue;
            Attr attr = (Attr)attributeNode;
            prefix = attr.getLocalName();
            uri = attr.getNodeValue();
            if (prefix != null && !prefix.equals("")) {
                namespaces.put(uri, prefix);
                continue;
            }
            if (!LogRegistry.getInstance().logWarnings()) continue;
            LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$DOMHelper == null ? DOMHelper.class$("com.jaxfront.core.dom.DOMHelper") : class$com$jaxfront$core$dom$DOMHelper, new StringBuffer().append("don't add nsuri ").append(uri).append(" with empty prefix:").append(prefix).toString());
        }
        return namespaces;
    }

    public static String getAdditionalXUIHeaderAttribs(Document dom) {
        StringBuffer header = new StringBuffer(" ");
        String loc = DOMHelper.extractSchemaLocation(dom.getRootType().getSchemaElement().getSchema().getURL(), dom.getSchemaLocation(), dom.getRootType().getSchemaElement().getSchema().getTargetNamespace());
        if (loc != null) {
            header.append(" ");
            header.append(loc);
        }
        return header.toString();
    }

    public static String getAdditionalXMLHeaderAttribs(Document dom) {
        StringBuffer header = new StringBuffer(" ");
        header.append("xmlns:xsi");
        header.append(EQUALS);
        header.append("\"");
        header.append("http://www.w3.org/2001/XMLSchema-instance");
        header.append("\"");
        String loc = null;
        if (dom.getSchemaLocation() != null) {
            loc = DOMHelper.extractSchemaLocation(dom.getSchemaLocation(), null, dom.getRootType().getSchemaElement().getSchema().getTargetNamespace());
        } else if (dom.getFingerPrint().getXSDURL() != null) {
            loc = DOMHelper.extractSchemaLocation(dom.getFingerPrint().getXSDURL(), null, dom.getRootType().getSchemaElement().getSchema().getTargetNamespace());
        }
        if (loc != null) {
            header.append(" ");
            header.append(loc);
        }
        return header.toString();
    }

    public static String getXMLHeaderAttribs(Document dom, Map attribs) {
        String loc;
        if (attribs.get("xmlns:xsi") == null) {
            attribs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        boolean hasNoNSSchemaLocation = false;
        boolean hasSchemaLocation = false;
        StringBuffer header = new StringBuffer(" ");
        if (attribs != null) {
            Iterator aSetIt = attribs.entrySet().iterator();
            while (aSetIt.hasNext()) {
                Map.Entry aEntry = aSetIt.next();
                String key = (String)aEntry.getKey();
                String value = (String)aEntry.getValue();
                if (!hasNoNSSchemaLocation && key.indexOf("noNamespaceSchemaLocation") >= 0) {
                    hasNoNSSchemaLocation = true;
                    if (dom.getSchemaLocation() != null) {
                        value = dom.getSchemaLocation();
                    }
                    if (value != null && JAXFrontProperties.getInstance().serializeXSDUrlRelative()) {
                        value = DOMHelper.makeRelative(value);
                    }
                }
                if (!hasSchemaLocation && key.indexOf(SchemaSymbols.XSI_SCHEMALOCATION) >= 0) {
                    hasSchemaLocation = true;
                    if (dom.getSchemaLocation() != null) {
                        value = dom.getSchemaLocation();
                    }
                    if (value != null && JAXFrontProperties.getInstance().serializeXSDUrlRelative()) {
                        value = DOMHelper.makeRelative(value);
                    }
                }
                if (dom.getRootType().getDirectChildren(key).size() != 0) continue;
                header.append(key);
                header.append(EQUALS);
                header.append("\"");
                header.append(value);
                header.append("\"");
                if (!aSetIt.hasNext()) continue;
                header.append(" ");
            }
        }
        if (!hasNoNSSchemaLocation && !hasSchemaLocation && (loc = DOMHelper.extractSchemaLocation(dom.getRootType().getSchemaElement().getSchema().getURL(), dom.getSchemaLocation(), dom.getRootType().getSchemaElement().getSchema().getTargetNamespace())) != null) {
            header.append(" ");
            header.append(loc);
        }
        return header.toString();
    }

    public static Hashtable getXMLHeaderAttributes(org.w3c.dom.Document dom) {
        Hashtable<String, String> attributes = null;
        NamedNodeMap nodeMap = dom.getDocumentElement().getAttributes();
        Node attributeNode = null;
        String name = null;
        String value = null;
        if (nodeMap.getLength() > 0) {
            attributes = new Hashtable<String, String>();
        }
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            attributeNode = nodeMap.item(i);
            Attr attr = (Attr)attributeNode;
            name = attr.getName();
            value = attr.getNodeValue();
            attributes.put(name, value);
        }
        return attributes;
    }

    public static String getDefaultNameSpace(org.w3c.dom.Document dom) {
        String defNS = null;
        NamedNodeMap nodeMap = dom.getDocumentElement().getAttributes();
        Node attributeNode = null;
        String uri = null;
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            attributeNode = nodeMap.item(i);
            if (!attributeNode.getNodeName().equals(XMLNS)) continue;
            Attr attr = (Attr)attributeNode;
            defNS = uri = attr.getNodeValue();
            break;
        }
        return defNS;
    }

    public static void getAllIncludedURLs(URL xsdURL, List includeList, boolean onlyValue, boolean rootIncluded) {
        if (xsdURL != null) {
            try {
                org.w3c.dom.Document dom = DOMHelper.createDocument(xsdURL);
                if (rootIncluded) {
                    includeList.add(DOMHelper.serialize(dom));
                }
                NodeList includes = dom.getElementsByTagName("xs:include");
                for (int i = 0; i < includes.getLength(); ++i) {
                    Element includeElement = (Element)includes.item(i);
                    String includeUrl = includeElement.getAttribute(SCHEMA_LOCATION);
                    if (includeUrl == null || includeUrl.length() <= 0) continue;
                    DOMHelper.getAllIncludedURLs(URLHelper.getUserURL(xsdURL, includeUrl), includeList, onlyValue, true);
                }
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e);
            }
        }
    }

    private static void addAttribute(Hashtable result, Element element, String name) {
        String attrValue = element.getAttribute(name);
        if (attrValue != null && attrValue.length() > 0) {
            result.put(name, attrValue);
        }
    }

    public static Hashtable getAllSchemaBaseAttributes(org.w3c.dom.Document dom) {
        Hashtable result = new Hashtable();
        if (dom != null) {
            try {
                Element schemaElement = dom.getDocumentElement();
                DOMHelper.addAttribute(result, schemaElement, "targetNamespace");
                DOMHelper.addAttribute(result, schemaElement, "attributeFormDefault");
                DOMHelper.addAttribute(result, schemaElement, "elementFormDefault");
                DOMHelper.addAttribute(result, schemaElement, "default");
                DOMHelper.addAttribute(result, schemaElement, "schemaLocation");
                DOMHelper.addAttribute(result, schemaElement, "noNamespaceSchemaLocation");
                DOMHelper.addAttribute(result, schemaElement, XMLNS);
                DOMHelper.addAttribute(result, schemaElement, SchemaSymbols.ATT_VERSION);
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e);
            }
        }
        return result;
    }

    public static Hashtable getAllSchemaBaseAttributes(String xsdString) {
        try {
            return DOMHelper.getAllSchemaBaseAttributes(DOMHelper.createDocument(xsdString));
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e);
            return null;
        }
    }

    public static Hashtable getAllSchemaBaseAttributes(URL xsdURL) {
        try {
            return DOMHelper.getAllSchemaBaseAttributes(DOMHelper.createDocument(xsdURL));
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e.getMessage());
            return null;
        }
    }

    public static String getPrefixForNamespace(org.w3c.dom.Document doc, String nameSpace) {
        Hashtable docNameSpaces = DOMHelper.getNameSpaces(doc);
        for (Map.Entry aEntry : docNameSpaces.entrySet()) {
            if (aEntry.getValue().toString().indexOf(nameSpace) < 0) continue;
            return aEntry.getKey().toString();
        }
        return null;
    }

    public static void mergeSchemaWithIncludedSchemas(URL xsdURL, org.w3c.dom.Document baseDoc, boolean isRoot, String startXSDPrefix) {
        if (xsdURL != null) {
            try {
                org.w3c.dom.Document dom = DOMHelper.createDocument(xsdURL);
                String nameSpacePrefix = DOMHelper.getPrefixForNamespace(dom, "XMLSchema");
                if (nameSpacePrefix == null) {
                    nameSpacePrefix = "xsi:";
                }
                if (startXSDPrefix == null) {
                    startXSDPrefix = nameSpacePrefix;
                }
                if (!isRoot) {
                    NodeImporter.doImport(dom.getDocumentElement().getChildNodes(), (Node)baseDoc.getDocumentElement(), 3, startXSDPrefix);
                }
                NodeList includes = dom.getElementsByTagName(new StringBuffer().append(nameSpacePrefix).append(":include").toString());
                for (int i = 0; i < includes.getLength(); ++i) {
                    Element includeElement = (Element)includes.item(i);
                    String includeUrl = includeElement.getAttribute(SCHEMA_LOCATION);
                    if (includeUrl == null || includeUrl.length() <= 0) continue;
                    DOMHelper.mergeSchemaWithIncludedSchemas(URLHelper.getUserURL(xsdURL, includeUrl, false), baseDoc, false, startXSDPrefix);
                }
                NodeList includeList = baseDoc.getDocumentElement().getElementsByTagName(new StringBuffer().append(nameSpacePrefix).append(":include").toString());
                for (int i = includeList.getLength() - 1; i >= 0; --i) {
                    Node includeToRemove = includeList.item(i);
                    Node includeParent = includeToRemove.getParentNode();
                    if (includeParent == null) continue;
                    includeParent.removeChild(includeList.item(i));
                }
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? (class$com$jaxfront$core$dom$DOMHelper = DOMHelper.class$("com.jaxfront.core.dom.DOMHelper")) : class$com$jaxfront$core$dom$DOMHelper, e);
            }
        }
    }

    public static Hashtable extractData(org.w3c.dom.Document dom, String tagName) throws TransformerException {
        Hashtable<String, String> metaData = new Hashtable<String, String>();
        NodeList nodeList = dom.getDocumentElement().getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            NodeList xmlElementMetaData = nodeList.item(0).getChildNodes();
            for (int i = 0; i < xmlElementMetaData.getLength(); ++i) {
                Node aMetaNode = xmlElementMetaData.item(i);
                String name = aMetaNode.getNodeName();
                if (aMetaNode.getNodeType() != 1) continue;
                String value = DOMHelper.getText((Element)aMetaNode);
                if (name == null || value == null) continue;
                metaData.put(name, value);
            }
        }
        return metaData;
    }

    public static Vector getNamespaceDeclarations(Hashtable nameSpaces, boolean isXuiDom, boolean forceSerialization, String defaultNameSpace) {
        Vector<String> xmlNS = null;
        if (nameSpaces != null) {
            Enumeration nsKeys = nameSpaces.keys();
            xmlNS = new Vector<String>();
            while (nsKeys.hasMoreElements()) {
                String uri = (String)nsKeys.nextElement();
                String xmlNSText = null;
                if (uri == null || uri.length() <= 0 || uri.equals(HTTP_WWW_W3_ORG_2001_XMLSCHEMA)) continue;
                String prefix = (String)nameSpaces.get(uri);
                if (prefix != null && prefix.length() > 0) {
                    if (prefix.startsWith(XSD)) continue;
                    xmlNSText = new StringBuffer().append("xmlns:").append(prefix).append(EQUALS).append("\"").append(uri).append("\"").toString();
                    xmlNS.add(xmlNSText);
                    continue;
                }
                xmlNSText = forceSerialization && isXuiDom ? new StringBuffer().append("xmlns:").append(prefix).append(EQUALS).append("\"").append(uri).append("\"").toString() : new StringBuffer().append("xmlns=\"").append(uri).append("\"").toString();
                xmlNS.add(xmlNSText);
            }
            if (defaultNameSpace != null) {
                boolean defNsExist = false;
                for (int xns = 0; xns < xmlNS.size(); ++xns) {
                    String nsDef = (String)xmlNS.get(xns);
                    if (!nsDef.startsWith("xmlns=")) continue;
                    defNsExist = true;
                    break;
                }
                if (!defNsExist) {
                    xmlNS.add(new StringBuffer().append("xmlns=\"").append(defaultNameSpace).append("\"").toString());
                }
            }
        }
        return xmlNS;
    }

    public static void performLateBind(Type targetType, Element dataSource) {
        targetType.getDOM().getController().getErrorController().maintainErrors(targetType);
        targetType.bind(targetType.getDOM(), dataSource);
        DOMHelper.resetListViews(targetType);
        TypeVisualizerFactory.getInstance().populateView(targetType);
    }

    public static void resetListViews(Type type) {
        List ls = DOMHelper.getAllListChilds(type, false);
        for (int i = 0; i < ls.size(); ++i) {
            Vector vs = TypeVisualizerFactory.getInstance().getAllVisualizers((Type)ls.get(i));
            for (int vi = vs.size() - 1; vi >= 0; --vi) {
                Visualizer v = (Visualizer)vs.get(vi);
                if (!((v = v.getImplementation()) instanceof ListVisualizer)) continue;
                ((ListVisualizer)v).resetView();
            }
        }
    }

    public static boolean containsChild(Type aStartType, boolean includingStartType, String[] names) {
        Vector<Type> childsToEvaluate = new Vector<Type>();
        if (includingStartType) {
            if (ArrayUtil.containsIgnoreCase(names, aStartType.getName()) >= 0) {
                return true;
            }
            childsToEvaluate.add(aStartType);
        } else {
            List dirChilds = aStartType.getDirectChildren();
            for (int d = 0; d < dirChilds.size(); ++d) {
                Type cType = (Type)dirChilds.get(d);
                if (ArrayUtil.containsIgnoreCase(names, cType.getName()) >= 0) {
                    return true;
                }
                childsToEvaluate.add(cType);
            }
        }
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            Type cType;
            int d;
            List dirChilds;
            Type aType = (Type)childsToEvaluate.get(c);
            if (aType.isList()) {
                dirChilds = (List)((Object)aType);
                for (d = 0; d < dirChilds.size(); ++d) {
                    cType = (Type)dirChilds.get(d);
                    if (ArrayUtil.containsIgnoreCase(names, cType.getName()) >= 0) {
                        return true;
                    }
                    childsToEvaluate.add(cType);
                }
                continue;
            }
            if (aType.getDirectChildren() == null) continue;
            dirChilds = aType.getDirectChildren();
            for (d = 0; d < dirChilds.size(); ++d) {
                cType = (Type)dirChilds.get(d);
                if (ArrayUtil.containsIgnoreCase(names, cType.getName()) >= 0) {
                    return true;
                }
                childsToEvaluate.add(cType);
            }
        }
        return false;
    }

    public static List getAllChilds(Type aStartType, boolean includingStartType) {
        Vector<Type> childsToEvaluate = new Vector<Type>();
        if (includingStartType) {
            childsToEvaluate.add(aStartType);
        } else {
            childsToEvaluate.addAll(aStartType.getDirectChildren());
        }
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            Type aType = (Type)childsToEvaluate.get(c);
            if (aType.isList()) {
                childsToEvaluate.addAll((List)((Object)aType));
                continue;
            }
            if (aType.getDirectChildren() == null) continue;
            childsToEvaluate.addAll(aType.getDirectChildren());
        }
        return childsToEvaluate;
    }

    public static void getAllChilds(Type aStartType, String name, String ns, List result) {
        if (aStartType.getName().equals(name)) {
            if (ns == null) {
                result.add(aStartType);
            } else if (ns.equals(aStartType.getNamespace())) {
                result.add(aStartType);
            }
        }
        List childs = aStartType.getDirectChildren();
        for (int c = 0; c < childs.size(); ++c) {
            Type aType = (Type)childs.get(c);
            if (aType.isList()) {
                List listChilds = (List)((Object)aType);
                for (int l = 0; l < listChilds.size(); ++l) {
                    DOMHelper.getAllChilds((Type)listChilds.get(l), name, ns, result);
                }
                continue;
            }
            if (aType.getName().equals(name)) {
                if (ns == null) {
                    result.add(aType);
                } else if (ns.equals(aType.getNamespace())) {
                    result.add(aType);
                }
            }
            if (aType.isSimple()) continue;
            DOMHelper.getAllChilds(aType, name, ns, result);
        }
    }

    public static List getAllSelectedVisStructureChilds(Type aStartType, boolean choosenOnly) {
        ArrayList<Type> childsToEvaluate = new ArrayList<Type>();
        childsToEvaluate.add(aStartType);
        boolean isInPageLayout = false;
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            FormLayoutInfo info;
            int selIdx;
            Type aType = (Type)childsToEvaluate.get(c);
            Vector layoutInfos = aType.getStyle().getLayoutInfos();
            if (aType.isList()) {
                if (!isInPageLayout && aType.getStyle().isUsingPagingList()) {
                    selIdx = aType.getStyle().getSelectedTabIdx();
                    if (selIdx < 0 || selIdx >= ((ListType)aType).getList().size()) continue;
                    childsToEvaluate.add((Type)((ListType)aType).getList().get(selIdx));
                    isInPageLayout = true;
                    continue;
                }
                if (aType.getStyle().getSelectedTabType() != null) {
                    childsToEvaluate.add(aType.getStyle().getSelectedTabType());
                    continue;
                }
                childsToEvaluate.addAll((List)((Object)aType));
                continue;
            }
            if (!isInPageLayout && aType.hasUIDefinition() && layoutInfos != null && layoutInfos.size() > 0) {
                selIdx = aType.getStyle().getSelectedTabIdx();
                if (aType.getStyle().isTabHolder() || aType.getStyle().isPagingLayout()) {
                    if (selIdx >= 0 && selIdx < layoutInfos.size()) {
                        info = (FormLayoutInfo)layoutInfos.get(selIdx);
                        childsToEvaluate.addAll(info.getCellTypes());
                    }
                } else {
                    for (int l = 0; l < layoutInfos.size(); ++l) {
                        FormLayoutInfo info2 = (FormLayoutInfo)layoutInfos.get(l);
                        childsToEvaluate.addAll(info2.getCellTypes());
                    }
                }
                isInPageLayout = true;
                continue;
            }
            if (aType.isChoice()) {
                if (aType.getChoosenType() == null) continue;
                if (choosenOnly) {
                    childsToEvaluate.add(aType.getChoosenType());
                    continue;
                }
                childsToEvaluate.addAll(aType.getDirectChildren());
                continue;
            }
            if (layoutInfos != null && aType.hasUIDefinition() && aType.getStyle().isTableLayout()) {
                for (int l = 0; l < layoutInfos.size(); ++l) {
                    info = (FormLayoutInfo)layoutInfos.get(l);
                    childsToEvaluate.addAll(info.getCellTypes());
                }
                continue;
            }
            if (aType.getDirectChildren() == null) continue;
            if (aType.getStyle().getSelectedTabType() != null) {
                childsToEvaluate.add(aType.getStyle().getSelectedTabType());
                continue;
            }
            childsToEvaluate.addAll(aType.getDirectChildren());
        }
        return childsToEvaluate;
    }

    public static List getAllVisStructureChilds(Type aStartType, boolean includingStartType) {
        Vector<Type> childsToEvaluate = new Vector<Type>();
        if (includingStartType) {
            childsToEvaluate.add(aStartType);
        } else {
            childsToEvaluate.addAll(aStartType.getDirectChildren());
        }
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            Type aType = (Type)childsToEvaluate.get(c);
            Vector layoutInfos = aType.getStyle().getLayoutInfos();
            if (aType.isList()) {
                Type edType = ((ListType)aType).getEditingType();
                if (!edType.isGlobal()) {
                    childsToEvaluate.add(edType);
                }
                childsToEvaluate.addAll((List)((Object)aType));
                continue;
            }
            if (aType.hasUIDefinition() && layoutInfos != null && layoutInfos.size() > 0) {
                for (int l = 0; l < layoutInfos.size(); ++l) {
                    FormLayoutInfo info = (FormLayoutInfo)layoutInfos.get(l);
                    childsToEvaluate.addAll(info.getCellTypes());
                }
            }
            if (aType.getDirectChildren() == null) continue;
            childsToEvaluate.addAll(aType.getDirectChildren());
        }
        return childsToEvaluate;
    }

    public static List getAllChilds(Type aStartType) {
        return DOMHelper.getAllChilds(aStartType, true);
    }

    public static List getAllListChilds(Type aStartType, boolean onlyDirect) {
        ArrayList<Type> childsToEvaluate = new ArrayList<Type>();
        ArrayList<Type> childsFound = new ArrayList<Type>();
        childsToEvaluate.add(aStartType);
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            Type aType = (Type)childsToEvaluate.get(c);
            if (aType.isList()) {
                if (aType != aStartType) {
                    childsFound.add(aType);
                    if (onlyDirect) continue;
                    childsToEvaluate.addAll((List)((Object)aType));
                    continue;
                }
                childsToEvaluate.addAll((List)((Object)aType));
                continue;
            }
            childsToEvaluate.addAll(aType.getDirectChildren());
        }
        return childsFound;
    }

    public static List<Type> getPDFPrintTree(Type type) {
        TreeModel tm = new TreeModel(type);
        List<Type> allChilds2 = tm.getTreeNodes(null);
        return allChilds2;
    }

    public static String extractSchemaLocation(URL loadedFrom, String schemaLocation, String targetNS) {
        return DOMHelper.extractSchemaLocation(loadedFrom != null ? loadedFrom.toExternalForm() : null, schemaLocation, targetNS);
    }

    public static String extractSchemaLocation(String loadedFrom, String schemaLocation, String targetNS) {
        String result = null;
        if (loadedFrom != null) {
            String theNoNSLocation;
            String theTargetNS;
            String schemaName = null;
            schemaName = schemaLocation != null ? schemaLocation : loadedFrom;
            if (schemaName != null && JAXFrontProperties.getInstance().serializeXSDUrlRelative()) {
                schemaName = DOMHelper.makeRelative(schemaName);
            }
            result = targetNS != null ? (theTargetNS = new StringBuffer().append("xsi:schemaLocation=\"").append(targetNS).append(" ").append(loadedFrom).append("\"").toString()) : (theNoNSLocation = new StringBuffer().append("xsi:noNamespaceSchemaLocation=\"").append(schemaName).append("\"").toString());
        }
        return result;
    }

    public static List vizualizerSelectorTypePathForFocus(Type startElement) {
        Vector<Type> path = new Vector<Type>();
        Type currentElement = startElement;
        Type parent = null;
        while (currentElement != null) {
            parent = DOMHelper.getParentToSelect2(currentElement);
            if (parent == null) {
                path.add(currentElement);
                if (currentElement == currentElement.getDOM().getRootType()) break;
                path.add(currentElement.getDOM().getRootType());
                break;
            }
            path.add(currentElement);
            if (parent == currentElement) {
                parent = currentElement.getParent();
            }
            currentElement = parent;
        }
        Vector<Type> relevantResult = new Vector<Type>();
        for (int i = 0; i < path.size(); ++i) {
            Type aType = (Type)path.get(i);
            relevantResult.add(aType);
        }
        Vector<Type> result = new Vector<Type>();
        for (int i = relevantResult.size() - 1; i >= 0; --i) {
            Type aType = (Type)relevantResult.get(i);
            result.add(aType);
        }
        return result;
    }

    private static Type isToSelect(Type type) {
        if (type.isList() || type.getStyle().isTabHolder()) {
            return type;
        }
        if (type.getParent() != null && type.getParent().isList()) {
            return type;
        }
        return null;
    }

    private static Type isToSelect2(Type type) {
        if (type.isList()) {
            return type;
        }
        if (type.getStyle().isTabHolder()) {
            return type;
        }
        if (type.getParent() != null && (type.getParent().isList() || type.getParent().getStyle().isTabHolder())) {
            return type;
        }
        if (type.getViewContextType() != null) {
            Type tableviewType = type.getViewContextType();
            return tableviewType;
        }
        if (type.getDOM().getGlobalDefinition().isShowingTree() && type.isRepresentedAsTreeNode()) {
            return type;
        }
        return null;
    }

    private static Type getParentToSelect(Type type, boolean checkCurrentType) {
        Type typeToSelect = null;
        if (checkCurrentType && (typeToSelect = DOMHelper.isToSelect(type)) != null) {
            return typeToSelect;
        }
        Type parent = type.getParent();
        if (parent != null) {
            if (parent.isList() || parent.getStyle().isTabHolder()) {
                return parent;
            }
            if (parent.getViewContextType() != null) {
                Type tableviewType;
                parent = tableviewType = parent.getViewContextType();
            }
            return DOMHelper.getParentToSelect(parent, true);
        }
        return null;
    }

    public static String evalNamespace(Type type) {
        String targetNS = null;
        if (type.isSimple() && ((SimpleType)type).isSimpleContent()) {
            targetNS = "";
        } else if (type.isEmpty()) {
            targetNS = null;
        } else if (type.getSchemaElement() != null) {
            targetNS = type.getSchemaElement().getTargetNS();
        }
        if (targetNS != null) {
            return targetNS;
        }
        Type parent = type.getParent();
        if (parent != null) {
            return DOMHelper.evalNamespace(parent);
        }
        return null;
    }

    private static Type getParentToSelect2(Type type) {
        Type typeToSelect = null;
        typeToSelect = DOMHelper.isToSelect2(type);
        if (typeToSelect != null) {
            return typeToSelect;
        }
        Type parent = type.getParent();
        if (parent != null) {
            return DOMHelper.getParentToSelect2(parent);
        }
        return null;
    }

    public static short[] generateListPositionIdx(Type type) {
        Type parent = null;
        short[] res = new short[]{};
        while ((parent = type.getParent()) != null) {
            if (parent.isList()) {
                short idx = (short)((ListType)parent).indexOf(type);
                res = ArrayUtil.addAtStartToArray(res, idx);
            } else {
                List composites = ((CompositeType)parent).getComposites();
                res = ArrayUtil.addAtStartToArray(res, (short)composites.indexOf(type));
            }
            type = parent;
            parent = parent.getParent();
        }
        return res;
    }

    public static List getChildren(XMLSchema schema, Element element) {
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        ArrayList<Node> list = new ArrayList<Node>(length);
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                list.add(node);
            }
        }
        return list;
    }

    public static List getEditingTypeParentPath(Type start) {
        ArrayList<Type> result = new ArrayList<Type>(4);
        boolean edTFound = false;
        while ((start = start.getParent()) != null) {
            if (!start.isEditingType()) continue;
            edTFound = true;
            result.add(start);
        }
        if (!edTFound) {
            result.clear();
        }
        return result;
    }

    public static List getParents(Type start) {
        ArrayList<Type> result = new ArrayList<Type>(start.getId().length);
        while ((start = start.getParent()) != null) {
            result.add(start);
        }
        return result;
    }

    public static Type createBranchFromEditingTypes(List edTypes) {
        Type aType;
        int c;
        Type baseChild = null;
        Type lastCreated = null;
        for (c = edTypes.size() - 1; c >= 0; --c) {
            aType = (Type)edTypes.get(c);
            if (!aType.isEditingType()) continue;
            ListType parent = (ListType)aType.getParent();
            lastCreated = baseChild = parent.addNewChild();
            break;
        }
        --c;
        if (baseChild != null) {
            while (c >= 0) {
                aType = (Type)edTypes.get(c);
                Type equalBaseChild = baseChild.getDirectChild(aType.getName());
                if (equalBaseChild != null) {
                    if (equalBaseChild.isList()) {
                        lastCreated = baseChild = ((ListType)equalBaseChild).addNewChild();
                    } else {
                        baseChild = equalBaseChild;
                    }
                } else if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(class$com$jaxfront$core$dom$DOMHelper == null ? DOMHelper.class$("com.jaxfront.core.dom.DOMHelper") : class$com$jaxfront$core$dom$DOMHelper, "can't create edtype branch!");
                }
                --c;
            }
        }
        return lastCreated;
    }

    public static boolean containsValue(ListType list, String value) {
        boolean result = false;
        ListType values = list;
        for (int v = 0; v < values.size(); ++v) {
            String typeValue = ((Type)values.get(v)).getDisplayValue();
            if (value != typeValue && !value.equals(typeValue)) continue;
            return true;
        }
        return result;
    }

    public static String getSchemaXPath(SchemaNode sNode) {
        StringBuffer accessPath = new StringBuffer();
        accessPath.append(sNode.getName());
        while ((sNode = sNode.getParent()) != null) {
            accessPath.append("/");
            accessPath.append(sNode.getName());
        }
        return accessPath.toString();
    }

    public static Type walkNormalizedXpathUp(String xpath, Type start) {
        String[] upPath = TextTools.tokenize(xpath, "/");
        Type parent = start;
        for (int u = upPath.length - 1; u >= 0; --u) {
            if (".".equals(upPath[u])) continue;
            if (parent == null) {
                return null;
            }
            String parName = parent.getName();
            String parNS = parent.getNamespace();
            String parNSPrefix = parent.getSchemaElement().getNamespacePrefix();
            String upName = upPath[u];
            if (upName != null && upName.length() > 0 && upName.charAt(0) == '@') {
                upName = upName.substring(1);
            }
            int upNSPos = upName.indexOf(":");
            String upNSPrefix = null;
            if (upNSPos >= 0) {
                upNSPrefix = upName.substring(0, upNSPos);
                upName = upName.substring(upNSPos + 1);
            }
            if (!parName.equals(upName) || upNSPrefix != parNSPrefix && (upNSPrefix == null || !upNSPrefix.equals(parNSPrefix))) {
                return null;
            }
            if ((parent = parent.getParent()) == null || !parent.isList()) continue;
            parent = parent.getParent();
        }
        return parent;
    }

    public static Type walkTypeXpath(String xpath, Type start) throws XPathError {
        return DOMHelper.walkTypeXpath(xpath, start, false);
    }

    public static Type walkTypeXpath(String xpath, Type start, boolean edTypeTraverseOnly) throws XPathError {
        XPNode xnode = null;
        if (xpath.startsWith("/")) {
            start = start.getDOM().getRootType();
        }
        while ((xnode = XPathNodeExtractor.tokenizeNext(xpath, xnode, false, true)) != null) {
            if (start == null) {
                return null;
            }
            String nodeName = xnode.getNodeName();
            String nodeNS = xnode.getNodeNSPrefix();
            String nodeExp = xnode.getNodeExpression();
            if (nodeName.equals("")) continue;
            if (nodeName.equals("..")) {
                start = start.getParent();
                if (!edTypeTraverseOnly || start == null || !start.isList()) continue;
                start = start.getParent();
                continue;
            }
            if (nodeName.equals(".")) continue;
            start = start.getDirectChild(nodeName, nodeNS);
            if (!edTypeTraverseOnly || start == null || !start.isList()) continue;
            start = ((ListType)start).getEditingType();
        }
        return start;
    }

    public static boolean isMandatoryWithinAnonymousGroup(Type type, boolean checkGroupIndex) {
        int unnamedIndex = type.getSchemaElement().getAnonymousGroupIndex();
        List childs = type.getParent().getDirectChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            if (checkGroupIndex && (!checkGroupIndex || child.getSchemaElement().getAnonymousGroupIndex() != unnamedIndex || child == type)) continue;
            if (child.isSimple()) {
                String value = ((SimpleType)child).getValue();
                if (value == null || value.length() <= 0) continue;
                return true;
            }
            if (!child.isAnonymous()) continue;
            List uChilds = child.getDirectChildren();
            for (int uC = 0; uC < uChilds.size(); ++uC) {
                Type uchildType = (Type)uChilds.get(uC);
                if (!DOMHelper.isMandatoryWithinAnonymousGroup(uchildType, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAnnotation(Type type) {
        String annotation = null;
        Hashtable annotations = type.getSchemaElement().getAnnotation();
        if (annotations != null && (annotation = (String)annotations.get(type.getDOM().getLanguage())) == null) {
            annotation = (String)annotations.get("default");
        }
        return annotation;
    }

    public static String getEnumerationAnnotation(Type type, String enumName) {
        String annotation = null;
        Hashtable annotations = ((SchemaSimpleType)type.getSchemaElement().getSchemaType()).getEnumerationAnnotation(enumName);
        if (annotations != null && (annotation = (String)annotations.get(type.getDOM().getLanguage())) == null) {
            annotation = (String)annotations.get("default");
        }
        return annotation;
    }

    public static String getEmailValue(Document dom) {
        String emailXPath;
        String email = DOMHelper.getValueFromDOM(dom, XPATH_FORM_META_OWNER);
        if (email == null && (emailXPath = dom.getGlobalDefinition().getEmailCommitXPath()) != null) {
            email = DOMHelper.getValueFromDOM(dom, emailXPath);
        }
        return email;
    }

    private static String getValueFromDOM(Document dom, String xpath) {
        Type found = TypePathExecuter.getInstance().getTypeForXPath(dom.getRootType(), xpath);
        String value = null;
        if (found != null && found.isSimple()) {
            value = ((SimpleType)found).getValue();
        }
        return value;
    }

    public static void prettyPrint(org.w3c.dom.Document doc, OutputStream out) throws Exception {
        DOMHelper.prettyPrint(doc, out, 65, true, 2);
    }

    public static void prettyPrint(org.w3c.dom.Document doc, OutputStream out, int lineWidth, boolean indenting, int indent) throws Exception {
        OutputFormat format = new OutputFormat(doc);
        format.setLineWidth(lineWidth);
        format.setIndenting(indenting);
        format.setIndent(indent);
        XMLSerializer serializer = new XMLSerializer(out, format);
        serializer.serialize(doc);
    }

    public static String prettyPrint(org.w3c.dom.Document doc, int lineWidth, boolean indenting, int indent) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMHelper.prettyPrint(doc, out);
            return new String(out.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String prettyPrint(String xml, int lineWidth, boolean indenting, int indent) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            org.w3c.dom.Document dom = null;
            DOMParser parser = new DOMParser();
            parser.setErrorHandler(null);
            InputSource is = new InputSource(new ByteArrayInputStream(xml.getBytes()));
            parser.parse(is);
            dom = parser.getDocument();
            DOMHelper.prettyPrint(dom, out, lineWidth, indenting, indent);
            return new String(out.toByteArray());
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static String[] toStringArray(List simpleTypes) {
        String[] res = new String[simpleTypes.size()];
        for (int t = 0; t < simpleTypes.size(); ++t) {
            res[t] = ((SimpleType)simpleTypes.get(t)).getValue();
        }
        return res;
    }

    public static Map elementsToMap(List propElements, String keyField, String valueField) {
        HashMap<String, String> props = new HashMap<String, String>(propElements.size());
        for (int p = 0; p < propElements.size(); ++p) {
            Element pElem = (Element)propElements.get(p);
            props.put(DOMHelper.getChildText(null, pElem, keyField), DOMHelper.getChildText(null, pElem, valueField));
        }
        return props;
    }

    public static List elementsToList(List propElements, String field) {
        if (propElements == null) {
            return new ArrayList();
        }
        ArrayList<String> props = new ArrayList<String>(propElements.size());
        for (int p = 0; p < propElements.size(); ++p) {
            Element pElem = (Element)propElements.get(p);
            if (field == null) {
                props.add(DOMHelper.getText(pElem));
                continue;
            }
            props.add(DOMHelper.getChildText(null, pElem, field));
        }
        return props;
    }

    public static Hashtable toHashtable(ListType list, String keyName, String valName) {
        Hashtable<String, String> res = new Hashtable<String, String>(list.size());
        for (int l = 0; l < list.size(); ++l) {
            String key;
            Type entry = (Type)list.get(l);
            Type keyT = entry.getChild(keyName);
            Type valT = entry.getChild(valName);
            if (keyT == null) continue;
            String value = "";
            String string = key = keyT.isSimple() ? ((SimpleType)keyT).getPlainValue() : keyT.toString();
            if (valT != null) {
                String string2 = value = valT.isSimple() ? ((SimpleType)valT).getPlainValue() : valT.toString();
            }
            if (key == null) continue;
            res.put(key, value);
        }
        return res;
    }

    public static List toValueList(List simpleTypes) {
        return DOMHelper.toValueList(simpleTypes, null);
    }

    public static List toValueList(List simpleTypes, String[] names) {
        Vector<String> res = new Vector<String>(simpleTypes.size());
        for (int t = 0; t < simpleTypes.size(); ++t) {
            SimpleType st = (SimpleType)simpleTypes.get(t);
            if (names != null) {
                if (ArrayUtil.contains(names, st.getName()) <= 0) continue;
                res.add(st.getValue());
                continue;
            }
            res.add(st.getValue());
        }
        return res;
    }

    public static List valueToList(List listOfSimpleTypes) {
        return DOMHelper.valueToList(listOfSimpleTypes, null);
    }

    public static List valueToList(List listOfSimpleTypes, String[] names) {
        if (listOfSimpleTypes == null) {
            return null;
        }
        Vector<String> result = new Vector<String>(listOfSimpleTypes.size());
        for (int r = 0; r < listOfSimpleTypes.size(); ++r) {
            Type t = (Type)listOfSimpleTypes.get(r);
            if (!t.isSimple()) continue;
            if (names != null) {
                if (ArrayUtil.contains(names, t.getName()) <= 0) continue;
                result.add(((SimpleType)t).getValue());
                continue;
            }
            result.add(((SimpleType)t).getValue());
        }
        return result;
    }

    public static String[] valueToArray(List listOfSimpleTypes) {
        return DOMHelper.valueToArray(listOfSimpleTypes, null);
    }

    public static String[] valueToArray(List listOfSimpleTypes, String[] names) {
        if (listOfSimpleTypes == null) {
            return null;
        }
        String[] result = new String[listOfSimpleTypes.size()];
        for (int r = 0; r < listOfSimpleTypes.size(); ++r) {
            Type t = (Type)listOfSimpleTypes.get(r);
            if (names != null) {
                if (ArrayUtil.contains(names, t.getName()) <= 0) continue;
                if (t.isSimple()) {
                    result[r] = ((SimpleType)t).getValue();
                    continue;
                }
                result[r] = ((SimpleType)t).getDisplayValue();
                continue;
            }
            result[r] = t.isSimple() ? ((SimpleType)t).getValue() : ((SimpleType)t).getDisplayValue();
        }
        return result;
    }

    public static String getValue(Type aType) {
        if (aType != null) {
            if (aType.isSimple()) {
                return ((SimpleType)aType).getValue();
            }
            return aType.getDisplayValue();
        }
        return null;
    }

    public static String getValueFromW3CDOM(org.w3c.dom.Document dom, String xpath) {
        String value = null;
        try {
            List foundList = W3CXPathExecuterImpl.getInstance().processXPath(dom.getDocumentElement(), xpath);
            if (foundList.size() > 0) {
                value = DOMHelper.getText((Element)foundList.get(0));
            }
        }
        catch (TransformerException e) {
            // empty catch block
        }
        return value;
    }

    public static String toString(ListType aMappingTargetType, String delim) {
        List childs = aMappingTargetType.getDirectChildren();
        StringBuffer res = new StringBuffer();
        int count = childs.size();
        for (int i = 0; i < count; ++i) {
            Type aChild = (Type)childs.get(i);
            String val = aChild.getDisplayValue();
            res.append(val);
            if (i + 1 >= count) continue;
            res.append(delim);
        }
        return res.toString();
    }

    public static String mergeDBM(JAXFrontLSInput dbmInput) throws XMLParseException, SAXException, IOException {
        Element pPageActions;
        Element xmlField;
        String dbMappingXML = FileHelper.readFileAsString(dbmInput, 512);
        if (dbMappingXML.indexOf("parentDBM") < 0) {
            return dbMappingXML;
        }
        org.w3c.dom.Document targetDoc = DOMHelper.createDocument(dbMappingXML);
        String parentDBM = targetDoc.getDocumentElement().getAttribute("parentDBM");
        if (parentDBM == null || parentDBM.length() == 0) {
            return dbMappingXML;
        }
        JAXFrontLSInput pInput = dbmInput.copy();
        pInput.setSystemId(URLHelper.canonicalize(new StringBuffer().append(pInput.getSystemId()).append("/").append(parentDBM).toString()));
        org.w3c.dom.Document parentDoc = DOMHelper.createDocument(pInput);
        Node lastField = targetDoc.getDocumentElement().getFirstChild();
        Element fingerPrint = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "fingerprint");
        if (fingerPrint == null) {
            Element pFingerPrint = DOMHelper.getChild(null, parentDoc.getDocumentElement(), "fingerprint");
            if (pFingerPrint != null) {
                NodeImporter.doImport(pFingerPrint, lastField, 4, null);
                lastField = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "fingerprint");
            }
        } else {
            lastField = fingerPrint;
        }
        NodeImporter.mergeXML(targetDoc, parentDoc, "//field", "//field", 1, "id", lastField);
        if (DOMHelper.getChild(null, targetDoc.getDocumentElement(), "field") != null) {
            lastField = DOMHelper.getLastChild(null, targetDoc.getDocumentElement(), new String[]{"field"}, -1);
        }
        if ((xmlField = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "xmlField")) == null) {
            Element pXmlField = DOMHelper.getChild(null, parentDoc.getDocumentElement(), "xmlField");
            if (pXmlField != null) {
                NodeImporter.doImport(pXmlField, lastField, 5, null);
                lastField = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "xmlField");
            }
        } else {
            lastField = xmlField;
        }
        Element rowActions = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "rowActions");
        if (rowActions == null) {
            Element pRowActions = DOMHelper.getChild(null, parentDoc.getDocumentElement(), "rowActions");
            if (pRowActions != null) {
                NodeImporter.doImport(pRowActions, lastField, 5, null);
                lastField = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "rowActions");
            }
        } else {
            lastField = rowActions;
        }
        Element pageActions = DOMHelper.getChild(null, targetDoc.getDocumentElement(), "pageActions");
        if (pageActions == null && (pPageActions = DOMHelper.getChild(null, parentDoc.getDocumentElement(), "pageActions")) != null) {
            NodeImporter.doImport(pPageActions, lastField, 5, null);
        }
        return DOMHelper.serialize(targetDoc);
    }

    public static String getProcessingInstructionValue(ProcessingInstruction pi, String name) {
        String value = null;
        if (pi != null && (value = pi.getData()) != null) {
            String searchString = new StringBuffer().append(name).append(EQUALS).toString();
            int index = value.indexOf(searchString);
            if (index != -1) {
                int endIdx = value.indexOf("\"", index += searchString.length() + 1);
                value = value.substring(index, endIdx);
            } else {
                value = null;
            }
        }
        return value;
    }

    public static String getAttributeValue(Node aType, String name) {
        Node attNode;
        NamedNodeMap nnm;
        if (aType != null && (nnm = aType.getAttributes()) != null && (attNode = nnm.getNamedItem(name)) != null) {
            return attNode.getNodeValue();
        }
        return null;
    }

    public static ProcessingInstruction searchPrevProcessingInstruction(Node startNode, String target) {
        Node prevSib = startNode.getPreviousSibling();
        if (prevSib == null || prevSib.getNodeType() == 1) {
            return null;
        }
        if (prevSib instanceof ProcessingInstruction) {
            if (target != null && prevSib.getNodeName().equals(target)) {
                return (ProcessingInstruction)prevSib;
            }
            return (ProcessingInstruction)prevSib;
        }
        return DOMHelper.searchPrevProcessingInstruction(prevSib, target);
    }

    public static List<ProcessingInstruction> searchPrevProcessingInstructions(Node startNode, String target) {
        Vector<ProcessingInstruction> found = new Vector<ProcessingInstruction>();
        boolean stop = false;
        while (!stop) {
            if (startNode == null) continue;
            ProcessingInstruction pi = DOMHelper.searchPrevProcessingInstruction(startNode, target);
            if (pi != null) {
                found.add(pi);
                startNode = pi;
                continue;
            }
            stop = true;
        }
        return found;
    }

    public static int getNodePos(NodeList nl, Node startNode) {
        int ls = nl.getLength();
        for (int n = 0; n < ls; ++n) {
            Node aN = nl.item(n);
            if (aN != startNode) continue;
            return n;
        }
        return -1;
    }

    public static List<ProcessingInstruction> getProcessingInstructions(NodeList levelNodes, Node startNode, String target, int pos) {
        if (levelNodes == null) {
            return DOMHelper.searchPrevProcessingInstructions(startNode, target);
        }
        if (pos == -1) {
            pos = DOMHelper.getNodePos(levelNodes, startNode);
        }
        if (--pos < 0) {
            return null;
        }
        ArrayList<ProcessingInstruction> found = new ArrayList<ProcessingInstruction>();
        while (pos >= 0) {
            Node aN = levelNodes.item(pos);
            System.out.println(aN);
            if (aN instanceof ProcessingInstruction) {
                if (target != null) {
                    if (aN.getNodeName().equals(target)) {
                        found.add((ProcessingInstruction)aN);
                    }
                } else {
                    found.add((ProcessingInstruction)aN);
                }
            } else if (aN.getNodeType() == 1) break;
            --pos;
        }
        return found;
    }

    public static boolean setTypeValues(Document dom, String xpath, String value) {
        boolean set = false;
        if (dom != null && xpath != null) {
            List types = dom.getTypes(xpath);
            for (int t = 0; t < types.size(); ++t) {
                Type aType = (Type)types.get(t);
                if (!aType.isSimple()) continue;
                ((SimpleType)aType).setValue(value);
                set = true;
            }
        }
        return set;
    }

    public static void forceSerialization(List types, boolean serialize) {
        if (types == null) {
            return;
        }
        for (int r = 0; r < types.size(); ++r) {
            Type t = (Type)types.get(r);
            ((AbstractType)t).forceSerialization(serialize);
        }
    }

    public static void forceSerializationWholeTree(Type root, boolean inclRoot, boolean serialize) {
        if (root != null) {
            List types = DOMHelper.getAllChilds(root, inclRoot);
            if (types == null) {
                return;
            }
            for (int r = 0; r < types.size(); ++r) {
                Type t = (Type)types.get(r);
                ((AbstractType)t).forceSerialization(serialize);
            }
        }
    }

    public String[] getDisplayValues(ListType aList) {
        List list = aList.getDirectChildren();
        String[] result = new String[list.size()];
        boolean first = true;
        boolean wasEmpty = false;
        String value = null;
        for (int l = 0; l < list.size(); ++l) {
            Type simpleGroup = (Type)list.get(l);
            value = simpleGroup.getDisplayValue();
            wasEmpty = value == null || value.equals("");
            result[l] = wasEmpty ? "" : value;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

