/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class Bind
extends SuperTypeNode {
    public Bind() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        int bindResult = -1;
        switch (this.curNumberOfParameters) {
            case 2: {
                Object data = stack.pop();
                Object bindTo = stack.pop();
                if (data == NULL._null && bindTo == NULL._null) break;
                if (bindTo == NULL._null) {
                    this.doFastBind(communicator, null, data);
                    break;
                }
                if (data instanceof Type && bindTo instanceof Type) {
                    this.doFastBind(communicator, bindTo, data);
                    break;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
            default: {
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
        }
        if (bindResult >= 0) {
            stack.push(SuperTypeNode.isTrue);
        } else {
            stack.push(SuperTypeNode.isFalse);
        }
    }

    private void doFastBind(MathEvaluator.MathCommunicator communicator, Object bindTo, Object data) {
        boolean wasBinding = communicator.getDoc().isBinding();
        boolean wasRuleBlocked = communicator.getDoc().isRuleEngineBlocked();
        communicator.getDoc().setIsBinding(true);
        communicator.getDoc().setRuleEngineBlocked(true);
        ((Type)data).bind((Type)bindTo);
        if (!wasRuleBlocked) {
            communicator.getDoc().setRuleEngineBlocked(false);
        }
        if (!wasBinding) {
            communicator.getDoc().setIsBinding(false);
        }
    }
}

