/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.util.VectorHelper;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Contains
extends PostfixMathCommand {
    private static final Double DOUBLE_TRUE = new Double(1.0);
    private static final Double DOUBLE_FALSE = new Double(0.0);

    public Contains() {
        this.numberOfParameters = -1;
    }

    private static Double containsValue(List sources, String toSearchFor) {
        for (int i = 0; i < sources.size(); ++i) {
            Object aObject = sources.get(i);
            if (aObject != toSearchFor && (aObject == null || !aObject.toString().equals(toSearchFor))) continue;
            return DOUBLE_TRUE;
        }
        return DOUBLE_FALSE;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Double result = DOUBLE_FALSE;
        if (this.curNumberOfParameters == 2) {
            Object paramSearch = stack.pop();
            Object paramSource = stack.pop();
            if (paramSearch instanceof String && paramSource instanceof String) {
                String toSearchFor = paramSearch.toString();
                String source = paramSource.toString();
                int found = source.indexOf(toSearchFor);
                result = found == -1 ? DOUBLE_FALSE : DOUBLE_TRUE;
            } else if (paramSearch instanceof List && paramSource instanceof String) {
                List sources = (List)paramSearch;
                String toSearchFor = paramSource.toString();
                result = Contains.containsValue(sources, toSearchFor);
            } else if (paramSearch != null && paramSearch instanceof Vector && paramSource instanceof Vector) {
                Vector intersect = VectorHelper.intersection((Vector)paramSearch, (Vector)paramSource);
                result = intersect == null || intersect.size() == 0 ? DOUBLE_FALSE : DOUBLE_TRUE;
            } else if (paramSearch != null && paramSource instanceof List) {
                List sources = (List)paramSource;
                String toSearchFor = paramSearch.toString();
                result = Contains.containsValue(sources, toSearchFor);
            }
        } else {
            throw new ParseException("Invalid parameters");
        }
        stack.push(result);
    }
}

