/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.IntroSpectionHelper;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;

public class ListControlAccess
extends SuperTypeNode {
    public static final String delete = "setDeleteActionEnabled";
    public static final String add = "setAddActionEnabled";
    public static final String copy = "setCopyActionEnabled";
    public static final String copyContent = "setCopyContentActionEnabled";
    public static final String edit = "setEditActionEnabled";
    public static final String moveUp = "setMoveUpActionEnabled";
    public static final String moveDown = "setMoveDownActionEnabled";
    public static final String paste = "setPasteContentActionEnabled";
    static Hashtable methodMapping = new Hashtable(8);
    static Hashtable listInfoMapping;

    public ListControlAccess() {
        this.numberOfParameters = -1;
    }

    public void callBooleanMethod(Object on, String qualifier, String value, boolean onListInfo) {
        Boolean bValue = Boolean.valueOf(value);
        if (onListInfo) {
            IntroSpectionHelper.callFunktion(on, (String)listInfoMapping.get(qualifier), new Class[]{Boolean.TYPE}, new Object[]{bValue});
        } else {
            IntroSpectionHelper.callFunktion(on, (String)methodMapping.get(qualifier), new Class[]{Boolean.TYPE}, new Object[]{bValue});
        }
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Double result = isFalse;
        if (this.curNumberOfParameters == 2) {
            String value = stack.pop().toString();
            String controlName = stack.pop().toString();
            Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer(communicator.getRootType(), false);
            if (vis != null) {
                this.callBooleanMethod(vis.getImplementation(), controlName, value, false);
                result = isTrue;
            } else {
                this.callBooleanMethod(communicator.getRootType().getStyle().getListInfo(), controlName, value, true);
            }
        } else if (this.curNumberOfParameters == 3) {
            String value = stack.pop().toString();
            String controlName = stack.pop().toString();
            Type visType = (Type)stack.pop();
            if (visType != null) {
                Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer(visType, false);
                if (vis != null) {
                    this.callBooleanMethod(vis.getImplementation(), controlName, value, false);
                    result = isTrue;
                } else {
                    this.callBooleanMethod(communicator.getRootType().getStyle().getListInfo(), controlName, value, true);
                }
            }
        } else {
            Type visType = communicator.getRootType();
            List params = this.invertParams(stack);
            int i = 0;
            if (this.curNumberOfParameters % 2 == 1) {
                visType = (Type)params.get(0);
                ++i;
            }
            if (visType != null) {
                Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer(visType, false);
                while (i < params.size()) {
                    String controlName = (String)params.get(i);
                    String value = (String)params.get(i + 1);
                    if (vis != null) {
                        this.callBooleanMethod(vis.getImplementation(), controlName, value, false);
                        result = isTrue;
                    } else {
                        this.callBooleanMethod(communicator.getRootType().getStyle().getListInfo(), controlName, value, true);
                    }
                    i += 2;
                }
            }
        }
        stack.push(result);
    }

    static {
        methodMapping.put("delete", delete);
        methodMapping.put("add", add);
        methodMapping.put("copy", copy);
        methodMapping.put("copyContent", copyContent);
        methodMapping.put("edit", edit);
        methodMapping.put("moveUp", moveUp);
        methodMapping.put("moveDown", moveDown);
        methodMapping.put("paste", paste);
        listInfoMapping = new Hashtable(8);
        listInfoMapping.put("delete", "setShowingDeleteButton");
        listInfoMapping.put("add", "setShowingNewButton");
        listInfoMapping.put("copy", "setShowingCopyButton");
        listInfoMapping.put("copyContent", "");
        listInfoMapping.put("edit", "");
        listInfoMapping.put("moveUp", "");
        listInfoMapping.put("moveDown", "");
        listInfoMapping.put("paste", "");
    }
}

