/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class SetValue
extends SuperTypeNode {
    public SetValue() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Type baseType = communicator.getRootType();
        boolean setVal = communicator.getResultBag() == null;
        boolean fireChange = communicator.fireChange();
        boolean success = false;
        Object value = null;
        switch (this.curNumberOfParameters) {
            case 1: {
                value = stack.pop();
                success = this.setTypeValue(baseType, value, setVal, fireChange);
                break;
            }
            case 2: {
                value = stack.pop();
                Object targetObj = stack.pop();
                if (targetObj instanceof List) {
                    List targetObjs = (List)targetObj;
                    for (int t = 0; t < targetObjs.size(); ++t) {
                        baseType = (Type)targetObjs.get(t);
                        boolean aSuccess = this.setTypeValue(baseType, value, setVal, fireChange);
                        if (aSuccess) continue;
                        success = false;
                    }
                    break;
                }
                baseType = (Type)targetObj;
                success = this.setTypeValue(baseType, value, setVal, fireChange);
            }
        }
        stack.push(success ? isTrue : isFalse);
    }

    private boolean setTypeValue(Type baseType, Object value, boolean setVal, boolean fireChange) {
        if (baseType != null && setVal && baseType.isSimple()) {
            if (value == NULL._null || value == null) {
                ((SimpleType)baseType).setValue(null, !fireChange);
                return true;
            }
            if (value instanceof List) {
                List vals = (List)value;
                if (vals.size() > 0 && vals.get(0) != null) {
                    ((SimpleType)baseType).setValue(vals.get(0).toString(), !fireChange);
                } else {
                    ((SimpleType)baseType).setValue(null, !fireChange);
                }
            } else {
                ((SimpleType)baseType).setValue(value.toString(), !fireChange);
            }
            return true;
        }
        return false;
    }
}

