/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.log;

import com.jaxfront.core.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.SimpleLayout;

public class Log4JLogRegistry
implements Logger {
    public static final String ERROR = "ERROR";
    public static final String WARN = "WARN";
    public static final String FATAL = "FATAL";
    public static final String LOG = "LOG";
    public static final String INFO = "INFO";
    private String _logFileUrl;
    private boolean _logErrors;
    private boolean _logWarnings;
    private boolean _logInfos;
    private boolean _logLogs;
    private boolean _logFatals;
    private boolean _isDebug = false;

    public Log4JLogRegistry() {
        BasicConfigurator.configure();
        this._logErrors = true;
        this._logWarnings = true;
        this._logInfos = true;
        this._logLogs = true;
        this._logFatals = true;
        org.apache.log4j.Logger.getRootLogger().getAllAppenders();
    }

    public void error(Class aClass, Exception e) {
        if (this.logErrors()) {
            StringBuilder msg = new StringBuilder("Exception message:");
            msg.append(e.getMessage());
            if (e.getStackTrace() != null && e.getStackTrace().length > 0) {
                msg.append(" -> error at:");
                msg.append(e.getStackTrace()[0].toString());
            }
            Category cat = Category.getInstance((String)aClass.getName());
            cat.error((Object)msg.toString(), (Throwable)e);
        }
    }

    public void error(Class aClass, String message) {
        if (this.logErrors()) {
            Category cat = Category.getInstance((String)aClass.getName());
            cat.error((Object)message);
        }
    }

    public void fatal(Class aClass, Exception e) {
        if (this.logFatals()) {
            PrintStream aStream = new PrintStream(new ByteArrayOutputStream());
            e.printStackTrace(aStream);
            Category cat = Category.getInstance((String)aClass.getName());
            cat.fatal((Object)aStream.toString());
        }
    }

    public void fatal(Class aClass, String message) {
        if (this.logFatals()) {
            Category cat = Category.getInstance((String)aClass.getName());
            cat.fatal((Object)message);
        }
    }

    public void info(Class aClass, String message) {
        if (this.logInfos()) {
            Category cat = Category.getInstance((String)aClass.getName());
            cat.info((Object)message);
        }
    }

    public void log(Class aClass, String message) {
        if (this.logLogs()) {
            Category cat = Category.getInstance((String)aClass.getName());
            cat.debug((Object)message);
        }
    }

    private boolean writeToFile() {
        return this.getLogFileUrl() != null;
    }

    public void warn(Class aClass, String message) {
        if (this.logWarnings()) {
            Category cat = Category.getInstance((String)aClass.getName());
            cat.warn((Object)message);
        }
    }

    public void setLogFileUrl(String url) {
        this._logFileUrl = url;
        try {
            if (url != null) {
                this.initAppenders(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAppenders(String url) throws IOException {
        boolean found = false;
        Enumeration appenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Object object = appenders.nextElement();
            if (!(object instanceof FileAppender)) continue;
            ((FileAppender)object).setFile(url);
            found = true;
        }
        if (!found) {
            org.apache.log4j.Logger.getRootLogger().addAppender((Appender)new RollingFileAppender((Layout)new SimpleLayout(), url));
        }
    }

    public String getLogFileUrl() {
        return this._logFileUrl;
    }

    public void setLogLevels(String[] logLevels) {
        this._logWarnings = false;
        this._logErrors = false;
        this._logFatals = false;
        this._logInfos = false;
        this._logLogs = false;
        if (logLevels != null) {
            this._isDebug = logLevels.length > 0;
            for (int a = 0; a < logLevels.length; ++a) {
                String level = logLevels[a];
                if (level.equalsIgnoreCase(WARN)) {
                    this._logWarnings = true;
                }
                if (level.equalsIgnoreCase(ERROR)) {
                    this._logErrors = true;
                }
                if (level.equalsIgnoreCase(FATAL)) {
                    this._logFatals = true;
                }
                if (level.equalsIgnoreCase(INFO)) {
                    this._logInfos = true;
                }
                if (!level.equalsIgnoreCase(LOG)) continue;
                this._logLogs = true;
            }
        }
    }

    public boolean logWarnings() {
        return this._logWarnings;
    }

    public boolean logErrors() {
        return this._logErrors;
    }

    public boolean logLogs() {
        return this._logLogs;
    }

    public boolean logInfos() {
        return this._logInfos;
    }

    public boolean logFatals() {
        return this._logFatals;
    }

    private File getFile() {
        if (this.getLogFileUrl() != null) {
            return new File(this.getLogFileUrl());
        }
        return null;
    }

    public boolean isDebug() {
        return this._isDebug;
    }

    public void setDebug(boolean isDebug) {
        this._isDebug = isDebug;
    }
}

