/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.Action;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.IAction;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.StringUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public abstract class AbstractAction
implements Cloneable,
Serializable,
IAction {
    private Type _definedOnType;
    protected Type _xuiType;
    protected boolean _includeOnlySerializableNodes = false;
    protected boolean _useActionTargetAsBase = true;
    private transient List _targetTypes;
    private String _targetXPath;
    private AbstractAction _inverseAction;
    private transient Document _DOM;
    private String _className;
    private Action _userAction;
    protected boolean _fireChange = true;

    public AbstractAction(Document DOM, Type sourceType, Type xuiType, String xpath, String className) {
        this._DOM = DOM;
        this._definedOnType = sourceType;
        this._xuiType = xuiType;
        if (xuiType != null) {
            String iOSN = xuiType.getDirectChildValue("includeOnlySerializableNodes");
            this._includeOnlySerializableNodes = iOSN != null ? Boolean.valueOf(iOSN) : false;
            String fireChange = xuiType.getParent().getDirectChildValue("fireChange");
            if (fireChange != null) {
                this._fireChange = StringUtil.isTrue(fireChange);
            }
        }
        this._targetXPath = xpath;
        this._className = className;
        this._targetXPath = this._targetXPath == null || this._targetXPath.length() == 0 ? "." : this._targetXPath.trim();
    }

    public AbstractAction getInverseAction() {
        return this._inverseAction;
    }

    public List getTargetTypes() {
        this.initializeTargetTypes();
        return this._targetTypes;
    }

    protected void initialize(Type uiAction) {
    }

    private void initializeTargetTypes() {
        if (this._targetXPath.equals("$this") || this._targetXPath.equals(".")) {
            this._targetTypes = new Vector(2);
            if (this._includeOnlySerializableNodes) {
                if (this._definedOnType.isSerializable()) {
                    this._targetTypes.add(this._definedOnType);
                }
            } else {
                this._targetTypes.add(this._definedOnType);
            }
        } else {
            Type sourceType = this._definedOnType;
            if (sourceType == null) {
                sourceType = this._DOM.getRootType();
            }
            if (!this._targetXPath.startsWith(".") && !this._targetXPath.startsWith("/")) {
                String[] varSplit = StringUtil.split(this._targetXPath, "|");
                this._targetTypes = new Vector(varSplit.length);
                this._DOM.getVarsFor(varSplit, this._targetTypes);
            } else {
                this._targetTypes = TypePathExecuter.getInstance().processXPath(sourceType, this._targetXPath, true, false, false, this._includeOnlySerializableNodes);
            }
            if (this._targetTypes == null) {
                this._targetTypes = new Vector(1);
            }
        }
    }

    public boolean isInversable() {
        return this._inverseAction != null;
    }

    public void perform(Type eventSource) throws RuleInvocationException {
        this.perform(eventSource, false);
    }

    protected abstract void perform(Type var1, Object var2) throws RuleInvocationException;

    protected abstract void perform(Type var1, Object var2, Stack var3) throws RuleInvocationException;

    public void perform(Type eventSource, boolean isTemporary) throws RuleInvocationException {
        this.perform(eventSource, isTemporary, (Stack)null);
    }

    public void perform(Type eventSource, boolean isTemporary, Stack callStack) throws RuleInvocationException {
        long start = System.currentTimeMillis();
        this._DOM = eventSource != null ? eventSource.getDOM() : this._definedOnType.getDOM();
        Iterator iterator = this.getTargetTypes().iterator();
        if (callStack == null) {
            callStack = new Stack<AbstractAction>();
        } else if (callStack.contains(this)) {
            return;
        }
        callStack.add(this);
        while (iterator.hasNext()) {
            try {
                Type targetType = (Type)iterator.next();
                targetType.putClientProperty("ACTION_IDENTIFIER", this);
                targetType.putClientProperty("ACTION_SOURCE", this._definedOnType);
                this.perform(eventSource, targetType, callStack);
                if (!this.isUsingUserAction() || this.getUserAction() == null) continue;
                try {
                    this.getUserAction().perform(eventSource, targetType);
                }
                catch (Throwable t) {
                    if (!LogRegistry.getInstance().logWarnings()) continue;
                    LogRegistry.getInstance().warn(this.getClass(), "Problem while performing UserAction (" + this.getUserAction().getClass() + ") for: " + targetType);
                }
            }
            catch (Throwable t) {
                if (t instanceof RuleInvocationException) {
                    throw (RuleInvocationException)t;
                }
                throw new RuleInvocationException(t);
            }
        }
        long stop = System.currentTimeMillis();
        if (callStack != null) {
            callStack.pop();
        }
    }

    public boolean isUsingUserAction() {
        return this._className != null;
    }

    public Action getUserAction() {
        block3: {
            if (this._userAction == null && this._className != null) {
                try {
                    this._userAction = AbstractAction.checkAction(this.getDOM().getCustomClassloader(), this._className);
                }
                catch (Exception e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block3;
                    LogRegistry.getInstance().warn(this.getClass(), "User Action Class (" + this._className + ") can not be built.");
                }
            }
        }
        return this._userAction;
    }

    public static Action checkAction(ClassLoader classloader, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> userActionClass = classloader.loadClass(className);
        if (userActionClass != null) {
            return (Action)userActionClass.newInstance();
        }
        return null;
    }

    public void performInverse(Type eventSource, Stack callStack) throws RuleInvocationException {
        if (eventSource != null) {
            this._DOM = eventSource.getDOM();
        }
        if (callStack == null) {
            callStack = new Stack<AbstractAction>();
        } else if (callStack.contains(this)) {
            return;
        }
        callStack.add(this);
        Iterator iterator = this.getInverseAction() == null ? this.getTargetTypes().iterator() : this.getInverseAction().getTargetTypes().iterator();
        while (iterator.hasNext()) {
            Type targetType = (Type)iterator.next();
            targetType.putClientProperty("ACTION_IDENTIFIER", this);
            this.performInverse(eventSource, targetType, callStack);
            if (this.getInverseAction() == null || !this.getInverseAction().isUsingUserAction() || this.getInverseAction().getUserAction() == null) continue;
            try {
                this.getInverseAction().getUserAction().perform(eventSource, targetType);
            }
            catch (Throwable t) {
                if (!LogRegistry.getInstance().logWarnings()) continue;
                LogRegistry.getInstance().warn(this.getClass(), "Problem while performing UserAction (" + this.getUserAction().getClass() + ") for: " + targetType);
            }
        }
        if (callStack != null) {
            callStack.pop();
        }
    }

    protected abstract void performInverse(Type var1, Type var2, Stack var3) throws RuleInvocationException;

    public void release() {
        this._definedOnType = null;
        this._targetTypes = null;
        if (this._inverseAction != null) {
            this._inverseAction.release();
        }
        this._inverseAction = null;
        this._DOM = null;
        this._className = null;
        this._targetXPath = null;
        this._userAction = null;
    }

    public void setInverseAction(AbstractAction action) {
        this._inverseAction = action;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" on Type: ");
        sb.append(this._definedOnType.getXPathLocation());
        if (this.getUserAction() != null) {
            sb.append(" User Action:");
            sb.append(this.getUserAction().toString());
        }
        return sb.toString();
    }

    public Object clone(Type newSource) {
        AbstractAction clone = null;
        try {
            clone = (AbstractAction)super.clone();
            clone._definedOnType = newSource;
            clone._targetTypes = null;
            clone._userAction = null;
            if (this._inverseAction != null) {
                clone._inverseAction = (AbstractAction)this._inverseAction.clone(newSource);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean isEmpty() {
        return false;
    }

    public String getTargetXPath() {
        return this._targetXPath;
    }

    public void setTargetXPath(String xpath) {
        this._targetXPath = xpath;
    }

    public abstract void check(Document var1, Type var2) throws RuleInvocationException;

    public Document getDOM() {
        return this._DOM;
    }

    public void setSource(Type sourceType) {
        this._definedOnType = sourceType;
    }

    public Type getSource() {
        return this._definedOnType;
    }

    public void setUseActionTargetAsBase(boolean use) {
        this._useActionTargetAsBase = use;
    }

    public FormulaExpression getExpression() {
        return null;
    }

    public int getActionType() {
        return 0;
    }

    public void setFireChange(boolean fireChange) {
        this._fireChange = fireChange;
    }

    public boolean fireChange() {
        return this._fireChange;
    }
}

