/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.Action;
import com.jaxfront.core.rule.ActionDefinition;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.IntroSpectionHelper;
import java.util.Stack;

public class JavaAction
extends AbstractAction {
    public static final String IMPL_CLASS_NAME = "className";
    public static final String IMPL_VALUE = "value";
    public static final String IMPL_TYPE = "type";
    public static final String IMPL_PARAM = "param";
    private Action _javaImplementation = null;

    public JavaAction(Document dom, Type source, Action userAction) {
        super(dom, source, null, null, null);
        this._javaImplementation = userAction;
    }

    public JavaAction(Document DOM, Type sourceType, String xpath, Type xuiType, String className) {
        super(DOM, sourceType, xuiType, xpath, className);
        this.initialize(xuiType);
    }

    protected void initialize(Type actionDef) {
        SimpleType classNameType;
        super.initialize(actionDef);
        if (actionDef != null && (classNameType = (SimpleType)actionDef.getDirectChild(IMPL_CLASS_NAME)) != null && classNameType.getValue() != null) {
            Object o = IntroSpectionHelper.createObjectByClassloader(classNameType.getValue(), IntroSpectionHelper.getMethodParameters(actionDef), this.getDOM().getCustomClassloader());
            this._javaImplementation = (Action)o;
        }
    }

    public static Object createActionObject(ActionDefinition aActionDef, ClassLoader cl) {
        return IntroSpectionHelper.createObjectByClassloader(aActionDef.getClassName(), aActionDef.getParams(), cl);
    }

    public static ActionDefinition createActionDefinition(Type aActionDef, ClassLoader cl) {
        return new ActionDefinition(aActionDef.getDirectChildValue(IMPL_CLASS_NAME), IntroSpectionHelper.getMethodParameters(aActionDef));
    }

    protected void perform(Type eventSource, Object target) {
        this.perform(eventSource, target, null);
    }

    protected void perform(Type eventSource, Object target, Stack callstack) {
        if (this._javaImplementation != null) {
            this._javaImplementation.perform(eventSource, (Type)target);
        }
    }

    public void check(Document dom, Type target) throws RuleInvocationException {
    }

    protected void performInverse(Type eventSource, Type targetType, Stack callStack) throws RuleInvocationException {
    }

    public void release() {
        this._javaImplementation = null;
        super.release();
    }

    public boolean isEmpty() {
        return false;
    }

    public Object clone(Type newSource) {
        JavaAction clone = (JavaAction)super.clone(newSource);
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" on Type: ");
        sb.append(this.getSource().getXPathLocation());
        return sb.toString();
    }

    public int getActionType() {
        return 4;
    }
}

