/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.access.IUser;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.jep.JAXEvaluatorVisitor;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.MRUHashtable;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.ToStringConverter;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.classloader.DBClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLParseException;
import org.nfunk.jep.FunctionViewerFactory;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MathEvaluator {
    private static final String VAR_PREFIX_XPATH = "XPATH";
    private static final String VAR_PREFIX_NLS = "NLS=";
    private static final String VAR_PREFIX_FORMULA = "FORMULA=";
    private static final String VAR_PREFIX_XPATH_VISUALIZER = "XPATH_VISUALIZER=";
    private static final String VAR_PREFIX_XPATH_USCORE = "XPATH_";
    private static final String VAR_PREFIX_XPATH_EQUAL = "XPATH=";
    private static final String VAR_PREFIX_XPATH_VALUE = "XPATH_VALUE=";
    private static final String VAR_PREFIX_XPATH_NATIVE_VALUE = "XPATH_NATIVE_VALUE=";
    private static final String VAR_PREFIX_FINGERPRINT = "FINGERPRINT=";
    private static final String VAR_PREFIX_SEQUENCE = "SEQUENCE=";
    public static final String MATH_EVALUATOR_ARGUMENT_PREFIX = "-MathEvaluator_";
    public static final String MATH_VAR_HTTP_SESSION = "SESSION";
    public static final String MATH_VAR_SYSTEM_FORM_IDS = "SYSTEM_FORM_IDS";
    public static final String MATH_VAR_USER = "IUser";
    public static final String MATH_VAR_TRUE = "true";
    public static final String MATH_VAR_FALSE = "false";
    public static final String MATH_VAR_PARAM_TRUE = "YES";
    public static final String MATH_VAR_PARAM_FALSE = "NO";
    public static final String MATH_VAR_NA_N = "NaN";
    public static final String MATH_VAR_NULL = "NULL";
    public static final String MATH_VAR_USER_COUNTRY = "USER_COUNTRY";
    public static final String MATH_VAR_OS_NAME = "OS_NAME";
    public static final String MATH_VAR_ESURVEY_ID = "";
    public static final String MATH_VAR_USER_HOME = "USER_HOME";
    public static final String MATH_VAR_MANDANT = "MANDANT";
    public static final String MATH_VAR_MANDANT_ID = "MANDANT_ID";
    public static final String MATH_VAR_MANDANT_NAME = "MANDANT_NAME";
    public static final String MATH_VAR_APPLICATION = "APPLICATION";
    public static final String MATH_VAR_USER_ROLE = "ROLE";
    public static final String MATH_VAR_USER_TIMEZONE = "USER_TIMEZONE";
    public static final String MATH_VAR_USER_EMAIL = "USER_EMAIL";
    public static final String MATH_VAR_USER_NAME = "USER_NAME";
    public static final Object MATH_VAR_USER_LOGIN_TIME = "USER_LOGIN_TIME";
    public static final Object MATH_VAR_USER_LAST_LOGIN_TIME = "USER_LAST_LOGIN_TIME";
    public static final String MATH_VAR_USER_LANGUAGE = "USER_LANGUAGE";
    public static final String MATH_VAR_LANGUAGES = "LANGUAGES";
    public static final String MATH_VAR_NLS_LANGUAGE_SEQUENCE = "NLS_LANGUAGE_SEQUENCE";
    public static final String MATH_VAR_XUI_LANGUAGE = "XUI_LANGUAGE";
    public static final String MATH_VAR_USER_ID = "USER_ID";
    public static final String MATH_VAR_GROUP_UUIDS = "GROUP_UUIDS";
    public static final String MATH_VAR_BASE_GROUP_IDS = "BASE_GROUP_IDS";
    public static final String MATH_VAR_BASE_GROUP_UUIDS = "BASE_GROUP_UUIDS";
    public static final String MATH_VAR_ABSTRACT_GROUP_IDS = "ABSTRACT_GROUP_IDS";
    public static final String MATH_VAR_ABSTRACT_GROUP_UUIDS = "ABSTRACT_GROUP_UUIDS";
    public static final String MATH_VAR_DEPUTY_IDS = "DEPUTY_IDS";
    public static final String MATH_VAR_DEPUTY_FROM_IDS = "DEPUTY_FROM_IDS";
    public static final String MATH_VAR_GROUP_NAMES = "GROUP_NAMES";
    public static final String MATH_VAR_PARENT_GROUP_ID = "PARENT_GROUP_ID";
    public static final String MATH_VAR_PARENT_GROUPS = "PARENT_GROUPS";
    public static final String MATH_VAR_DIRECT_PARENT_GROUP = "DIRECT_PARENT_GROUPS";
    public static final String MATH_VAR_PARENT_GROUPS_IDS = "PARENT_GROUP_IDS";
    public static final String MATH_VAR_GROUPS = "GROUPS";
    public static final String MATH_VAR_HISTORY_PARTICIPANTS = "HISTORY_PARTICIPANTS";
    public static final String MATH_VAR_GROUP_IDS = "GROUP_IDS";
    public static final String MATH_VAR_BASE_GROUPS = "BASE_GROUPS";
    public static final String MATH_VAR_SYSTEM_NAME = "SYSTEM_NAME";
    public static final String MATH_VAR_USER_UUID_ID = "USER_UUID_ID";
    public static final String MATH_VAR_USER_UUID = "USER_UUID";
    public static final String MATH_VAR_GROUP_UUID_IDS = "GROUP_UUID_IDS";
    public static final String MATH_VAR_UUID = "UUID";
    public static final String MATH_VAR_PIDS = "PIDS";
    public static final String MATH_VAR_DOM_ID = "domId";
    public static final String MATH_VAR_FORM_ID = "formID";
    public static final String MATH_VAR_ICONNECTIONMANAGER = "IConnectionManager";
    public static final String MATH_VAR_DOMHANDLER = "domHandler";
    public static final String MATH_VAR_JEP_FUNCTIONS = "JEP_FUNCTIONS";
    public static final String MATH_VAR_MATH_EVALUATOR = "MathEvaluator";
    public static final String MATH_VAR_WORKFLOW_SUCESS_STATE = "WORKFLOW_SUCESS_STATE";
    public static final String MATH_VAR_WORKFLOW_FAILED_STATE = "WORKFLOW_FAILED_STATE";
    private MRUHashtable _nodeCache = new MRUHashtable(30);
    private transient boolean _debug = false;
    private JEP _parser;
    public int _callCount = 0;
    private static MathEvaluator _mathEvaluator;
    private Hashtable _nodeFunctionNames = new Hashtable();
    private static Hashtable _externalFunctions;
    public long timeConsumption;
    private static final String NODE_NAME_FUNCTION = "function";
    private static final String NODE_NAME_IMPLEMENTATIONCLASS = "ImplementationClass";
    private static final String NODE_NAME_FUNCTION_NAME = "Name";
    private static final String NODE_NAME_IS_NODE_FUNCTION = "IsNodeFunction";
    private Stack callStack;

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean _debug) {
        this._debug = _debug;
        this._parser.setDebug(_debug);
    }

    public MathEvaluator(Hashtable initVars) {
        try {
            this.init(initVars);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
    }

    public double evaluate(Type formulaRoot, String expression) throws ParseException {
        return this.evaluate(formulaRoot, expression, false);
    }

    public boolean evaluateExternalOK(Type formulaRoot, String expression) {
        return this.evaluateExternalOK(formulaRoot, expression, null);
    }

    public boolean evaluateExternalOK(Type formulaRoot, String expression, Map userObjects) {
        try {
            if (expression != null) {
                MathCommunicator communi = this.createCommunicatorWithValues(formulaRoot, null, null, null, false, false, null, userObjects, true);
                double res = this.evaluate(expression, communi);
                return res >= 1.0;
            }
        }
        catch (ParseException e) {
            LogRegistry.getInstance().warn(this.getClass(), e.getClass() + " " + e.getMessage());
        }
        return false;
    }

    public String evaluateExternal(Type formulaRoot, String expression) throws Exception {
        return this.evaluateExternal(formulaRoot, expression, null);
    }

    public String evaluateExternal(Type formulaRoot, String expression, Map userObjs) throws Exception {
        try {
            if (expression != null) {
                return this.evaluateString(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, false, false, null, userObjs, true));
            }
        }
        catch (ParseException e) {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), e.getLocalizedMessage());
            }
            throw e;
        }
        return null;
    }

    public String evaluateExternalCaught(Type formulaRoot, String expression, Map userObjs) {
        block3: {
            try {
                if (expression != null) {
                    return this.evaluateString(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, false, false, null, userObjs, true));
                }
            }
            catch (Exception e) {
                if (!LogRegistry.getInstance().logInfos()) break block3;
                LogRegistry.getInstance().info(this.getClass(), e.getLocalizedMessage());
            }
        }
        return null;
    }

    public double evaluate(Type formulaRoot, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluate(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, includeOnlySerializable, null));
    }

    public double evaluate(Type formulaRoot, Type eventSource, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluate(expression, this.createCommunicatorWithValues(formulaRoot, eventSource, null, null, includeOnlySerializable, null));
    }

    public double evaluate(String expression, MathCommunicator communicator) throws ParseException {
        Object value = this.getResultAsObject(expression, communicator);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Complex) {
            return ((Complex)value).re();
        }
        return 0.0;
    }

    public boolean evaluateBoolean(Type formulaRoot, String expression) throws ParseException {
        return this.evaluateBoolean(formulaRoot, expression, false);
    }

    public boolean evaluateBoolean(Type formulaRoot, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluateBoolean(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, includeOnlySerializable, null));
    }

    public boolean evaluateBoolean(Type formulaRoot, Type eventSource, Object event, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluateBoolean(expression, this.createCommunicatorWithValues(formulaRoot, eventSource, event, null, includeOnlySerializable, null));
    }

    public boolean evaluateBoolean(String expression, MathCommunicator communicator) throws ParseException {
        Object value = this.getResultAsObject(expression, communicator);
        double result = -1.0;
        if (value == null) {
            return false;
        }
        result = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof Complex ? ((Complex)value).re() : 0.0);
        return result > 0.0;
    }

    public Object evaluateObject(Type formulaRoot, String expression) throws ParseException {
        return this.evaluateObject(formulaRoot, expression, false);
    }

    public Object evaluateObject(Type formulaRoot, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluateObject(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, includeOnlySerializable, null));
    }

    public Object evaluateObject(Type formulaRoot, Type eventSource, Object event, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluateObject(expression, this.createCommunicatorWithValues(formulaRoot, eventSource, event, null, includeOnlySerializable, null));
    }

    public Object evaluateObject(String expression, MathCommunicator com) throws ParseException {
        return this.getResultAsObject(expression, com);
    }

    public String evaluateString(Type formulaRoot, String expression) throws ParseException {
        return this.evaluateString(formulaRoot, expression, false);
    }

    public String evaluateString(Type formulaRoot, Object eventSource, Object event, String expression, boolean includeOnlySerializable, List targetTypes) throws ParseException {
        return this.evaluateString(expression, this.createCommunicatorWithValues(formulaRoot, eventSource, event, null, includeOnlySerializable, targetTypes));
    }

    public String evaluateString(Type formulaRoot, String expression, boolean includeOnlySerializable) throws ParseException {
        return this.evaluateString(expression, this.createCommunicatorWithValues(formulaRoot, null, null, null, includeOnlySerializable, null));
    }

    public String evaluateString(String expression, MathCommunicator com) throws ParseException {
        Object o = this.getResultAsObject(expression, com);
        if (o == null) {
            return MATH_VAR_ESURVEY_ID;
        }
        return o.toString();
    }

    public String evaluateUserString(String expression, MathCommunicator com) {
        try {
            Object o = this.getResultAsObject(expression, com);
            if (o == null) {
                return null;
            }
            return o.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String evaluateUserString(String expression, Type aBaseType) {
        try {
            Object o = this.getResultAsObject(expression, this.createCommunicatorWithValues(aBaseType, aBaseType, null, null, true, null));
            if (o == null) {
                return null;
            }
            return o.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object evaluateUser(String expression, Type aBaseType) {
        try {
            Object o = this.getResultAsObject(expression, this.createCommunicatorWithValues(aBaseType, aBaseType, null, null, true, null));
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getErrorInfo() {
        return this.getParser().getErrorInfo();
    }

    public static synchronized MathEvaluator getInstance() {
        if (_mathEvaluator == null) {
            _mathEvaluator = new MathEvaluator(null);
        }
        return _mathEvaluator;
    }

    public Enumeration getRegisteredFunctions() {
        return this.getParser().getFunctionTable().keys();
    }

    public int getCalls() {
        return this._callCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResultAsObject(String expression, MathCommunicator communicator) throws ParseException {
        long start = System.currentTimeMillis();
        Node topNode = null;
        try {
            try {
                topNode = this.parseExpressionToNode(expression);
            }
            catch (ParseException pe) {
                if (this.isDebug()) {
                    FunctionViewerFactory.getFunctionViewer().showFormulaError(pe.getErrorInfo());
                }
                throw pe;
            }
            JAXEvaluatorVisitor ev = new JAXEvaluatorVisitor();
            ev.setFastFail(communicator._resultBag == null);
            ev.setCommunicator(communicator);
            JEP parser = this.getParser();
            Object result = parser.getValueAsObject(topNode, ev);
            String errorInfo = MATH_VAR_ESURVEY_ID;
            errorInfo = parser.getErrorInfo();
            if (errorInfo != null) {
                if (this.isDebug()) {
                    FunctionViewerFactory.getFunctionViewer().showFormulaError(errorInfo);
                }
                communicator.getDoc().notifyDebug(3, "Formula: " + expression + " Result:" + result);
                throw new ParseException(errorInfo);
            }
            if (this.isDebug()) {
                FunctionViewerFactory.getFunctionViewer().endFormulas(MATH_VAR_ESURVEY_ID + result);
            }
            Object object = result;
            return object;
        }
        finally {
            long stop = System.currentTimeMillis();
            this.timeConsumption += stop - start;
        }
    }

    private void init(Hashtable initVars) throws XMLParseException, SAXException, IOException {
        IUser user;
        if (initVars != null && initVars.containsKey(MATH_VAR_USER) && (user = (IUser)initVars.get(MATH_VAR_USER)) != null) {
            initVars.put(MATH_VAR_MANDANT_NAME, user.getMandantName());
            initVars.put(MATH_VAR_MANDANT, user.getMandantID());
            initVars.put(MATH_VAR_MANDANT_ID, user.getMandantID());
        }
        this.setVariables(initVars);
        this.getParser().setTraverse(false);
        this.getParser().setImplicitMul(false);
        this.getParser().initFunTab();
        this.getParser().addVariableAsObject(MATH_VAR_TRUE, Boolean.TRUE);
        this.getParser().addVariableAsObject(MATH_VAR_FALSE, Boolean.FALSE);
        this.getParser().addVariableAsObject(MATH_VAR_PARAM_TRUE, SuperTypeNode.isTrue);
        this.getParser().addVariableAsObject(MATH_VAR_PARAM_FALSE, SuperTypeNode.isFalse);
        this.getParser().addVariableAsObject(MATH_VAR_NA_N, MATH_VAR_NA_N);
        this.getParser().addVariableAsObject(MATH_VAR_NULL, NULL._null);
        this.getParser().addVariableAsObject(MATH_VAR_USER_COUNTRY, System.getProperty("user.country"));
        this.getParser().addVariableAsObject(MATH_VAR_OS_NAME, System.getProperty("os.name"));
        this.getParser().addVariableAsObject(MATH_VAR_USER_HOME, System.getProperty("user.home"));
        this.getParser().addVariableAsObject(MATH_VAR_USER_TIMEZONE, System.getProperty("user.timezone"));
        this.getParser().addVariableAsObject(MATH_VAR_USER_LANGUAGE, System.getProperty("user.language"));
        this.getParser().addVariableAsObject(MATH_VAR_XUI_LANGUAGE, System.getProperty("user.language"));
        this.getParser().addVariableAsObject("NONE", new Integer(0));
        this.getParser().addVariableAsObject("SimpleType", new Integer(1));
        this.getParser().addVariableAsObject("SimpleTypeList", new Integer(128));
        this.getParser().addVariableAsObject("SimpleGroup", new Integer(65));
        this.getParser().addVariableAsObject("SimpleGroupList", new Integer(193));
        this.getParser().addVariableAsObject("ComplexGroup", new Integer(66));
        this.getParser().addVariableAsObject("ComplexGroupList", new Integer(194));
        this.getParser().addVariableAsObject("VirtualType", new Integer(4));
        this.getParser().addVariableAsObject("EmptyType", new Integer(8));
        this.getParser().addVariableAsObject("CompositeType", new Integer(2));
        this.getParser().addVariableAsObject("ListType", new Integer(128));
        this.getParser().addVariableAsObject("GroupType", new Integer(64));
        this.getParser().addVariableAsObject("DummyType", new Integer(256));
        this.initExternalFunctions();
    }

    private Object createFunctionInstance(Class aClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object function = null;
        if (aClass != null) {
            Constructor classConstructor = aClass.getConstructor(new Class[0]);
            function = classConstructor.newInstance(new Object[0]);
        }
        return function;
    }

    public void initExternalFunctions() throws XMLParseException, SAXException, IOException {
        if (_externalFunctions == null) {
            this.initExternalFunctions(DOMHelper.createDocument(this.getFunctionsURL()), true);
        } else {
            this.getParser().getFunctionTable().putAll(MathEvaluator.getExternalFunctions());
        }
    }

    public static Hashtable getExternalFunctions() {
        if (_externalFunctions == null) {
            _externalFunctions = new Hashtable();
        }
        return _externalFunctions;
    }

    public void initExternalFunctions(org.w3c.dom.Document doc, boolean cache) throws XMLParseException, SAXException, IOException {
        NodeList functions = doc.getElementsByTagName(NODE_NAME_FUNCTION);
        for (int i = 0; i < functions.getLength(); ++i) {
            String isNodeFunction;
            String functionName;
            String functionImplementorClass = DOMHelper.getChildText(null, (Element)functions.item(i), NODE_NAME_IMPLEMENTATIONCLASS);
            PostfixMathCommandI functionImplementtation = this.registerFunction(functionImplementorClass, functionName = DOMHelper.getChildText(null, (Element)functions.item(i), NODE_NAME_FUNCTION_NAME), isNodeFunction = DOMHelper.getChildText(null, (Element)functions.item(i), NODE_NAME_IS_NODE_FUNCTION));
            if (functionImplementtation == null || !cache) continue;
            MathEvaluator.getExternalFunctions().put(functionName, functionImplementtation);
        }
    }

    public PostfixMathCommandI registerFunction(String functionImplementorClass, String functionName, String isNodeFunction) {
        if (functionImplementorClass != null && !functionImplementorClass.equals(MATH_VAR_ESURVEY_ID) && functionName != null && !functionName.equals(MATH_VAR_ESURVEY_ID)) {
            try {
                Object functionImplementtation = this.createFunctionInstance(DBClassLoader.getInstance((String)this.getParser().getSymbolTable().get(MATH_VAR_MANDANT_NAME)).loadClass(functionImplementorClass));
                if (isNodeFunction != null && isNodeFunction.equals(MATH_VAR_TRUE)) {
                    this._nodeFunctionNames.put(functionName, MATH_VAR_ESURVEY_ID);
                }
                if (functionImplementtation != null) {
                    this.getParser().addFunction(functionName.trim(), (PostfixMathCommandI)functionImplementtation);
                } else {
                    LogRegistry.getInstance().info(this.getClass(), "Can't register function: " + functionName);
                }
                return (PostfixMathCommandI)functionImplementtation;
            }
            catch (Exception e1) {
                LogRegistry.getInstance().error(this.getClass(), "Can't register function: " + functionName + " " + e1.getClass().getName());
            }
        }
        return null;
    }

    public URL getFunctionsURL() {
        return URLHelper.getFunctionsURL();
    }

    public URL getFunctionsXSD() {
        return URLHelper.getFunctionsXSDURL();
    }

    private Node parseExpressionToNode(String expression) throws ParseException {
        JEP parser = this.getParser();
        ++this._callCount;
        if (this.isDebug()) {
            FunctionViewerFactory.getFunctionViewer().startFormulas(expression + " (Calls:" + this._callCount + ")");
        }
        Node aNode = this._nodeCache != null ? (Node)this._nodeCache.get(expression) : null;
        parser.removeErrors();
        if (aNode == null) {
            aNode = parser.parseExpressionToNode(expression);
            if (parser.hasError()) {
                throw new ParseException(expression + " " + parser.getErrorInfo());
            }
            if (aNode != null && this._nodeCache != null && expression.length() < 200) {
                this._nodeCache.put(expression, aNode);
            }
        }
        return aNode;
    }

    private MathCommunicator createCommunicatorWithValues(Type rootType, Object eventSource, Object event, Set resultBag, boolean includeOnlySerializable, List targetTypes) {
        return this.createCommunicatorWithValues(rootType, eventSource, event, resultBag, includeOnlySerializable, false, targetTypes, null, true);
    }

    private MathCommunicator createCommunicatorWithValues(Type rootType, Object eventSource, Object event, Set resultBag, boolean includeOnlySerializable, boolean isDoesConcernEval, List targetTypes, Map userObjects, boolean fireChange) {
        MathCommunicator com = new MathCommunicator();
        com.release();
        com._doc = rootType != null ? rootType.getDOM() : null;
        com._rootType = rootType;
        com._eventSource = eventSource;
        com._event = event;
        com.setResultBag(resultBag);
        com._targetTypes = targetTypes;
        com._includeOnlySerializable = Double.valueOf(includeOnlySerializable ? "1" : "0");
        com._isDoesConcernEval = isDoesConcernEval;
        com._userObjects = userObjects;
        com._fireChange = fireChange;
        return com;
    }

    public void setVariable(String name, Object value) {
        this.getParser().addVariableAsObject(name, value);
    }

    public void setVariables(Map variables) {
        if (variables != null) {
            Iterator it = variables.entrySet().iterator();
            JEP parser = this.getParser();
            while (it.hasNext()) {
                Map.Entry aEntry = it.next();
                String key = (String)aEntry.getKey();
                Object value = aEntry.getValue();
                parser.addVariableAsObject(key, value);
            }
        }
    }

    public Hashtable getVariables() {
        return this.getParser().getSymbolTable();
    }

    private synchronized JEP getParser() {
        if (this._parser == null) {
            this._parser = new JEP();
            this._parser.setAllowUndeclared(true);
            this._parser.setDefaultUndeclaredValue(NULL._null);
        }
        return this._parser;
    }

    public HashSet evaluateReferencedNodes(Type formulaRoot, String expression) throws ParseException {
        HashSet result = new HashSet();
        if (expression != null) {
            MathCommunicator communi = this.createCommunicatorWithValues(formulaRoot, null, null, result, false, true, null, null, false);
            communi.setEditingTypeIncluded(true);
            this.evaluate(expression, communi);
        }
        return result;
    }

    public HashSet evaluateReferencedNodes(Type formulaRoot, String expression, boolean edTypeIncl) throws ParseException {
        HashSet result = new HashSet();
        if (expression != null) {
            MathCommunicator communi = this.createCommunicatorWithValues(formulaRoot, null, null, result, false, true, null, null, false);
            communi.setEditingTypeIncluded(edTypeIncl);
            this.evaluate(expression, communi);
        }
        return result;
    }

    public Hashtable getNodeFunctionNames() {
        return this._nodeFunctionNames;
    }

    public Stack getCallStack() {
        if (this.callStack == null) {
            this.callStack = new Stack();
        }
        return this.callStack;
    }

    public static Object translateVar(Map vars, String aValue) {
        if (vars != null && aValue != null && aValue.startsWith("${") && aValue.endsWith("}")) {
            Object val = vars.get(aValue.substring(2, aValue.length() - 1));
            return val != null ? val : MATH_VAR_ESURVEY_ID;
        }
        return aValue;
    }

    public static void release() {
        _externalFunctions = null;
    }

    public static Properties evaluateUserProperties(IUser user) {
        Properties xuiProperties = new Properties();
        if (user != null) {
            xuiProperties.put(MATH_VAR_USER, user);
            xuiProperties.put(MATH_VAR_USER_ID, user.getId() != null ? user.getId() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_USER_EMAIL, user.getEMail() != null ? user.getEMail() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_MANDANT, user.getMandantID() != null ? user.getMandantID() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_MANDANT_ID, user.getMandantID() != null ? user.getMandantID() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_MANDANT_NAME, user.getMandantName() != null ? user.getMandantName() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_APPLICATION, user.getCurrentApplication() != null ? user.getCurrentApplication() : MATH_VAR_ESURVEY_ID);
            if (user.getLanguage() != null) {
                xuiProperties.put(MATH_VAR_USER_LANGUAGE, user.getLanguage());
                Hashtable<String, String[]> userProps = (Hashtable<String, String[]>)xuiProperties.get("domArgs");
                if (userProps == null) {
                    userProps = new Hashtable<String, String[]>(2);
                }
                userProps.put(MATH_VAR_NLS_LANGUAGE_SEQUENCE, JAXFrontProperties.getInstance(user.getMandantName()).getNLSReadingSequence(user.getLanguage()));
                xuiProperties.put("domArgs", userProps);
            } else {
                xuiProperties.put(MATH_VAR_USER_LANGUAGE, JAXFrontProperties.getInstance(user.getMandantName()).getLanguage());
            }
            xuiProperties.put(MATH_VAR_USER_NAME, user.getName() != null ? user.getName() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_USER_ROLE, user.getRole() != null ? Integer.valueOf(StringUtil.getInt(user.getRole(), 4)) : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_USER_UUID_ID, user.getUuid() != null ? user.getUuid() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_USER_UUID, user.getUuid() != null ? user.getUuid() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_GROUP_UUIDS, user.getGroupUUIDs() != null ? new ArrayResult(user.getGroupUUIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_BASE_GROUPS, user.getBaseGroups() != null ? new ArrayResult((Collection)user.getBaseGroups()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_BASE_GROUP_IDS, user.getBaseGroupIDs() != null ? new ArrayResult(user.getBaseGroupIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_BASE_GROUP_UUIDS, user.getBaseGroupUUIDs() != null ? new ArrayResult(user.getBaseGroupUUIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_PARENT_GROUP_ID, user.getParentGroupID() != null ? user.getParentGroupID() : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_PARENT_GROUPS, user.getAllParentGroups() != null ? new ArrayResult((Collection)user.getAllParentGroups()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_DIRECT_PARENT_GROUP, user.getDirectParentGroups() != null ? new ArrayResult(user.getDirectParentGroups()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_PARENT_GROUPS_IDS, user.getParentGroupsIds() != null ? new ArrayResult(user.getParentGroupsIds()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_GROUPS, user.getGroups() != null ? new ArrayResult((Collection)user.getGroups()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_GROUP_IDS, user.getGroups() != null ? new ArrayResult(user.getGroupIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_GROUP_NAMES, user.getGroupNames() != null ? ArrayUtil.toString(user.getGroupNames()) : MATH_VAR_ESURVEY_ID);
            xuiProperties.put(MATH_VAR_ABSTRACT_GROUP_IDS, user.getAbstractGroupIDs() != null ? new ArrayResult(user.getAbstractGroupIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_ABSTRACT_GROUP_UUIDS, user.getAbstractGroupUUIDs() != null ? new ArrayResult(user.getAbstractGroupUUIDs()) : new ArrayResult());
            xuiProperties.put(MATH_VAR_DEPUTY_FROM_IDS, user.getDeputyFrom(false) != null ? new ArrayResult(user.getDeputyFrom(false)) : new ArrayResult());
            xuiProperties.put(MATH_VAR_DEPUTY_IDS, user.getDeputies() != null ? new ArrayResult(user.getDeputies()) : new ArrayResult());
            if (user.getLoginTime() != null) {
                xuiProperties.put(MATH_VAR_USER_LOGIN_TIME, user.getLoginTime());
            }
            if (user.getLastLogin() != null) {
                xuiProperties.put(MATH_VAR_USER_LAST_LOGIN_TIME, user.getLastLogin());
            }
        }
        return xuiProperties;
    }

    public static String translateVar(String text, Type aType) {
        String result = text;
        List vars = StringUtil.getAllBetween(text, "${", "}", null);
        for (int v = 0; v < vars.size(); ++v) {
            String aValue = (String)vars.get(v);
            String varValue = MathEvaluator.translateVar(aType, aValue, null, null, null);
            if (varValue == null || varValue.equals(NULL._null)) {
                varValue = MATH_VAR_ESURVEY_ID;
            }
            result = StringUtil.replace(result, "${" + aValue + "}", varValue);
        }
        return result;
    }

    public static String translateVar(String text, Map varMap) {
        return MathEvaluator.translateVar(text, varMap, null);
    }

    public static String translateVar(String text, MathEvaluator math) {
        return MathEvaluator.translateVar(text, null, math);
    }

    public static String translateVar(String text, Map varMap, MathEvaluator math) {
        return MathEvaluator.translateVar(null, text, varMap, math);
    }

    public static String translateVar(Type aType, String text, Map varMap, MathEvaluator math) {
        String result = text;
        List vars = StringUtil.getAllBetween(text, "${", "}");
        if (varMap == null && math != null) {
            varMap = math.getVariables();
        }
        if (varMap == null && aType != null) {
            varMap = aType.getDOM().getController().getMathEvaluator().getVariables();
        }
        if (varMap != null) {
            for (int v = 0; v < vars.size(); ++v) {
                String aValue = (String)vars.get(v);
                String varValue = MathEvaluator.translateVar(aType, aValue, null, varMap, math);
                if (varValue == null || varValue.equals(NULL._null)) {
                    varValue = MATH_VAR_ESURVEY_ID;
                }
                result = StringUtil.replace(result, "${" + aValue + "}", varValue);
            }
        }
        return result;
    }

    public static String translateVars(Map vars, String aValue) {
        if (vars != null && aValue != null) {
            int pos = 0;
            MathEvaluator math = (MathEvaluator)vars.get(MATH_VAR_MATH_EVALUATOR);
            while ((pos = aValue.indexOf("${", pos)) >= 0) {
                int endPos = aValue.indexOf("}", pos);
                if (endPos >= pos + 2) {
                    String key = aValue.substring(pos + 2, endPos);
                    String varName = aValue.substring(pos, endPos + 1);
                    Object varValue = vars.get(key);
                    if (math != null && key.toUpperCase().startsWith(VAR_PREFIX_FORMULA)) {
                        try {
                            varValue = math.evaluateExternal(null, key.substring(VAR_PREFIX_FORMULA.length(), key.length()));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (varValue == null || varValue == NULL._null) {
                        varValue = MATH_VAR_ESURVEY_ID;
                    }
                    String vString = varValue.toString();
                    aValue = TextTools.replace(aValue, varName, vString);
                    pos += vString.length();
                    continue;
                }
                ++pos;
            }
        }
        return aValue;
    }

    public static String serializeProperties(Map props) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MapHelper.store(props, bos, null, MATH_EVALUATOR_ARGUMENT_PREFIX, new ToStringConverter(true), "<argument>", "</argument>");
        return new String(bos.toString());
    }

    public static String translateVar(Type aType, String aValue, IUser user, Map vars, MathEvaluator math) {
        Object clienProp;
        String upperVal;
        if (aValue == null) {
            return aValue;
        }
        String varValue = null;
        if (aType != null) {
            if (math == null) {
                math = aType.getDOM().getController().getMathEvaluator();
            }
            if (user == null) {
                user = aType.getDOM().getUser();
            }
            if (vars == null) {
                vars = aType.getDOM().getApplicationProperties();
            }
        }
        if (math == null && vars != null) {
            math = (MathEvaluator)vars.get(MATH_VAR_MATH_EVALUATOR);
        }
        if (vars == null && math != null) {
            vars = math.getVariables();
        }
        if ((upperVal = aValue.toUpperCase()).startsWith(VAR_PREFIX_SEQUENCE, 0)) {
            String seq;
            String seqDef = aValue.substring(VAR_PREFIX_SEQUENCE.length(), aValue.length());
            varValue = seq = aType.getDOM().getConnectionManager().getDataBaseInfo().createIdentity(StringUtil.substringBefore(seqDef, "."), StringUtil.substringAfter(seqDef, "."));
        } else if (aType != null && upperVal.startsWith(VAR_PREFIX_FINGERPRINT)) {
            varValue = aType.getDOM().getFingerPrint().getProcessingInstruction(aValue.substring(VAR_PREFIX_FINGERPRINT.length(), aValue.length()));
        } else if (aType != null && upperVal.startsWith(VAR_PREFIX_XPATH)) {
            boolean isNativeVal = false;
            String xpath = null;
            if (upperVal.startsWith(VAR_PREFIX_XPATH_NATIVE_VALUE)) {
                xpath = aValue.substring(19, aValue.length());
                isNativeVal = true;
            } else if (upperVal.startsWith(VAR_PREFIX_XPATH_VALUE)) {
                xpath = aValue.substring(12, aValue.length());
            } else if (upperVal.startsWith(VAR_PREFIX_XPATH_EQUAL) || upperVal.startsWith(VAR_PREFIX_XPATH_USCORE)) {
                xpath = aValue.substring(6, aValue.length());
            }
            if (xpath != null) {
                Type foundType = aType.getDOM().getType(xpath, aType);
                varValue = foundType != null ? (foundType.isSimple() ? (isNativeVal ? ((SimpleType)foundType).getPlainValue() : ((SimpleType)foundType).getValue()) : foundType.getName()) : null;
            }
        } else if (aType != null && upperVal.startsWith(VAR_PREFIX_XPATH_VISUALIZER)) {
            Type foundType = aType.getDOM().getType(aValue.substring(VAR_PREFIX_XPATH_VISUALIZER.length(), aValue.length()), aType);
            if (foundType != null) {
                foundType.getStyle().setVisibleAtRuntime(true);
                foundType.getStyle().setEditableAtRuntime(true);
                Vector allVis = TypeVisualizerFactory.getInstance().getAllVisualizers(foundType);
                if (allVis == null || allVis.size() == 0) {
                    Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer(foundType, foundType, true);
                    if (vis != null) {
                        vis.populateView();
                        if (vis.getRendererType() == 2) {
                            varValue = IntroSpectionHelper.callFunktion((Object)vis, "getHTMLComponent").toString();
                        }
                    }
                } else {
                    for (int a = 0; a < allVis.size(); ++a) {
                        Visualizer vis = (Visualizer)allVis.get(a);
                        if (vis == null) continue;
                        vis.populateView();
                        if (a != 0) continue;
                        varValue = IntroSpectionHelper.callFunktion((Object)vis, "getHTMLComponent").toString();
                    }
                }
            } else {
                varValue = null;
            }
        } else if (upperVal.startsWith(VAR_PREFIX_FORMULA)) {
            try {
                String formula = aValue.substring(VAR_PREFIX_FORMULA.length(), aValue.length());
                formula = MathEvaluator.translateVar(aType, formula, vars, math);
                varValue = math.evaluateExternal(aType, formula);
            }
            catch (Exception e) {
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(MathEvaluator.class, e.getMessage());
                }
            }
        } else if (user != null && upperVal.startsWith(VAR_PREFIX_NLS)) {
            varValue = user.getNLS(aValue.substring(VAR_PREFIX_NLS.length(), aValue.length()));
        } else if (vars != null && (clienProp = vars.get(aValue)) != null) {
            varValue = clienProp instanceof List ? ArrayUtil.toString((List)clienProp, ",") : clienProp.toString();
        }
        return varValue;
    }

    static {
        _externalFunctions = null;
    }

    public class MathCommunicator {
        private Document _doc;
        private Type _rootType;
        private List _targetTypes;
        private Map _userObjects;
        private Object _eventSource;
        private Object _event;
        private Set _resultBag = null;
        private Double _includeOnlySerializable = SuperTypeNode.isFalse;
        private boolean _extractValues = false;
        private boolean _extractFirstOnly = false;
        protected boolean _listTypeIncluded = false;
        protected boolean _editingTypeIncluded = false;
        protected boolean _addEmptyElementsToResult = true;
        protected boolean _isDoesConcernEval = false;
        protected boolean _fireChange = true;

        public void release() {
            this._doc = null;
            this._rootType = null;
            if (this._userObjects != null) {
                this._userObjects.clear();
            }
            this._resultBag = null;
            this._includeOnlySerializable = SuperTypeNode.isFalse;
        }

        public Document getDoc() {
            return this._doc;
        }

        public boolean fireChange() {
            return this._fireChange;
        }

        public void setFireChange(boolean fireChange) {
            this._fireChange = fireChange;
        }

        public List getTargetTypes() {
            return this._targetTypes;
        }

        public void setTargetTypes(List targetTypes) {
            this._targetTypes = targetTypes;
        }

        public Double getIncludeOnlySerializable() {
            return this._includeOnlySerializable;
        }

        public Set getResultBag() {
            return this._resultBag;
        }

        public void setResultBag(Set rb) {
            this._resultBag = rb;
        }

        public boolean isConcernEval() {
            return this._isDoesConcernEval;
        }

        public void setConcernEval(boolean doesConcernEval) {
            this._isDoesConcernEval = doesConcernEval;
        }

        public Type getRootType() {
            return this._rootType;
        }

        public Object getEventSource() {
            return this._eventSource;
        }

        public Object getEvent() {
            return this._event;
        }

        public Object setUserObject(Object key, Object value) {
            if (this._userObjects == null) {
                this._userObjects = new HashMap();
            }
            return this._userObjects.put(key, value);
        }

        public Object getUserObject(Object key) {
            if (this._userObjects != null) {
                return this._userObjects.get(key);
            }
            return null;
        }

        public boolean isAddEmptyElementsToResult() {
            return this._addEmptyElementsToResult;
        }

        public void setAddEmptyElementsToResult(boolean emptyElementsToResult) {
            this._addEmptyElementsToResult = emptyElementsToResult;
        }

        public boolean isExtractFirstOnly() {
            return this._extractFirstOnly;
        }

        public void setExtractFirstOnly(boolean firstOnly) {
            this._extractFirstOnly = firstOnly;
        }

        public boolean isExtractValues() {
            return this._extractValues;
        }

        public void setExtractValues(boolean values) {
            this._extractValues = values;
        }

        public boolean isListTypeIncluded() {
            return this._listTypeIncluded;
        }

        public void setListTypeIncluded(boolean typeIncluded) {
            this._listTypeIncluded = typeIncluded;
        }

        public boolean isEditingTypeIncluded() {
            return this._editingTypeIncluded;
        }

        public void setEditingTypeIncluded(boolean typeIncluded) {
            this._editingTypeIncluded = typeIncluded;
        }

        public String toString() {
            StringBuffer toString = new StringBuffer();
            if (this._rootType != null) {
                toString.append(this._rootType);
                toString.append(" ");
            }
            if (this._eventSource != null) {
                toString.append(this._eventSource);
            }
            return toString.toString();
        }
    }
}

