/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import java.util.Stack;
import org.nfunk.jep.FunctionViewerFactory;
import org.nfunk.jep.ParseException;

public class ModelAction
extends AbstractAction {
    FormulaExpression _expression;

    public ModelAction(Document DOM, Type sourceType, String xpath, Type xuiType, String className, String expression) {
        super(DOM, sourceType, xuiType, xpath, className);
        this.initialize(xuiType);
        if (expression != null) {
            this._expression = new FormulaExpression(this.getSource(), expression, false, false);
        }
    }

    public ModelAction(Document DOM, Type sourceType, String xpath, Type xuiType, String className) {
        this(DOM, sourceType, xpath, xuiType, className, null);
    }

    private String getValue(Type target) {
        if (this.hasExpression()) {
            try {
                return this._expression.evaluate(target, null, null, true, null);
            }
            catch (FormulaException e) {
                LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                return null;
            }
        }
        return null;
    }

    private Object getValueAsObject() {
        if (this.hasExpression()) {
            try {
                return this._expression.evaluateObject();
            }
            catch (FormulaException e) {
                LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                return null;
            }
        }
        return null;
    }

    boolean hasExpression() {
        return this._expression != null;
    }

    protected void initialize(Type uiAction) {
        super.initialize(uiAction);
        if (uiAction != null && uiAction.getDirectChild("formulaExpression") != null && uiAction.getDirectChildValue("formulaExpression") != null) {
            boolean includeOnlySerializableNodes = Boolean.valueOf(uiAction.getParent().getDirectChildValue("includeOnlySerializableNodes"));
            this._expression = new FormulaExpression(this.getSource(), uiAction.getDirectChildValue("formulaExpression"), includeOnlySerializableNodes, false);
        }
    }

    protected void perform(Type eventSource, Object target) {
        this.perform(eventSource, target, null);
    }

    protected void perform(Type eventSource, Object target, Stack callstack) {
        if (this._expression != null && target != null && target instanceof Type) {
            Type aTarget = (Type)target;
            if (aTarget == null) {
                aTarget = this.getSource();
            }
            String theValue = null;
            if (aTarget.isSimple() || aTarget.getSchemaElement().getSchemaType().isMixedContent()) {
                theValue = this._useActionTargetAsBase ? this.getValue(aTarget) : this.getValue(this.getSource());
                if (aTarget.getDOM().getController().isDebug()) {
                    FunctionViewerFactory.getFunctionViewer().endAction("   ->Set Value: " + theValue + " on: " + aTarget.getXPathLocation());
                }
                ((SimpleType)aTarget).setValue(this, theValue, !this.fireChange(), false, callstack);
            } else {
                Object resultObject = this.getValueAsObject();
                if (aTarget.getDOM().getController().isDebug()) {
                    FunctionViewerFactory.getFunctionViewer().endAction("performed Expression with: " + theValue + " on: " + ((Type)target).getXPathLocation());
                }
            }
        }
    }

    public void check(Document dom, Type target) throws RuleInvocationException {
        Type foundTarget;
        if (this.getTargetXPath() != null && !(foundTarget = TypePathExecuter.getInstance().getTypeForXPath(target, this.getTargetXPath(), true)).isSimple()) {
            throw new RuleInvocationException(new RuntimeException("Target must be simple for ModelAction (" + target.getXPathLocation() + ")"));
        }
        if (this._expression != null) {
            try {
                dom.getController().getMathEvaluator().evaluate(target, this._expression.getExpression());
            }
            catch (ParseException ex) {
                throw new RuleInvocationException(ex);
            }
        }
    }

    protected void performInverse(Type eventSource, Type targetType, Stack callStack) throws RuleInvocationException {
        if (this.getInverseAction() != null) {
            this.getInverseAction().perform(eventSource, targetType, callStack);
        }
    }

    public void release() {
        if (this._expression != null) {
            this._expression.release();
        }
        super.release();
    }

    public boolean isEmpty() {
        return this._expression == null;
    }

    public Object clone(Type newSource) {
        ModelAction clone = (ModelAction)super.clone(newSource);
        if (this._expression != null) {
            String oldExpression = this._expression.getExpression();
            clone._expression = new FormulaExpression(newSource, oldExpression, this._expression.doesIncludeOnlySerializableNodes(), false, null);
        }
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" on Type: ");
        sb.append(this.getSource().getXPathLocation());
        sb.append(" apply expression: " + this._expression);
        return sb.toString();
    }

    public void setSource(Type sourceType) {
        super.setSource(sourceType);
        this._expression.setSource(sourceType);
    }

    public FormulaExpression getExpression() {
        return this._expression;
    }

    public int getActionType() {
        return 1;
    }
}

