/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.error.ConditionalError;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.IAction;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.rule.ScopeChecker;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.xui.BehaviourDefinition;
import com.jaxfront.core.xui.StyleDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.FunctionViewerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleImpl
implements Cloneable,
Serializable,
Rule {
    private Type _source;
    private String _executionMode;
    private String _id;
    private ConditionExpression _condition;
    private List<IAction> _actions;
    private long _eventType = 0L;
    private String _scope;
    private int _priority = 0;
    private boolean _doesConcernNoneSerializableSource;
    private boolean _doesConcernOnlyVisibleSource;
    private boolean _isReleased = false;
    private static long _instCount = 0L;
    private long _creationID = -1L;
    private boolean _scopeInclActionTarget = false;

    public RuleImpl(long type, Type source) {
        this(type, source, "sourceAndReferencedNodes");
    }

    public RuleImpl(long type, Type source, String scope) {
        this(type, source, scope, true);
    }

    public RuleImpl(long type, Type source, String scope, boolean doesConcernNoneSerializableSource) {
        this(type, source, "clientAndServer", scope, doesConcernNoneSerializableSource, false);
    }

    public RuleImpl(long type, Type source, String executionMode, String scope, boolean doesConcernNoneSerializableSource, boolean doesConcernOnlyVisible) {
        this(null, type, source, executionMode, scope, doesConcernNoneSerializableSource, doesConcernOnlyVisible, false);
    }

    public RuleImpl(String id, long type, Type source, String executionMode, String scope, boolean doesConcernNoneSerializableSource, boolean doesConcernOnlyVisible, boolean includeActionTarget) {
        this._id = id;
        this._eventType = type;
        this._executionMode = executionMode;
        this._source = source;
        this._scope = scope;
        this._doesConcernNoneSerializableSource = doesConcernNoneSerializableSource;
        this._doesConcernOnlyVisibleSource = doesConcernOnlyVisible;
        this._creationID = _instCount++;
        this._scopeInclActionTarget = includeActionTarget;
    }

    @Override
    public void apply(Type eventSource, Object event) {
        this.apply(eventSource, event, false);
    }

    @Override
    public void apply(Type eventSource, Object event, boolean isRunningAsServer) {
        this.apply(eventSource, event, isRunningAsServer, null);
    }

    @Override
    public void apply(Type eventSource, Object event, boolean isRunningAsServer, Stack callStack) {
        Type aSourceType = this.getSource();
        TypeController typeCtrl = aSourceType.getDOM().getController();
        if (typeCtrl.isDebug()) {
            FunctionViewerFactory.getFunctionViewer().startTraceUnit(this._source.getXPathLocation(), new StringBuffer().append("raised by: ").append(BehaviourDefinition.convertMaskToRuleString(this)).append(" with Priority:").append(this.getPriority()).toString(), this._eventType, this.getPriority());
        }
        if (this.getExecutionMode().equals("client") && isRunningAsServer || this.getExecutionMode().equals("server") && !isRunningAsServer) {
            return;
        }
        boolean checkRule = false;
        checkRule = this._doesConcernNoneSerializableSource ? true : aSourceType.isSerializable();
        if (checkRule && this._doesConcernOnlyVisibleSource) {
            boolean parentSer;
            boolean isVisible = aSourceType.getXUIDefinition().getStyle().isVisibleAtRuntime();
            boolean bl = parentSer = aSourceType.getParent() != null && aSourceType.getParent().isSerializable();
            if (!isVisible || !parentSer) {
                checkRule = false;
                typeCtrl.getErrorController().removeConditionalError(this, this.getCondition(), aSourceType);
            }
        }
        if (checkRule && this.getCondition() != null) {
            boolean toggledConditionUsed;
            boolean conditionsOK;
            block18: {
                conditionsOK = true;
                toggledConditionUsed = false;
                try {
                    conditionsOK = this.getCondition().isTrue(eventSource, event);
                }
                catch (FormulaException e) {
                    conditionsOK = false;
                }
                catch (Exception ex) {
                    conditionsOK = false;
                    if (!LogRegistry.getInstance().logWarnings()) break block18;
                    LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Error while perform condition. Reason: ").append(ex.getLocalizedMessage()).toString());
                }
            }
            if (!conditionsOK) {
                toggledConditionUsed = true;
                this.performInverseActions(eventSource, callStack, event);
            }
            if (this.getCondition().isShowingError()) {
                typeCtrl.getErrorController().removeConditionalError(this, this.getCondition(), aSourceType);
                StyleDefinition sourceStyle = aSourceType.getXUIDefinition().getStyle();
                if (conditionsOK && sourceStyle.isVisibleAtRuntime()) {
                    typeCtrl.getErrorController().addError(new ConditionalError(this, this.getCondition(), this.getCondition().getSource()));
                } else {
                    typeCtrl.getErrorController().removeConditionalError(this, this.getCondition(), aSourceType);
                }
            }
            if (conditionsOK && !toggledConditionUsed) {
                for (IAction aAction : this.getActions()) {
                    if (typeCtrl.isDebug()) {
                        FunctionViewerFactory.getFunctionViewer().startAction(new StringBuffer().append("Fire Action: ").append(aAction.toString()).toString());
                    }
                    try {
                        aAction.perform(eventSource, false, callStack);
                    }
                    catch (RuleInvocationException e1) {
                        if (!this.isVisualizerInitializationRule()) {
                            aSourceType.getDOM().addNotFiredInitializationRule(e1.getTargetType(), this);
                            continue;
                        }
                        if (!LogRegistry.getInstance().logWarnings()) continue;
                        LogRegistry.getInstance().warn(this.getClass(), e1.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public boolean doesConcern(Type sourceType) {
        if (this._scope != null) {
            return ScopeChecker.doesConcern(this._scope, this.getSource(), sourceType, this.getCondition(), this._scopeInclActionTarget, this.getActions());
        }
        return false;
    }

    @Override
    public boolean isScopeIncludeActionTarget() {
        return this._scopeInclActionTarget;
    }

    public void setScopeIncludeActionTarget(boolean inclTargets) {
        this._scopeInclActionTarget = inclTargets;
    }

    @Override
    public List<IAction> getActions() {
        if (this._actions == null) {
            this._actions = new ArrayList<IAction>();
        }
        return this._actions;
    }

    @Override
    public ConditionExpression getCondition() {
        return this._condition;
    }

    @Override
    public Type getSource() {
        return this._source;
    }

    public long getType() {
        return this._eventType;
    }

    @Override
    public boolean isVisualizerInitializationRule() {
        return (1L & this._eventType) != 0L;
    }

    @Override
    public boolean isOnCreationRule() {
        return (0x800L & this._eventType) != 0L;
    }

    @Override
    public boolean isChangeRule() {
        return (2L & this._eventType) != 0L;
    }

    @Override
    public boolean isChangeAndInitializationRule() {
        return (4L & this._eventType) != 0L;
    }

    @Override
    public boolean isPropertyChangeRule() {
        return (8L & this._eventType) != 0L;
    }

    @Override
    public boolean isStructureChangeRule() {
        return (0x40L & this._eventType) != 0L;
    }

    @Override
    public boolean isStructureChangeAddRule() {
        return (0x10L & this._eventType) != 0L;
    }

    @Override
    public boolean isStructureChangeRemoveRule() {
        return (0x20L & this._eventType) != 0L;
    }

    @Override
    public boolean isSaveDocumentRule() {
        return (0x400L & this._eventType) != 0L;
    }

    @Override
    public boolean isDomDeletedRule() {
        return (0x10000L & this._eventType) != 0L;
    }

    @Override
    public boolean isPersistentRule() {
        return (0x4000L & this._eventType) != 0L;
    }

    @Override
    public boolean isAboutToPersistRule() {
        return (0x8000L & this._eventType) != 0L;
    }

    @Override
    public boolean isTypeCommit() {
        return (0x8000000L & this._eventType) != 0L;
    }

    @Override
    public boolean isAboutToValidateRule() {
        return (0x20000L & this._eventType) != 0L;
    }

    @Override
    public boolean isDomInitialized() {
        return (0x80L & this._eventType) != 0L;
    }

    @Override
    public boolean isListItemSelectedRule() {
        return (0x100L & this._eventType) != 0L;
    }

    @Override
    public boolean isListItemDeselectedRule() {
        return (0x200L & this._eventType) != 0L;
    }

    @Override
    public boolean isCopyContentRule() {
        return (0x1000L & this._eventType) != 0L;
    }

    @Override
    public boolean isPasteContentRule() {
        return (0x2000L & this._eventType) != 0L;
    }

    @Override
    public long removeRuleType(long removeType) {
        this._eventType = BehaviourDefinition.removeFromEventFilter(this._eventType, removeType);
        return this._eventType;
    }

    protected void performInverseActions(Type eventSource, Stack callStack, Object event) {
        Iterator<IAction> iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            try {
                AbstractAction action = (AbstractAction)iterator.next();
                boolean performInverse = false;
                if (action.getInverseAction() != null) {
                    performInverse = true;
                } else if (this.getCondition().isUsingDefaultToggle() && action.isInversable()) {
                    performInverse = true;
                }
                if (action.isInversable() && this.getSource().getDOM().getController().isDebug()) {
                    if (action != null && action.getInverseAction() != null) {
                        FunctionViewerFactory.getFunctionViewer().startAction(new StringBuffer().append("Fire InverseAction: ").append(action.getInverseAction().toString()).toString());
                    } else {
                        FunctionViewerFactory.getFunctionViewer().startAction("Fire InverseAction: no action taken!");
                    }
                }
                if (!performInverse) continue;
                action.performInverse(eventSource, callStack);
            }
            catch (RuleInvocationException e1) {
                if (this.isVisualizerInitializationRule()) continue;
                this.getSource().getDOM().addNotFiredInitializationRule(e1.getTargetType(), this);
            }
        }
    }

    @Override
    public void release() {
        if (this._condition != null) {
            if (this._source != null && this._source.getDOM() != null && !this._source.getDOM().isReleased()) {
                this._source.getDOM().getController().getErrorController().removeConditionalError(this, this._condition, this._source);
            }
            this._condition.release();
        }
        if (this._actions != null) {
            Iterator<IAction> iterator = this._actions.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this._isReleased = true;
        this._source = null;
    }

    @Override
    public void setCondition(ConditionExpression condition) {
        this._condition = condition;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n");
        sb.append(new StringBuffer().append("--- Source Type: ").append(this.getSource().getXPathLocation()).toString());
        sb.append("\n");
        sb.append(new StringBuffer().append("--- Priority : ").append(this.getPriority()).toString());
        sb.append("\n");
        sb.append(new StringBuffer().append("--- CreationId : ").append(this.getCreationId()).toString());
        sb.append("\n");
        sb.append(new StringBuffer().append("--- Event Type : ").append(this.getType()).toString());
        sb.append("\n");
        sb.append("--- Condition : ");
        if (this.getCondition() != null) {
            sb.append(this.getCondition().toString());
        }
        sb.append("\n");
        sb.append("--- Actions    : ");
        for (int i = 0; i < this.getActions().size(); ++i) {
            sb.append("\n");
            sb.append(new StringBuffer().append("(").append(i).append(") ").append(this.getActions().get(i).toString()).toString());
        }
        return sb.toString();
    }

    @Override
    public Object clone(Type newSource) {
        RuleImpl clone = null;
        try {
            clone = (RuleImpl)super.clone();
            clone.setSource(newSource);
            if (this._condition != null) {
                clone._condition = (ConditionExpression)this._condition.clone(newSource);
            }
            List<IAction> actions = this.getActions();
            Iterator<IAction> iterator = actions.iterator();
            ArrayList<IAction> newActions = new ArrayList<IAction>(actions.size());
            while (iterator.hasNext()) {
                AbstractAction action = (AbstractAction)iterator.next();
                newActions.add((IAction)action.clone(newSource));
            }
            clone._actions = newActions;
            clone._creationID = _instCount++;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void setSource(Type type) {
        this._source = type;
    }

    public String getScope() {
        return this._scope;
    }

    public String getExecutionMode() {
        return this._executionMode;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public void setPriority(int priority) {
        this._priority = priority;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public long getRuleType() {
        return this._eventType;
    }

    @Override
    public boolean isReleased() {
        return this._isReleased;
    }

    @Override
    public long getCreationId() {
        return this._creationID;
    }

    @Override
    public boolean isAboutGoNext() {
        return (0x1000000L & this._eventType) != 0L;
    }

    @Override
    public boolean isGoNext() {
        return (0x800000L & this._eventType) != 0L;
    }

    @Override
    public boolean isPageSelected() {
        return (0x2000000L & this._eventType) != 0L;
    }

    @Override
    public boolean isGoPrevious() {
        return (0x20000000L & this._eventType) != 0L;
    }

    @Override
    public boolean isAboutGoPrevious() {
        return (0x40000000L & this._eventType) != 0L;
    }

    @Override
    public boolean isAboutToSerialize() {
        return (Integer.MIN_VALUE & this._eventType) != 0L;
    }
}

