/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import java.util.List;
import java.util.Vector;

public class ScopeChecker {
    public static boolean doesConcern(String scope, Type source, Type checkType, ConditionExpression condition, boolean inclActionTargets, List actions) {
        if (scope != null) {
            if (scope.equals("all")) {
                return true;
            }
            if (scope.equals("sourceOnly")) {
                if (source == checkType) {
                    return true;
                }
            } else if (scope.startsWith("source")) {
                if (source == checkType) {
                    return true;
                }
                if (scope.equals("sourceAndReferencedNodes") && condition != null && condition.doesConcern(checkType, false)) {
                    return true;
                }
                if (scope.equals("sourceAndAllDescendants") && checkType.isDerivedFrom(source)) {
                    return true;
                }
                if (scope.equals("sourceAndDirectDescendants")) {
                    return ScopeChecker.checkDirectDescendants(source, checkType);
                }
                if (scope.equals("sourceAndSiblings")) {
                    return ScopeChecker.checkSiblings(source, checkType);
                }
            } else {
                if (scope.equals("allDescendants") && checkType.isDerivedFrom(source)) {
                    return true;
                }
                if (scope.equals("directDescendants")) {
                    return ScopeChecker.checkDirectDescendants(source, checkType);
                }
                if (scope.equals("parent")) {
                    return ScopeChecker.checkParent(source, checkType);
                }
                if (scope.equals("directParent")) {
                    return ScopeChecker.checkDirectParent(source, checkType);
                }
            }
            if (inclActionTargets && actions != null) {
                for (int a = 0; a < actions.size(); ++a) {
                    boolean concerns;
                    FormulaExpression formula;
                    AbstractAction aAction = (AbstractAction)actions.get(a);
                    if (aAction.getActionType() != 1 || (formula = aAction.getExpression()) == null || !(concerns = ScopeChecker.doesConcern(checkType, formula))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesConcern(Type checkType, FormulaExpression formula) {
        return formula != null && formula.doesConcern(checkType, true);
    }

    private static boolean checkDirectDescendants(Type source, Type checkType) {
        List directDescendants = new Vector();
        if (source.isList()) {
            directDescendants = ((ListType)source).getList();
        } else if (source.isComposite()) {
            directDescendants = ((CompositeType)source).getComposites();
        }
        if (checkType.getParent() != null && checkType.getParent().isList() && checkType.getParent() == source && !((ListType)checkType.getParent()).getList().contains(checkType)) {
            return true;
        }
        return directDescendants.contains(checkType);
    }

    private static boolean checkSiblings(Type source, Type checkType) {
        boolean isSibling = false;
        if (source.getParent() != null) {
            Type srcParent = source.getParent();
            if (srcParent.isList()) {
                isSibling = ((List)((Object)srcParent)).contains(checkType);
            } else if (srcParent.isComposite()) {
                List compChilds = ((AbstractType)srcParent).getDirectChildren();
                isSibling = compChilds.contains(checkType);
            }
        }
        return isSibling;
    }

    private static boolean checkDirectParent(Type source, Type checkType) {
        return source.getParent() != null && source.getParent() == checkType;
    }

    private static boolean checkParent(Type source, Type checkType) {
        for (Type aParent = source.getParent(); aParent != null; aParent = aParent.getParent()) {
            if (aParent != checkType) continue;
            return true;
        }
        return false;
    }
}

