/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.SchemaType;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.SchemaNodeImpl;
import com.jaxfront.core.schema.impl.SchemaParticleList;
import com.jaxfront.core.schema.impl.SchemaTypeComparatorWrapper;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.TextTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class SchemaComplexTypeImpl
implements SchemaComplexType,
Serializable {
    private SchemaNode[] _recursiveElements = null;
    protected Type _type;
    protected boolean _isSimpleContent = false;
    protected boolean _isGroup = false;
    protected boolean _isAttributeGroup = false;
    protected boolean _isAbstract = false;
    protected boolean _isAnonymous = false;
    protected int _simpleContentIndex = -1;
    protected String _baseName;
    protected String _nameSpace;
    private String _name;
    protected String _qName;
    protected boolean _isChoice;
    protected int _choiceMin = -1;
    protected int _choiceMax = -1;
    protected boolean _isRecursion;
    protected SchemaSimpleType _simpleContent;
    protected transient XSTypeDefinition _node;
    protected transient XSModelGroup _unnamedNode;
    protected transient XMLSchema _schema;
    protected SchemaNode _schemaElement;
    private SchemaNode[] _elementSet;
    private SchemaNode[] _attributeSet;
    private String[] _recElementNames = null;
    static /* synthetic */ Class class$java$lang$String;

    public SchemaComplexTypeImpl(String nameSpace, String name, XSTypeDefinition node, XMLSchema schema, SchemaNode element) {
        this(nameSpace, name, schema, element);
        this._node = node;
        if (node != null) {
            this.initialize((XSObject)node);
        }
    }

    public SchemaComplexTypeImpl(String nameSpace, String name, XSModelGroup unnamedNode, XMLSchema schema, SchemaNode element) {
        this(nameSpace, name, schema, element);
        this._unnamedNode = unnamedNode;
        if (unnamedNode != null) {
            this.initialize((XSObject)unnamedNode);
        }
    }

    public SchemaComplexTypeImpl(String nameSpace, String name, XSAttributeGroupDefinition attrGroup, XMLSchema schema, SchemaNode element) {
        this(nameSpace, name, schema, element);
        this._isAttributeGroup = true;
        if (attrGroup != null) {
            this.initialize((XSObject)attrGroup);
        }
    }

    public SchemaComplexTypeImpl(String nameSpace, String name, XMLSchema schema, SchemaNode element) {
        this.setName(name);
        this._nameSpace = nameSpace;
        this._schemaElement = element;
        this._schema = schema;
    }

    public SchemaComplexTypeImpl(XSTypeDefinition node, XMLSchema schema, SchemaNode element) {
        this(null, null, node, schema, element);
    }

    private SchemaParticleList checkForXSDGroups(XSModelGroup modelGroup) {
        XSObjectList list = modelGroup.getParticles();
        Vector newList = new Vector();
        Hashtable<XSObject, String> groupRefs = null;
        Vector schemaNodes = new Vector();
        int unnamedSequenceCounter = 0;
        ArrayList unnamedSequenceCounterList = new ArrayList();
        for (int i = 0; i < list.getLength(); ++i) {
            XSObject item = list.item(i);
            if (item.getType() == 8) {
                XSTerm term = ((XSParticle)item).getTerm();
                if (term.getType() == 7) {
                    XSModelGroup group = (XSModelGroup)term;
                    String groupRefName = ((XMLSchemaImpl)this.getSchemaElement().getSchema()).getGroupQName((XSObject)group);
                    if (groupRefName != null) {
                        if (groupRefs == null) {
                            groupRefs = new Hashtable<XSObject, String>();
                        }
                        this.addItemToParticleList(-1, unnamedSequenceCounterList, newList, schemaNodes, item, item);
                        groupRefs.put(item, groupRefName);
                        continue;
                    }
                    if (group.getCompositor() != 2 && modelGroup.getCompositor() != 2) {
                        XSObjectList particles = group.getParticles();
                        if (particles.getLength() > 0) {
                            ++unnamedSequenceCounter;
                        }
                        for (int j = 0; j < particles.getLength(); ++j) {
                            this.addItemToParticleList(unnamedSequenceCounter, unnamedSequenceCounterList, newList, schemaNodes, particles.item(j), item);
                        }
                        continue;
                    }
                    this.addItemToParticleList(-1, unnamedSequenceCounterList, newList, schemaNodes, item, item);
                    continue;
                }
                this.addItemToParticleList(-1, unnamedSequenceCounterList, newList, schemaNodes, item, item);
                continue;
            }
            this.addItemToParticleList(-1, unnamedSequenceCounterList, newList, schemaNodes, item, item);
        }
        return new SchemaParticleList(newList, groupRefs, schemaNodes, unnamedSequenceCounterList);
    }

    private void addItemToParticleList(int counter, ArrayList unnamedSequenceList, Vector list, List schemaNodes, XSObject item, XSObject holder) {
        list.add(item);
        schemaNodes.add(holder);
        unnamedSequenceList.add(new Integer(counter));
    }

    public SchemaNode[] getAttributeSet() {
        if (this._attributeSet == null) {
            this.initializeAttributeSet();
        }
        return this._attributeSet;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public SchemaNode[] getElementSet() {
        if (this._elementSet == null) {
            this.initializeElementSet();
        }
        return this._elementSet;
    }

    public String getQName() {
        if (this._qName == null) {
            this._qName = SchemaComplexTypeImpl.createQName(this._nameSpace, this.getName());
        }
        return this._qName;
    }

    public Object getParserXSDNode() {
        return this._node;
    }

    public void addRecursiveElement(SchemaNode element) {
        if (this._recursiveElements == null) {
            this._recursiveElements = new SchemaNode[0];
        }
        this.getElementSet();
        this._recursiveElements = (SchemaNode[])ArrayUtil.addToArray(SchemaNode.class, (Object[])this._recursiveElements, element);
    }

    public SchemaNode[] getRecursiveElements() {
        return this._recursiveElements;
    }

    public SchemaNode getChild(String name) {
        SchemaNode[] attribs = this.getAttributeSet();
        int aCount = attribs.length;
        for (int a = 0; a < aCount; ++a) {
            if (!attribs[a].getName().equals(name)) continue;
            return attribs[a];
        }
        SchemaNode[] elems = this.getElementSet();
        int eCount = elems.length;
        for (int e = 0; e < eCount; ++e) {
            if (!elems[e].getName().equals(name)) continue;
            return elems[e];
        }
        return null;
    }

    public SchemaSimpleType getSimpleContent() {
        return this._simpleContent;
    }

    public Type getType() {
        return this._type;
    }

    public boolean hasBeenAnalysed() {
        return this._type != null;
    }

    private void initialize(XSObject node) {
        if (node != null) {
            if (this.isGroup() || this.isAttributeGroup()) {
                this._isAbstract = false;
            } else if (!this.isSimple()) {
                if (node.getType() == 2) {
                    this._isAbstract = ((XSElementDeclaration)node).getAbstract();
                } else if (node.getType() == 3) {
                    XSComplexTypeDefinition complex = (XSComplexTypeDefinition)node;
                    this._isAbstract = complex.getAbstract();
                    if (complex.getDerivationMethod() == 1 || complex.getDerivationMethod() == 2) {
                        this._baseName = complex.getBaseType().getName();
                    }
                }
            }
            if (this.getName() == null) {
                if (node.getNamespace() != null && node.getNamespace().length() > 0) {
                    this.setName(node.getNamespace() + ":" + node.getName());
                } else {
                    this.setName(node.getName());
                }
            }
            if (!this.isSimple()) {
                if (!this.isGroup() && !this.isAttributeGroup() || this._isAbstract) {
                    // empty if block
                }
                if (this.isAbstract()) {
                    this._isChoice = true;
                } else if (this.isAttributeGroup()) {
                    this._isChoice = false;
                } else if (!this.isGroup()) {
                    XSParticle particle;
                    XSModelGroup group = null;
                    if (node.getType() == 3) {
                        particle = ((XSComplexTypeDefinition)this._node).getParticle();
                        if (particle != null && particle.getTerm().getType() == 7) {
                            group = (XSModelGroup)particle.getTerm();
                        }
                    } else {
                        group = (XSModelGroup)node;
                        this._isGroup = true;
                    }
                    if (group != null) {
                        boolean bl = this._isChoice = group.getCompositor() == 2;
                        if (this._isChoice && node.getType() == 3) {
                            particle = ((XSComplexTypeDefinition)this._node).getParticle();
                            if (particle != null) {
                                this._choiceMin = particle.getMinOccurs();
                                this._choiceMax = particle.getMaxOccurs();
                            }
                        } else if (this._isChoice && node.getType() == 7) {
                            this._choiceMin = this._schemaElement.getMinOccurs();
                            this._choiceMax = this._schemaElement.getMaxOccurs();
                        }
                    }
                }
            }
        }
        this._isAnonymous = this.getName().startsWith("UNNAMED");
    }

    public int getChoiceMinOccurs() {
        return this._choiceMin;
    }

    public int getChoiceMaxOccurs() {
        return this._choiceMax;
    }

    private void initializeAttributeSet() {
        if (this._node != null) {
            XSObjectList attributeList = null;
            if (this._node.getTypeCategory() == 15) {
                XSComplexTypeDefinition complexDecl = (XSComplexTypeDefinition)this._node;
                attributeList = complexDecl.getAttributeUses();
            }
            this.initAttributes(attributeList);
        } else if (this.isAttributeGroup()) {
            this.initAttributes(((XSAttributeGroupDefinition)this._schemaElement.getNode()).getAttributeUses());
        } else {
            this._attributeSet = new SchemaNodeImpl[0];
        }
    }

    private void initAttributes(XSObjectList attributeList) {
        if (attributeList == null) {
            this._attributeSet = new SchemaNode[0];
            return;
        }
        this._attributeSet = new SchemaNode[attributeList.getLength()];
        if (attributeList.getLength() > 0) {
            for (int i = 0; i < attributeList.getLength(); ++i) {
                XSAttributeUse use = (XSAttributeUse)attributeList.item(i);
                Integer minOccurs = new Integer(0);
                Integer maxOccurs = new Integer(1);
                if (use.getRequired()) {
                    minOccurs = new Integer(1);
                }
                String defaultValue = null;
                if (use.getConstraintType() == 1) {
                    defaultValue = use.getConstraintValue();
                    if (this.isSimple() && ((SchemaSimpleType)((Object)this)).isFloatingNumber()) {
                        defaultValue = TextTools.convertExponentialValue(defaultValue);
                    }
                }
                String fixedValue = null;
                if (use.getConstraintType() == 2) {
                    fixedValue = use.getConstraintValue();
                }
                this._attributeSet[i] = new SchemaNodeImpl((XSObject)use.getAttrDeclaration(), this._schema, minOccurs, maxOccurs, defaultValue, fixedValue, this.getSchemaElement());
            }
        }
    }

    private void initializeElementSet() {
        XSModelGroup group = this._unnamedNode;
        XSSimpleTypeDefinition mixedContentType = null;
        if (this.isAttributeGroup()) {
            this._elementSet = new SchemaNodeImpl[0];
        } else {
            if (group == null) {
                if (this._node.getTypeCategory() == 16) {
                    this._elementSet = new SchemaNode[0];
                } else {
                    XSParticle particle = ((XSComplexTypeDefinition)this._node).getParticle();
                    if (particle != null) {
                        if (particle.getMaxOccurs() != 1) {
                            this._elementSet = new SchemaNodeImpl[1];
                            this._elementSet[0] = new SchemaNodeImpl((XSObject)particle.getTerm(), this._schema, particle.getMinOccurs(), particle.getMaxOccurs(), 1, this.getSchemaElement());
                            this._isChoice = false;
                            if (((XSComplexTypeDefinition)this._node).getContentType() == 3) {
                                mixedContentType = new XSSimpleTypeDecl();
                            }
                        } else {
                            if (particle.getTerm() instanceof XSModelGroup) {
                                group = (XSModelGroup)particle.getTerm();
                            } else if (particle.getTerm() instanceof XSElementDeclaration) {
                                if (LogRegistry.getInstance().logWarnings()) {
                                    LogRegistry.getInstance().warn(this.getClass(), "unable to create ComplexTypeImpl for: " + this._node.getName());
                                }
                            } else if (particle.getTerm() instanceof XSWildcard && LogRegistry.getInstance().logWarnings()) {
                                LogRegistry.getInstance().warn(this.getClass(), "unable to create ComplexTypeImpl for: " + this._node.getName());
                            }
                            if (((XSComplexTypeDefinition)this._node).getContentType() == 3) {
                                mixedContentType = new XSSimpleTypeDecl();
                            }
                        }
                    } else {
                        XSComplexTypeDefinition xsdComplexType;
                        if (this._node.getTypeCategory() == 15 && (xsdComplexType = (XSComplexTypeDefinition)this._node).getAttributeUses().getLength() > 0 && xsdComplexType.getContentType() == 1) {
                            mixedContentType = xsdComplexType.getSimpleType();
                        }
                        this._elementSet = new SchemaNode[0];
                    }
                }
            }
            if (group != null) {
                SchemaParticleList list = this.checkForXSDGroups(group);
                this._elementSet = new SchemaNodeImpl[list.size()];
                if (list.size() > 0) {
                    Integer minOccurs = null;
                    Integer maxOccurs = null;
                    int unnamedCounter = 1;
                    for (int i = 0; i < list.size(); ++i) {
                        XSObject item = (XSObject)list.get(i);
                        XSTerm element = null;
                        if (item.getType() == 8) {
                            XSParticle itemParticle = (XSParticle)item;
                            minOccurs = new Integer(itemParticle.getMinOccurs());
                            maxOccurs = new Integer(itemParticle.getMaxOccurs());
                            XSTerm term = ((XSParticle)item).getTerm();
                            if (term.getType() == 2) {
                                element = term;
                            } else if (term.getType() == 9) {
                                element = term;
                            } else if (term.getType() == 7) {
                                element = term;
                            } else if (LogRegistry.getInstance().logWarnings()) {
                                LogRegistry.getInstance().warn(this.getClass(), "unable to handle composition: " + term.getName());
                            }
                        }
                        XSParticle holder = (XSParticle)list.getSchemaNode(i);
                        this._elementSet[i] = new SchemaNodeImpl((XSObject)element, this._schema, minOccurs, maxOccurs, unnamedCounter, null, null, this.getSchemaElement(), false, false);
                        if (holder != item) {
                            this._elementSet[i].setAnonymousGroupIndex(list.getAnonymousGroupIndex(i));
                            if (holder.getMinOccurs() == 0 && ((XSParticle)item).getMinOccurs() > 0) {
                                this._elementSet[i].markAsUnnamedOptionalParent();
                            }
                        }
                        if (this._elementSet[i].getName().startsWith("UNNAMED")) {
                            String groupRefName = list.getGroupRefName(item);
                            if (groupRefName != null) {
                                ((SchemaNodeImpl)this._elementSet[i]).setGroupRefName(groupRefName);
                            }
                            ++unnamedCounter;
                        }
                        ((SchemaNodeImpl)this._elementSet[i]).finalAnalyse();
                    }
                }
            }
            if (mixedContentType != null) {
                SchemaNode[] elementSet = new SchemaNode[this._elementSet.length + 1];
                for (int i = 0; i < this._elementSet.length; ++i) {
                    elementSet[i] = this._elementSet[i];
                }
                SchemaNodeImpl mixedElement = new SchemaNodeImpl((XSObject)mixedContentType, this._schema, 0, 1, this.getSchemaElement());
                mixedElement.getSchemaType().setIsSimpleContent(true);
                this._simpleContent = (SchemaSimpleType)mixedElement.getSchemaType();
                elementSet[this._elementSet.length] = mixedElement;
                this._elementSet = elementSet;
            }
        }
    }

    public boolean isAnonymous() {
        return this._isAnonymous;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    private boolean isAttributeGroup() {
        return this._isAttributeGroup;
    }

    public boolean isChoice() {
        return this._isChoice;
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isMixedContent() {
        return this._isSimpleContent;
    }

    public void setIsSimpleContent(boolean simpleContentFlag) {
        this._isSimpleContent = simpleContentFlag;
        if (this._schemaElement != null) {
            this._schemaElement.markAsOptional();
        }
    }

    public void setType(Type type) {
        this._type = type;
    }

    public String toString() {
        return this.getClass().getName() + "\n" + "Name: " + this.getQName() + "\n";
    }

    public void release() {
        this._type = null;
        this._simpleContent = null;
        this._node = null;
        this._unnamedNode = null;
        this._schema = null;
        this._schemaElement = null;
        this._elementSet = null;
        this._attributeSet = null;
    }

    public boolean isGlobal() {
        if (this._schemaElement != null) {
            if (this.getName() == null) {
                return false;
            }
            if (this._schemaElement.getSchema() != null && this._schemaElement.getSchema().getGlobalEntity(this.getSchemaElement()) != null) {
                return true;
            }
        }
        return false;
    }

    public int countSubNodes() {
        Stack nodeStack = new Stack();
        return this.countSubNodes(this, nodeStack);
    }

    private boolean checkForRecursion(Stack stack, SchemaTypeComparatorWrapper schemaTypewrapper) {
        return stack.contains(schemaTypewrapper);
    }

    private int countSubNodes(SchemaType schemaType, Stack nodeStack) {
        int currentNo = 0;
        SchemaTypeComparatorWrapper wrapper = new SchemaTypeComparatorWrapper(schemaType);
        if (this.checkForRecursion(nodeStack, wrapper)) {
            return currentNo;
        }
        nodeStack.push(wrapper);
        if (!schemaType.isSimple()) {
            SchemaComplexType complexType = (SchemaComplexType)schemaType;
            SchemaNode[] elementSet = complexType.getElementSet();
            currentNo += elementSet.length;
            for (int i = 0; i < elementSet.length; ++i) {
                SchemaType aSubSchemaType = elementSet[i].getSchemaType();
                currentNo += this.countSubNodes(aSubSchemaType, nodeStack);
            }
        }
        nodeStack.pop();
        return currentNo;
    }

    public SchemaNode getSchemaElement() {
        return this._schemaElement;
    }

    public boolean isEmptyComplexType() {
        if (this._node != null && this._node.getType() == 3) {
            XSComplexTypeDefinition complex = (XSComplexTypeDefinition)this._node;
            return complex.getContentType() == 0;
        }
        return false;
    }

    public boolean isRecursive() {
        return this._isRecursion;
    }

    public String[] getRecursiveElementNames() {
        if (this._recElementNames == null) {
            this._recElementNames = new String[0];
            SchemaNode[] recursiveElements = this.getRecursiveElements();
            if (recursiveElements != null) {
                for (int r = 0; r < recursiveElements.length; ++r) {
                    this._recElementNames = (String[])ArrayUtil.addToArray(class$java$lang$String == null ? SchemaComplexTypeImpl.class$("java.lang.String") : class$java$lang$String, (Object[])this._recElementNames, recursiveElements[r].getName());
                }
            }
        }
        return this._recElementNames;
    }

    public void setRecursive(boolean isRecursion) {
        this._isRecursion = isRecursion;
    }

    public String getNamespace() {
        return this._nameSpace;
    }

    public String getRefName() {
        return this.getSchemaElement().getRefName();
    }

    public static String createQName(String nameSpace, String name) {
        if (nameSpace != null && nameSpace.length() > 0) {
            return nameSpace + ":" + name;
        }
        return name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespacePrefix() {
        if (this.getNamespace() != null) {
            return ((XMLSchemaImpl)this.getSchemaElement().getSchema()).getNamespacePrefix(this.getNamespace());
        }
        return null;
    }
}

