/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.SchemaComplexTypeImpl;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import java.util.Hashtable;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class SchemaSimpleTypeImpl
extends SchemaComplexTypeImpl
implements SchemaSimpleType {
    private int _primitiveDataType = -1;
    private int _orgPrimitiveDataType;
    private String[] _choices;
    private long _minLength = -1L;
    private long _maxLength = -1L;
    private double _minInclValue = Double.NaN;
    private double _minExclValue = Double.NaN;
    private double _maxInclValue = Double.NaN;
    private double _maxExclValue = Double.NaN;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;
    private short _whitespace = (short)-1;
    private String _regularExpression;
    private boolean _isAnyType;

    public SchemaSimpleTypeImpl(XSTypeDefinition node, XMLSchema schema, SchemaNode element) {
        this(null, null, node, schema, element);
    }

    public SchemaSimpleTypeImpl(String nameSpace, String name, XSTypeDefinition node, XMLSchema schema, SchemaNode element) {
        super(nameSpace, name, node, schema, element);
        this.initialize(node);
    }

    public String getBaseName() {
        return "";
    }

    public String[] getChoices() {
        return this._choices;
    }

    public int getPrimitiveDataType() {
        if (this._primitiveDataType == -1) {
            this.initializePrimitiveDataType();
        }
        return this._primitiveDataType;
    }

    private void initializePrimitiveDataType() {
        this._primitiveDataType = this._orgPrimitiveDataType;
    }

    private void initialize(XSTypeDefinition node) {
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)node;
        this._orgPrimitiveDataType = simpleType.getBuiltInKind();
        this.initializeChoices();
        this.initializeRegularExpression();
        this.initAnyType();
        this.initDefaultFacets();
    }

    private void initializeChoices() {
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)this._node;
        if (simpleType.isDefinedFacet((short)2048)) {
            XSObjectList list = simpleType.getMultiValueFacets();
            for (int i = 0; i < list.getLength(); ++i) {
                XSMultiValueFacet facet = (XSMultiValueFacet)list.item(i);
                if (facet.getFacetKind() != 2048) continue;
                StringList values = facet.getLexicalFacetValues();
                this._choices = new String[values.getLength()];
                for (int j = 0; j < values.getLength(); ++j) {
                    this._choices[j] = values.item(j);
                }
            }
        }
    }

    private void initializeRegularExpression() {
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)this._node;
        if (simpleType.isDefinedFacet((short)8)) {
            XSObjectList list = simpleType.getMultiValueFacets();
            for (int i = 0; i < list.getLength(); ++i) {
                StringList values;
                XSMultiValueFacet facet = (XSMultiValueFacet)list.item(i);
                if (facet.getFacetKind() != 8 || (values = facet.getLexicalFacetValues()).getLength() <= 0) continue;
                this._regularExpression = values.item(0);
            }
        }
    }

    public boolean isAttribute() {
        return this._node.getType() == 1;
    }

    public boolean isChoice() {
        return this._choices != null && this.getChoices().length > 0;
    }

    public boolean isGroup() {
        return false;
    }

    public boolean isSimple() {
        return true;
    }

    public void validate(SimpleType source, String value) throws ValidationException {
        try {
            if (source.getActAsDataType() != null) {
                XSObject node = XMLSchemaImpl.getGlobalXSDInternalTypes(source.getActAsDataType());
                if (node != null) {
                    ((XSSimpleTypeDecl)node).validate(value, null, null);
                }
            } else if (this._node != null && this._node.getBaseType() != null) {
                ((XSSimpleTypeDecl)this._node).validate(value, null, null);
            }
        }
        catch (Exception e) {
            throw new ValidationException((Type)source, e, "error");
        }
    }

    public boolean hasRegularExpression() {
        return this._regularExpression != null;
    }

    private long getFacetLongValueFor(String value) {
        if (value != null && StringUtil.isNumeric(value)) {
            return Long.parseLong(value);
        }
        return -1L;
    }

    private int getFacetIntValueFor(String value) {
        if (value != null && StringUtil.isNumeric(value)) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private double getFacetDoubleValueFor(String value) {
        if (value != null && StringUtil.isNumeric(value)) {
            return Double.parseDouble(value);
        }
        return Double.NaN;
    }

    private void initFacetMinLength(XSFacet facet, String value) {
        this._minLength = this.getFacetLongValueFor(value);
    }

    private void initFacetLength(XSFacet facet, String value) {
        this._minLength = this.getFacetLongValueFor(value);
        if (!this.isNumber()) {
            this._maxLength = this.getFacetLongValueFor(value);
        }
    }

    private void initFacetMaxLength(XSFacet facet, String value) {
        this._maxLength = this.getFacetLongValueFor(value);
    }

    public long getMaxLength() {
        return this._maxLength;
    }

    public long getMinLength() {
        return this._maxLength;
    }

    private void initDefaultFacets() {
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)this._node;
        XSObjectList list = simpleType.getFacets();
        if (list != null) {
            int fcount = list.getLength();
            block12: for (int i = 0; i < fcount; ++i) {
                XSFacet facet = (XSFacet)list.item(i);
                String value = facet.getLexicalFacetValue();
                if (value == null) continue;
                switch (facet.getFacetKind()) {
                    case 16: {
                        this.initFacetWhitespace(facet, value);
                        continue block12;
                    }
                    case 1: {
                        this.initFacetLength(facet, value);
                        continue block12;
                    }
                    case 4: {
                        this.initFacetMaxLength(facet, value);
                        continue block12;
                    }
                    case 2: {
                        this.initFacetMinLength(facet, value);
                        continue block12;
                    }
                    case 32: {
                        this._maxInclValue = this.getFacetDoubleValueFor(value);
                        continue block12;
                    }
                    case 64: {
                        this._maxExclValue = this.getFacetDoubleValueFor(value);
                        continue block12;
                    }
                    case 256: {
                        this._minInclValue = this.getFacetDoubleValueFor(value);
                        continue block12;
                    }
                    case 128: {
                        this._minExclValue = this.getFacetDoubleValueFor(value);
                        continue block12;
                    }
                    case 512: {
                        this._totalDigits = this.getFacetIntValueFor(value);
                        continue block12;
                    }
                    case 1024: {
                        this._fractionDigits = this.getFacetIntValueFor(value);
                    }
                }
            }
        }
    }

    private void initFacetWhitespace(XSFacet facet, String value) {
        if ("collapse".equalsIgnoreCase(value)) {
            this._whitespace = (short)2;
        } else if ("preserve".equalsIgnoreCase(value)) {
            this._whitespace = 0;
        } else if ("replace".equalsIgnoreCase(value)) {
            this._whitespace = 1;
        }
    }

    public boolean isNumber() {
        int dataType = this.getPrimitiveDataType();
        switch (dataType) {
            case 4: 
            case 5: 
            case 6: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatingNumber() {
        int dataType = this.getPrimitiveDataType();
        switch (dataType) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloat() {
        return this.getPrimitiveDataType() == 5;
    }

    public boolean isDouble() {
        return this.getPrimitiveDataType() == 6;
    }

    public boolean isDate() {
        return this.getPrimitiveDataType() == 10;
    }

    public boolean isDateTime() {
        return this.getPrimitiveDataType() == 8;
    }

    public boolean isDuration() {
        return this.getPrimitiveDataType() == 7;
    }

    public boolean isString() {
        if (this.getPrimitiveDataType() == 0) {
            return true;
        }
        return this.getPrimitiveDataType() == 2 || this.getPrimitiveDataType() == 25;
    }

    public boolean isID() {
        return this.getPrimitiveDataType() == 27;
    }

    public boolean isTime() {
        return this.getPrimitiveDataType() == 9;
    }

    public boolean isAnyType() {
        return this._isAnyType;
    }

    private void initAnyType() {
        XSWildcardDecl wc;
        short constraint;
        this._isAnyType = false;
        if (this._schemaElement.getNode().getType() == 9 && 1 == (constraint = (wc = (XSWildcardDecl)this._schemaElement.getNode()).getConstraintType())) {
            this._isAnyType = true;
        }
    }

    public boolean isBoolean() {
        return this.getPrimitiveDataType() == 3;
    }

    public String getRegularExpression() {
        return this._regularExpression;
    }

    public double getMaxInclValue() {
        return this._maxInclValue;
    }

    public double getMaxExclValue() {
        return this._maxExclValue;
    }

    public double getMinInclValue() {
        return this._minInclValue;
    }

    public int getFractionDigits() {
        return this._fractionDigits;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public short getWhitespace() {
        return this._whitespace;
    }

    public double getMinExclValue() {
        return this._minExclValue;
    }

    public Hashtable getEnumerationAnnotation(String enumeration) {
        if (this._node != null && this._node instanceof XSSimpleTypeDecl) {
            XSSimpleTypeDecl stDecl = (XSSimpleTypeDecl)this._node;
            XSObjectList list = stDecl.enumerationAnnotations;
            XSObject object = null;
            for (int i = 0; i < list.getLength(); ++i) {
                String enumName;
                object = list.item(i);
                if (object == null || (enumName = this.getChoices()[i]) == null || !enumName.equals(enumeration)) continue;
                try {
                    return DOMHelper.extractAnnotation((XSAnnotation)object);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void setMinLength(long minLength) {
        this._minLength = minLength;
    }

    public void setMaxLength(long maxLength) {
        this._maxLength = maxLength;
    }

    public void setMinInclValue(double minInclValue) {
        this._minInclValue = minInclValue;
    }

    public void setMinExclValue(double minExclValue) {
        this._minExclValue = minExclValue;
    }

    public void setMaxInclValue(double maxInclValue) {
        this._maxInclValue = maxInclValue;
    }

    public void setMaxExclValue(double maxExclValue) {
        this._maxExclValue = maxExclValue;
    }

    public void setTotalDigits(int totalDigits) {
        this._totalDigits = totalDigits;
    }

    public void setFractionDigits(int fractionDigits) {
        this._fractionDigits = fractionDigits;
    }

    public void setWhitespace(short whitespace) {
        this._whitespace = whitespace;
    }

    public void setRegularExpression(String regularExpression) {
        this._regularExpression = regularExpression;
    }
}

