/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.error.ConditionalError;
import com.jaxfront.core.error.Error;
import com.jaxfront.core.error.UserError;
import com.jaxfront.core.error.ValidationError;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.type.ValidationChangeEvent;
import com.jaxfront.core.type.ValidationChangeEventMulticaster;
import com.jaxfront.core.type.ValidationChangeListener;
import com.jaxfront.core.util.sort.FastQSort;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ErrorController {
    protected transient ValidationChangeListener aValidationChangeListener;
    private Hashtable _errors;
    private Hashtable _errorsDelegate;
    private Hashtable _unhandledValidationExceptions;
    private boolean _blocked = false;
    private TypeController _controller;

    public ErrorController(TypeController controller) {
        this._controller = controller;
    }

    public void addError(Error error) {
        this.addError(error, true);
    }

    public void addValidationChangeListener(ValidationChangeListener newListener) {
        this.aValidationChangeListener = ValidationChangeEventMulticaster.add(this.aValidationChangeListener, newListener);
    }

    public void addError(Error error, boolean shouldFireEvent) {
        if (!this._blocked) {
            if (this.putError(error) && error.shouldMarkError()) {
                error.markError();
            }
            if (shouldFireEvent) {
                this.fireValidationChanged(ValidationChangeEvent.exceptionOccured(error));
            }
        }
    }

    private boolean putError(Error aError) {
        Vector<Error> errors = null;
        errors = (Vector<Error>)this.getErrors().get(aError.getErrorHolder());
        if (errors == null) {
            errors = new Vector<Error>();
            this.getErrors().put(aError.getErrorHolder(), errors);
        }
        if (!errors.contains(aError)) {
            errors.add(aError);
            return true;
        }
        return false;
    }

    public void removeMandatoryAndCardinalityValidationErrors() {
        this.removeMandatoryAndCardinalityValidationErrors(null);
    }

    public void removeMandatoryAndCardinalityValidationErrors(Type type) {
        Enumeration errors = this.getErrors().elements();
        while (errors.hasMoreElements()) {
            Vector typeErrorList = (Vector)errors.nextElement();
            for (int i = 0; i < typeErrorList.size(); ++i) {
                Error error = (Error)typeErrorList.get(i);
                if (!error.isMandatoryError() && !error.isCardinalityError()) continue;
                if (type == null) {
                    this.removeError(error, false);
                    continue;
                }
                if (error.getErrorHolder() != type) continue;
                this.removeError(error, false);
            }
        }
    }

    protected void fireValidationChanged(ValidationChangeEvent event) {
        if (this.aValidationChangeListener == null) {
            return;
        }
        this.aValidationChangeListener.validationChanged(event);
    }

    public Vector getErrorsForType(Type source) {
        return (Vector)this.getErrors().get(source);
    }

    public Vector getErrorsForType(Type source, int errorType) {
        Vector typeErrors = this.getErrorsForType(source);
        Vector<Error> result = new Vector<Error>();
        if (typeErrors != null) {
            for (int i = 0; i < typeErrors.size(); ++i) {
                Error aTypeError = (Error)typeErrors.get(i);
                if (aTypeError.getErrorType() != errorType) continue;
                result.add(aTypeError);
            }
        }
        return result;
    }

    public Hashtable getErrors() {
        if (this._errorsDelegate != null) {
            return this._errorsDelegate;
        }
        if (this._errors == null) {
            this._errors = new Hashtable();
        }
        return this._errors;
    }

    public Vector getErrorsForClassification(String errorClassification) {
        Vector<Error> classifiedErrors = null;
        if (errorClassification != null && errorClassification.length() > 0) {
            Hashtable validationErrors = this.getErrors();
            Enumeration errors = validationErrors.elements();
            while (errors.hasMoreElements()) {
                String classification;
                Error validationError = (Error)errors.nextElement();
                if (validationError == null || (classification = validationError.getClassification()) == null || !classification.equals(errorClassification)) continue;
                if (classifiedErrors == null) {
                    classifiedErrors = new Vector<Error>();
                }
                classifiedErrors.add(validationError);
            }
        }
        return classifiedErrors;
    }

    public boolean hasPageErrors(Type type, boolean validate) {
        return type.getDOM().validatePageErrors(type, type.getStyle().getSelectedTabIdx(), validate).size() > 0;
    }

    public boolean hasValidationErrors() {
        return this.getErrors().size() > 0;
    }

    public void release() {
        if (this._errors != null) {
            this._errors.clear();
            this._errors = null;
        }
        if (this._errorsDelegate != null) {
            this._errorsDelegate.clear();
            this._errorsDelegate = null;
        }
        this._unhandledValidationExceptions = null;
    }

    public void setErrorsDelegate(Hashtable delegate) {
        this._errorsDelegate = delegate;
    }

    public void removeAllErrors(boolean fireEvent) {
        Enumeration errorKeys = this.getErrors().keys();
        while (errorKeys.hasMoreElements()) {
            Object errorKey = errorKeys.nextElement();
            Enumeration errors = ((Vector)this.getErrors().get(errorKey)).elements();
            while (errors.hasMoreElements()) {
                Error aError = (Error)errors.nextElement();
                this.removeError(aError, fireEvent);
            }
        }
    }

    public void removeErrors(List errors) {
        Iterator errIt = errors.iterator();
        while (errIt.hasNext()) {
            this.removeError((Error)errIt.next());
        }
    }

    public void removeErrors(List errors, boolean fireEvent) {
        Iterator errIt = errors.iterator();
        while (errIt.hasNext()) {
            this.removeError((Error)errIt.next(), fireEvent);
        }
    }

    public void removeValidationChangeListener(ValidationChangeListener newListener) {
        EventListener listener = ValidationChangeEventMulticaster.remove(this.aValidationChangeListener, newListener);
        this.aValidationChangeListener = (ValidationChangeListener)listener;
    }

    public void removeError(Error error) {
        if (this.getErrors().size() > 0) {
            this.removeError(error, true);
        }
    }

    public void removeConditionalError(Rule rule, ConditionExpression condition, Type sourceType) {
        if (this.getErrors().size() > 0) {
            this.removeError(new ConditionalError(rule, condition, sourceType), true);
        }
    }

    public void removeUserError(Object identifierObject, Type sourceType) {
        if (this.getErrors().size() > 0) {
            this.removeError(new UserError(identifierObject, sourceType), true);
        }
    }

    public void removeValidationError(Type sourceType) {
        if (this.getErrors().size() > 0) {
            this.removeError(new ValidationError(null, sourceType), true);
        }
    }

    public void removeError(Error error, boolean shouldFireEvent) {
        int typeErrorCount = 0;
        Vector errors = this.getErrorsForType(error.getErrorHolder());
        if (errors != null) {
            for (int i = errors.size() - 1; i >= 0; --i) {
                Error aError = (Error)errors.get(i);
                if (!this.getController().getDom().isPasteMode() && !aError.equals(error)) continue;
                errors.remove(i);
            }
            Enumeration registeredErrors = errors.elements();
            while (registeredErrors.hasMoreElements()) {
                Error element = (Error)registeredErrors.nextElement();
                if (element.getErrorHolder() != error.getErrorHolder()) continue;
                ++typeErrorCount;
            }
            if (typeErrorCount == 0) {
                this.getErrors().remove(error.getErrorHolder());
                error.resetError();
            }
            if (shouldFireEvent) {
                this.fireValidationChanged(ValidationChangeEvent.exceptionResolved(error));
            }
        }
    }

    public void removeError(Type errorHolder) {
        Vector errors = this.getErrorsForType(errorHolder);
        if (errors != null) {
            for (int i = errors.size() - 1; i >= 0; --i) {
                Error aError = (Error)errors.get(i);
                aError.release();
            }
            this.getErrors().remove(errorHolder);
        }
    }

    public void maintainErrors(Type removedType) {
        Enumeration allErrors = this.getErrors().elements();
        Error error = null;
        Type source = null;
        while (allErrors.hasMoreElements()) {
            Vector errors = (Vector)allErrors.nextElement();
            for (int e = 0; e < errors.size(); ++e) {
                error = (Error)errors.get(e);
                Type errorRaiser = error.getRaiser();
                source = error.getErrorHolder();
                if (source == removedType || source.isDerivedFrom(removedType)) {
                    this.removeError(error, true);
                    continue;
                }
                if (errorRaiser == null || removedType == null || errorRaiser != removedType) continue;
                this.removeError(error, true);
            }
        }
        Iterator iterator = this._controller.getRules().values().iterator();
        Vector<Rule> rulesToRemove = new Vector<Rule>();
        if (source != null) {
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                if (rule.getSource() == null) {
                    rulesToRemove.add(rule);
                    continue;
                }
                if (rule.getSource() != removedType && !rule.getSource().isDerivedFrom(removedType)) continue;
                rulesToRemove.add(rule);
                if (rule.getCondition() == null) continue;
                this.removeConditionalError(rule, rule.getCondition(), removedType);
            }
        }
    }

    public TypeController getController() {
        return this._controller;
    }

    private void createAndFireValidationError(Type type, ValidationException exception) {
        if (type != null && exception != null) {
            ValidationError validationError = new ValidationError(exception, type);
            this.addError(validationError);
        }
    }

    public void fireUnhandledValidationExceptions() {
        if (this._unhandledValidationExceptions != null) {
            Enumeration unhandErr = this.getUnhandledValidationExceptions().keys();
            while (unhandErr.hasMoreElements()) {
                Type type = (Type)unhandErr.nextElement();
                ValidationException valEx = (ValidationException)this.getUnhandledValidationExceptions().get(type);
                this.createAndFireValidationError(type, valEx);
            }
        }
    }

    private Hashtable getUnhandledValidationExceptions() {
        if (this._unhandledValidationExceptions == null) {
            this._unhandledValidationExceptions = new Hashtable();
        }
        return this._unhandledValidationExceptions;
    }

    public void handleValidationException(Type type, ValidationException exception) {
        if (type != null && exception != null) {
            if (type.getDOM().isBinding()) {
                this.getUnhandledValidationExceptions().put(type, exception);
            } else {
                this.createAndFireValidationError(type, exception);
            }
        }
    }

    public Collection getAllErrors() {
        Vector list = new Vector();
        if (this.hasValidationErrors()) {
            Enumeration typeErrors = this.getErrors().elements();
            while (typeErrors.hasMoreElements()) {
                Vector errors = (Vector)typeErrors.nextElement();
                list.addAll(errors);
            }
        }
        return list;
    }

    public Collection getOptimizedErrors() {
        Vector<Error> list = new Vector<Error>();
        if (this.hasValidationErrors()) {
            Enumeration typeErrors = this.getErrors().elements();
            while (typeErrors.hasMoreElements()) {
                Vector errors = (Vector)typeErrors.nextElement();
                if (errors.size() > 1) {
                    for (int e = 0; e < errors.size(); ++e) {
                        Error aError = (Error)errors.get(e);
                        if (aError.isXSDError()) continue;
                        list.add(aError);
                    }
                    continue;
                }
                list.addAll(errors);
            }
        }
        return list;
    }

    public Collection getAllErrors(int errorType) {
        return this.getAllErrors(this.getErrors(), errorType);
    }

    public Collection getAllErrors(Hashtable errorMap, int errorType) {
        Vector<Error> list = new Vector<Error>();
        if (this.hasValidationErrors()) {
            Enumeration typeErrors = errorMap.elements();
            while (typeErrors.hasMoreElements()) {
                Vector errors = (Vector)typeErrors.nextElement();
                for (int e = 0; e < errors.size(); ++e) {
                    Error aError = (Error)errors.get(e);
                    if (errorType != -1 && aError.getErrorType() != errorType) continue;
                    list.add(aError);
                }
            }
        }
        return list;
    }

    public Collection getAllErrors(Comparator comparator) {
        Vector errorList = new Vector(this.getAllErrors());
        FastQSort sort = new FastQSort();
        try {
            sort.sort(errorList, comparator);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e.getMessage());
        }
        return errorList;
    }

    public Collection getOptimizedErrors(Comparator comparator) {
        Vector errorList = new Vector(this.getOptimizedErrors());
        FastQSort sort = new FastQSort();
        try {
            sort.sort(errorList, comparator);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e.getMessage());
        }
        return errorList;
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }

    public boolean isBlocked() {
        return this._blocked;
    }
}

