/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.DirtyChangeEvent;
import com.jaxfront.core.dom.DirtyChangeListener;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontPropertyChangeEvent;
import com.jaxfront.core.dom.LogEntry;
import com.jaxfront.core.dom.LoggingListener;
import com.jaxfront.core.error.Error;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.rule.RulePrioritySorter;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.ErrorController;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.type.ValidationChangeEvent;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.XUIDefinition;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.nfunk.jep.FunctionViewerFactory;

public class TypeController
implements PropertyChangeListener,
DOMChangeListener {
    private transient boolean _debug = false;
    public static final String TEMPORARY_PROPERTYCHANGE = "propertyChange_temporary";
    public static final String PROPERTYCHANGE = "propertyChange";
    public static final String XUI_INITIALIZED = "xuiInitialized";
    public static final String SERIALIZABLE_CHANGED = "serializableChanged";
    private TreeMap _rules;
    private transient List _loggedChanges;
    private Hashtable _indeterminateXPaths;
    private PropertyChangeSupport _propertyChangeSupport;
    private MathEvaluator mathEvaluator;
    private transient Hashtable _loggingListeners;
    private Document _dom;
    private boolean _hasChanged = false;
    private boolean _isPerformingSerializationChange;
    private ErrorController _errorController;
    protected transient Vector _dirtyListeners;
    private boolean _blockDirtyChange;
    private boolean _changeWhileBlocking;

    public TypeController(Document dom) {
        this._dom = dom;
        this.init();
    }

    public void addIndeterminateXPath(Type source, String xpath, Type xuiType) {
        XUIDefinition xuiDefinition = new XUIDefinition(source, xuiType, false, true);
        this.getIndeterminateXPaths().put(xpath, xuiDefinition);
    }

    private Hashtable getIndeterminateXPaths() {
        if (this._indeterminateXPaths == null) {
            this._indeterminateXPaths = new Hashtable();
        }
        return this._indeterminateXPaths;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public Rule addRule(Rule rule) {
        this.getRules().put(rule, rule);
        return rule;
    }

    public List getRules(Type source, boolean initializationRulesOnly) {
        Iterator iterator = ((TreeMap)this.getRules().clone()).values().iterator();
        Vector<Rule> foundRules = new Vector<Rule>();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.getSource() != source) continue;
            if (initializationRulesOnly) {
                if (!rule.isVisualizerInitializationRule()) continue;
                foundRules.add(rule);
                continue;
            }
            foundRules.add(rule);
        }
        return foundRules;
    }

    public List getRules(Type source, boolean initializationRulesOnly, boolean inclDerived) {
        Iterator iterator = ((TreeMap)this.getRules().clone()).values().iterator();
        Vector<Rule> foundRules = new Vector<Rule>();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.getSource() != source && !rule.getSource().isDerivedFrom(source)) continue;
            if (initializationRulesOnly) {
                if (!rule.isVisualizerInitializationRule()) continue;
                foundRules.add(rule);
                continue;
            }
            foundRules.add(rule);
        }
        return foundRules;
    }

    public Rule getRule(FormulaExpression formula) {
        if (formula != null) {
            Iterator iterator = ((TreeMap)this.getRules().clone()).values().iterator();
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                if (rule.getCondition().getFormulaExpression() != formula) continue;
                return rule;
            }
        }
        return null;
    }

    public Rule getRule(String id) {
        Iterator iterator = ((TreeMap)this.getRules().clone()).values().iterator();
        while (id != null && iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!id.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public void fireDOMValidated(Document dom) {
        this.getErrorController().fireValidationChanged(ValidationChangeEvent.domValidated(dom));
    }

    private void applyFormulas() {
        if (!this.getDom().isBinding() && this.getDom().isXUIInitialized()) {
            Vector formulas = new Vector(this.getDom().getFormulas().values());
            for (int f = 0; f < formulas.size(); ++f) {
                FormulaExpression formula = (FormulaExpression)formulas.get(f);
                try {
                    if (formula.getSource() == null || formula.getSource().isReleased()) continue;
                    formula.evaluate();
                    continue;
                }
                catch (FormulaException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void checkLoggingInfos(Type source, String oldValue, DOMChangeEvent event) {
        if (event != null && event.isFingerprintChanged() && !"STATUS".equals(event.getChangeName())) {
            return;
        }
        if (this.getLoggingListeners().size() > 0) {
            Enumeration logis = this.getLoggingListeners().elements();
            while (logis.hasMoreElements()) {
                LoggingListener log = (LoggingListener)logis.nextElement();
                log.apply(source, event, oldValue);
            }
        }
    }

    private void checkLoggingInfos(Type source, String oldValue, PropertyChangeEvent event) {
        Enumeration logis = this.getLoggingListeners().elements();
        while (logis.hasMoreElements()) {
            LoggingListener log = (LoggingListener)logis.nextElement();
            log.apply(source, event, oldValue);
        }
    }

    public void applySaveRules(boolean isRunningOnServer) {
        this.applySaveRules(null, isRunningOnServer);
    }

    public void applySaveRules(Object event, boolean isRunningOnServer) {
        Vector rules = new Vector(this.getRules().values());
        for (int r = 0; r < rules.size(); ++r) {
            Rule rule = (Rule)rules.get(r);
            if (rule.isReleased()) {
                this.removeRule(rule);
                continue;
            }
            if (rule.getSource().hasUnChoosenChoiceParent() || !rule.isSaveDocumentRule()) continue;
            rule.apply(this.getDom().getRootType(), event, isRunningOnServer);
        }
    }

    private void applyRules(Type sourceType, DOMChangeEvent event, Stack callStack) {
        long start = System.currentTimeMillis();
        Vector rules = new Vector(this.getRules().values());
        block10: for (int r = 0; r < rules.size(); ++r) {
            Rule rule = (Rule)rules.get(r);
            if (rule.isReleased()) {
                this.removeRule(rule);
                continue;
            }
            switch ((int)event.getType()) {
                case 32768: {
                    if (!rule.isDomInitialized()) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 16: {
                    if (!rule.isVisualizerInitializationRule() && !rule.isChangeAndInitializationRule() || rule.getSource() != sourceType) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 262144: {
                    if (!rule.isOnCreationRule() || !rule.doesConcern(sourceType)) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 524288: {
                    if (!rule.isCopyContentRule() || !rule.doesConcern(sourceType)) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 0x100000: {
                    if (!rule.isPasteContentRule() || !rule.doesConcern(sourceType)) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 1: {
                    if (!rule.isSaveDocumentRule()) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 8192: {
                    if (!rule.isSaveDocumentRule()) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                case 0x200000: {
                    if (!rule.isDomDeletedRule()) continue block10;
                    rule.apply(sourceType, event);
                    continue block10;
                }
                default: {
                    if (rule.isChangeRule()) {
                        if (!rule.doesConcern(sourceType)) continue block10;
                        rule.apply(sourceType, event);
                        continue block10;
                    }
                    if (event.isNullEvent()) {
                        if (!rule.isChangeAndInitializationRule() && !rule.isPropertyChangeRule() || !rule.doesConcern(sourceType)) continue block10;
                        rule.apply(sourceType, event, false, callStack);
                        continue block10;
                    }
                    if ((rule.isStructureChangeRule() || rule.isChangeAndInitializationRule()) && rule.doesConcern(sourceType)) {
                        rule.apply(sourceType, event);
                        continue block10;
                    }
                    if (rule.isStructureChangeAddRule() && event.isAddingNode()) {
                        if (sourceType.isEmpty() && sourceType.getParent() != null) {
                            sourceType = sourceType.getParent();
                        }
                        if (rule.getCondition() != null && rule.getCondition().getFormulaExpression() != null) {
                            rule.getCondition().getFormulaExpression().setReferencedExpressionNodes(null);
                        }
                        if (!rule.doesConcern(sourceType)) continue block10;
                        rule.apply(sourceType, event);
                        continue block10;
                    }
                    if (!rule.isStructureChangeRemoveRule() || !event.isRemovingNode()) continue block10;
                    if (sourceType.isEmpty() && sourceType.getParent() != null) {
                        sourceType = sourceType.getParent();
                    }
                    if (!rule.doesConcern(sourceType)) continue block10;
                    rule.apply(sourceType, event);
                }
            }
        }
        long stop = System.currentTimeMillis();
    }

    private void checkRemoveRule(Rule rule) {
        int rType = (int)rule.getRuleType();
        switch (rType) {
            case 1: 
            case 128: 
            case 2048: {
                this.removeRule(rule);
                break;
            }
        }
    }

    public void domChanged(DOMChangeEvent event, Stack callStack) {
        if (this.getDom().isImmutable() || this.getDom().isRuleEngineBlocked()) {
            return;
        }
        Type eventSource = null;
        if (event.getSource() == this.getDom()) {
            eventSource = ((Document)event.getSource()).getRootType();
        } else if (event.getSource() instanceof Type) {
            eventSource = (Type)event.getSource();
        }
        Vector rules = new Vector(this.getRules().values());
        Rule rule = null;
        switch ((int)event.getType()) {
            case 512: 
            case 1024: {
                this.hasChanged(true);
                break;
            }
            case 4096: {
                this.hasChanged(true);
                if (!eventSource.isEmpty()) {
                    this.checkIndeterminateXPaths(eventSource);
                }
                if (!eventSource.isEmpty() && eventSource.getParent().isChoice()) {
                    eventSource = eventSource.getParent();
                }
                this.applyRules(eventSource, event, callStack);
                block28: for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (rule.isReleased()) {
                        this.removeRule(rule);
                        continue;
                    }
                    if (rule.getSource().isAttribute() || eventSource == rule.getSource().getParent()) continue;
                    switch ((int)rule.getRuleType()) {
                        case 1: 
                        case 32: 
                        case 256: 
                        case 512: 
                        case 1024: 
                        case 4096: 
                        case 8192: 
                        case 0x800000: 
                        case 0x1000000: {
                            continue block28;
                        }
                        default: {
                            if (!rule.getSource().isDerivedFromEditingType() && !rule.getSource().isDerivedFrom(eventSource)) continue block28;
                        }
                    }
                }
                if (!eventSource.isEmpty() && !event.isTemporary()) {
                    this.checkSubTreeForErrorValues(eventSource);
                    this.checkLoggingInfos(eventSource, null, event);
                }
                this.applyFormulas();
                break;
            }
            case 2: {
                this.hasChanged(true);
                this.maintainLoggedChanges(eventSource, event);
                this.getErrorController().maintainErrors(eventSource);
                if (!eventSource.isEmpty() && eventSource.getParent().isChoice()) {
                    eventSource = eventSource.getParent();
                } else {
                    this.applyRules(eventSource, event, callStack);
                }
                this.applyFormulas();
                break;
            }
            case 16: {
                this.applyRules(eventSource, event, callStack);
                break;
            }
            case 2048: {
                if (!eventSource.isRoot()) break;
                this.applyRules(eventSource, event, callStack);
                break;
            }
            case 32768: {
                this.applyRules(eventSource, event, callStack);
                break;
            }
            case 1: {
                this.hasChanged(false);
                this.getDom().setRuleEngineBlocked(true);
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isSaveDocumentRule()) continue;
                    rule.apply(eventSource, event);
                }
                this.getDom().setRuleEngineBlocked(false);
                break;
            }
            case 4: {
                this.hasChanged(false);
                this.getDom().setRuleEngineBlocked(true);
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isSaveDocumentRule()) continue;
                    rule.apply(eventSource, event, false, callStack);
                }
                this.getDom().setRuleEngineBlocked(false);
                break;
            }
            case 8192: {
                this.getDom()._lastDomUpdateTime = -1L;
                this.getDom().setRuleEngineBlocked(true);
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isPersistentRule()) continue;
                    rule.apply(eventSource, event);
                }
                this.getDom().setRuleEngineBlocked(false);
                break;
            }
            case 65536: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isListItemSelectedRule() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event, false, callStack);
                }
                break;
            }
            case 131072: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isListItemDeselectedRule() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x800000: {
                this.getDom()._lastDomUpdateTime = -1L;
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isGoNext() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x1000000: {
                this.getDom()._lastDomUpdateTime = -1L;
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isAboutGoNext() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x20000000: {
                this.getDom()._lastDomUpdateTime = -1L;
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isGoPrevious() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x40000000: {
                this.getDom()._lastDomUpdateTime = -1L;
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isAboutGoPrevious() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x2000000: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isPageSelected() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 262144: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isOnCreationRule() || rule.getSource() != eventSource) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 524288: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isCopyContentRule() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x100000: {
                this.hasChanged(true);
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isPasteContentRule() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x200000: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isDomDeletedRule()) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 16384: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isAboutToPersistRule()) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 0x8000000: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isTypeCommit() || !rule.doesConcern(eventSource)) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
            case 8: {
                for (int r = 0; r < rules.size(); ++r) {
                    rule = (Rule)rules.get(r);
                    if (!rule.isAboutToValidateRule()) continue;
                    rule.apply(eventSource, event);
                }
                break;
            }
        }
        if (event.isPersistent() || event.isFingerprintChanged() && this.getDom().isHistoryMode() && !eventSource.isEmpty() && !event.isTemporary()) {
            this.checkLoggingInfos(eventSource, null, event);
        }
    }

    private void checkIndeterminateXPaths(Type source) {
        boolean wasXuiCached = source.getDOM().isXPathCached();
        source.getDOM().setXPathCached(true);
        Enumeration iixpaths = this.getIndeterminateXPaths().keys();
        boolean doCheck = false;
        while (iixpaths.hasMoreElements()) {
            String xpath = (String)iixpaths.nextElement();
            XUIDefinition xuiDefinition = (XUIDefinition)this.getIndeterminateXPaths().get(xpath);
            int index = xpath.indexOf("//");
            if (index != -1) {
                String startXPath = xpath.substring(0, xpath.indexOf("//"));
                String currentXPath = TypePathExecuter.getRelativeXPathLocation(source.getXPathLocation());
                if (currentXPath.startsWith(startXPath)) {
                    doCheck = true;
                }
            } else if (source.getParent().isChoice()) {
                doCheck = true;
            }
            if (!doCheck) continue;
            List types = TypePathExecuter.getInstance().processXPath(source.getDOM().getRootType(), xpath, true);
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                if (type.getXUIDefinition().hasBeenInitializedFromFile()) continue;
                type.getXUIDefinition().reinitialize(xuiDefinition);
            }
        }
        if (!wasXuiCached) {
            source.getDOM().setXPathCached(false);
        }
    }

    public MathEvaluator getMathEvaluator() {
        if (this.mathEvaluator == null) {
            this.mathEvaluator = new MathEvaluator(this.getDom().getApplicationProperties());
            this.mathEvaluator.setVariable("XUI_LANGUAGE", this.getDom().getLanguage());
        }
        return this.mathEvaluator;
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this._propertyChangeSupport;
    }

    TreeMap getRules() {
        if (this._rules == null) {
            this._rules = new TreeMap(new RulePrioritySorter(false));
        }
        return this._rules;
    }

    private void init() {
        Object[] jF;
        this.getMathEvaluator().setVariables(JAXFrontProperties.getInstance(this.getDom().getAppContext()).getUserProperties());
        Object funcs = this.getDom().getClientProperty("JEP_FUNCTIONS");
        if (funcs != null && (jF = (Object[])this.getDom().getClientProperty("JEP_FUNCTIONS")) != null) {
            try {
                for (int i = 0; i < jF.length; ++i) {
                    if (jF[i] instanceof String) {
                        this.getMathEvaluator().initExternalFunctions(DOMHelper.createDocument((String)jF[i]), false);
                        continue;
                    }
                    if (!(jF[i] instanceof org.w3c.dom.Document)) continue;
                    this.getMathEvaluator().initExternalFunctions((org.w3c.dom.Document)jF[i], false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getDom().isImmutable()) {
            return;
        }
        if (this.getMathEvaluator().getCallStack() == null || this.getMathEvaluator().getCallStack().size() == 0) {
            this.getDom()._lastDomUpdateTime = System.currentTimeMillis();
        }
        if (evt.getPropertyName().startsWith(PROPERTYCHANGE)) {
            if (this.getDom().isBinding() || evt.getPropertyName().startsWith(TEMPORARY_PROPERTYCHANGE)) {
                if (evt.getPropertyName().equals(TEMPORARY_PROPERTYCHANGE)) {
                    this.getPropertyChangeSupport().firePropertyChange(evt);
                }
            } else {
                Type source = (Type)evt.getSource();
                this.hasChanged(true);
                if (this.getDom().isHistoryMode()) {
                    this.checkLoggingInfos(source, (String)evt.getOldValue(), evt);
                }
                this.checkRules(evt);
                this.getPropertyChangeSupport().firePropertyChange(evt);
            }
        } else if (evt.getPropertyName().equals(SERIALIZABLE_CHANGED)) {
            this.serializationChange((Type)evt.getSource(), evt, (Boolean)evt.getNewValue());
        }
    }

    public static void handleDynamicRequiredState(Type source, boolean checkParent) {
        Vector sourceVisualizers;
        Vector errors = new Vector();
        Type firstMandatoryParent = source;
        if (checkParent) {
            firstMandatoryParent = TypeController.getFirstMandatoryParent(source);
        }
        if ((sourceVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(firstMandatoryParent)).size() > 0) {
            source.getDOM().validateMandatoryAndCardinality(firstMandatoryParent, errors, false);
        }
        for (int v = 0; v < sourceVisualizers.size(); ++v) {
            int i;
            Visualizer sourceVisualizer = ((Visualizer)sourceVisualizers.get(v)).getImplementation();
            if (sourceVisualizer == null) continue;
            Vector noErrors = TypeVisualizerFactory.getInstance().getVisualizerStructure(sourceVisualizer, true);
            for (i = 0; i < noErrors.size(); ++i) {
                Visualizer visualizer = (Visualizer)noErrors.get(i);
                visualizer.setRequired(false);
            }
            for (i = 0; i < errors.size(); ++i) {
                Error error = (Error)errors.get(i);
                Vector allVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(error.getErrorHolder());
                Iterator allVisIterator = allVisualizers.iterator();
                while (allVisIterator.hasNext()) {
                    Visualizer visualizer = (Visualizer)allVisIterator.next();
                    visualizer.setRequired(true);
                }
            }
        }
    }

    private static Type getFirstMandatoryParent(Type type) {
        if (type.getParent() != null) {
            if (!type.getParent().isAnonymous() && type.getParent().isRequired()) {
                return type.getParent();
            }
            return TypeController.getFirstMandatoryParent(type.getParent());
        }
        return type.getDOM().getRootType();
    }

    private void checkRules(PropertyChangeEvent evt) {
        if (!this.getDom().isRuleEngineBlocked()) {
            Type type = (Type)evt.getSource();
            if (evt instanceof JAXFrontPropertyChangeEvent) {
                this.applyRules(type, DOMChangeEvent.NULL_EVENT(), ((JAXFrontPropertyChangeEvent)evt).getCallStack());
            } else {
                this.applyRules(type, DOMChangeEvent.NULL_EVENT(), null);
            }
            this.applyFormulas();
        }
    }

    public void release() {
        if (this._rules != null) {
            Iterator iterator = this._rules.values().iterator();
            while (iterator.hasNext()) {
                ((Rule)iterator.next()).release();
            }
            this._rules = null;
        }
        if (this._errorController != null) {
            this._errorController.release();
            this._errorController = null;
        }
        if (this._indeterminateXPaths != null) {
            this._indeterminateXPaths.clear();
            this._indeterminateXPaths = null;
        }
        if (this._dirtyListeners != null) {
            this._dirtyListeners = null;
        }
        this.mathEvaluator = null;
    }

    public StringBuffer getInfo() {
        Iterator iterator;
        StringBuffer result = new StringBuffer();
        if (this._rules != null) {
            result.append("\n");
            iterator = this._rules.values().iterator();
            result.append("rules:" + this._rules.size());
            result.append("\n");
            while (iterator.hasNext()) {
                Rule aRule = (Rule)iterator.next();
                result.append("rule:" + aRule.getSource().getXPathLocation());
                result.append("\n");
            }
        }
        if (this.getDom().getFormulas() != null) {
            iterator = this.getDom().getFormulas().values().iterator();
            result.append("\n");
            result.append("formulas:" + this.getDom().getFormulas().size());
            result.append("\n");
            while (iterator.hasNext()) {
                ((FormulaExpression)iterator.next()).release();
                FormulaExpression aFormula = (FormulaExpression)iterator.next();
                result.append("formula:" + aFormula.getSource().getXPathLocation());
                result.append("\n");
            }
        }
        if (this._errorController != null) {
            result.append("errors:" + this._errorController.getErrors().size());
        }
        return result;
    }

    public void releaseRules() {
        this.getRules().clear();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removeRule(Type sourceType) {
        this.removeRule(sourceType, false);
    }

    public void removeRule(Type sourceType, boolean inclDerived) {
        List rules = this.getRules(sourceType, false, true);
        for (int r = 0; r < rules.size(); ++r) {
            Rule aRule = (Rule)rules.get(r);
            aRule.release();
            Object removed = this.getRules().remove(aRule);
        }
    }

    public void removeRule(FormulaExpression formula) {
        Rule toRemove = this.getRule(formula);
        if (toRemove != null) {
            Object v = this.getRules().remove(toRemove);
        }
    }

    void setMathEvaluator(MathEvaluator newMathEvaluator) {
        this.mathEvaluator = newMathEvaluator;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    public void hasChanged(boolean hasChanged) {
        if (hasChanged != this._hasChanged) {
            this.fireDirtyChange(new DirtyChangeEvent(this.getDom(), hasChanged));
        }
        if (this._blockDirtyChange) {
            if (hasChanged) {
                this._changeWhileBlocking = hasChanged;
            }
        } else {
            this._hasChanged = hasChanged;
        }
    }

    private Vector getDirtyListeners() {
        if (this._dirtyListeners == null) {
            this._dirtyListeners = new Vector();
        }
        return this._dirtyListeners;
    }

    public void fireDirtyChange() {
        this.hasChanged(true);
    }

    public void fireDirtyChange(DirtyChangeEvent event) {
        if (!this._blockDirtyChange) {
            Vector ap = this.getDirtyListeners();
            for (int i = 0; i < this.getDirtyListeners().size(); ++i) {
                ((DirtyChangeListener)ap.get(i)).dirtyChange(event);
            }
        } else {
            this._changeWhileBlocking = true;
        }
    }

    public void addDirtyChangeListener(DirtyChangeListener newListener) {
        this.getDirtyListeners().add(newListener);
    }

    public void removeDirtyChangeListener(DirtyChangeListener listener) {
        this.getDirtyListeners().remove(listener);
    }

    public LoggingListener addLogListener(Type sourceType, String scope, String logLevel) {
        LoggingListener info = new LoggingListener(sourceType, scope, logLevel);
        return this.addLogListener(info);
    }

    public LoggingListener addLogListener(LoggingListener listener) {
        this.getLoggingListeners().put(listener.getSource(), listener);
        return listener;
    }

    public void removeLogListener(LoggingListener listener) {
        this.getLoggingListeners().remove(listener.getSource());
    }

    public Hashtable getLoggingListeners() {
        if (this._loggingListeners == null) {
            this._loggingListeners = new Hashtable();
        }
        return this._loggingListeners;
    }

    public void cleanLogging() {
        Vector clone = new Vector();
        clone.addAll(this.getLoggedChanges());
        this.getDom().putClientProperty("LOGGED_CHANGES", clone);
        this.getLoggedChanges().clear();
    }

    public List getLoggedChanges() {
        if (this._loggedChanges == null) {
            this._loggedChanges = new Vector();
        }
        return this._loggedChanges;
    }

    public void addChangeLog(LogEntry logEntry) {
        Vector logEnt = new Vector(this.getLoggedChanges());
        LogEntry foundEntry = null;
        for (int l = 0; l < logEnt.size(); ++l) {
            LogEntry log = (LogEntry)logEnt.get(l);
            if (!log.equals(logEntry)) continue;
            foundEntry = log;
            break;
        }
        if (foundEntry != null && foundEntry.getOldValue() != null) {
            if (foundEntry.getOldValue().equals(logEntry.getNewValue())) {
                this.getLoggedChanges().remove(foundEntry);
                this.getLoggedChanges().add(logEntry);
            } else {
                logEntry.refresh();
            }
        } else {
            this.getLoggedChanges().add(logEntry);
        }
    }

    private void maintainLoggedChanges(Type removedType, DOMChangeEvent event) {
        Iterator iterator = this.getLoggedChanges().iterator();
        LogEntry log = null;
        Vector<LogEntry> logEntriesToRemove = new Vector<LogEntry>();
        while (iterator.hasNext()) {
            log = (LogEntry)iterator.next();
            if (log.getSource() != removedType && !log.getSource().isDerivedFrom(removedType)) continue;
            logEntriesToRemove.add(log);
        }
        if (logEntriesToRemove.size() > 0) {
            this.getLoggedChanges().removeAll(logEntriesToRemove);
        } else {
            this.checkLoggingInfos(removedType, null, event);
        }
    }

    public void dumpLog() {
        Iterator iterator = this.getLoggedChanges().iterator();
        System.out.println(" START DUMP LOGGING ****************************");
        System.out.println("");
        while (iterator.hasNext()) {
            LogEntry logEntry = (LogEntry)iterator.next();
            logEntry.dump();
        }
        System.out.println("");
        System.out.println(" END DUMP LOGGING   ****************************");
    }

    private void serializationChange(Type source, Object event, Boolean isSerializable) {
        if (!this._isPerformingSerializationChange) {
            if (isSerializable.booleanValue()) {
                this._isPerformingSerializationChange = true;
                Iterator rules = ((TreeMap)this.getRules().clone()).values().iterator();
                Rule rule = null;
                while (rules.hasNext()) {
                    rule = (Rule)rules.next();
                    if (!rule.isVisualizerInitializationRule() && !rule.isChangeAndInitializationRule() && !rule.isPropertyChangeRule() || rule.getSource() != source && !rule.getSource().isDerivedFrom(source)) continue;
                    rule.apply(source, event);
                }
                this.checkSubTreeForErrorValues(source);
                this._isPerformingSerializationChange = false;
            } else {
                this._isPerformingSerializationChange = true;
                Enumeration validationErrors = this.getErrorController().getErrors().elements();
                Error error = null;
                Vector<Error> toRemove = new Vector<Error>();
                while (validationErrors.hasMoreElements()) {
                    Vector typeErrors = (Vector)validationErrors.nextElement();
                    for (int i = typeErrors.size() - 1; i >= 0; --i) {
                        error = (Error)typeErrors.get(i);
                        if (error.getErrorHolder() != source && !error.getErrorHolder().isDerivedFrom(source)) continue;
                        toRemove.add(error);
                    }
                }
                Iterator toBeRemoved = toRemove.iterator();
                while (toBeRemoved.hasNext()) {
                    this.getErrorController().removeError((Error)toBeRemoved.next(), true);
                }
                this._isPerformingSerializationChange = false;
            }
        }
    }

    private void checkSubTreeForErrorValues(Type source) {
        if (source.isSimple()) {
            SimpleType st = (SimpleType)source;
            if (st.getValue() != null) {
                st.validate();
            }
        } else if (source.isChoice()) {
            if (source.getChoosenType() != null) {
                this.checkSubTreeForErrorValues(source.getChoosenType());
            }
        } else {
            Iterator iterator = null;
            if (source.isComposite()) {
                CompositeType compositeType = (CompositeType)source;
                iterator = compositeType.getComposites().iterator();
            } else {
                ListType listType = (ListType)source;
                iterator = listType.getList().iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.checkSubTreeForErrorValues((Type)iterator.next());
                }
            }
        }
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean _debug) {
        this._debug = _debug;
        this.getMathEvaluator().setDebug(_debug);
        try {
            FunctionViewerFactory.init("com.jaxfront.xuieditor.ui.tools.FunctionViewer");
            FunctionViewerFactory.getFunctionViewer().setVisible(_debug);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ErrorController getErrorController() {
        if (this._errorController == null) {
            this._errorController = new ErrorController(this);
        }
        return this._errorController;
    }

    public static Type updateXUICompUserObject(Type aType) {
        Type component = aType.getParent("component");
        Type target = null;
        Type startType = aType.getDOM().getEditor().getTargetDOM().getRootType();
        boolean isGlobal = false;
        String globalName = null;
        if (component != null && component.getUserObject() == null) {
            String xpath = component.getDirectChildValue("xpath");
            if (xpath.startsWith("global:")) {
                isGlobal = true;
                globalName = DOMHelper.getGlobalNameFromXPath(xpath);
                xpath = DOMHelper.getGlobalAddressFromXPath(xpath);
                SchemaNode globalElement = startType.getSchemaElement().getSchema().getGlobalEntity((short)-32307, globalName);
                if (globalElement != null) {
                    startType = globalElement.getSchemaType().getType();
                    if (!globalElement.getSchemaType().hasBeenAnalysed()) {
                        startType = globalElement.getSchema().getType(globalElement);
                    }
                }
            }
            if (startType != null) {
                target = TypePathExecuter.getInstance().getTypeForXPath(startType, xpath, true);
                if (!isGlobal) {
                    component.setUserObject(target);
                } else if (target == null) {
                    target = new EmptyType(null, null);
                    target.putClientProperty("message", "XPath (" + xpath + ") was not found on global type (" + globalName + ").");
                }
            }
        }
        return target;
    }

    public void domChanged(DOMChangeEvent event) {
        this.domChanged(event, null);
    }

    public void printRules() {
        Iterator rulesIterator = this.getRules().values().iterator();
        while (rulesIterator.hasNext()) {
            Rule rule = (Rule)rulesIterator.next();
            if (rule.isReleased()) continue;
            System.out.println("Rule ( " + rule.getSource().getDOM() + ") " + rule.getSource().getXPathLocation());
        }
    }

    public void removeRule(Rule rule) {
        Object removed = this.getRules().remove(rule);
    }

    public Document getDom() {
        return this._dom;
    }

    public void blockDirtyChange(boolean dirtyChange) {
        this._blockDirtyChange = dirtyChange;
        this._changeWhileBlocking = false;
    }

    public boolean isBlockDirtyChange() {
        return this._blockDirtyChange;
    }

    public boolean changeWhileBlocking() {
        return this._changeWhileBlocking;
    }
}

