/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.PrimitiveRowHeaderLabellingStrategy;
import com.jaxfront.core.ui.RowHeaderLabellingStrategy;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.xui.ColumnInfo;
import com.jaxfront.core.xui.TableInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class FlipOrientationTableModel
extends AbstractTableModel
implements DOMChangeListener {
    private Boolean _isComplexList;
    protected List _columns;
    private Vector _rowHeaders;
    private RowHeaderLabellingStrategy _strategy = null;
    private boolean _isFlipped = false;
    private boolean _showRowHeaders = false;
    private ListType _listType = null;
    private TableInfo _tableInfo = null;

    public FlipOrientationTableModel(ListType listType) {
        this._listType = listType;
        this._tableInfo = listType.getStyle().getTableInfo();
        this._listType.getDOM().addDOMChangeListener(this);
        this.initializeRowHeaderStrategy();
        this._isFlipped = this._tableInfo.getLineDirection() == 0;
        this._showRowHeaders = this._tableInfo.showSequenceNumbering();
    }

    public FlipOrientationTableModel(AbstractType listType) {
        this((ListType)((Object)listType));
    }

    private void addRow(Type type) {
        this.fillRowHeaders();
        if (this.isFlipped()) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    private void createDefaultLineInfos(TableInfo tableInfo) {
        if (this._listType.getEditingType().isSimple()) {
            ColumnInfo lineInfo = new ColumnInfo(this._listType.getEditingType(), 0, this._listType.getEditingType().getStyle().getLabelText());
            lineInfo.setUsingDefaultRendering(true);
            tableInfo.addLineInfo(lineInfo);
            return;
        }
        CompositeType composite = (CompositeType)this._listType.getEditingType();
        Iterator compositeIterator = composite.getComposites().iterator();
        int counter = 0;
        tableInfo.releaseLineInfos();
        while (compositeIterator.hasNext()) {
            Type type = (Type)compositeIterator.next();
            if (!type.isSimple() && type.getTypeClassification() != 128 && type.getTypeClassification() != 65) continue;
            ColumnInfo lineInfo = new ColumnInfo(type, counter, type.getStyle().getLabelText());
            lineInfo.setUsingDefaultRendering(true);
            tableInfo.addLineInfo(lineInfo);
            ++counter;
        }
        if (tableInfo.size() == 0) {
            tableInfo.addLineInfo(new ColumnInfo(composite, 0, "no name"));
        }
    }

    private TableInfo createTableInfo() {
        List list = TypePathExecuter.getInstance().processXPath(DOMBuilder.getInstance().getXUISchemaDOM(this.getListType().getDOM().getAppContext()).getRootType(), "./component/style/list", true);
        Type xuiListType = (Type)list.get(0);
        TableInfo tableInfo = new TableInfo(xuiListType, this._listType, 1, true);
        tableInfo.setIsXUIControlled(false);
        return tableInfo;
    }

    public void domChanged(DOMChangeEvent event) {
        Object source = event.getSource();
        Type type = null;
        if (source instanceof Type) {
            type = (Type)event.getSource();
        }
        if (event.isAddingNode() || event.isRemovingNode() || event.isChangingNode()) {
            Type representiveParent = this.getListEntryHolder(type);
            if (type.getParent() != null && !type.getParent().isList() || type.getParentList() != this.getListType()) {
                return;
            }
            if (this.isComplexList() || this.getListType().getEditingType().isAbstract()) {
                if (this.getListType().getEditingType().isAbstract() || this.getDirectComplexGroupParent(type) == this._listType) {
                    this.performEvent(event, representiveParent);
                } else {
                    boolean isTemplateOrDialogMode = false;
                    if (this._listType.getStyle().getTableInfo() != null && this._listType.getStyle().getTableInfo().isDialogEditMode()) {
                        isTemplateOrDialogMode = true;
                    }
                    if (!this.getTableInfo().isUsingDefaultRendering() && !isTemplateOrDialogMode) {
                        this.fireTableDataChanged();
                    }
                }
            } else {
                this.performEvent(event, representiveParent);
            }
        } else if (event.isFinishedBinding() && event.getSource() == this.getListType()) {
            this.getTableInfo().updateLineInfos(this.getListType());
            this.initializeRowHeaderStrategy();
            this.fireTableStructureChanged();
        }
    }

    private Object evaluate(int line, int col, boolean useCached) {
        ColumnInfo lineInfo = this._tableInfo.getLineInfo(line);
        Object value = null;
        value = useCached ? lineInfo.getCachedValue(col) : lineInfo.evalFormulaObject(col);
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected void fillRowHeaders() {
        this._rowHeaders = new Vector();
        for (int rowCounter = 0; rowCounter < this._listType.size(); ++rowCounter) {
            this._rowHeaders.add(this._strategy.getRowHeader((Type)this._listType.get(rowCounter)));
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (this.isComplexList()) {
            if (this.getListType().isKey()) {
                return SimpleType.class;
            }
            return super.getColumnClass(columnIndex);
        }
        return SimpleType.class;
    }

    public int getColumnCount() {
        int size = 0;
        size = this._isFlipped ? this._listType.getList().size() : this._columns.size();
        return size;
    }

    public String getColumnName(int col) {
        if (this._isFlipped) {
            if (this._showRowHeaders) {
                return this._rowHeaders.get(col).toString();
            }
            return new String(" ");
        }
        return this.getRowName(col);
    }

    public String[] getColumnNames() {
        String[] colNames = new String[this.getColumnCount()];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = this.getColumnName(i);
        }
        return colNames;
    }

    public String getRowName(int index) {
        return ((ColumnInfo)this._columns.get(index)).getName();
    }

    private Type getListEntryHolder(Type type) {
        if (type.getParent() != null && type.getParent().isList()) {
            return type;
        }
        if (type.getParent() != null) {
            return this.getListEntryHolder(type.getParent());
        }
        return null;
    }

    private ComplexGroupList getDirectComplexGroupParent(Type type) {
        if (type.getParent() != null && type.getParent() instanceof ComplexGroupList) {
            return (ComplexGroupList)type.getParent();
        }
        return null;
    }

    public String getExcelTableData() {
        StringBuffer buf = new StringBuffer();
        String value = null;
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                value = (String)this.getValueAt(i, j);
                buf.append(value == null ? "" : value);
                buf.append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public int getIndexFor(Type type) {
        int index = -1;
        for (int i = 0; i < this._listType.getList().size(); ++i) {
            CompositeType composite = (CompositeType)this._listType.getList().get(i);
            if (composite != type) continue;
            index = i;
            break;
        }
        return index;
    }

    public ListType getListType() {
        return this._listType;
    }

    public int getRowCount() {
        if (this._isFlipped) {
            return this._columns.size();
        }
        return this._listType.size();
    }

    public SimpleType getSimpleTypeAt(int row, int col) {
        Type result = this.getTypeAt(row, col);
        if (result != null && result.isSimple()) {
            return (SimpleType)result;
        }
        return null;
    }

    public FormulaExpression getFormulaExpression(int row, int col) {
        ColumnInfo lineInfo = null;
        Vector formulaExpressions = null;
        FormulaExpression expression = null;
        try {
            if (this.isFlipped()) {
                lineInfo = this._tableInfo.getLineInfo(row);
                formulaExpressions = lineInfo.getFormulaExpressions();
                expression = (FormulaExpression)formulaExpressions.get(col);
            } else {
                lineInfo = this._tableInfo.getLineInfo(col);
                formulaExpressions = lineInfo.getFormulaExpressions();
                if (row < formulaExpressions.size()) {
                    expression = (FormulaExpression)formulaExpressions.get(row);
                }
            }
        }
        catch (Throwable t) {
            LogRegistry.getInstance().error(this.getClass(), t.getMessage());
        }
        return expression;
    }

    public Type getTypeAt(int row, int col) {
        Type type = null;
        FormulaExpression expression = this.getFormulaExpression(row, col);
        if (expression != null) {
            if (expression.getExpression() != null) {
                try {
                    Object eval = expression.evaluateObject();
                    if (eval != null && eval instanceof Type) {
                        type = (Type)eval;
                    }
                }
                catch (FormulaException ex) {}
            } else if (expression.getSource() != null && expression.getSource() instanceof Type) {
                type = expression.getSource();
            }
        }
        return type;
    }

    private boolean isContextNavigationField(int row, int col) {
        ColumnInfo lineInfo = null;
        lineInfo = this.isFlipped() ? this._tableInfo.getLineInfo(row) : this._tableInfo.getLineInfo(col);
        return lineInfo.allowContextNavigation();
    }

    public RowHeaderLabellingStrategy getStrategy() {
        return this._strategy;
    }

    public TableInfo getTableInfo() {
        return this._tableInfo;
    }

    public Object getValueAt(int row, int col) {
        String o = null;
        if (this._isFlipped) {
            if (col != 0) {
                return this.evaluate(row, col - 1, false);
            }
        } else {
            return this.evaluate(col, row, false);
        }
        o = this.getRowName(row);
        return o;
    }

    public String[][] getData() {
        String[][] data = new String[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < data.length; ++i) {
            int addition = 0;
            if (this.isFlipped()) {
                addition = 1;
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Object dataObject = this.getValueAt(i, j + addition);
                String stringValue = null;
                stringValue = dataObject instanceof Type ? ((Type)dataObject).getDisplayValue() : dataObject.toString();
                data[i][j] = stringValue;
            }
        }
        return data;
    }

    public List getRowFormulas(int col) {
        return (List)this._tableInfo.getLineInfo(col).getFormulaExpressions().clone();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getCachedValueAt(int row, int col) {
        void var3_8;
        Object var3_3 = null;
        if (this._isFlipped) {
            if (col != 0) return this.evaluate(row, col - 1, true);
            String string = this.getRowName(row);
            return var3_8;
        } else {
            if (col != 0) return this.evaluate(col - 1, row, true);
            if (this._showRowHeaders) {
                if (row >= this._rowHeaders.size()) {
                    String string = String.valueOf(row);
                    return var3_8;
                } else {
                    Object e = this._rowHeaders.get(row);
                }
                return var3_8;
            } else {
                String string = new String(" ");
            }
        }
        return var3_8;
    }

    private void initializeRowHeaderStrategy() {
        String strategyName = "";
        if (this._tableInfo == null || this._tableInfo.getLineInfos().size() == 0) {
            this._strategy = new PrimitiveRowHeaderLabellingStrategy();
            if (this._tableInfo == null) {
                this._tableInfo = this.createTableInfo();
            } else if (this._tableInfo.getLineInfos().size() == 0) {
                this.createDefaultLineInfos(this._tableInfo);
            }
            if (this._tableInfo.getColumnHeaderLabellingStrategy() == null) {
                strategyName = this._strategy.getClass().getName();
            }
        } else {
            strategyName = this._tableInfo.getColumnHeaderLabellingStrategy();
        }
        this._strategy = RowHeaderLabellingStrategy.create(strategyName, this._listType);
        this.fillRowHeaders();
        this._columns = this._tableInfo.getLineInfos();
        this._tableInfo.updateLineInfos(this._listType);
    }

    public boolean isCellEditable(int row, int column) {
        if (this.isCellEditableEnabled()) {
            boolean isEditable = false;
            TableInfo tableInfo = this.getListType().getStyle().getTableInfo();
            if (this.isComplexList() && tableInfo != null) {
                if (this.getListType().isKey() && this.isContextNavigationField(row, column)) {
                    return true;
                }
                return this.getSimpleTypeAt(row, column) != null;
            }
            if (this.isComplexList()) {
                return false;
            }
            if (this.getListType().isKey() && this.isContextNavigationField(row, column)) {
                return true;
            }
            if (this.getListType().getStyle().isDialogMode()) {
                return false;
            }
            if (this.getListType() instanceof SimpleGroupList && tableInfo != null && !tableInfo.isDefaultPanelEditMode()) {
                return false;
            }
            isEditable = this.getSimpleTypeAt(row, column) != null;
            return isEditable;
        }
        return false;
    }

    public boolean isCellEditableEnabled() {
        if (this.getListType().getStyle().getTableInfo() != null && this.getListType().getStyle().getTableInfo().isSelectionOnly()) {
            return false;
        }
        if (this.getListType().getStyle().isDialogMode()) {
            return false;
        }
        if (this.getListType().getStyle().isPanelMode()) {
            return false;
        }
        if (this.getListType().isKey()) {
            return true;
        }
        if (this.isComplexList()) {
            return true;
        }
        return true;
    }

    private boolean isComplexList() {
        if (this._isComplexList == null) {
            this._isComplexList = new Boolean(this.getListType() instanceof ComplexGroupList);
        }
        return this._isComplexList;
    }

    public boolean isFlipped() {
        return this._isFlipped;
    }

    protected void performEvent(DOMChangeEvent event, Type representiveParent) {
        Type type = (Type)event.getSource();
        this.fillRowHeaders();
        if (event.isChangingNode()) {
            this.fireTableDataChanged();
        } else if (event.isAddingNode()) {
            Type typeToAdd = representiveParent;
            if (type.isSimple()) {
                typeToAdd = type;
                this.getTableInfo().createFormula((SimpleType)type);
            } else {
                this.getTableInfo().createFormulas((CompositeType)representiveParent);
            }
            this.addRow(typeToAdd);
        } else if (event.isRemovingNode()) {
            this.getTableInfo().updateLineInfo(type, event.getType());
        }
        if (this.isFlipped()) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void setFlipped(boolean flipped) {
        this._isFlipped = flipped;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SimpleType simpleType;
        if (this.isFlipped()) {
            --columnIndex;
        }
        if (!((simpleType = this.getSimpleTypeAt(rowIndex, columnIndex)) == null || simpleType.getStyle().isUsingPlugIn() || simpleType.getValue() != null && aValue != null && ((String)aValue).equals(simpleType.getValue()))) {
            Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer((Type)simpleType, false);
            simpleType.setValue(vis, (String)aValue, false);
        }
    }

    public boolean showRowHeaders() {
        return this._showRowHeaders;
    }

    public void swapFormula(int from, int to) {
        if (from == -1 || to == -1) {
            return;
        }
        for (int j = 0; j < this._columns.size(); ++j) {
            ColumnInfo o = (ColumnInfo)this._columns.get(j);
            o.swapFormula(from, to);
        }
    }

    public void release() {
        this._isComplexList = null;
        this._columns = null;
        this._rowHeaders = null;
        this._strategy = null;
        if (this._listType != null && this._listType.getDOM() != null) {
            this._listType.getDOM().removeDOMChangeListener(this);
            this._listType = null;
        }
        this._tableInfo = null;
    }

    public Vector getRowHeaders() {
        if (this._rowHeaders == null || this._rowHeaders.size() == 0) {
            this.fillRowHeaders();
        }
        return this._rowHeaders;
    }

    public String[] getRowValues(int row) {
        Object object = null;
        int cols = this.isFlipped() ? this.getRowCount() : this.getColumnCount();
        String[] values = new String[cols];
        for (int i = 0; i < cols; ++i) {
            object = this._isFlipped ? this.evaluate(i, row, false) : this.getValueAt(row, i);
            values[i] = this.valueAtToString(object);
        }
        return values;
    }

    public StringBuffer rowToCSV(int row, String delim) {
        StringBuffer values = new StringBuffer();
        Object object = null;
        int cols = this.isFlipped() ? this.getRowCount() : this.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            object = this._isFlipped ? this.evaluate(i, row, false) : this.getValueAt(row, i);
            values.append(this.valueAtToString(object));
            if (delim == null) continue;
            values.append(delim);
        }
        return values;
    }

    private String valueAtToString(Object object) {
        String value;
        if (object instanceof Type) {
            value = null;
            if (object instanceof SimpleType) {
                value = ((SimpleType)object).getValue();
            }
        } else {
            value = object instanceof Object[] ? ArrayUtil.toString((Object[])object, ",", false) : object.toString();
        }
        return value;
    }
}

