/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.ui.LayoutConstants;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.stringSearch.StringCutter;

public class FormlayoutDefaults
implements LayoutConstants {
    private static FormlayoutDefaults _instance = null;
    private double _defRowHeight = 22.0;
    private double _defColWidth = 0.2;
    private String _defRowHorizAlgin;
    private String _defRowVertAlgin;
    private String _defColHorizAlgin;
    private String _defColVertAlgin;
    private String _defHeaderVertAlgin;
    private String _defHeaderHorizAlgin;
    private String _defSepClassicVertAlgin;
    private String _defSepClassicHorizAlgin;
    private String _defSepModernVertAlgin;
    private String _defSepModernHorizAlgin;
    public static final int XUIEDITOR_VISUAL_HEIGHT_OFFSET = 18;
    public static final String TABLE_LAYOUT_ALIGN_WIDGET = "tableLayoutAlignWidget";

    private FormlayoutDefaults() {
        this.init();
    }

    public static synchronized FormlayoutDefaults getInstance() {
        if (_instance == null) {
            _instance = new FormlayoutDefaults();
        }
        return _instance;
    }

    public void init() {
        String[] defaults = FormlayoutDefaults.convertXUIRowColTableDefToFormTableDef(JAXFrontProperties.getInstance().getXuiEditorFormLayoutRowDefaults());
        this._defRowHeight = defaults[0] != null ? Double.parseDouble(defaults[0]) : this._defRowHeight;
        this._defRowHorizAlgin = defaults[1];
        this._defRowVertAlgin = defaults[2];
        defaults = FormlayoutDefaults.convertXUIRowColTableDefToFormTableDef(JAXFrontProperties.getInstance().getXuiEditorFormLayoutColDefaults());
        this._defColWidth = defaults[0] != null ? Double.parseDouble(defaults[0]) : this._defColWidth;
        this._defColHorizAlgin = defaults[1];
        this._defColVertAlgin = defaults[2];
        this._defHeaderVertAlgin = JAXFrontProperties.getInstance().getXuiEditorFormLayoutHeaderDefaults();
        this._defSepClassicVertAlgin = JAXFrontProperties.getInstance().getXuiEditorFormLayoutSepClassicDefaults();
        this._defSepModernVertAlgin = JAXFrontProperties.getInstance().getXuiEditorFormLayoutSepModernDefaults();
    }

    public double getDefaultRowHeight() {
        return this._defRowHeight;
    }

    public double getDefaultColWidth() {
        return this._defColWidth;
    }

    public String getDefaultRowHeightAsString() {
        return String.valueOf(this.getDefaultRowHeight());
    }

    public String getDefaultColWidthAsString() {
        return String.valueOf(this.getDefaultColWidth());
    }

    public String getDefaultRowHorizontalAlignment() {
        return this._defRowHorizAlgin == null ? "F" : this._defRowHorizAlgin;
    }

    public String getDefaultRowVerticalAlignment() {
        return this._defRowVertAlgin == null ? "C" : this._defRowVertAlgin;
    }

    public String getDefaultColHorizontalAlignment() {
        return this._defColHorizAlgin == null ? "F" : this._defColHorizAlgin;
    }

    public String getDefaultColVerticalAlignment() {
        return this._defColVertAlgin == null ? "C" : this._defColVertAlgin;
    }

    public String getDefaultHeaderHorizontalAlignment() {
        return this._defHeaderHorizAlgin == null ? "fill" : this._defHeaderHorizAlgin;
    }

    public String getDefaultHeaderVerticalAlignment() {
        return this._defHeaderVertAlgin == null ? "B" : this._defHeaderVertAlgin;
    }

    public String getDefaultSepClassicHorizontalAlignment() {
        return this._defSepClassicHorizAlgin == null ? "fill" : this._defSepClassicHorizAlgin;
    }

    public String getDefaultSepClassicVerticalAlignment() {
        return this._defSepClassicVertAlgin == null ? "B" : this._defSepClassicVertAlgin;
    }

    public String getDefaultSepModernHorizontalAlignment() {
        return this._defSepModernHorizAlgin == null ? "fill" : this._defSepModernHorizAlgin;
    }

    public String getDefaultSepModernVerticalAlignment() {
        return this._defSepModernVertAlgin == null ? "B" : this._defSepModernVertAlgin;
    }

    public static String[] convertXUIRowColTableDefToFormTableDef(String modelValue) {
        String[] formLayoutConstraints = new String[3];
        if (modelValue != null) {
            StringCutter st = new StringCutter(modelValue, ",", ",", true);
            double width = 0.0;
            String hAlign = "";
            String vAlign = "";
            String aToken1 = (String)st.nextElement();
            st.nextElement();
            String aToken2 = (String)st.nextElement();
            st.nextElement();
            String aToken3 = (String)st.nextElement();
            width = aToken1 == null || aToken1.equals("") ? Double.NaN : Double.parseDouble(aToken1.trim());
            hAlign = aToken2 == null || aToken2.equals("") ? null : aToken2.trim();
            vAlign = aToken3 == null || aToken3.equals("") ? null : aToken3.trim();
            String widthAsString = null;
            widthAsString = Double.isNaN(width) ? null : (width < 1.0 ? (width == -2.0 ? "PREF" : (width == -1.0 ? "F" : String.valueOf(width))) : String.valueOf((int)width));
            formLayoutConstraints[0] = widthAsString;
            formLayoutConstraints[1] = hAlign;
            formLayoutConstraints[2] = vAlign;
        }
        return formLayoutConstraints;
    }

    public static String[] buildRowDefsRespectingDefaults(String modelValue) {
        String[] converted = FormlayoutDefaults.convertXUIRowColTableDefToFormTableDef(modelValue);
        if (converted[0] == null || converted[0].equals("")) {
            converted[0] = FormlayoutDefaults.getInstance().getDefaultRowHeightAsString();
        }
        if (converted[1] == null || converted[1].equals("")) {
            converted[1] = FormlayoutDefaults.getInstance().getDefaultRowHorizontalAlignment();
        }
        if (converted[2] == null || converted[2].equals("")) {
            converted[2] = FormlayoutDefaults.getInstance().getDefaultRowVerticalAlignment();
        }
        return converted;
    }

    public static String[] buildColDefsRespectingDefaults(String modelValue) {
        String[] converted = FormlayoutDefaults.convertXUIRowColTableDefToFormTableDef(modelValue);
        if (converted[0] == null || converted[0].equals("")) {
            converted[0] = FormlayoutDefaults.getInstance().getDefaultColWidthAsString();
        }
        if (converted[1] == null || converted[1].equals("")) {
            converted[1] = FormlayoutDefaults.getInstance().getDefaultColHorizontalAlignment();
        }
        if (converted[2] == null || converted[2].equals("")) {
            converted[2] = FormlayoutDefaults.getInstance().getDefaultColVerticalAlignment();
        }
        return converted;
    }

    public static String convertTLAlign2FLAlign(String tableLayoutAlign) {
        if (tableLayoutAlign.equalsIgnoreCase("L")) {
            return "left";
        }
        if (tableLayoutAlign.equalsIgnoreCase("R")) {
            return "right";
        }
        if (tableLayoutAlign.equalsIgnoreCase("C")) {
            return "center";
        }
        if (tableLayoutAlign.equalsIgnoreCase("T")) {
            return "top";
        }
        if (tableLayoutAlign.equalsIgnoreCase("B")) {
            return "bottom";
        }
        if (tableLayoutAlign.equalsIgnoreCase("F")) {
            return "fill";
        }
        return "default";
    }
}

