/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.XMLSchemaPositionSorter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModel
extends DefaultTreeModel {
    protected Type _rootType;
    protected Type _xuiRootType;
    protected XMLSchemaPositionSorter _sorter;

    public TreeModel(Type root) {
        this(root, null);
    }

    public TreeModel(DefaultMutableTreeNode node, Type rootType, Type xuiRootType) {
        super(node);
        this._rootType = rootType;
        this._xuiRootType = xuiRootType;
        this.buildTree();
    }

    public TreeModel(Type rootType, Type xuiRootType) {
        this(new TreeNode(null, rootType), rootType, xuiRootType);
        ((TreeNode)this.getRoot()).setModel(this);
    }

    protected void buildTree() {
        Type xuiComponent;
        TreeNode rootNode = (TreeNode)this.getRoot();
        rootNode.setModel(this);
        if (this._xuiRootType != null && (xuiComponent = rootNode.getType().getXUIDefinition().getXUIType()) != null) {
            xuiComponent.setUserObject(rootNode.getType());
        }
        this.buildTree(rootNode, this._rootType);
    }

    public void buildTree(TreeNode startNode, Type startType) {
        List childsList = null;
        if (startType.isComposite()) {
            childsList = ((CompositeType)startType).getComposites();
        }
        int position = -1;
        if (startType.isList()) {
            childsList = ((ListType)startType).getList();
            position = 0;
        }
        if (childsList != null) {
            for (Type child : childsList) {
                this.buildTree(startNode, child, startType, true, true, position);
                if (position == -1) continue;
                ++position;
            }
        }
    }

    public boolean buildTree(TreeNode node, Type type, Type parentType, boolean addable, boolean checkRepresentedAsTreeNode, int position) {
        boolean representedAsTreeNode;
        boolean addChilds = true;
        boolean isChoice = false;
        if (type.hasUIDefinition() && !type.getStyle().isTreeEntryShowAsOptional() && !type.getStyle().isVisibleAtRuntime()) {
            return false;
        }
        if (type.hasUIDefinition() && type.getStyle().isTreeEntryNever() && type.getStyle().isTreeEntryApplyOnAllDescendants()) {
            return false;
        }
        if (type instanceof ListType || type instanceof CompositeType && (isChoice = ((CompositeType)type).isChoice())) {
            addChilds = addable;
        }
        if (representedAsTreeNode = !checkRepresentedAsTreeNode ? true : type.isRepresentedAsTreeNode()) {
            TreeNode newNode = new TreeNode(this, type);
            if (position == -1) {
                position = node.getPosition(newNode);
            }
            if (!(parentType instanceof CompositeType) || !type.hasUnChoosenChoiceParent()) {
                if (addable && (!type.isList() || type.getDOM().isShowingTreeListContainer())) {
                    this.insertNodeInto(newNode, node, position);
                    node = newNode;
                }
            } else if (type.equals(parentType.getChoosenType())) {
                if (addable) {
                    this.insertNodeInto(newNode, node, position);
                }
                node = newNode;
            } else {
                addChilds = false;
            }
        }
        List childsList = null;
        if (type.isComposite()) {
            childsList = ((CompositeType)type).getComposites();
        }
        int innerPosition = -1;
        if (type.isList()) {
            childsList = ((ListType)type).getList();
            innerPosition = 0;
        }
        if (childsList != null) {
            List listChilds = childsList;
            for (int c = 0; c < listChilds.size(); ++c) {
                Type child = (Type)listChilds.get(c);
                boolean added = true;
                if (isChoice) {
                    Type choosenType = ((CompositeType)type).getChoosenType();
                    if (choosenType != null && child == choosenType) {
                        added = this.buildTree(node, choosenType, parentType, addable, true, innerPosition);
                    }
                } else {
                    added = this.buildTree(node, child, type, addChilds, true, innerPosition);
                }
                if (!added || innerPosition == -1) continue;
                ++innerPosition;
            }
        }
        return true;
    }

    public TreeNode getNode(Type type) {
        return this.getNode(type, (TreeNode)this.getRoot());
    }

    private TreeNode getNode(Type type, TreeNode node) {
        if (node.getType() == type) {
            return node;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeNode childNode = (TreeNode)node.getChildAt(i);
            TreeNode foundNode = this.getNode(type, childNode);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public void insertNode(Type type) {
        Type parentType;
        if (type != null && !type.getDOM().isPasteMode() && (parentType = type.getParent()) != null) {
            TreeNode parentNode;
            Type treeNodeParent = type.getParent().getRepresentedTreeNodeParent();
            if (treeNodeParent.isList() && !type.getDOM().isShowingTreeListContainer()) {
                treeNodeParent = treeNodeParent.getParent().getRepresentedTreeNodeParent();
            }
            if ((parentNode = this.getNode(treeNodeParent)) != null && this.getNode(type) == null) {
                type.getStyle().setTreeEntry(true);
                this.buildTree(parentNode, type, type.getParent(), true, true, -1);
            }
        }
    }

    public void moveNode(Type sourceType, Type targetType) {
        TreeNode sourceNode = this.getNode(sourceType);
        TreeNode targetNode = this.getNode(targetType);
        if (sourceNode != null && targetNode != null) {
            TreeNode parent = this.getNode(sourceType.getParent());
            int targetIndex = parent.getIndex(targetNode);
            this.insertNodeInto(sourceNode, parent, targetIndex);
            this.reload(parent);
        }
    }

    public void removeNode(Type type) {
        TreeNode node;
        if (!type.getDOM().isPasteMode() && (node = this.getNode(type)) != null) {
            this.removeNodeFromParent(node);
        }
    }

    public void removeNodeFromParent(DefaultMutableTreeNode node) {
        this.removeNodeFromParent(node, true);
    }

    public void removeNodeFromParent(DefaultMutableTreeNode node, boolean release) {
        super.removeNodeFromParent(node);
        if (release && node instanceof TreeNode) {
            ((TreeNode)node).release();
        }
    }

    public void setIcon(Type type, String gifName) {
        TreeNode treeNode = this.getNode(type);
        ImageIcon icon = JAXFrontProperties.getImageIcon(type.getDOM().getFingerPrint().getXUIURL(), gifName);
        if (treeNode != null) {
            treeNode.setIcon(icon);
            this.nodeChanged(treeNode);
        }
    }

    public void swapNode(Type sourceType, Type targetType) {
        TreeNode sourceNode = this.getNode(sourceType);
        TreeNode targetNode = this.getNode(targetType);
        if (sourceNode != null && targetNode != null) {
            TreeNode parent = this.getNode(sourceType.getParent());
            int targetIndex = parent.getIndex(targetNode);
            this.removeNodeFromParent(sourceNode, false);
            this.insertNodeInto(sourceNode, parent, targetIndex);
        }
    }

    public Integer[] getDepthStatistic() {
        TreeNode parent = (TreeNode)this.getRoot();
        Integer[] levels = new Integer[parent.getChildCount()];
        int level = 0;
        if (parent != null && parent.children() != null) {
            Enumeration<javax.swing.tree.TreeNode> childs = parent.children();
            TreeNode node = null;
            while (childs.hasMoreElements()) {
                node = (TreeNode)childs.nextElement();
                levels[level] = new Integer(node.getDepth() + 2);
                ++level;
            }
        }
        return levels;
    }

    public void release() {
        if (this.getRoot() != null) {
            TreeNode root = (TreeNode)this.getRoot();
            root.release();
        }
        this._sorter = null;
        this._rootType = null;
        this._xuiRootType = null;
    }

    public XMLSchemaPositionSorter getSorter() {
        if (this._sorter == null) {
            this._sorter = new XMLSchemaPositionSorter(false);
        }
        return this._sorter;
    }

    private void addElementNode(TreeNode nodeType, List result, Type treeSelection) {
        Type type = nodeType.getType();
        int length = nodeType.getChildCount();
        boolean isSelected = false;
        if (length == 0 && type == treeSelection) {
            isSelected = true;
        }
        if (!nodeType.isRoot() || !nodeType.getType().getStyle().isRepresentedAsTreeNode()) {
            // empty if block
        }
        if (type.isRoot() && type.getStyle().isInTableLayoutContext()) {
            result.add(type);
        } else {
            result.add(type);
        }
        if (length != 0) {
            for (int a = 0; a < length; ++a) {
                TreeNode childNodeType = (TreeNode)nodeType.getChildAt(a);
                this.addElementNode(childNodeType, result, treeSelection);
            }
        }
    }

    public List<Type> getTreeNodes(Type treeSelection) {
        ArrayList<Type> treeNodes = new ArrayList<Type>();
        this.addElementNode((TreeNode)this.getRoot(), treeNodes, treeSelection);
        return treeNodes;
    }
}

