/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.PluginBean;
import com.jaxfront.core.xui.PluginException;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.XUIDefinition;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.LookAndFeel;

public abstract class TypeVisualizerFactory {
    public static final int RENDERER_TYPE_SWING = 1;
    public static final int RENDERER_TYPE_HTML = 2;
    public static final int RENDERER_TYPE_PDF = 3;
    private static TypeVisualizerFactory _singleton;
    private Hashtable _visualizers;
    protected Hashtable _editors;
    private Hashtable _clientProperties;
    public static final Type WILDCARD_TYPE;

    protected TypeVisualizerFactory() {
    }

    private static String createKey(Type type) {
        String factoryClassName = JAXFrontProperties.getInstance(type.getDOM().getAppContext()).getUIFactoryClassName();
        return factoryClassName + "_" + type.hashCode();
    }

    public Visualizer getFirstCachedVisualizer(Type type) {
        Vector visualizers = this.getAllVisualizers(type);
        if (visualizers.size() > 0) {
            return (Visualizer)visualizers.get(0);
        }
        return null;
    }

    public String toString(Document dom) {
        Vector visualizers = this.getAllVisualizers(dom);
        StringBuffer visbuff = new StringBuffer();
        for (int i = 0; i < visualizers.size(); ++i) {
            Visualizer vis = (Visualizer)visualizers.get(i);
            visbuff.append(i + " " + vis.getModel().getXPathLocation() + " context:" + vis.getContext());
            visbuff.append("\n");
        }
        return visbuff.toString();
    }

    public Vector getAllVisualizers(Type aType) {
        Vector result = new Vector();
        if (aType != null && !aType.isReleased()) {
            this.getAllVisualizers(result, aType);
        }
        return result;
    }

    public Vector getAllVisualizers(Vector result, Type aType) {
        Hashtable allVisualizers;
        Object vises;
        String aKey = TypeVisualizerFactory.createKey(aType);
        Document aDom = aType.getDOM();
        if (aDom != null && this.hasVisualizers(aDom) && (vises = (allVisualizers = this.getVisualizers(aDom)).get(aKey)) != null) {
            if (vises instanceof Object[]) {
                ArrayUtil.addToVector(result, (Object[])vises, true);
            } else if (!result.contains(vises)) {
                result.add(vises);
            }
        }
        return result;
    }

    public Vector getAllVisualizers(Document dom) {
        Vector<Object> result = new Vector<Object>();
        if (this.hasVisualizers(dom)) {
            Hashtable allVisualizers = this.getVisualizers(dom);
            Enumeration typeVisualizers = allVisualizers.elements();
            while (typeVisualizers.hasMoreElements()) {
                Object typeContextVisualizers = typeVisualizers.nextElement();
                if (typeContextVisualizers instanceof Object[]) {
                    Object[] typeContextVisualizersArr = (Object[])typeContextVisualizers;
                    for (int i = 0; i < typeContextVisualizersArr.length; ++i) {
                        result.add(typeContextVisualizersArr[i]);
                    }
                    continue;
                }
                result.add(typeContextVisualizers);
            }
        }
        return result;
    }

    protected Visualizer createPlugin(Type type, Type context) {
        Visualizer visualizer = null;
        try {
            visualizer = this.getPluginFor(type, context);
        }
        catch (PluginException e) {
            LogRegistry.getInstance().error(this.getClass(), e.getMessage());
        }
        return visualizer;
    }

    public abstract Visualizer createRecursiveView(Type var1, Type var2);

    public abstract Visualizer createView(ComplexGroup var1, Type var2);

    public abstract Visualizer createView(ComplexGroupList var1, Type var2);

    public abstract Visualizer createView(SimpleGroup var1, Type var2);

    public abstract Visualizer createView(SimpleGroupList var1, Type var2);

    public abstract Visualizer createView(SimpleType var1, Type var2);

    public abstract Visualizer createView(SimpleTypeList var1, Type var2);

    public abstract Visualizer createView(VirtualType var1, Type var2);

    public Visualizer createVisualizerFor(Type type, Type context) {
        return this.createVisualizerFor(type, context, true);
    }

    public static synchronized TypeVisualizerFactory getInstance() {
        if (_singleton == null) {
            try {
                _singleton = (TypeVisualizerFactory)Class.forName(JAXFrontProperties.getInstance().getUIFactoryClassName()).newInstance();
            }
            catch (Exception e) {
                LogRegistry.getInstance().fatal(TypeVisualizerFactory.class, "unable to initialize UI-Factory: " + JAXFrontProperties.getInstance().getUIFactoryClassName());
            }
        }
        return _singleton;
    }

    public static TypeVisualizerFactory setInstance(TypeVisualizerFactory factory) {
        TypeVisualizerFactory oldFactory = TypeVisualizerFactory.getInstance();
        _singleton = factory;
        String factoryClassName = factory.getClass().getName();
        JAXFrontProperties.getInstance().setUIFactoryClassName(factoryClassName);
        return oldFactory;
    }

    public boolean isHTMLFactory() {
        return false;
    }

    public boolean isPDFFactory() {
        return false;
    }

    public boolean isSwingFactory() {
        return false;
    }

    public Visualizer getPluginFor(Type type, Type context) throws PluginException {
        Class visualizerClass;
        PluginBean plugin = type.getXUIDefinition().getStyle().getPluginBean(this.getRendererID());
        if (plugin == null) {
            plugin = type.getXUIDefinition().getStyle().getPluginBean();
        }
        if (plugin != null && (visualizerClass = plugin.getPluginClass(type.getDOM().getCustomClassloader())) != null) {
            try {
                Constructor visualizerConstructor = visualizerClass.getConstructor(plugin.getParameterClasses());
                Visualizer visualizer = (Visualizer)visualizerConstructor.newInstance(plugin.getParameters(type));
                visualizer.setModel(type);
                return visualizer;
            }
            catch (Throwable e) {
                LogRegistry.getInstance().error(this.getClass(), "PLUGIN-ERROR IN:" + type.getXPathLocation() + "\n" + e.getClass() + " " + e.getMessage());
                throw new PluginException(e.getMessage());
            }
        }
        return null;
    }

    public Visualizer getVisualizer(Type type) {
        return this.getVisualizer(type, null, true);
    }

    public Visualizer getVisualizer(Type aType, String xPath) {
        Type aFoundType = TypePathExecuter.getInstance().getTypeForXPath(aType, xPath);
        if (aFoundType != null) {
            return this.getVisualizer(aFoundType, null, true);
        }
        return null;
    }

    public Visualizer getVisualizer(Type type, Type context) {
        return this.getVisualizer(type, context, true);
    }

    public Visualizer getVisualizer(Type type, boolean lazyInit) {
        return this.getVisualizer(type, null, lazyInit, type.getDOM().isUsingPlugins() && type.getXUIDefinition().getStyle().isUsingPlugIn());
    }

    public Visualizer getVisualizer(Type type, Type context, boolean lazyInit) {
        return this.getVisualizer(type, context, lazyInit, type.getDOM().isUsingPlugins() && type.getXUIDefinition().getStyle().isUsingPlugIn());
    }

    public Visualizer getVisualizer(Type type, Type context, boolean lazyInit, boolean usePlugin) {
        Visualizer visualizer = this.resolveVisualizer(type, context);
        if (visualizer == null && lazyInit && type.isRenderable()) {
            Document visDom = type.getDOM();
            visDom.fireDOMChanged(DOMChangeEvent.DOM_VISUALIZER_ONCREATE(type), true);
            if (JAXFrontProperties.getInstance(type.getDOM().getAppContext()).isBindingOnlyAvailable() && !visDom.isXUIDOMInstance() && !visDom.isPDFXUIDOM() && type.isComposite() && !type.isList() && type.getParentList() != null) {
                ((AbstractCompositeType)type).completeMissingTypes(type.isKey());
            }
            boolean pluginCreated = false;
            if (usePlugin && (visualizer = this.createPlugin(type, context)) != null) {
                pluginCreated = true;
            }
            if (visualizer == null) {
                visualizer = this.createVisualizerFor(type, context);
            }
            if (visualizer != null) {
                this.cacheVisualizer(type, context, visualizer);
                this.initializeVisualizer(pluginCreated, type, visualizer);
                visDom.fireDOMChanged(DOMChangeEvent.DOM_VISUALIZER_INITIALIZED(type), true);
                visualizer.postInitialization();
            }
        }
        return visualizer;
    }

    public void cacheVisualizer(Type type, Visualizer visualizer) {
        this.cacheVisualizer(type, null, visualizer);
    }

    private Hashtable getVisualizers() {
        if (this._visualizers == null) {
            this._visualizers = new Hashtable();
        }
        return this._visualizers;
    }

    public Hashtable getVisualizers(Document DOM) {
        if (this.getVisualizers().get(DOM) == null) {
            this.getVisualizers().put(DOM, new Hashtable());
        }
        return (Hashtable)this.getVisualizers().get(DOM);
    }

    public boolean hasVisualizers(Document DOM) {
        Hashtable domVis = (Hashtable)this.getVisualizers().get(DOM);
        return domVis != null && domVis.size() != 0;
    }

    private void initializeVisualizer(boolean pluginCreated, Type type, Visualizer visualizer) {
        XUIDefinition xuiDef = type.getXUIDefinition(false);
        StyleDefinition style = xuiDef != null ? xuiDef.getStyle() : null;
        Document dom = type.getDOM();
        if (dom.isEditable()) {
            if (type.isRequired() && type.isMandatoryAxis() && !type.getStyle().showAsLabel()) {
                if (!type.getGlobalDefinition().hideRequiredState()) {
                    visualizer.setRequired(true);
                }
            } else {
                visualizer.setRequired(false);
            }
            if (style != null) {
                if (style.isApplicationRequired()) {
                    visualizer.setApplicationRequired(style.isApplicationRequired());
                }
                if (!style.isEditable()) {
                    visualizer.setEditable(false);
                }
                if (style.isReadOnly()) {
                    visualizer.setEnabled(false);
                }
                if (type.hasValidationError()) {
                    visualizer.markError();
                    style.markAsError(true);
                } else {
                    visualizer.resetError();
                    style.markAsError(false);
                }
            }
        } else if (xuiDef != null && style.isUnlocked()) {
            visualizer.setEditable(style.isEditable());
        } else {
            visualizer.setEditable(false);
        }
        visualizer.setVisible(style.isVisibleAtRuntime());
    }

    public static void release() {
        _singleton = null;
    }

    public void releaseCache(Document DOM) {
        this.releaseCache(DOM, true);
    }

    public void releaseCache() {
        Enumeration keys = this.getVisualizers().keys();
        while (keys.hasMoreElements()) {
            this.releaseCache((Document)keys.nextElement());
        }
    }

    public void releaseCache(Document DOM, boolean releaseEditor) {
        Hashtable visualizers = (Hashtable)this.getVisualizers().get(DOM);
        if (visualizers != null) {
            String key;
            String factoryClassName = JAXFrontProperties.getInstance().getUIFactoryClassName();
            Enumeration keys = visualizers.keys();
            Vector<String> visualizersToRemove = new Vector<String>();
            while (keys.hasMoreElements()) {
                Visualizer visualizer;
                key = (String)keys.nextElement();
                if (!key.startsWith(factoryClassName)) continue;
                Object visOrArray = visualizers.get(key);
                visualizersToRemove.add(key);
                if (visOrArray == null) continue;
                if (visOrArray instanceof Visualizer) {
                    visualizer = (Visualizer)visOrArray;
                    if (visualizer == null) continue;
                    visualizer.release();
                    continue;
                }
                Object[] visArray = (Object[])visOrArray;
                for (int i = 0; i < visArray.length; ++i) {
                    visualizer = (Visualizer)visArray[i];
                    if (visualizer == null) continue;
                    visualizer.release();
                }
                visArray = null;
            }
            Iterator iterator = visualizersToRemove.iterator();
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                visualizers.remove(key);
            }
        }
        this.getVisualizers().remove(DOM);
    }

    public void releaseCache(Type type) {
        this.releaseCache(type, null, true, true);
    }

    public void releaseCache(Type type, Type context, boolean removeAllForType) {
        this.releaseCache(type, context, true, removeAllForType);
    }

    public void releaseCache(Type type, Type context, boolean removePropertyChangeListener, boolean removeAllForType) {
        if (type.getDOM() != null) {
            String cacheKey = TypeVisualizerFactory.createKey(type);
            Object cachedVisualizerOrArray = this.getVisualizers(type.getDOM()).get(cacheKey);
            if (cachedVisualizerOrArray != null) {
                if (cachedVisualizerOrArray instanceof Visualizer) {
                    Visualizer cachedVisualizer = (Visualizer)cachedVisualizerOrArray;
                    this.releaseCache(cachedVisualizer, type, context, removePropertyChangeListener, removeAllForType);
                    if (removeAllForType || context == cachedVisualizer.getContext() || context == WILDCARD_TYPE) {
                        if (!cachedVisualizer.isViewReleased()) {
                            cachedVisualizer.release();
                        }
                        this.getVisualizers(type.getDOM()).remove(cacheKey);
                    }
                } else {
                    Object[] visArray = (Object[])cachedVisualizerOrArray;
                    Object[] newVisArr = null;
                    if (visArray.length == 0) {
                        this.getVisualizers(type.getDOM()).remove(cacheKey);
                    } else {
                        for (int i = 0; i < visArray.length; ++i) {
                            Visualizer visObj = (Visualizer)visArray[i];
                            if (!removeAllForType && context != visObj.getContext() && context != WILDCARD_TYPE) continue;
                            Visualizer cachedVisualizer = visObj;
                            this.releaseCache(cachedVisualizer, type, context, removePropertyChangeListener, removeAllForType);
                            if (cachedVisualizer == null) continue;
                            if (!cachedVisualizer.isViewReleased()) {
                                cachedVisualizer.release();
                            }
                            if ((newVisArr = ArrayUtil.removeFromArray(visArray, (Object)cachedVisualizer)) == null || newVisArr.length == 0) {
                                this.getVisualizers(type.getDOM()).remove(cacheKey);
                                continue;
                            }
                            this.getVisualizers(type.getDOM()).put(cacheKey, newVisArr);
                        }
                    }
                }
            }
        }
    }

    public void releaseCache(Visualizer cachedVisualizer, Type type, Type context, boolean removePropertyChangeListener, boolean removeAllForType) {
        if (removePropertyChangeListener && cachedVisualizer instanceof PropertyChangeListener) {
            type.getPropertyChangeSupport().removePropertyChangeListener((PropertyChangeListener)((Object)cachedVisualizer));
        }
        if (type.isComposite()) {
            this.releaseCache((CompositeType)type, context, removePropertyChangeListener, removeAllForType);
        } else if (type.isList()) {
            this.releaseCache((ListType)type, context, removePropertyChangeListener, removeAllForType);
        }
    }

    public void releaseCache(ListType list, Type context, boolean removePropertyChangeListener, boolean removeAllForType) {
        Iterator children = list.getList().iterator();
        while (children.hasNext()) {
            this.releaseCache((Type)children.next(), context, removePropertyChangeListener, removeAllForType);
        }
    }

    public void releaseCache(CompositeType composite, Type context, boolean removePropertyChangeListener, boolean removeAllForType) {
        Iterator composites = composite.getComposites().iterator();
        while (composites.hasNext()) {
            this.releaseCache((Type)composites.next(), context, removePropertyChangeListener, removeAllForType);
        }
    }

    public EditablePanel getEditor(Document DOM) {
        return (EditablePanel)this.getEditors().get(DOM);
    }

    protected Hashtable getEditors() {
        if (this._editors == null) {
            this._editors = new Hashtable();
        }
        return this._editors;
    }

    public EditablePanel registerEditor(Document DOM, EditablePanel editor) {
        this.getEditors().put(DOM, editor);
        return editor;
    }

    public void putClientProperty(String key, Object value) {
        this.getClientProperties().put(key, value);
    }

    public Object getClientProperty(String key) {
        return this.getClientProperties().get(key);
    }

    private Hashtable getClientProperties() {
        if (this._clientProperties == null) {
            this._clientProperties = new Hashtable();
        }
        return this._clientProperties;
    }

    public static boolean isAvailableLookAndFeel(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void populateView(Type aType) {
        Vector vs = this.getAllVisualizers(aType);
        for (int vi = vs.size() - 1; vi >= 0; --vi) {
            Visualizer v = (Visualizer)vs.get(vi);
            v = v.getImplementation();
            v.populateView();
        }
    }

    public Visualizer resolveVisualizer(Type type, Type context) {
        if (context == null && !this.isSwingFactory()) {
            context = WILDCARD_TYPE;
        }
        String cacheKey = TypeVisualizerFactory.createKey(type);
        Object cachedVisualizerOrArrray = this.getVisualizers(type.getDOM()).get(cacheKey);
        Visualizer resultVis = null;
        if (cachedVisualizerOrArrray == null) {
            resultVis = null;
        } else if (cachedVisualizerOrArrray instanceof Visualizer) {
            Visualizer visObj = (Visualizer)cachedVisualizerOrArrray;
            if (context == WILDCARD_TYPE || context == visObj.getContext()) {
                resultVis = visObj;
            }
        } else {
            Object[] visArray = (Object[])cachedVisualizerOrArrray;
            Visualizer nullContVis = null;
            for (int i = 0; i < visArray.length; ++i) {
                Visualizer visObj = (Visualizer)visArray[i];
                if (visObj.getContext() == null) {
                    nullContVis = visObj;
                }
                if (context != visObj.getContext()) continue;
                resultVis = visObj;
                break;
            }
            if (resultVis == null && context == WILDCARD_TYPE && nullContVis != null) {
                resultVis = nullContVis;
            }
        }
        if (resultVis != null && resultVis.getModel() == null) {
            this.releaseCache(type, context, true);
            resultVis = null;
        }
        return resultVis;
    }

    public void cacheVisualizer(Type type, Type context, Visualizer vis) {
        String cacheKey = TypeVisualizerFactory.createKey(type);
        Object cachedVisualizerOrArrray = this.getVisualizers(type.getDOM()).get(cacheKey);
        if (cachedVisualizerOrArrray == null) {
            this.getVisualizers(type.getDOM()).put(cacheKey, vis);
        } else if (cachedVisualizerOrArrray instanceof Visualizer) {
            Visualizer[] newVisArray = new Visualizer[]{(Visualizer)cachedVisualizerOrArrray, vis};
            this.getVisualizers(type.getDOM()).put(cacheKey, newVisArray);
        } else {
            Object[] visArray = (Object[])cachedVisualizerOrArrray;
            this.getVisualizers(type.getDOM()).put(cacheKey, ArrayUtil.addToArray(visArray, vis));
        }
    }

    public Visualizer getVisualizerMapping(String className, Type type, Type context) {
        Object[] paramValues;
        Class[] constParams;
        Visualizer vis = null;
        String classToCreate = JAXFrontProperties.getInstance(type.getDOM().getAppContext()).getStringProperty(className);
        if (classToCreate != null && (vis = (Visualizer)IntroSpectionHelper.createObjectWithAdditionalParams(classToCreate, constParams = new Class[]{Type.class, Type.class}, paramValues = new Object[]{type, context})) == null) {
            vis = (Visualizer)IntroSpectionHelper.createObject(classToCreate, (List)null);
            vis.setModel(type);
            vis.setContext(context);
        }
        return vis;
    }

    public void populateAllVisualizerForType(Type type) {
        if (type.isReleased()) {
            return;
        }
        Vector possibleTargetVis = TypeVisualizerFactory.getInstance().getAllVisualizers(type);
        for (int pt = 0; pt < possibleTargetVis.size(); ++pt) {
            Visualizer visualizer = (Visualizer)possibleTargetVis.get(pt);
            if (visualizer == null) continue;
            visualizer.populateView();
        }
    }

    public void removeVisualizerStructure(Type visType, boolean includeRoot) {
    }

    public void removeVisualizerStructure(Visualizer vis, boolean includeRoot) {
    }

    public Vector getVisualizerStructure(Visualizer vis, boolean includingRoot) {
        return null;
    }

    public Vector getVisualizerStructure(Type start, boolean includingRoot) {
        return null;
    }

    public static Visualizer buildRecursionView(Type recType, Type context) {
        AbstractCompositeType composite = (AbstractCompositeType)recType;
        TypeVisualizerFactory.getInstance().releaseCache(recType);
        Visualizer recVis = TypeVisualizerFactory.getInstance().getVisualizer((Type)composite, context);
        composite.getDOM().getKeyKeyRefManager().registerAllKeyAndKeyRefs(composite);
        return recVis;
    }

    public Visualizer createVisualizerFor(Type type, Type context, boolean createRecursionWrapper) {
        RecursionVisualizer recVis;
        Visualizer view = null;
        switch (type.getTypeClassification()) {
            case 66: {
                view = this.createView((ComplexGroup)type, context);
                break;
            }
            case 1: {
                view = this.createView((SimpleType)type, context);
                break;
            }
            case 65: {
                view = this.createView((SimpleGroup)type, context);
                break;
            }
            case 193: {
                view = this.createView((SimpleGroupList)type, context);
                break;
            }
            case 128: {
                view = this.createView((SimpleTypeList)type, context);
                break;
            }
            case 194: {
                view = this.createView((ComplexGroupList)type, context);
                break;
            }
            case 4: {
                view = this.createView((VirtualType)type, context);
            }
        }
        if (!type.isList() && !type.isVirtual() && type.getSchemaElement().getSchemaType().isRecursive() && createRecursionWrapper && (recVis = (RecursionVisualizer)this.createRecursiveView(type, context)) != null) {
            recVis.addToRecursionPanel(view);
            view = recVis;
        }
        return view;
    }

    public void checkAllVisualizers(Document dom) {
        Vector allVises = this.getAllVisualizers(dom);
        for (int v = 0; v < allVises.size(); ++v) {
            Visualizer vis = (Visualizer)allVises.get(v);
            if (vis.getImplementation().isViewReleased()) {
                System.out.println("error vis is released:" + vis.getImplementation().toString());
            }
            if (!vis.getImplementation().getModel().isReleased()) continue;
            System.out.println("error vis model is released:" + vis.getImplementation().toString());
        }
    }

    public String getRendererID() {
        return null;
    }

    static {
        WILDCARD_TYPE = new VirtualType(null);
    }
}

