/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.access.IUser;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontDateConverter;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.XSDDateFormat;
import com.jaxfront.core.xui.GlobalDefinition;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class JAXFrontDateTools {
    public static final String NLS_DATE_TIME_SHORT_PREFIX = "short_dateTime_";
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String SQL_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    public static final String SQL_DATE_TIME_PATTERN_SHORT = "yyyy-MM-dd HH:mm:ss";
    public static final String SQL_DATE_PATTERN = "yyyy-MM-dd";
    public static final String SQL_TIME_PATTERN = "HH:mm:ss.SSS";
    public static final String ISO_TIME_PATTERN = "HH:mm:ss.SSS";
    public static final String ISO_TIME_SHORT_PATTERN = "HH:mm";
    public static SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat isoDateFormatNotLenient = null;
    public static SimpleDateFormat sqlDateTimeFormatShort = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat sqlDateTIMEFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
    public static SimpleDateFormat sqlTIMEFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    public static SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static XSDDateFormat isoDateTimeFormat = new XSDDateFormat();
    public static XSDDateFormat isoDateTimeFormatNotLenient = null;
    public static SimpleDateFormat isoTimeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    public static SimpleDateFormat isoTimeFormatNotLenient = null;
    public static SimpleDateFormat isoTimeShortFormat = new SimpleDateFormat("HH:mm");
    static SimpleDateFormat standardIsoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final int iSONoFormat = -1;
    public static final int iSODateFormat = 0;
    public static final int iSODateTimeFormat = 1;
    public static final int iSOTimeFormat = 2;
    public static final int DIFFERENCE_IN_DAYS = 0;
    public static final int DIFFERENCE_IN_MS = 1;

    public static String getCurrentISODate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(new Date());
    }

    public static String convertLocalized(String pattern, IUser user) {
        StringBuffer conv = new StringBuffer(pattern.length());
        for (int p = 0; p < pattern.length(); ++p) {
            char aChar = pattern.charAt(p);
            if (user != null) {
                String transl = user.getNLS(NLS_DATE_TIME_SHORT_PREFIX + aChar, null, false);
                if (transl != null) {
                    conv.append(transl);
                    continue;
                }
                conv.append(aChar);
                continue;
            }
            conv.append(aChar);
        }
        return conv.toString();
    }

    public static String getCurrentISODateTime() {
        return isoDateTimeFormat.format(new Date());
    }

    public static String toISODateTime(long time) {
        return isoDateTimeFormat.format(new Date(time));
    }

    public static String toISODateTime(Timestamp time) {
        return JAXFrontDateTools.toISODateTime(time.getTime());
    }

    public static String toSQLDateTimeShort(long time) {
        return sqlDateTimeFormatShort.format(new Date(time));
    }

    public static String toSQLDateTime(long time) {
        return sqlDateTIMEFormat.format(new Date(time));
    }

    public static String toSQLTime(long time) {
        return sqlTIMEFormat.format(new Date(time));
    }

    public static String toSQLTime(Date time) {
        return sqlTIMEFormat.format(time);
    }

    public static String toSQLDate(long time) {
        return sqlDateFormat.format(new Date(time));
    }

    public static String getCurrentISODateTime(long time) {
        return isoDateTimeFormat.format(new Date(time));
    }

    public static String getCurrentISOTime(long time) {
        return isoTimeFormat.format(new Date(time));
    }

    public static String formatToISODate(DateFormat currentFormat, String currentFormatedDate) throws ParseException {
        try {
            currentFormatedDate = JAXFrontDateConverter.getInstance().expandYear(((SimpleDateFormat)currentFormat).toPattern(), currentFormatedDate, "2");
            long time = currentFormat.parse(currentFormatedDate).getTime();
            return isoDateFormat.format(new Date(time));
        }
        catch (Exception e) {
            if (JAXFrontDateTools.isSQLDate(currentFormatedDate)) {
                return JAXFrontDateTools.toISODateTime(sqlDateTIMEFormat.parse(currentFormatedDate).getTime());
            }
            return null;
        }
    }

    public static String formatToISODateTime(DateFormat currentFormat, String currentFormatedDateTime) throws ParseException {
        return JAXFrontDateTools.formatToISODateTime(currentFormat, currentFormatedDateTime, false);
    }

    public static String formatToISODateTime(DateFormat currentFormat, String currentFormatedDateTime, boolean hasReqEx) throws ParseException {
        try {
            long time = currentFormat.parse(currentFormatedDateTime).getTime();
            return isoDateTimeFormat.format(new Date(time));
        }
        catch (Exception ex) {
            if (JAXFrontDateTools.isSQLDate(currentFormatedDateTime)) {
                return JAXFrontDateTools.convertSQLDateToIsoDate(currentFormatedDateTime);
            }
            if (currentFormat instanceof SimpleDateFormat) {
                return JAXFrontDateConverter.getInstance().create(((SimpleDateFormat)currentFormat).toPattern(), ISO_DATE_TIME_PATTERN, currentFormatedDateTime);
            }
            return null;
        }
    }

    public static String formatTo(DateFormat currentFormat, String currentFormatedTime, String targetFormat) throws ParseException {
        try {
            long time = JAXFrontDateTools.evalIsoTimeFormatter(currentFormatedTime).parse(currentFormatedTime).getTime();
            SimpleDateFormat targetFormater = new SimpleDateFormat(targetFormat);
            return targetFormater.format(new Date(time));
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return currentFormatedTime;
        }
    }

    public static String formatToISOTime(DateFormat currentFormat, String currentFormatedTime) throws ParseException {
        try {
            long time = currentFormat.parse(currentFormatedTime).getTime();
            return isoTimeFormat.format(new Date(time));
        }
        catch (Exception ex) {
            if (currentFormat instanceof SimpleDateFormat) {
                String formatted = JAXFrontDateConverter.getInstance().create(((SimpleDateFormat)currentFormat).toPattern(), "HH:mm:ss.SSS", currentFormatedTime);
                if (formatted != null && (formatted.endsWith(".") || formatted.endsWith(":"))) {
                    formatted = formatted + "00";
                    return formatted;
                }
                return formatted;
            }
            return null;
        }
    }

    public static String formatToISODate(String pattern, String currentFormatedDate) throws ParseException {
        long time = new SimpleDateFormat(pattern).parse(currentFormatedDate).getTime();
        return isoDateFormat.format(new Date(time));
    }

    public static int getUsedISODateFormat(String value) {
        if (JAXFrontDateTools.isISODateTime(value)) {
            return 1;
        }
        if (JAXFrontDateTools.isISODate(value)) {
            return 0;
        }
        if (JAXFrontDateTools.isISOTime(value)) {
            return 2;
        }
        return -1;
    }

    public static SimpleDateFormat getISODateFormatNotLenient() {
        if (isoDateFormatNotLenient == null) {
            isoDateFormatNotLenient = new SimpleDateFormat("yyyy-MM-dd");
            isoDateFormatNotLenient.setLenient(false);
        }
        return isoDateFormatNotLenient;
    }

    public static XSDDateFormat getISODateTimeFormatNotLenient() {
        if (isoDateTimeFormatNotLenient == null) {
            isoDateTimeFormatNotLenient = new XSDDateFormat();
            isoDateTimeFormatNotLenient.setLenient(false);
        }
        return isoDateTimeFormatNotLenient;
    }

    public static SimpleDateFormat getISOTimeFormatNotLenient() {
        if (isoTimeFormatNotLenient == null) {
            isoTimeFormatNotLenient = new SimpleDateFormat("HH:mm:ss.SSS");
            isoTimeFormatNotLenient.setLenient(false);
        }
        return isoTimeFormatNotLenient;
    }

    public static boolean isSQLDate(String currentFormatedDate) {
        if (currentFormatedDate == null || currentFormatedDate.length() == 0) {
            return false;
        }
        return JAXFrontDateTools.convertSQLDateToIsoDate(currentFormatedDate) != null;
    }

    public static boolean isISODate(String currentFormat) {
        try {
            if (currentFormat == null || currentFormat.length() == 0) {
                return false;
            }
            isoDateFormat.parse(currentFormat.trim());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isISODateTime(String currentFormat) {
        try {
            if (currentFormat == null || currentFormat.length() == 0) {
                return false;
            }
            isoDateTimeFormat.parse(currentFormat.trim());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isISOTime(String currentFormat) {
        if (currentFormat == null || currentFormat.length() == 0) {
            return false;
        }
        try {
            isoTimeFormat.parse(currentFormat.trim());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static String formatDate(long number, String pattern) {
        SimpleDateFormat myFormatter = new SimpleDateFormat(pattern);
        return myFormatter.format(new Date(number));
    }

    public static long difference(Date from, Date to, int mode) {
        GregorianCalendar cal_1 = new GregorianCalendar();
        cal_1.setTime(from);
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_2.setTime(to);
        long result = -1L;
        long time = -1L;
        switch (mode) {
            case 0: {
                time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
                result = Math.round((double)time / 8.64E7);
                break;
            }
            case 1: {
                result = cal_2.getTime().getTime() - cal_1.getTime().getTime();
                break;
            }
            default: {
                time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
                result = Math.round((double)time / 8.64E7);
            }
        }
        return result;
    }

    public static int getDateDelimiterFor(String pattern, char dateSymbol) {
        int prevChar = -1;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == dateSymbol) {
                if (i == 0) {
                    return 0;
                }
                return prevChar;
            }
            prevChar = pattern.charAt(i);
        }
        return -1;
    }

    public static int extractDateDelimiter(String pattern, char dateSymbol) {
        int deli = JAXFrontDateTools.getDateDelimiterFor(pattern, dateSymbol);
        switch (deli) {
            case -1: 
            case 0: 
            case 72: 
            case 77: 
            case 83: 
            case 100: 
            case 104: 
            case 109: 
            case 115: 
            case 121: {
                return -1;
            }
        }
        return deli;
    }

    public static String hardCoreIsoConverter(String pattern, String value) {
        char[] valarr = value.toCharArray();
        int yearDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'y');
        int monthDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'M');
        int dayDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'd');
        int hourDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'h');
        int longHourDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'H');
        int minuteDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'M');
        int secondDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 's');
        int miliDelimiter = JAXFrontDateTools.extractDateDelimiter(pattern, 'S');
        valarr = TextTools.replace(valarr, (char)yearDelimiter, '-');
        valarr = TextTools.replace(valarr, (char)monthDelimiter, '-');
        valarr = TextTools.replace(valarr, (char)dayDelimiter, '-');
        valarr = TextTools.replace(valarr, (char)hourDelimiter, ' ');
        valarr = TextTools.replace(valarr, (char)longHourDelimiter, ' ');
        valarr = TextTools.replace(valarr, (char)minuteDelimiter, ':');
        valarr = TextTools.replace(valarr, (char)secondDelimiter, ':');
        valarr = TextTools.replace(valarr, (char)miliDelimiter, ' ');
        return String.valueOf(valarr);
    }

    public static String convertSQLDateToIsoDate(String dateStr) {
        Date aSqlDate;
        String newDateF = null;
        if (dateStr != null && (aSqlDate = JAXFrontDateTools.parseSQLDate(dateStr)) != null) {
            newDateF = JAXFrontDateTools.evalIsoDateFormatter(dateStr).format(aSqlDate);
        }
        return newDateF;
    }

    public static Date parseISODate(String dateStr) {
        Date d = null;
        if (dateStr != null) {
            DateFormat formatter = JAXFrontDateTools.evalIsoDateFormatter(dateStr);
            try {
                d = formatter.parse(dateStr);
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(TextTools.class, "constructor failed for" + dateStr);
            }
        }
        return d;
    }

    public static Date parseISOTime(String timeStr) {
        DateFormat formatter = JAXFrontDateTools.evalIsoTimeFormatter(timeStr);
        Date d = null;
        try {
            d = formatter.parse(timeStr);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(TextTools.class, "constructor failed for" + timeStr);
        }
        return d;
    }

    private static DateFormat evalIsoDateFormatter(String dateStr) {
        String timePattern = "";
        switch (dateStr.length()) {
            case 10: {
                timePattern = "yyyy-MM-dd";
                break;
            }
            case 19: {
                timePattern = ISO_DATE_TIME_PATTERN;
                break;
            }
            case 21: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.S";
                break;
            }
            case 22: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SS";
                break;
            }
            case 23: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                break;
            }
            case 24: {
                if (dateStr.endsWith("Z")) {
                    timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
                    break;
                }
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSS";
                break;
            }
            case 25: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSS";
                break;
            }
            case 26: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
                break;
            }
            case 27: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS";
                break;
            }
            case 28: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSS";
                break;
            }
            case 29: {
                timePattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat(timePattern);
        return formatter;
    }

    public static DateFormat evalIsoTimeFormatter(String dateStr) {
        String timePattern = "";
        switch (dateStr.length()) {
            case 5: {
                timePattern = ISO_TIME_SHORT_PATTERN;
                break;
            }
            case 8: {
                timePattern = "HH:mm:ss";
                break;
            }
            case 10: {
                timePattern = "HH:mm:ss.S";
                break;
            }
            case 11: {
                timePattern = "HH:mm:ss.SS";
                break;
            }
            case 12: {
                timePattern = "HH:mm:ss.SSS";
                break;
            }
            case 13: {
                if (dateStr.endsWith("Z")) {
                    timePattern = "HH:mm:ss.SSS'Z'";
                    break;
                }
                timePattern = "HH:mm:ss.SSSS";
                break;
            }
            case 14: {
                timePattern = "HH:mm:ss.SSSSS";
                break;
            }
            case 15: {
                timePattern = "HH:mm:ss.SSSSSS";
                break;
            }
            case 16: {
                timePattern = "HH:mm:ss.SSSSSSS";
                break;
            }
            case 17: {
                timePattern = "HH:mm:ss.SSSSSSSS";
                break;
            }
            case 18: {
                timePattern = "HH:mm:ss.SSSSSSSSS";
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat(timePattern);
        return formatter;
    }

    public static Date parseSQLDate(String dateStr) {
        String timePattern = "";
        switch (dateStr.length()) {
            case 10: {
                timePattern = "yyyy-MM-dd";
                break;
            }
            case 19: {
                timePattern = SQL_DATE_TIME_PATTERN_SHORT;
                break;
            }
            case 21: {
                timePattern = "yyyy-MM-dd HH:mm:ss.S";
                break;
            }
            case 22: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SS";
                dateStr = dateStr + "0";
                break;
            }
            case 23: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSS";
                break;
            }
            case 24: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSSS";
                break;
            }
            case 25: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSSSS";
                break;
            }
            case 26: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
                break;
            }
            case 27: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSSSSSS";
                break;
            }
            case 28: {
                timePattern = "yyyy-MM-dd HH:mm:ss.SSSSSSSS";
            }
        }
        if (timePattern.length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(timePattern);
        Date d = null;
        try {
            d = formatter.parse(dateStr, new ParsePosition(0));
        }
        catch (NullPointerException e) {
            LogRegistry.getInstance().error(TextTools.class, "constructor failed for" + dateStr);
        }
        return d;
    }

    public static String formatLoginTime(Date loginTime, String language) {
        if (loginTime != null) {
            String pattern = GlobalDefinition.getDefaultDateTimeFormatShortStringPattern(language);
            DateFormat datePattern = null;
            datePattern = pattern != null ? new SimpleDateFormat(pattern) : DateFormat.getDateTimeInstance(3, 3, new Locale(language));
            return datePattern.format(loginTime);
        }
        return "";
    }
}

