/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.JAXFrontBaseEntityResolver;
import com.jaxfront.core.util.JAXFrontCatalog;
import com.jaxfront.core.util.JAXFrontURLEntityResolver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.readers.CatalogReader;
import org.apache.xml.resolver.readers.SAXCatalogReader;

public class JAXFrontXMLCatalogResolver
extends XMLCatalogResolver {
    private JAXFrontBaseEntityResolver _jaxFrontBaseEntityResolver;
    private XMLCatalogResolver _xmlCatalogResolver;
    private CatalogManager _catalogManager = new CatalogManager();
    private Catalog _catalog;
    private static EntityResolverMode _mode;
    static /* synthetic */ Class class$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode;
    static final /* synthetic */ int[] $SwitchMap$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode;

    public JAXFrontXMLCatalogResolver(XMLEntityResolver resolver) {
        this._catalogManager.setIgnoreMissingProperties(true);
        if (resolver instanceof JAXFrontBaseEntityResolver) {
            _mode = resolver instanceof JAXFrontURLEntityResolver ? EntityResolverMode.REMOTE_XUIEDITOR : EntityResolverMode.REMOTE;
            this._jaxFrontBaseEntityResolver = (JAXFrontBaseEntityResolver)resolver;
            this.resolveCatalogFromDB("catalog.xml", 2);
        } else {
            _mode = EntityResolverMode.LOCAL;
            this._xmlCatalogResolver = (XMLCatalogResolver)resolver;
        }
    }

    public JAXFrontXMLCatalogResolver(XMLEntityResolver resolver, URL xsdUrl) {
        this(resolver);
        this.resolveCatalog("catalog.xml", new File(xsdUrl.getFile()));
    }

    public JAXFrontBaseEntityResolver getJaxFrontBaseEntityResolver() {
        return this._jaxFrontBaseEntityResolver;
    }

    private void resolveCatalogFromDB(String catalogName, int recursionDepth) {
        try {
            for (int i = 0; i < recursionDepth; ++i) {
                XMLInputSource catalogSrc;
                XMLResourceIdentifier identifier;
                String basePath;
                if (_mode == EntityResolverMode.REMOTE_XUIEDITOR) {
                    basePath = JAXFrontURLEntityResolver.getIDParam(this._jaxFrontBaseEntityResolver.getBasePath());
                    basePath = basePath.substring(0, basePath.lastIndexOf(47) + 1);
                } else {
                    basePath = this._jaxFrontBaseEntityResolver.getBasePath();
                }
                if (i > 0) {
                    String tempBasePath = basePath.substring(0, basePath.length() - 1);
                    basePath = tempBasePath.substring(0, tempBasePath.lastIndexOf("/")) + "/";
                }
                if (_mode == EntityResolverMode.REMOTE_XUIEDITOR) {
                    String dbPath = JAXFrontURLEntityResolver.newURL(this._jaxFrontBaseEntityResolver.getBasePath(), basePath, catalogName);
                    identifier = this.buildXMLResourceIdentifier(dbPath);
                } else {
                    identifier = this.buildXMLResourceIdentifier(basePath + catalogName);
                }
                identifier.setNamespace("http://www.jaxfront.com/jaxforms/" + basePath);
                if (_mode != EntityResolverMode.REMOTE_XUIEDITOR) {
                    this._jaxFrontBaseEntityResolver.setBaseLocation(this._jaxFrontBaseEntityResolver.createBaseKey(identifier), null, basePath);
                }
                if ((catalogSrc = this._jaxFrontBaseEntityResolver.resolveEntity(identifier)).getByteStream() == null) continue;
                this.setCatalogList(new String[]{identifier.getBaseSystemId()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resolveCatalog(String catalogName, File xsdFile) {
        File catalog = null;
        if (xsdFile.isDirectory()) {
            catalog = new File(xsdFile.getPath() + "/" + catalogName);
            if (catalog.exists()) {
                System.out.println(catalog.getPath());
                this._xmlCatalogResolver.setCatalogList(new String[]{catalog.getPath()});
            } else {
                catalog = null;
            }
        }
        if (catalog == null && xsdFile.getParent() != null) {
            this.resolveCatalog(catalogName, new File(xsdFile.getParent()));
        }
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        XMLInputSource xmlInputSource = null;
        String resolvedId = this.resolveIdentifier(resourceIdentifier);
        if (resolvedId != null) {
            resourceIdentifier = this.buildXMLResourceIdentifier(resolvedId);
        }
        switch ($SwitchMap$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode[_mode.ordinal()]) {
            case 1: 
            case 2: {
                xmlInputSource = this._jaxFrontBaseEntityResolver.resolveEntity(resourceIdentifier);
                break;
            }
            default: {
                xmlInputSource = this._xmlCatalogResolver.resolveEntity(resourceIdentifier);
            }
        }
        return xmlInputSource;
    }

    public String resolveDB(String namespace) throws IOException, CatalogException {
        this.parseCatalogs();
        return this._catalog != null ? this._catalog.resolveURI(namespace) : null;
    }

    private void parseCatalogs() throws IOException, CatalogException {
        if (this.getCatalogList() != null) {
            this._catalog = new JAXFrontCatalog(this._catalogManager);
            this.attachReaderToCatalog(this._catalog);
            for (int i = 0; i < this.getCatalogList().length; ++i) {
                String catalog = this.getCatalogList()[i];
                if (catalog == null || catalog.length() <= 0) continue;
                XMLResourceIdentifier resourceIdentifier = this.buildXMLResourceIdentifier(catalog);
                XMLInputSource inputSource = this._jaxFrontBaseEntityResolver.resolveEntity(resourceIdentifier);
                try {
                    this._catalog.parseCatalog("application/xml", inputSource.getByteStream());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this._catalog = null;
        }
    }

    private void attachReaderToCatalog(Catalog catalog) {
        SAXParserFactoryImpl spf = new SAXParserFactoryImpl();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXCatalogReader saxReader = new SAXCatalogReader((SAXParserFactory)spf);
        saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
        catalog.addReader("application/xml", (CatalogReader)saxReader);
    }

    public String resolveIdentifier(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        if (_mode == EntityResolverMode.LOCAL) {
            return super.resolveIdentifier(resourceIdentifier);
        }
        String resolvedId = null;
        String publicId = resourceIdentifier.getPublicId();
        String systemId = this.getUseLiteralSystemId() ? resourceIdentifier.getLiteralSystemId() : resourceIdentifier.getExpandedSystemId();
        String namespace = resourceIdentifier.getNamespace();
        if (namespace != null) {
            try {
                resolvedId = this.resolveDB(namespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (resolvedId == null) {
            resolvedId = this.resolveURI(namespace);
        }
        if (resolvedId == null) {
            if (publicId != null && systemId != null) {
                resolvedId = this.resolvePublic(publicId, systemId);
            } else if (systemId != null) {
                resolvedId = this.resolveSystem(systemId);
            }
        }
        return resolvedId;
    }

    private XMLResourceIdentifier buildXMLResourceIdentifier(String dbPath) {
        String literalSystemId = "catalog.xml";
        if (_mode == EntityResolverMode.REMOTE) {
            try {
                URL url = new URL(dbPath);
                dbPath = url.getPath().substring(1);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            literalSystemId = dbPath.substring(dbPath.lastIndexOf("/") + 1, dbPath.length());
        } else if (_mode == EntityResolverMode.REMOTE_XUIEDITOR) {
            try {
                URL url = new URL(dbPath);
                if (url.getHost().contains("www.jaxfront.com")) {
                    literalSystemId = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
                    dbPath = JAXFrontURLEntityResolver.newURL(this._jaxFrontBaseEntityResolver.getBasePath(), url.getPath().substring(1), literalSystemId);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new XMLResourceIdentifierImpl(null, literalSystemId, dbPath, null);
    }

    static {
        $SwitchMap$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode = new int[EntityResolverMode.values().length];
        try {
            JAXFrontXMLCatalogResolver.$SwitchMap$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode[EntityResolverMode.REMOTE.ordinal()] = 1;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            JAXFrontXMLCatalogResolver.$SwitchMap$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode[EntityResolverMode.REMOTE_XUIEDITOR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityResolverMode
    extends Enum<EntityResolverMode> {
        public static final EntityResolverMode LOCAL = new EntityResolverMode("LOCAL", 0);
        public static final EntityResolverMode REMOTE = new EntityResolverMode("REMOTE", 1);
        public static final EntityResolverMode REMOTE_XUIEDITOR = new EntityResolverMode("REMOTE_XUIEDITOR", 2);
        private static final /* synthetic */ EntityResolverMode[] $VALUES;

        public static EntityResolverMode[] values() {
            return (EntityResolverMode[])$VALUES.clone();
        }

        public static EntityResolverMode valueOf(String name) {
            return (EntityResolverMode)((Object)Enum.valueOf(class$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode == null ? (class$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode = JAXFrontXMLCatalogResolver.class$("com.jaxfront.core.util.JAXFrontXMLCatalogResolver$EntityResolverMode")) : class$com$jaxfront$core$util$JAXFrontXMLCatalogResolver$EntityResolverMode, name));
        }

        private EntityResolverMode() {
        }

        static {
            $VALUES = new EntityResolverMode[]{LOCAL, REMOTE, REMOTE_XUIEDITOR};
        }
    }
}

