/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.util.ArrayList;
import java.util.List;

public class RollingList {
    private final List items = new ArrayList();
    private int capacity;
    private int position = -1;
    private boolean addEmpty;
    private Object empty;
    private boolean rollingGet = false;

    public RollingList(int capacity) {
        this.capacity = capacity;
        this.addEmpty = false;
    }

    public RollingList(int capacity, boolean rolingGet) {
        this.capacity = capacity;
        this.addEmpty = false;
        this.rollingGet = rolingGet;
    }

    public RollingList(List rolingItems, boolean rolingGet) {
        this.items.addAll(rolingItems);
        this.capacity = this.items.size();
        this.addEmpty = false;
        this.rollingGet = rolingGet;
    }

    public RollingList(Object[] rolingItems, boolean rolingGet) {
        for (int r = 0; r < rolingItems.length; ++r) {
            this.items.add(rolingItems[r]);
        }
        this.capacity = this.items.size();
        this.addEmpty = false;
        this.rollingGet = rolingGet;
    }

    public RollingList(int capacity, Object empty) {
        this.capacity = capacity;
        this.addEmpty = true;
        this.empty = empty;
    }

    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Object get(int index) {
        return this.items.get(index);
    }

    public Object getCurrent() {
        if (this.position == -1) {
            this.position = 0;
        }
        return this.items.get(this.position);
    }

    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    public void clear() {
        this.items.clear();
    }

    public boolean add(Object e) {
        while (this.items.size() > this.capacity - 1) {
            this.items.remove(0);
            --this.position;
        }
        return this.items.add(e);
    }

    public void append(Object e) {
        ++this.capacity;
        this.items.add(e);
    }

    public void append(int pos, Object e) {
        ++this.capacity;
        this.items.add(pos, e);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean hasNext() {
        return this.items.size() > this.position + 1 || this.items.size() > this.position && this.addEmpty;
    }

    public Object getNext() {
        if (this.rollingGet && this.position + 1 >= this.items.size()) {
            this.position = -1;
        }
        if (this.items.size() > this.position + 1 || !this.addEmpty) {
            return this.get(++this.position);
        }
        ++this.position;
        return this.empty;
    }

    public boolean hasPrevious() {
        return 0 < this.position;
    }

    public Object getPrevious() {
        if (this.rollingGet && this.position - 1 < 0) {
            this.position = this.items.size();
        }
        return this.get(--this.position);
    }

    public void seekToEnd() {
        this.position = this.items.size();
    }

    public void seekToStart() {
        this.position = -1;
    }

    public void seekTo(Object o) {
        if (o != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (o == null || !o.equals(this.items.get(i))) continue;
                this.position = i;
                return;
            }
        }
    }

    public List getList() {
        return new ArrayList(this.items);
    }

    public static void main(String[] args) {
        RollingList rlist = new RollingList(6, true);
        rlist.add("1");
        rlist.add("2");
        rlist.add("3");
        rlist.add("4");
        rlist.add("5");
        rlist.add("6");
        for (int i = 0; i < 32; ++i) {
            System.out.println(rlist.getNext());
        }
    }

    public void rollingGet(boolean rollingGet) {
        this.rollingGet = rollingGet;
    }
}

