/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.xpath.XPNode;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.core.xpath.XPathNodeExtractor;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class URLHelper {
    public static final String URL_SEPARATOR = "/";
    public static final String CONFIG_DIRECTORY = "config";
    public static final String EXAMPLES_DIRECTORY = "examples";
    private static final String JSESSIONID = "jsessionid=";
    public static URL _xuiXsdURL;

    public static URL getXUIXsdURL() {
        if (_xuiXsdURL == null) {
            String xuiXSDName = JAXFrontProperties.getInstance().getXuiXsdPath();
            if (xuiXSDName != null && URLHelper.doesUrlExist(_xuiXsdURL = URLHelper.getUserURL(null, xuiXSDName))) {
                return _xuiXsdURL;
            }
            _xuiXsdURL = URLHelper.class.getClassLoader().getResource("xui.xsd");
        }
        return _xuiXsdURL;
    }

    public static URI getUri(String path) throws URISyntaxException {
        path = TextTools.replace(path, " ", "%20");
        path = TextTools.replace(path, "\\", URL_SEPARATOR);
        return new URI(path);
    }

    public static URI getUri(URL url) throws URISyntaxException {
        return URLHelper.getUri(url.toExternalForm());
    }

    public static StringBuffer readResponse(HttpURLConnection con) throws IOException {
        InputStream is = con.getInputStream();
        int readCounter = 0;
        byte[] readBuffer = new byte[10000];
        StringBuffer respBuffer = new StringBuffer();
        while ((readCounter = is.read(readBuffer)) > -1) {
            respBuffer.append(new String(readBuffer));
        }
        return respBuffer;
    }

    public static void writeResponse(HttpURLConnection con, String content) throws IOException {
        OutputStream out = con.getOutputStream();
        FileHelper.write(new ByteArrayInputStream(content.getBytes()), out);
        out.flush();
        out.close();
    }

    public static HttpURLConnection doSend(String aUrl2S, String sessionId, byte[] content, String encoding, boolean contentAsParameter) throws MalformedURLException, IOException, ProtocolException {
        if (contentAsParameter) {
            aUrl2S = aUrl2S + "&content=" + TextTools.encodeBase64Ziped(content);
        }
        URL aUrl2 = new URL(aUrl2S);
        HttpURLConnection con = (HttpURLConnection)aUrl2.openConnection();
        if (sessionId != null) {
            con.setRequestProperty("Cookie", "JSESSIONID=" + sessionId);
        }
        con.setUseCaches(false);
        con.setDefaultUseCaches(false);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + encoding);
        con.setRequestProperty("Content-Length", "0");
        con.setRequestMethod("POST");
        if (!contentAsParameter && content != null) {
            con.setRequestProperty("Content-Length", content != null ? content.length + "" : "0");
            OutputStream os = con.getOutputStream();
            os.write(content);
            os.flush();
        }
        return con;
    }

    public static String extractSessionId(String response) {
        int jsessStart = response.indexOf(JSESSIONID);
        int jsessEnd = jsessStart + 43;
        String temp = response.substring(jsessStart, jsessEnd);
        return temp.substring(JSESSIONID.length());
    }

    public static InputStream openStream(URL from) throws IOException {
        if (from != null) {
            return from.openStream();
        }
        return null;
    }

    public static URLConnection openConnection(URL from) throws IOException {
        return from.openConnection();
    }

    public static URL getUrlFromUri(URI uri) throws MalformedURLException {
        return new URL(uri.toString().replaceAll("%20", " "));
    }

    public static URL getUserURL(URL targetURL, String url, boolean lookupInternal) {
        URL userURL = null;
        if (JAXFrontProperties.getInstance().getURLBase() != null && !JAXFrontProperties.getInstance().getURLBase().equals("null")) {
            targetURL = URLHelper.getUserURL(JAXFrontProperties.getInstance().getURLBase());
        }
        if ((userURL = URLHelper.getUserURL(url, lookupInternal)) == null) {
            try {
                URI userURI = URLHelper.resolve(targetURL, url);
                if (userURI != null) {
                    userURL = userURI.toURL();
                }
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(URLHelper.class, "resolved url from :" + targetURL + " " + url + " is:" + userURL);
        }
        return userURL;
    }

    public static URL getUserURL(URL targetURL, String url) {
        return URLHelper.getUserURL(targetURL, url, true);
    }

    public static URL getUserURL(String url) {
        return URLHelper.getUserURL(url, true);
    }

    public static URL getUserURL(String url, boolean lookupInternal) {
        URL userURL = null;
        if (url != null) {
            try {
                userURL = new URL(url);
                if (userURL != null) {
                    return userURL;
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            try {
                File userFile = new File(url);
                if (userFile.exists()) {
                    userURL = userFile.toURL();
                }
                if (userURL != null) {
                    return userURL;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (lookupInternal) {
                userURL = URLHelper.getInternalURL(url);
            }
        }
        return userURL;
    }

    public static URL getPluginsURL() {
        return URLHelper.getInternalURL("config/plugins.xml");
    }

    public static URL getActionsURL() {
        return URLHelper.getInternalURL("config/actions.xml");
    }

    public static String getLanguage(String nlsFileName) {
        int indexOfUnder = nlsFileName.lastIndexOf(95);
        int lastIndexOfDot = nlsFileName.lastIndexOf(".");
        if (indexOfUnder != -1 && lastIndexOfDot != -1) {
            return nlsFileName.substring(indexOfUnder + 1, lastIndexOfDot);
        }
        return nlsFileName;
    }

    public static URL getHelpTemplateURL() {
        return URLHelper.getInternalURL("config/helpTemplate.html");
    }

    public static URL getFunctionsURL() {
        return URLHelper.getInternalURL("config/functions.xml");
    }

    public static URL getFunctionsXSDURL() {
        return URLHelper.getInternalURL("functions.xsd");
    }

    public static URL getPluginsXSDURL() {
        return URLHelper.getInternalURL("plugins.xsd");
    }

    public static URL getPreferencesXSDURL() {
        return URLHelper.getInternalURL("property.xsd");
    }

    public static URL getUserHomeURL(String relativeURL) {
        String pathName = System.getProperty("user.home") + File.separator + relativeURL;
        File file = new File(pathName);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getInternalURL(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        URL urlFound = URLHelper.class.getClassLoader().getResource(url);
        if (urlFound == null) {
            try {
                File userFile = new File(url);
                if (userFile.exists()) {
                    urlFound = userFile.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (urlFound == null && LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(URLHelper.class, "Try resolve url (" + url + "). URL not found.");
        }
        return urlFound;
    }

    public static int getHostPort(String url) {
        String host_port = url.substring(url.indexOf("://") + 3, url.length());
        boolean hasPort = host_port.indexOf(":") != -1;
        String port = null;
        if (hasPort) {
            int index = (host_port = host_port.substring(host_port.indexOf(":") + 1, host_port.length())).indexOf(URL_SEPARATOR);
            if (index == -1) {
                index = host_port.length();
            }
            port = host_port.substring(host_port.indexOf(":") + 1, index);
        }
        if (port != null) {
            return Integer.parseInt(port);
        }
        return -1;
    }

    public static void writeToUrl(URL storeToUrl, char[] buffer) throws IOException {
        URLConnection connection = storeToUrl.openConnection();
        connection.setDoOutput(true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        writer.write(buffer.toString());
        writer.close();
    }

    public static String getHostAddress(String url) {
        String host_port = url.substring(url.indexOf("://") + 3, url.length());
        boolean hasPort = host_port.indexOf(":") != -1;
        int index = hasPort ? host_port.indexOf(":") : host_port.indexOf(URL_SEPARATOR);
        String host = null;
        host = index != -1 ? host_port.substring(0, index) : host_port;
        return host;
    }

    public static File getFile(URL url) {
        String fileName = url.getFile();
        if (System.getProperty("os.name").startsWith("Windows")) {
            fileName = TextTools.replace(fileName, "%20", " ");
        }
        return new File(fileName);
    }

    public static URL createNLSURL(URL xuiUrl, String language) {
        return URLHelper.getUserURL(URLHelper.createNLSFilePathLocation(xuiUrl, language));
    }

    public static boolean isDefinedLanguage(String language) {
        String[] languages = JAXFrontProperties.getInstance().getLanguages();
        for (int i = 0; i < languages.length; ++i) {
            if (languages[i] == null || !languages[i].equals(language)) continue;
            return true;
        }
        return false;
    }

    public static String createNLSFilePathLocation(URL xuiUrl, String language) {
        if (xuiUrl != null && language != null) {
            String nlsFileName = xuiUrl.toExternalForm();
            int indexOfUnder = nlsFileName.lastIndexOf(95);
            int lastIndexOfDot = nlsFileName.lastIndexOf(".");
            if (xuiUrl.getFile().indexOf(".") < 0) {
                lastIndexOfDot = -1;
            }
            if ((nlsFileName = indexOfUnder != -1 && URLHelper.isDefinedLanguage(nlsFileName.substring(indexOfUnder + 1, lastIndexOfDot)) ? nlsFileName.substring(0, indexOfUnder) + "_" + language + ".nls" : (lastIndexOfDot >= 0 ? nlsFileName.substring(0, lastIndexOfDot) + "_" + language + ".nls" : nlsFileName + "_" + language + ".nls")) != null) {
                nlsFileName = TextTools.replace(nlsFileName, "%20", " ");
            }
            return nlsFileName;
        }
        return null;
    }

    public static String createNLSFileName(URL xuiUrl, String language) {
        return URLHelper.createFileNameWithSuffix(xuiUrl, language, ".nls");
    }

    public static String createFileNameWithSuffix(URL xuiUrl, String suffix, String extension) {
        return URLHelper.createFileNameWithSuffix(xuiUrl, xuiUrl.toExternalForm(), suffix, extension);
    }

    public static String createFileNameWithSuffix(String fileName, String suffix, String extension) {
        return URLHelper.createFileNameWithSuffix(null, fileName, suffix, extension);
    }

    private static String createNameWithSuffix(URL xuiURL, String fileName, String suffix, String extension, int lastSeparator) {
        if (lastSeparator != -1) {
            int lastPoint = fileName.lastIndexOf(".");
            if (xuiURL != null && xuiURL.getFile() != null && xuiURL.getFile().indexOf(".") < 0) {
                lastPoint = -1;
            }
            if (lastPoint != -1) {
                if (extension == null) {
                    extension = fileName.substring(lastPoint, fileName.length());
                }
                fileName = suffix != null ? fileName.substring(lastSeparator, lastPoint) + "_" + suffix + extension : fileName.substring(lastSeparator, lastPoint) + extension;
            }
        }
        return fileName;
    }

    public static String createFileNameWithSuffix(URL xuiURL, String fileName, String suffix, String extension) {
        int lastSeparator = fileName.lastIndexOf(URL_SEPARATOR);
        lastSeparator = lastSeparator == -1 ? 0 : ++lastSeparator;
        return URLHelper.createNameWithSuffix(xuiURL, fileName, suffix, extension, lastSeparator);
    }

    public static String createNameWithSuffix(URL xuiURL, String fileName, String suffix, String extension) {
        return URLHelper.createNameWithSuffix(xuiURL, fileName, suffix, extension, 0);
    }

    public static String createNLSURLName(URL xuiUrl, String language) {
        String nlsFileName = xuiUrl.toExternalForm();
        int indexOfUnder = nlsFileName.lastIndexOf(95);
        int lastIndexOfDot = nlsFileName.lastIndexOf(".");
        if (xuiUrl.getFile().indexOf(".") < 0) {
            lastIndexOfDot = -1;
        }
        nlsFileName = indexOfUnder != -1 && URLHelper.isDefinedLanguage(nlsFileName.substring(indexOfUnder, lastIndexOfDot)) ? nlsFileName.substring(0, indexOfUnder) + "_" + language + ".nls" : nlsFileName.substring(0, lastIndexOfDot) + "_" + language + ".nls";
        return nlsFileName;
    }

    public static String extractFileName(String path) {
        File f = new File(path);
        return f.getName();
    }

    public static URL getParentURL(URL aUrl) {
        block4: {
            if (aUrl != null) {
                String externalURL = aUrl.toExternalForm();
                int lastIndexOfPathSeparator = externalURL.lastIndexOf(URL_SEPARATOR);
                if (lastIndexOfPathSeparator > -1) {
                    externalURL = externalURL.substring(0, lastIndexOfPathSeparator);
                }
                try {
                    return new URL(externalURL);
                }
                catch (MalformedURLException e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block4;
                    LogRegistry.getInstance().warn(URLHelper.class, "Can't create upper path for:" + externalURL);
                }
            }
        }
        return null;
    }

    public static URL getDefaultXUILocationURL(URL baseUrl) {
        if (baseUrl == null) {
            return null;
        }
        File baseFile = new File(baseUrl.getPath());
        String schemaFileName = baseFile.getName();
        String xuiFileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".xui";
        URL xuiURL = URLHelper.getUserURL(baseUrl, xuiFileName);
        return xuiURL;
    }

    public static URL getDefaultXSDLocationURL(URL baseUrl) {
        File baseFile = new File(baseUrl.getPath());
        String schemaFileName = baseFile.getName();
        String xsdFileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".xsd";
        URL xuiURL = URLHelper.getUserURL(baseUrl, xsdFileName);
        return xuiURL;
    }

    public static URL getDefaultXMLLocationURL(URL baseUrl) {
        File baseFile = new File(baseUrl.getPath());
        String schemaFileName = baseFile.getName();
        String xmlFileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".xml";
        URL xuiURL = URLHelper.getUserURL(baseUrl, xmlFileName);
        return xuiURL;
    }

    public static URL getDefaultLocationURL(URL baseUrl, String extension) {
        File baseFile = new File(baseUrl.getPath());
        String schemaFileName = baseFile.getName();
        String xmlFileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + extension;
        URL xuiURL = URLHelper.getUserURL(baseUrl, xmlFileName);
        return xuiURL;
    }

    public static boolean doesUrlExist(URL url) {
        boolean urlExists = false;
        if (url != null) {
            try {
                JAXFrontProperties.getInstance().getURLResolver().resolveURL(url);
                urlExists = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return urlExists;
    }

    public static boolean pointToSameFolder(URL url1, URL url2) {
        String firstUrl = url1.toExternalForm();
        String secondUrl = url2.toExternalForm();
        firstUrl = firstUrl.substring(firstUrl.lastIndexOf(URL_SEPARATOR));
        secondUrl = secondUrl.substring(secondUrl.lastIndexOf(URL_SEPARATOR));
        return firstUrl.equals(secondUrl);
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + "../";
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + URL_SEPARATOR;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static URI resolve(String base, String rel) {
        URI relPath = null;
        URI baseUri = URI.create(base);
        URI relUri = URI.create(rel);
        relPath = baseUri.resolve(relUri);
        return relPath;
    }

    public static URI relativize(URL base, URL rel) {
        URI relPath = null;
        try {
            URI baseUri = URLHelper.getUri(base);
            URI relUri = URLHelper.getUri(rel);
            relPath = baseUri.relativize(relUri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return relPath;
    }

    public static String canonicalize(String path) {
        if (path == null || path.length() == 0 || path.indexOf("..") == -1) {
            return path;
        }
        try {
            path = StringUtil.replace(path, "\\", URL_SEPARATOR);
            boolean withSlash = false;
            Stack<String> resultStack = new Stack<String>();
            List nodes = XPathNodeExtractor.tokenize(path, false);
            for (int i = 0; i < nodes.size(); ++i) {
                String name = ((XPNode)nodes.get(i)).getNodeName();
                if (name.equals("..")) {
                    if (resultStack.size() <= 0) continue;
                    resultStack.pop();
                    continue;
                }
                if (name.equals(".")) continue;
                resultStack.push(name);
            }
            int sSize = resultStack.size();
            StringBuffer result = new StringBuffer();
            for (int r = 0; r < sSize; ++r) {
                result.append(resultStack.get(r));
                if (r + 1 >= sSize) continue;
                result.append(URL_SEPARATOR);
            }
            return result.toString();
        }
        catch (XPathError xPathError) {
            return path;
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println(URLHelper.canonicalize("resources/AUDIOHUB/../../eform_base_search.xui"));
        System.out.println(URLHelper.relativize(new File("").toURL(), new File("resources/AUDIOHUB/../../eform_base_search.xui").toURL()));
        System.out.println(URLHelper.canonicalize("test1/test/resources/AUDIOHUB/../../eform_base_search.xui"));
        System.out.println(URLHelper.relativize(new File("").toURL(), new File("test1/test/resources/AUDIOHUB/../../eform_base_search.xui").toURL()));
        System.out.println(URLHelper.canonicalize("/test1/test/resources/AUDIOHUB/../../eform_base_search.xui"));
        System.out.println(URLHelper.relativize(new File("").toURL(), new File("/test1/test/resources/AUDIOHUB/../../eform_base_search.xui").toURL()));
    }

    public static URI relativize(URL base, URI rel) {
        URI relPath = null;
        try {
            URI baseUri = URLHelper.getUri(base);
            URI relUri = rel;
            relPath = baseUri.relativize(relUri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return relPath;
    }

    public static URI resolve(URL base, String rel) {
        URI resolvedURI = null;
        URI relUri = null;
        try {
            if (base != null) {
                URL foundURL;
                URI baseUri = URLHelper.getUri(base);
                relUri = URLHelper.getUri(rel);
                if (baseUri != null) {
                    resolvedURI = baseUri.resolve(relUri);
                }
                if (resolvedURI != null && relUri == resolvedURI && (foundURL = new URL(base, rel)) != null) {
                    resolvedURI = new URI(foundURL.toString());
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return resolvedURI;
    }

    public static String getRelativePath(URL base, URL rel) {
        URI uri = URLHelper.relativize(base, rel);
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public static String getRelativePath(File home, File f) {
        if (home.isFile()) {
            home = home.getParentFile();
        }
        List homelist = URLHelper.getPathList(home);
        List filelist = URLHelper.getPathList(f);
        String s = homelist == null || filelist == null ? f.getName() : URLHelper.matchPathLists(homelist, filelist);
        return s;
    }

    public static String getFileName(URL url) {
        if (url == null) {
            return null;
        }
        return URLHelper.getFile(url).getName();
    }

    public static boolean isUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public boolean checkURL(String url) {
        try {
            return this.checkURL(new URL(url));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkURL(URL url) {
        boolean isOK = false;
        try {
            URLConnection urlc;
            int responseCode;
            String protocol = url.getProtocol();
            isOK = protocol.equals("file") ? new File(url.getFile()).exists() : (responseCode = ((HttpURLConnection)(urlc = url.openConnection())).getResponseCode()) == 200;
        }
        catch (Exception e) {
            isOK = false;
        }
        return isOK;
    }

    public static URL getXMLDBMappingURL(URL xsdURL, URL xuiURL) {
        URL xmlMappingURL = null;
        try {
            String schemaFileName = null;
            String fileName = null;
            String path = null;
            path = xuiURL == null && xsdURL != null ? xsdURL.getPath() : xuiURL.getPath();
            File baseFile = new File(path);
            schemaFileName = baseFile.getName();
            fileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".dbm";
            xmlMappingURL = URLHelper.getUserURL(xuiURL, fileName);
            try {
                JAXFrontProperties.getInstance().getURLResolver().resolveURL(xmlMappingURL);
            }
            catch (Throwable t) {
                baseFile = new File(xsdURL.getPath());
                schemaFileName = baseFile.getName();
                fileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".dbm";
                xmlMappingURL = URLHelper.getUserURL(xsdURL, fileName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return xmlMappingURL;
    }

    public static URL getJAXFormsURL(URL xsdURL, URL xuiURL) {
        URL xmlMappingURL = null;
        try {
            String schemaFileName = null;
            String fileName = null;
            if (xuiURL != null) {
                File baseFile = new File(xuiURL.getPath());
                schemaFileName = baseFile.getName();
                fileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".jax";
                xmlMappingURL = URLHelper.getUserURL(xuiURL, fileName);
                try {
                    JAXFrontProperties.getInstance().getURLResolver().resolveURL(xmlMappingURL);
                }
                catch (Throwable t) {
                    baseFile = new File(xsdURL.getPath());
                    schemaFileName = baseFile.getName();
                    fileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".jax";
                    xmlMappingURL = URLHelper.getUserURL(xsdURL, fileName);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return xmlMappingURL;
    }

    public static boolean urlResourceExist(URL resURL) {
        try {
            InputStream testStream = URLHelper.openStream(resURL);
            testStream.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static File urlToFile(URL url) {
        URI uri;
        try {
            uri = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException e1) {
                throw new IllegalArgumentException("broken URL: " + url);
            }
        }
        return new File(uri);
    }
}

