/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class WeakListModel
implements ListModel,
Serializable {
    private final Object present = new Object();
    private Map listenerList = Collections.synchronizedMap(new WeakHashMap());
    private ArrayList delegate = new ArrayList();

    WeakListModel() {
    }

    public int getSize() {
        return this.delegate.size();
    }

    public Object getElementAt(int index) {
        return this.delegate.get(index);
    }

    public void trimToSize() {
        this.delegate.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Enumeration elements() {
        return Collections.enumeration(this.delegate);
    }

    public boolean contains(Object elem) {
        return this.delegate.contains(elem);
    }

    public int indexOf(Object elem) {
        return this.delegate.indexOf(elem);
    }

    public int lastIndexOf(Object elem) {
        return this.delegate.lastIndexOf(elem);
    }

    public Object elementAt(int index) {
        return this.delegate.get(index);
    }

    public Object firstElement() {
        return this.delegate.get(0);
    }

    public Object lastElement() {
        return this.delegate.get(this.delegate.size() - 1);
    }

    public void setElementAt(Object obj, int index) {
        this.delegate.set(index, obj);
        this.fireContentsChanged(this, index, index);
    }

    public void removeElementAt(int index) {
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void insertElementAt(Object obj, int index) {
        this.delegate.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElement(Object obj) {
        int index = this.delegate.size();
        this.delegate.add(obj);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean removeElement(Object obj) {
        int index = this.indexOf(obj);
        boolean rv = this.delegate.remove(obj);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public void removeAllElements() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public synchronized void addListDataListener(ListDataListener l) {
        this.listenerList.put(l, this.present);
    }

    public synchronized void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(l);
    }

    protected synchronized void fireContentsChanged(Object source, int index0, int index1) {
        ListDataEvent e = null;
        HashSet set = new HashSet(this.listenerList.keySet());
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            ListDataListener ldl = (ListDataListener)iter.next();
            ldl.contentsChanged(e);
        }
    }

    protected synchronized void fireIntervalAdded(Object source, int index0, int index1) {
        ListDataEvent e = null;
        HashSet set = new HashSet(this.listenerList.keySet());
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (e == null) {
                e = new ListDataEvent(source, 1, index0, index1);
            }
            ListDataListener ldl = (ListDataListener)iter.next();
            ldl.intervalAdded(e);
        }
    }

    protected synchronized void fireIntervalRemoved(Object source, int index0, int index1) {
        ListDataEvent e = null;
        HashSet set = new HashSet(this.listenerList.keySet());
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (e == null) {
                e = new ListDataEvent(source, 2, index0, index1);
            }
            ListDataListener ldl = (ListDataListener)iter.next();
            ldl.intervalRemoved(e);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        Set set = this.listenerList.keySet();
        return set.toArray(new EventListener[0]);
    }
}

