/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.IOException;
import java.io.InputStream;

public class CombinedInputStream
extends InputStream {
    private int current = 0;
    boolean isNextLineFeed = false;
    private final InputStream[] streams;

    public CombinedInputStream(InputStream[] streams) {
        this.streams = streams;
    }

    public int read() throws IOException {
        if (this.isNextLineFeed) {
            this.isNextLineFeed = false;
            return 10;
        }
        int i = -1;
        if (this.current < this.streams.length && (i = this.streams[this.current].read()) == -1) {
            this.isNextLineFeed = true;
            ++this.current;
            return this.read();
        }
        return i;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].close();
        }
    }

    public int available() throws IOException {
        return this.current < this.streams.length ? this.streams[this.current].available() : 0;
    }
}

