/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LanguageEnhancedProperties;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.csv.CsvWriter;
import com.jaxfront.core.util.sort.FastQSort;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class HelpExport {
    private String[] _languages = null;
    private URL _xuiLocationPath = null;
    private String _defaultLanguage = null;
    private Writer _destination = null;
    private Hashtable _nlsContent;
    private char _separator = (char)59;

    private StringBuffer extractNLS(Writer destination) throws IOException {
        Hashtable langProps = null;
        StringBuffer result = new StringBuffer();
        langProps = this._nlsContent == null ? this.getFilePropteries(this.buildLanguageFileURLS(this._languages)) : this.getFilePropteriesFromString(this._nlsContent);
        LanguageEnhancedProperties masterLangProperty = (LanguageEnhancedProperties)langProps.get(this._defaultLanguage);
        Iterator masterLangPropertyKeys = masterLangProperty.keySet().iterator();
        CsvWriter writer = new CsvWriter(destination, this.getSeparator());
        String[] header = new String[this._languages.length + 1];
        header[0] = "id";
        System.arraycopy(this._languages, 0, header, 1, this._languages.length);
        writer.writeRecord(header);
        writer.setEscapeMode(2);
        writer.setTextQualifier('\"');
        writer.setUseTextQualifier(true);
        int r = 0;
        while (masterLangPropertyKeys.hasNext()) {
            Vector<String> values = new Vector<String>();
            ++r;
            String propKey = (String)masterLangPropertyKeys.next();
            values.add(propKey);
            for (int i = 0; i < this._languages.length; ++i) {
                LanguageEnhancedProperties aLangProp = (LanguageEnhancedProperties)langProps.get(this._languages[i]);
                if (aLangProp == null) continue;
                String asinglePropValue = (String)aLangProp.get(propKey);
                values.add(asinglePropValue != null ? asinglePropValue : "<n.a.>");
            }
            writer.writeRecord(ArrayUtil.toStringArray(values));
        }
        destination.flush();
        destination.close();
        return result;
    }

    private StringBuffer extractMergedNLS(Writer osw) throws IOException {
        Hashtable langProps = null;
        StringBuffer result = new StringBuffer();
        langProps = this._nlsContent == null ? this.getFilePropteries(this.buildLanguageFileURLS(this._languages)) : this.getFilePropteriesFromString(this._nlsContent);
        LanguageEnhancedProperties masterLangProperty = (LanguageEnhancedProperties)langProps.get(this._defaultLanguage);
        Hashtable allKeys = new Hashtable();
        Enumeration registeredProps = langProps.keys();
        while (registeredProps.hasMoreElements()) {
            Object aRegNLSPropKey = registeredProps.nextElement();
            allKeys.putAll(MapHelper.toMap(((Hashtable)langProps.get(aRegNLSPropKey)).keys()));
        }
        Enumeration masterLangPropertyKeys = allKeys.keys();
        CsvWriter writer = new CsvWriter(osw, this.getSeparator());
        writer.setEscapeMode(2);
        writer.setTextQualifier('\"');
        writer.setUseTextQualifier(true);
        String[] header = new String[this._languages.length + 1];
        header[0] = "id";
        System.arraycopy(this._languages, 0, header, 1, this._languages.length);
        writer.writeRecord(header);
        int r = 0;
        while (masterLangPropertyKeys.hasMoreElements()) {
            Vector<String> values = new Vector<String>();
            ++r;
            String propKey = (String)masterLangPropertyKeys.nextElement();
            values.add(propKey);
            for (int i = 0; i < this._languages.length; ++i) {
                LanguageEnhancedProperties aLangProp = (LanguageEnhancedProperties)langProps.get(this._languages[i]);
                if (aLangProp == null) continue;
                String asinglePropValue = (String)aLangProp.get(propKey);
                values.add(asinglePropValue != null ? asinglePropValue : "<n.a.>");
            }
            writer.writeRecord(ArrayUtil.toStringArray(values));
        }
        osw.flush();
        osw.close();
        return result;
    }

    private StringBuffer extractMergedNLSAsGridXML() throws IOException {
        Hashtable langProps = null;
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<grid>");
        xml.append("<definition>");
        langProps = this._nlsContent == null ? this.getFilePropteries(this.buildLanguageFileURLS(this._languages)) : this.getFilePropteriesFromString(this._nlsContent);
        LanguageEnhancedProperties masterLangProperty = (LanguageEnhancedProperties)langProps.get(this._defaultLanguage);
        Hashtable allKeys = new Hashtable();
        Enumeration registeredProps = langProps.keys();
        while (registeredProps.hasMoreElements()) {
            Object aRegNLSPropKey = registeredProps.nextElement();
            allKeys.putAll((HashMap)langProps.get(aRegNLSPropKey));
        }
        Enumeration masterLangPropertyKeys = allKeys.keys();
        String[] sortedKeys = this.getSortedKeys(allKeys);
        int r = 0;
        for (int k = 0; k < sortedKeys.length; ++k) {
            Vector<String> values = new Vector<String>();
            ++r;
            String propKey = sortedKeys[k];
            values.add(propKey);
            for (int i = 0; i < this._languages.length; ++i) {
                LanguageEnhancedProperties aLangProp = (LanguageEnhancedProperties)langProps.get(this._languages[i]);
                if (aLangProp == null) continue;
                String asinglePropValue = (String)aLangProp.get(propKey);
                values.add(asinglePropValue != null ? asinglePropValue : "<n.a.>");
            }
            String[] row = ArrayUtil.toStringArray(values);
            String id = StringUtil.escapeXML(row[0]);
            xml.append("<row name=\"" + id + "\" id=\"" + id + "\">");
            for (int i = 1; i < row.length; ++i) {
                String value = row[i];
                String language = this._languages[i - 1];
                if ("<n.a.>".equals(value)) {
                    value = "";
                } else {
                    value = StringUtil.escapeXML(row[i]);
                    value = StringUtil.escapeHTML(value);
                }
                xml.append("<col id=\"" + language + "\" name=\"" + language + "\" >");
                xml.append("<v colID=\"" + id + "\" rowID=\"" + id + "\" gridID=\"" + id + "\" name=\"" + id + "\" >" + value + "</v>");
                xml.append("</col>");
            }
            xml.append("</row>");
        }
        xml.append("</definition>");
        xml.append("</grid>");
        return xml;
    }

    private String[] getSortedKeys(Hashtable all) {
        Object[] sortedKeys = new String[all.size()];
        Enumeration allKeys = all.keys();
        int i = 0;
        while (allKeys.hasMoreElements()) {
            sortedKeys[i] = (String)allKeys.nextElement();
            ++i;
        }
        FastQSort.sortArray(sortedKeys, FastQSort.getStringComparator());
        return sortedKeys;
    }

    public static void export(File dest, URL mainLanguageURL, String language, char separator) throws IOException {
        if (dest != null && mainLanguageURL != null && language != null && !language.equals("")) {
            HelpExport.getInstance(dest, mainLanguageURL, language, separator).doExport();
        }
    }

    public static void exportMerged(Writer dest, Hashtable nlsContent, String language, String[] languages, char separator) throws IOException {
        if (dest != null && nlsContent != null && language != null && !language.equals("")) {
            HelpExport.getInstance(dest, nlsContent, language, languages, separator).doMergedExport();
        }
    }

    public static StringBuffer exportMergedXML(Hashtable nlsContent, String language, String[] languages) throws IOException {
        if (nlsContent != null && language != null && !language.equals("")) {
            return HelpExport.getInstance((Writer)null, nlsContent, language, languages).extractMergedNLSAsGridXML();
        }
        return null;
    }

    private void doExport() throws IOException {
        this.extractNLS(this._destination).toString();
    }

    private void doMergedExport() throws IOException {
        this.extractMergedNLS(this._destination).toString();
    }

    private void inititialize(File destination, URL mainLanguageURL, String language, char separator) throws FileNotFoundException {
        this._xuiLocationPath = mainLanguageURL;
        this._defaultLanguage = language;
        this._languages = JAXFrontProperties.getInstance().getLanguages();
        this._destination = new OutputStreamWriter(new FileOutputStream(destination));
        this._separator = separator;
    }

    private void inititialize(Writer destination, Hashtable nlsContent, String language, String[] languages) {
        this.setNLSContent(nlsContent);
        this._defaultLanguage = language;
        this._languages = languages == null ? JAXFrontProperties.getInstance().getLanguages() : languages;
        this._destination = destination;
    }

    private void inititialize(Writer destination, Hashtable nlsContent, String language, String[] languages, char separator) {
        this.setNLSContent(nlsContent);
        this._defaultLanguage = language;
        this._languages = languages == null ? JAXFrontProperties.getInstance().getLanguages() : languages;
        this._destination = destination;
        this._separator = separator;
    }

    private Hashtable getFilePropteries(Hashtable langURLS) {
        Enumeration urlKeys = langURLS.keys();
        Hashtable<String, LanguageEnhancedProperties> result = new Hashtable<String, LanguageEnhancedProperties>();
        while (urlKeys.hasMoreElements()) {
            String aKey = (String)urlKeys.nextElement();
            String lang = URLHelper.getLanguage(aKey);
            URL urlToProp = (URL)langURLS.get(aKey);
            LanguageEnhancedProperties aLangProp = new LanguageEnhancedProperties();
            try {
                InputStreamReader propIn = new InputStreamReader(JAXFrontProperties.getInstance().getURLResolver().resolveURL(urlToProp), JAXFrontProperties.getDefaultFileEncoding());
                aLangProp.load(propIn);
                if (result.get(lang) != null) {
                    ((LanguageEnhancedProperties)result.get(lang)).putAll(aLangProp);
                } else {
                    result.put(lang, aLangProp);
                }
                propIn.close();
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), "Can't find URL:" + urlToProp.toExternalForm() + " building default!");
                result.put(lang, new LanguageEnhancedProperties());
            }
        }
        return result;
    }

    private Hashtable getFilePropteriesFromString(Hashtable langURLS) {
        Enumeration urlKeys = langURLS.keys();
        Hashtable<String, LanguageEnhancedProperties> result = new Hashtable<String, LanguageEnhancedProperties>();
        for (int i = 0; this._languages != null && i < this._languages.length; ++i) {
            LanguageEnhancedProperties aLangProp = new LanguageEnhancedProperties();
            result.put(this._languages[i], aLangProp);
        }
        while (urlKeys.hasMoreElements()) {
            String aKey = (String)urlKeys.nextElement();
            String nlsContent = (String)langURLS.get(aKey);
            String lang = URLHelper.getLanguage(aKey);
            LanguageEnhancedProperties aLangProp = new LanguageEnhancedProperties();
            try {
                StringReader reader = new StringReader(nlsContent);
                aLangProp.load(reader);
                if (result.get(lang) != null) {
                    ((LanguageEnhancedProperties)result.get(lang)).putAll(aLangProp);
                } else {
                    result.put(lang, aLangProp);
                }
                reader.close();
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), "Can't find URL:" + aKey + " building default!");
                result.put(aKey, new LanguageEnhancedProperties());
            }
        }
        return result;
    }

    private Hashtable getNLSContent() {
        return this._nlsContent;
    }

    private void setNLSContent(Hashtable content) {
        this._nlsContent = content;
    }

    private Hashtable buildLanguageFileURLS(String[] langs) {
        Hashtable<String, URL> languageURLS = new Hashtable<String, URL>();
        for (int i = 0; i < langs.length; ++i) {
            String aLang = langs[i];
            URL aUrl = URLHelper.createNLSURL(this._xuiLocationPath, aLang);
            if (aUrl == null) {
                try {
                    aUrl = new URL(URLHelper.createNLSURLName(this._xuiLocationPath, aLang));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            languageURLS.put(aLang, aUrl);
        }
        return languageURLS;
    }

    private static HelpExport getInstance(File dest, URL mainLanguageURL, String language, char separator) throws FileNotFoundException {
        return new HelpExport(dest, mainLanguageURL, language, separator);
    }

    private static HelpExport getInstance(Writer dest, Hashtable nlsContent, String language, String[] languages) {
        return new HelpExport(dest, nlsContent, language, languages);
    }

    private static HelpExport getInstance(Writer dest, Hashtable nlsContent, String language, String[] languages, char separator) {
        return new HelpExport(dest, nlsContent, language, languages, separator);
    }

    private HelpExport(File dest, URL mainLanguageURL, String language, char separator) throws FileNotFoundException {
        this.inititialize(dest, mainLanguageURL, language, separator);
    }

    private HelpExport(Writer dest, Hashtable nlsContent, String language, String[] languages) {
        this.inititialize(dest, nlsContent, language, languages);
    }

    private HelpExport(Writer dest, Hashtable nlsContent, String language, String[] languages, char separator) {
        this.inititialize(dest, nlsContent, language, languages, separator);
    }

    public static void main(String[] args) throws IOException {
        String de = "key1=de\nkey2=c1\nkey3=c2\nkey4=c3\n";
        String fr = "key1=fr\nkey2=c1\nkey3=c2\nkey4=c3\n";
        String en = "key1=en\nkey2=c1\nkey3=c2\nkey4=c3\n";
        Hashtable<String, String> content = new Hashtable<String, String>();
        content.put("de", de);
        content.put("en", en);
        content.put("fr", fr);
        FileOutputStream fos = new FileOutputStream(new File("c:/temp/test.csv"));
        HelpExport.exportMerged(new OutputStreamWriter(fos), content, "de", new String[]{"de", "fr", "en", "it", "br"}, ';');
        fos.close();
    }

    public void setSeparator(char separator) {
        this._separator = separator;
    }

    public char getSeparator() {
        return this._separator;
    }
}

