/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LinkedLanguageEnhancedProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.csv.CsvReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class HelpImport {
    private String[] _languages = null;
    private File _source = null;
    private URL _xuiLocationPath = null;
    private String _NLSHeader = "";
    private static HelpImport instance = null;
    public static final String CONSTANT_NOT_ASSIGNED = "<n.a.>";

    private void importHelper() throws IOException {
        if (this._source != null) {
            InputStreamReader in = new InputStreamReader(JAXFrontProperties.getInstance().getURLResolver().resolveURL(this._source.toURL()));
            CsvReader csvReader = new CsvReader(in, ',');
            csvReader.readHeaders();
            this._languages = this.getLanguagesFromHeader(csvReader.getHeaders());
            Hashtable langProps = this.getPropteries(this._languages);
            while (csvReader.readRecord()) {
                String[] fields = csvReader.getValues();
                String key = fields[0];
                for (int i = 0; i < this._languages.length; ++i) {
                    LinkedLanguageEnhancedProperties aSelectedLangProp = (LinkedLanguageEnhancedProperties)langProps.get(this._languages[i]);
                    try {
                        if (fields[i + 1].equals(CONSTANT_NOT_ASSIGNED)) continue;
                        aSelectedLangProp.put(key, fields[i + 1]);
                        continue;
                    }
                    catch (Exception e) {
                        LogRegistry.getInstance().log(this.getClass(), "can't import language property! key:" + key + " language:" + this._languages[i]);
                    }
                }
            }
            this.serializePropteries(this._languages, langProps);
        }
    }

    private String[] getLanguagesFromHeader(String[] line) {
        String[] result = new String[line.length - 1];
        for (int i = 1; i < line.length; ++i) {
            result[i - 1] = line[i];
        }
        return result;
    }

    public static void importHelp(File destination, URL mainLanguageURL, String language, String nlsHeader) throws MalformedURLException, IOException {
        if (mainLanguageURL != null && language != null && !language.equals("")) {
            HelpImport.getInstance(destination, mainLanguageURL, language, nlsHeader).importHelper();
        }
    }

    private static HelpImport getInstance(File source, URL mainLanguageURL, String language, String nlsHeader) {
        instance = new HelpImport(source, mainLanguageURL, language, nlsHeader);
        return instance;
    }

    private HelpImport(File destination, URL mainLanguageURL, String language, String nlsHeader) {
        this.inititialize(destination, mainLanguageURL, language, nlsHeader);
    }

    private void inititialize(File destination, URL mainLanguageURL, String language, String nlsHeader) {
        this._xuiLocationPath = mainLanguageURL;
        this._source = destination;
        this._NLSHeader = nlsHeader;
    }

    private Hashtable getPropteries(String[] langs) {
        Hashtable<String, LinkedLanguageEnhancedProperties> result = new Hashtable<String, LinkedLanguageEnhancedProperties>();
        for (int i = 0; i < langs.length; ++i) {
            String aKey = langs[i];
            LinkedLanguageEnhancedProperties aLangProp = new LinkedLanguageEnhancedProperties();
            try {
                URL aFile = new URL(URLHelper.createNLSFilePathLocation(this._xuiLocationPath, langs[i]));
                InputStream is = aFile.openStream();
                aLangProp.load(is);
                is.close();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            result.put(aKey, aLangProp);
        }
        return result;
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        File source = new File("c:\\temp\\BIT\\ASTRA\\NLS\\GENERAL-SYSTEM.csv");
        File url = new File("c:\\temp\\BIT\\ASTRA\\NLS\\general_de.nls");
        HelpImport.importHelp(source, url.toURL(), "de", "nlsHeader");
    }

    private Hashtable buildLanguageFiles(String[] langs) {
        Hashtable<String, URL> languageFiles = new Hashtable<String, URL>();
        for (int i = 0; i < langs.length; ++i) {
            String aLang = langs[i];
            URL aFile = null;
            try {
                aFile = new URL(URLHelper.createNLSFilePathLocation(this._xuiLocationPath, aLang + "_copy"));
            }
            catch (MalformedURLException e) {
                LogRegistry.getInstance().error(this.getClass(), "Can't create NLSHelpPropertyfile for:" + aLang);
            }
            languageFiles.put(aLang, aFile);
        }
        return languageFiles;
    }

    private void serializePropteries(String[] languages, Hashtable properties) {
        Enumeration props = properties.keys();
        Hashtable files = this.buildLanguageFiles(languages);
        while (props.hasMoreElements()) {
            String aKey = (String)props.nextElement();
            LinkedLanguageEnhancedProperties aLangProp = (LinkedLanguageEnhancedProperties)properties.get(aKey);
            URL fileURL = (URL)files.get(aKey);
            File aDestFile = new File(fileURL.getFile());
            if (!aDestFile.exists() || aDestFile.canWrite()) {
                try {
                    aDestFile.createNewFile();
                    FileOutputStream fis = new FileOutputStream(aDestFile);
                    aLangProp.store(fis, this._NLSHeader);
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    LogRegistry.getInstance().error(this.getClass(), "Can't find NLSHelpProperty file for:" + aKey);
                }
                catch (IOException e) {
                    LogRegistry.getInstance().error(this.getClass(), "Can't create NLSHelpProperty file for:" + aKey);
                }
                continue;
            }
            LogRegistry.getInstance().error(this.getClass(), "Can't create NLSHelpProperty file for:" + aDestFile.toString() + " file is maybe protected or does not exist!");
            FileWriter fileWriter = null;
            try {
                File tempFile = new File("c:\\temp\\" + aDestFile.getName());
                LogRegistry.getInstance().error(this.getClass(), "Write NLSHelpProperty file into:" + tempFile.toString() + "!");
                if (!tempFile.getParentFile().exists()) {
                    tempFile.mkdirs();
                }
                fileWriter = new FileWriter(tempFile);
                aLangProp.store(fileWriter, this._NLSHeader);
                fileWriter.close();
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), "Can't create NLSHelpProperty file for:" + aDestFile.toString() + "!");
            }
        }
    }
}

