/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.IOException;
import java.io.RandomAccessFile;

public class JTail
implements Runnable {
    private String file_name;
    private long file_length;
    private long[] pointers;
    private int delay;
    private int showed_lines;
    private int chars_per_line;
    private RandomAccessFile raf;
    private Thread thisOne;

    public JTail(String s) throws IOException {
        this.file_name = s;
        this.setLines(10);
        this.setColumns(80);
        this.setDelay(800);
        this.init();
    }

    public void start() {
        System.out.println("-------------------------------------\n@parm:");
        System.out.println("      delay: " + this.delay);
        System.out.println("      lines: " + this.showed_lines);
        System.out.println("    columns: " + this.chars_per_line);
        System.out.println("\n-------------------------------------\n");
        this.thisOne = new Thread(this);
        this.thisOne.start();
    }

    public void setLines(int i) {
        this.showed_lines = i + 2;
        this.pointers = new long[this.showed_lines];
    }

    public void setColumns(int i) {
        this.chars_per_line = i;
    }

    public void setDelay(int i) {
        this.delay = i;
    }

    private void init() throws IOException {
        this.raf = new RandomAccessFile(this.file_name, "r");
        this.file_length = this.raf.length();
    }

    private void finish() throws IOException {
        this.raf.close();
    }

    public void run() {
        new NewLine().start();
        int i = this.showed_lines * this.chars_per_line;
        try {
            this.init();
            this.seek(i);
            this.readFile();
            this.finish();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        while (true) {
            long l = this.file_length;
            try {
                this.init();
                if (l > this.file_length) {
                    this.seek(i);
                } else if (this.file_length > l) {
                    this.raf.seek(l);
                }
                if (l != this.file_length) {
                    this.readFile();
                }
                this.finish();
                this.sleep();
                continue;
            }
            catch (IOException ioexception1) {
                System.out.println("Error ...... :-/");
                ioexception1.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void seek(int i) throws IOException {
        this.raf.seek((long)i >= this.file_length ? 0L : this.file_length - (long)i);
        int j = 0;
        do {
            if (j < this.showed_lines) {
                this.pointers[j++] = this.raf.getFilePointer();
                continue;
            }
            int k = 0;
            int l = this.pointers.length - 1;
            while (k < l) {
                this.pointers[this.showed_lines - 1] = this.raf.getFilePointer();
                this.pointers[k++] = this.pointers[k];
            }
        } while (this.raf.readLine() != null);
        this.raf.seek(this.pointers[0]);
    }

    private void readFile() throws IOException {
        int j;
        int i = 0;
        while ((j = this.raf.read()) != -1) {
            ++i;
            if (j == 10) {
                i = 0;
            }
            if (i != this.chars_per_line) {
                System.out.print((char)j);
                continue;
            }
            System.out.println((char)j);
            i = 0;
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Jtail @ Vielinko");
        if (args.length == 0) {
            System.out.println("Uso:");
            System.out.println("     java com.vl.util.JTail <file_name> [-t<delay>] [-l<lines>] [-c<columns>]");
            System.out.println("\n\n");
            System.out.println("     file_name: nombre del archivo");
            System.out.println("     delay    : tiempo de espera entre cada chequeo al archivo -tiempo en milisegundos-, default 800ms");
            System.out.println("     lines    : numero de lineas iniciales que se veran al iniciar el comando, default 10 lineas");
            System.out.println("     columns  : numero de columnas que se visualizarn por linea mostrada, default 80 columnas");
        } else {
            JTail jtail = new JTail(args[0]);
            int j = args.length;
            for (int i = 1; i < j; ++i) {
                if (args[i].startsWith("-t")) {
                    jtail.setDelay(Integer.parseInt(args[i].substring(2)));
                    continue;
                }
                if (args[i].startsWith("-l")) {
                    jtail.setLines(Integer.parseInt(args[i].substring(2)));
                    continue;
                }
                if (!args[i].startsWith("-c")) continue;
                jtail.setLines(Integer.parseInt(args[i].substring(2)));
            }
            jtail.start();
        }
    }

    private class NewLine
    extends Thread {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        System.in.read();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

