/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZIPDeCompressor {
    private ZipInputStream _zis = null;
    private ZipEntry _currentEntry = null;
    private CRC32 _currentCRC32 = null;
    private int _bufferSize = 1024;
    private static int _staticBufferSize = 1024;

    public ZIPDeCompressor(InputStream inStream) {
        this._zis = new ZipInputStream(inStream);
    }

    public void getZipEntry(String id) throws IOException {
        ZipEntry aEntry = null;
        while ((aEntry = this._zis.getNextEntry()) != null) {
            if (!aEntry.getName().equals(id)) continue;
            return;
        }
        throw new IOException("ZipEntry for: " + id + "not found!");
    }

    public ZipEntry getFirstZipEntry() {
        ZipEntry aEntry = null;
        try {
            aEntry = this._zis.getNextEntry();
            if (aEntry != null) {
                return aEntry;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void write(OutputStream outStream) throws IOException {
        this.write(outStream, this._zis);
    }

    public void writeConverted(OutputStreamWriter outStream, String sourceEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader((InputStream)this._zis, sourceEncoding);
        this.write(outStream, in);
    }

    public ByteArrayOutputStream write() throws IOException {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        this.write(resultStream);
        return resultStream;
    }

    private OutputStream write(OutputStream outstream, InputStream inStream) throws IOException {
        byte[] rgb = new byte[this._bufferSize];
        int readCounter = 0;
        while ((readCounter = inStream.read(rgb)) > -1) {
            outstream.write(rgb, 0, readCounter);
        }
        outstream.flush();
        return outstream;
    }

    private OutputStreamWriter write(OutputStreamWriter outstream, InputStreamReader in) throws IOException {
        char[] rgb = new char[this._bufferSize];
        int readCounter = 0;
        while ((readCounter = in.read(rgb)) > -1) {
            outstream.write(rgb, 0, readCounter);
        }
        outstream.flush();
        return outstream;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void close() throws IOException {
        this._zis.close();
    }

    public ZipInputStream getInputStream() {
        return this._zis;
    }

    public static byte[] unzip(byte[] value) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPInputStream zipIn = new GZIPInputStream(byteIn);
        byte[] rgb = new byte[_staticBufferSize];
        int readCounter = 0;
        while ((readCounter = zipIn.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos.toByteArray();
    }
}

