/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cache;

import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.io.cache.Cache;
import com.jaxfront.core.util.io.cache.SoftObjectCache;
import com.jaxfront.core.util.io.cache.ZippedCache;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class DomainedObjectCache {
    static Hashtable _domains;

    private DomainedObjectCache() {
    }

    public static Hashtable getDomains() {
        if (_domains == null) {
            _domains = new Hashtable();
        }
        return _domains;
    }

    public static Cache getInstance(String domain) {
        return DomainedObjectCache.getInstance(domain, SoftObjectCache.class);
    }

    public static Cache getInstance(String domain, Class cacheClass) {
        Cache aCache = null;
        if (DomainedObjectCache.getDomains().contains(domain)) {
            return (Cache)DomainedObjectCache.getDomains().get(domain);
        }
        aCache = (Cache)IntroSpectionHelper.createObject(cacheClass.getName(), (List)null);
        DomainedObjectCache.getDomains().put(domain, aCache);
        return aCache;
    }

    public Cache getCache(String domain) {
        if (DomainedObjectCache.getDomains().get(domain) != null) {
            return (Cache)DomainedObjectCache.getDomains().get(domain);
        }
        return null;
    }

    public Object getCachedObject(String domain, Object key) {
        if (DomainedObjectCache.getDomains().get(domain) != null) {
            return ((Cache)DomainedObjectCache.getDomains().get(domain)).getCached(key);
        }
        return null;
    }

    public void cache(String domain, Object key, Object value) {
        if (DomainedObjectCache.getDomains().get(domain) != null) {
            ((Cache)DomainedObjectCache.getDomains().get(domain)).cache(key, value);
        }
    }

    public void releaseCached(String domain, Object keyToRelease) {
        if (DomainedObjectCache.getDomains().get(domain) != null) {
            ((Cache)DomainedObjectCache.getDomains().get(domain)).releaseCached(keyToRelease);
        }
    }

    public static void releaseDomains() {
        Enumeration domains = DomainedObjectCache.getDomains().elements();
        while (domains.hasMoreElements()) {
            Cache aDomain = (Cache)domains.nextElement();
            aDomain.releaseCache();
        }
        DomainedObjectCache.getDomains().clear();
    }

    public static void main(String[] args) {
        Cache aCache = DomainedObjectCache.getInstance("test");
        aCache.cache("test", "testValue");
        System.out.println(aCache.hasCached("test"));
        System.out.println(aCache.getCached("test"));
        ZippedCache aCache2 = (ZippedCache)DomainedObjectCache.getInstance("test2", ZippedCache.class);
        aCache2.cache("test2", "testValue2".getBytes());
        System.out.println(aCache2.hasCached("test2"));
        System.out.println(aCache2.getCached("test2"));
        DomainedObjectCache.releaseDomains();
    }
}

