/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.cvsexport;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.csv.CsvWriter;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVW3CDocumentExporter {
    public static String[] exportFlatten(org.w3c.dom.Document dom, boolean withHeader, Map<String, Integer> colNames, Map codeTables, boolean varMode) throws XMLParseException, SAXException, IOException {
        String[] aRow = new String[colNames.size()];
        CSVW3CDocumentExporter.getFlatten(dom.getDocumentElement(), aRow, colNames, codeTables, varMode);
        return aRow;
    }

    public static String[] exportFlattenByXPath(org.w3c.dom.Document dom, boolean withHeader, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables) throws XMLParseException, SAXException, IOException {
        String[] aRow = new String[colNames.size()];
        CSVW3CDocumentExporter.getFlattenByXPath(dom.getDocumentElement(), aRow, colNames, nameToColMap, codeTables);
        return aRow;
    }

    public static String[] exportFlattenByXPath(Document dom, boolean withHeader, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables) throws XMLParseException, SAXException, IOException {
        String[] aRow = new String[colNames.size()];
        CSVW3CDocumentExporter.getFlattenByXPath(dom.getRootType(), aRow, colNames, nameToColMap, codeTables);
        return aRow;
    }

    public static Map<String, Integer> getFlattenHeader(org.w3c.dom.Document dom, List colNames, boolean varMode) throws XMLParseException, SAXException, IOException {
        Object columnNames = null;
        int[] pos = ArrayUtil.addToGrowArray(null, 0, 10);
        if (colNames == null) {
            Vector flatHeaders = new Vector();
            CSVW3CDocumentExporter.getFlattenHeaders(dom.getDocumentElement(), flatHeaders, varMode, pos);
            colNames = flatHeaders;
        }
        return CSVW3CDocumentExporter.toMap(colNames, false, true);
    }

    public static Map toMap(List what, boolean emptyIfNull, boolean posAsValue) {
        if (what == null && emptyIfNull) {
            return new HashMap(2);
        }
        int l = what.size();
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>(l);
        for (int i = 0; i < l; ++i) {
            String key = (String)what.get(i);
            if (result.containsKey(key)) {
                key = new StringBuffer().append(key).append("_").append(i).toString();
            }
            result.put(key, i);
        }
        return result;
    }

    public static void getFlatten(Element aType, String[] row, Map<String, Integer> colNames, Map codeTables, boolean varMode) {
        List childs = DOMHelper.getChildren(null, aType);
        int maxChilds = childs.size();
        if (maxChilds == 0) {
            String codeValue;
            Map codes;
            String codeName;
            String colName = CSVW3CDocumentExporter.evalColName(aType, varMode);
            String value = DOMHelper.getText(aType);
            if (value == null) {
                value = "<n.a>";
            } else if (codeTables != null && (codeName = CSVW3CDocumentExporter.evalCodeSet(aType, varMode)) != null && (codes = (Map)codeTables.get(codeName)) != null && value != null && (codeValue = (String)codes.get(value)) != null) {
                value = codeValue;
            }
            if (colNames.containsKey(colName)) {
                int pos = colNames.get(colName);
                row[pos] = value;
            }
            return;
        }
        for (int a = 0; a < maxChilds; ++a) {
            CSVW3CDocumentExporter.getFlatten((Element)childs.get(a), row, colNames, codeTables, varMode);
        }
    }

    public static void getFlattenByXPath(Element aElem, String[] row, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables) {
        Iterator<Map.Entry<String, String>> colMap = colNames.entrySet().iterator();
        int pos = 0;
        while (colMap.hasNext()) {
            Map.Entry<String, String> aMapped = colMap.next();
            String varName = aMapped.getKey();
            String xPath = aMapped.getValue();
            String value = "";
            if (varName != null && xPath != null) {
                value = W3CXPathExecuterImpl.getInstance().getElementValue(aElem, xPath, true);
            }
            int aPos = pos;
            if (nameToColMap != null) {
                aPos = nameToColMap.get(varName);
            }
            row[aPos] = value;
            ++pos;
        }
    }

    public static void getFlattenByXPath(Type aType, String[] row, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables) {
        Iterator<Map.Entry<String, String>> colMap = colNames.entrySet().iterator();
        int pos = 0;
        while (colMap.hasNext()) {
            Type valType;
            Map.Entry<String, String> aMapped = colMap.next();
            String varName = aMapped.getKey();
            String xPath = aMapped.getValue();
            String value = "";
            if (varName != null && xPath != null && (valType = aType.getDOM().getType(xPath)) != null) {
                if (valType.isSimple()) {
                    String transValue;
                    value = ((SimpleType)valType).getValue();
                    if (value != null && (transValue = ((SimpleType)valType).translateToCodeSetValue(value)) != null) {
                        value = transValue;
                    }
                } else {
                    value = valType.getDisplayValue();
                }
            }
            int aPos = pos;
            if (nameToColMap != null) {
                aPos = nameToColMap.get(varName);
            }
            row[aPos] = value;
            ++pos;
        }
    }

    public static void getFlattenHeaders(Element aType, Vector result, boolean varMode, int[] pos) {
        List childs = DOMHelper.getChildren(null, aType);
        int maxChilds = childs.size();
        if (varMode) {
            String colName = CSVW3CDocumentExporter.evalColName(aType, varMode);
            if (colName != null) {
                result.add(colName);
            }
        } else if (maxChilds == 0) {
            String colName = CSVW3CDocumentExporter.evalColName(aType, varMode);
            if (colName != null) {
                result.add(colName);
            }
            return;
        }
        for (int a = 0; a < childs.size(); ++a) {
            CSVW3CDocumentExporter.getFlattenHeaders((Element)childs.get(a), result, varMode, pos);
        }
    }

    private static String evalColName(Element aType, boolean varMode) {
        String colName = null;
        ProcessingInstruction pi = null;
        if (varMode) {
            pi = DOMHelper.searchPrevProcessingInstruction(aType, "jaxfront-var");
            if (pi != null) {
                colName = DOMHelper.getProcessingInstructionValue(pi, "variableName");
            }
        } else {
            colName = aType.getNodeName();
            if (colName == null) {
                colName = "<n.a>";
            }
        }
        return colName;
    }

    private static String evalCodeSet(Element aType, boolean varMode) {
        String colName = null;
        ProcessingInstruction pi = null;
        if (varMode) {
            pi = DOMHelper.searchPrevProcessingInstruction(aType, "jaxfront-var");
            if (pi != null) {
                colName = DOMHelper.getProcessingInstructionValue(pi, "codeSetName");
            }
        } else {
            colName = aType.getNodeName();
            if (colName == null) {
                colName = "<n.a>";
            }
        }
        return colName;
    }

    public static void main(String[] args) throws SchemaCreationException, DocumentCreationException, ValidationException, XMLParseException, SAXException, IOException {
        org.w3c.dom.Document dom = DOMHelper.createDocument(new File("c:/temp/flatten.xml"));
        Map<String, Integer> colNames = CSVW3CDocumentExporter.getFlattenHeader(dom, null, false);
        CsvWriter writer = new CsvWriter("c:/temp/flatten.csv");
        writer.setForceQualifier(true);
        writer.setTextQualifier('\"');
        writer.writeRecord(MapHelper.toStringArrayForKey(colNames));
        for (int i = 0; i < 1000; ++i) {
            CSVW3CDocumentExporter.exportFlatten(dom, writer, colNames, null, false, null);
        }
        writer.close();
    }

    public static void exportFlatten(org.w3c.dom.Document dom, CsvWriter writer, Map<String, Integer> colNames, Map codeTables, boolean varMode, String[] addData) throws XMLParseException, SAXException, IOException {
        String[] flattends = CSVW3CDocumentExporter.exportFlatten(dom, true, colNames, codeTables, varMode);
        writer.writeRecord(ArrayUtil.addToArray(addData, flattends));
    }

    public static void exportFlattenByXPath(org.w3c.dom.Document dom, CsvWriter writer, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables, String[] addData) throws XMLParseException, SAXException, IOException {
        String[] flattends = CSVW3CDocumentExporter.exportFlattenByXPath(dom, true, colNames, nameToColMap, codeTables);
        writer.writeRecord(ArrayUtil.addToArray(addData, flattends));
    }

    public static void exportFlattenByXPath(Document dom, CsvWriter writer, Map<String, String> colNames, Map<String, Integer> nameToColMap, Map codeTables, String[] addData) throws XMLParseException, SAXException, IOException {
        String[] flattends = CSVW3CDocumentExporter.exportFlattenByXPath(dom, true, colNames, nameToColMap, codeTables);
        writer.writeRecord(ArrayUtil.addToArray(addData, flattends));
    }
}

