/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.files;

import com.jaxfront.core.util.io.files.Objects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Strings
extends Objects {
    private static final String[] HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    public static final String ESCAPEE = "\\\"'\n\r\t\f\b";
    public static final String ESCAPED = "\\\"'nrtfb";
    public static final int _TRUE_ = 3;
    public static final int _FALSE_ = 0;
    public static final int _UNDEF_ = 1;

    protected Strings() {
    }

    public static int indexOf(CharSequence s, char c, int fromIndex) {
        for (int i = fromIndex; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence s, char c) {
        return Strings.indexOf(s, c, 0);
    }

    public static int lastIndexOf(CharSequence s, char c) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence sequence, CharSequence subsequence, int fromIndex) {
        if (subsequence.length() == 0) {
            return fromIndex;
        }
        char c0 = subsequence.charAt(0);
        int subLength = subsequence.length();
        int lastIndex = sequence.length() - subsequence.length();
        int i = Strings.indexOf(sequence, c0, fromIndex);
        while (0 <= i && i <= lastIndex) {
            if (Strings.startsWith(sequence.subSequence(i, i + subLength), subsequence)) {
                return i;
            }
            i = Strings.indexOf(sequence, c0, i + 1);
        }
        return -1;
    }

    public static int indexOf(CharSequence sequence, CharSequence subsequence) {
        return Strings.indexOf(sequence, subsequence, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence subsequence) {
        if (sequence.length() < subsequence.length()) {
            return false;
        }
        for (int i = 0; i < subsequence.length(); ++i) {
            if (sequence.charAt(i) == subsequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static void write(Writer writer, CharSequence cs) throws IOException {
        if (cs == null) {
            return;
        }
        for (int i = 0; i < cs.length(); ++i) {
            writer.write(cs.charAt(i));
        }
    }

    public static boolean isAlmostEmpty(CharSequence s) {
        if (Strings.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String oneOf(Object o1, Object o2) {
        return !Strings.isEmpty(o1) ? o1.toString() : (o2 == null ? null : o2.toString());
    }

    public static String oneOf(Object o1, Object o2, Object o3) {
        return !Strings.isEmpty(o1) ? o1.toString() : (!Strings.isEmpty(o2) ? o2.toString() : (o3 == null ? null : o3.toString()));
    }

    public static String oneOf(Object o1, Object o2, Object o3, Object o4) {
        return !Strings.isEmpty(o1) ? o1.toString() : (!Strings.isEmpty(o2) ? o2.toString() : (!Strings.isEmpty(o3) ? o3.toString() : (o4 == null ? null : o4.toString())));
    }

    public static boolean isAlpha(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isVowel(char c) {
        return "aeiouAEIOU".indexOf(c) >= 0;
    }

    public static boolean hasAlpha(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isJavaIdentifierStart(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int countChar(CharSequence s, char c) {
        int n = 0;
        int i = Strings.indexOf(s, c);
        while (i >= 0) {
            ++n;
            i = Strings.indexOf(s, c, i + 1);
        }
        return n;
    }

    public static int textHeight(CharSequence s) {
        return Strings.countChar(s, '\n') + 1;
    }

    public static int textWidth(CharSequence s) {
        int n = 1;
        int curPos = 0;
        while (curPos < s.length()) {
            int nextPos = Strings.indexOf(s, '\n', curPos);
            if (nextPos < 0) {
                nextPos = s.length();
            }
            if (n < nextPos - curPos) {
                n = nextPos - curPos;
            }
            curPos = nextPos + 1;
        }
        return n;
    }

    public static int wordCount(CharSequence s) {
        return new StringTokenizer(((Object)s).toString()).countTokens();
    }

    public static int countLeadingSpaces(CharSequence s) {
        int n;
        int l = s.length();
        for (n = 0; n < l && s.charAt(n) == ' '; ++n) {
        }
        return n;
    }

    public static int countTrailingSpaces(CharSequence s) {
        int n;
        int l = s.length();
        for (n = 0; n < l && s.charAt(l - n - 1) == ' '; ++n) {
        }
        return n == s.length() ? 0 : n;
    }

    public static String fill(char c, int n) {
        char[] data = new char[n];
        for (int i = 0; i < n; ++i) {
            data[i] = c;
        }
        return new String(data);
    }

    public static String toHex(byte b) {
        byte i = b;
        return HEX[i & 0xFF];
    }

    public static String toHex(int i) {
        return Integer.toHexString(i);
    }

    public static String toHex(char ch, boolean up) {
        String hex = "0000" + Integer.toHexString(ch);
        if (up) {
            hex = hex.toUpperCase();
        }
        return hex.substring(hex.length() - 4);
    }

    public static String toHex(char ch) {
        return Strings.toHex(ch, false);
    }

    public static String toHex(CharSequence s, boolean up) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            b.append(Strings.toHex(s.charAt(i), up));
        }
        return b.toString();
    }

    public static String toJavaOctalEncoding(char c) {
        return "\\" + Integer.toString(c, 8);
    }

    public static String toJavaHexEncoding(char c) {
        return "\\u" + Strings.toHex(c);
    }

    public static String toJavaHexEncoding(char c, boolean up) {
        return "\\u" + Strings.toHex(c, up);
    }

    public static String toPropertiesEncoding(char c, boolean up) {
        return c > '\u007f' || c < ' ' ? Strings.toJavaHexEncoding(c, up) : "" + c;
    }

    public static String toPropertiesEncoding(char c) {
        return Strings.toPropertiesEncoding(c, false);
    }

    public static boolean needsEncoding(char c) {
        return ESCAPEE.indexOf(c) >= 0 || c < ' ' || c > '\u007f';
    }

    public static String toJavaEncoding(char c, boolean up, boolean escape) {
        int i;
        int n = i = escape ? ESCAPEE.indexOf(c) : -1;
        return i >= 0 ? "\\" + ESCAPED.charAt(i) : (c < ' ' ? Strings.toJavaOctalEncoding(c) : (c > '\u007f' ? Strings.toJavaHexEncoding(c, up) : "" + c));
    }

    public static String toJavaEncoding(char c, boolean up) {
        return Strings.toJavaEncoding(c, up, true);
    }

    public static String toJavaEncoding(char c) {
        return Strings.toJavaEncoding(c, false);
    }

    public static String toCEncoding(char c) {
        int i = ESCAPEE.indexOf(c);
        return i >= 0 ? "\\" + ESCAPED.charAt(i) : (c < ' ' || c > '\u007f' ? "\\x" + Long.toHexString(c) : "" + c);
    }

    public static boolean needsEncoding(CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Strings.needsEncoding(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String toJavaEncoding(CharSequence s, boolean up, boolean escape) {
        if (!Strings.needsEncoding(s)) {
            return ((Object)s).toString();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(Strings.toJavaEncoding(s.charAt(i), up, escape));
        }
        return buf.toString();
    }

    public static String toJavaEncoding(CharSequence s, boolean up) {
        return Strings.toJavaEncoding(s, up, true);
    }

    public static String toJavaEncoding(CharSequence s) {
        return Strings.toJavaEncoding(s, false);
    }

    public static String toCEncoding(CharSequence s) {
        if (!Strings.needsEncoding(s)) {
            return ((Object)s).toString();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(Strings.toCEncoding(s.charAt(i)));
        }
        return buf.toString();
    }

    public static String toSgmlEncoding(char c) {
        return c > ' ' || c == '\t' || c == '\n' || c == '\r' ? "&#" + c + ";" : "?";
    }

    public static String sgmlEntity(char c) {
        return c == '<' ? "&lt;" : (c == '>' ? "&gt;" : (c == '\'' ? "&apos;" : (c == '\"' ? "&quot;" : (c == '&' ? "&amp;" : (c == ']' ? "&#93;" : (c < ' ' && c != '\n' && c != '\r' && c != '\t' || c > '\u0080' ? Strings.toSgmlEncoding(c) : null))))));
    }

    public static String toSgmlEncoding(CharSequence s) {
        if (Strings.isEmpty(s)) {
            return ((Object)s).toString();
        }
        StringBuffer buffer = new StringBuffer(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String entity = Strings.sgmlEntity(c);
            if (entity == null) {
                buffer.append(c);
                continue;
            }
            buffer.append(entity);
        }
        return buffer.toString();
    }

    public static String htmlEncode(CharSequence s) {
        if (Strings.isEmpty(s)) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char k = c = s.charAt(i);
            if (c > '\u0100') {
                out.append("&#" + k + ";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String toReadable(char[] data, int beginIndex, int endIndex) {
        StringBuffer buf = new StringBuffer(data.length);
        for (int i = beginIndex; i < data.length && i < endIndex; ++i) {
            char c = data[i];
            if (c < ' ' || c > '\u007f') {
                c = '.';
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toReadable(CharSequence s) {
        return Strings.toReadable(((Object)s).toString().toCharArray(), 0, s.length());
    }

    public static String hexDump(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < data.length; i += 16) {
            int j;
            out.append("\r\n");
            out.append(Strings.toHex((byte)(i >> 8)));
            out.append(Strings.toHex((byte)i));
            out.append(": ");
            for (j = i; j < i + 16; ++j) {
                out.append(j < data.length ? Strings.toHex(data[j]) : "  ");
                out.append(" ");
            }
            out.append("| ");
            for (j = i; j < i + 16 && j < data.length; ++j) {
                byte b = data[j];
                out.append((char)(b >= 32 ? (int)b : 183));
                out.append(" ");
            }
        }
        out.append("\r\n");
        return out.toString();
    }

    public static String hexDump(char[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < data.length; i += 16) {
            out.append("\r\n");
            out.append(i < 16 ? "000" : (i < 256 ? "00" : (i < 4096 ? "0" : "")));
            out.append(Strings.toHex(i));
            out.append(": ");
            for (int j = i; j < i + 16; ++j) {
                out.append(j >= data.length ? "    " : Strings.toHex(data[j]));
                out.append(" ");
            }
            out.append("| ");
            out.append(Strings.toReadable(data, i, Math.min(i + 16, data.length)));
        }
        out.append("\r\n");
        return out.toString();
    }

    public static String hexDump(CharSequence data) {
        return Strings.hexDump(((Object)data).toString().toCharArray());
    }

    public static String toHexReadable(char[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < data.length; i += 16) {
            for (int j = i; j < i + 16 && j < data.length; ++j) {
                out.append(Strings.toHex(data[j]));
                out.append(" ");
            }
            out.append("\r\n");
        }
        return out.toString();
    }

    public static String toHexReadable(byte[] data, int from, int to) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = from; i < Math.min(to, data.length); i += 16) {
            for (int j = i; j < i + 16 && j < Math.min(to, data.length); ++j) {
                out.append(Strings.toHex(data[j]));
                out.append(" ");
            }
            out.append("\r\n");
        }
        return out.toString();
    }

    public static String toHexReadable(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < data.length; i += 16) {
            for (int j = i; j < i + 16 && j < data.length; ++j) {
                out.append(Strings.toHex(data[j]));
                out.append(" ");
            }
            out.append("\r\n");
        }
        return out.toString();
    }

    public static String toHexReadable(CharSequence s) {
        if (Strings.isEmpty(s)) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); i += 16) {
            CharSequence chunk = s.subSequence(i, Math.min(i + 16, s.length()));
            for (int j = 0; j < chunk.length(); ++j) {
                out.append(Strings.toHex(chunk.charAt(j)));
                out.append(" ");
            }
            out.append("\r\n");
        }
        return out.toString();
    }

    public static String join(CharSequence separator, Collection collection) {
        if (separator == null || collection == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object ith = i.next();
            if (ith != null) {
                buf.append(ith);
            }
            if (!i.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String join(CharSequence separator, Object[] what) {
        if (separator == null || what == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < what.length; ++i) {
            Object ith = what[i];
            if (ith != null) {
                buf.append(ith.toString());
            }
            if (i >= what.length - 1) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static List split(CharSequence separator, CharSequence source) {
        ArrayList<CharSequence> stringList = new ArrayList<CharSequence>();
        boolean found = false;
        int pos = 0;
        while (source != null && separator != null && pos < source.length()) {
            int last = Strings.indexOf(source, separator, pos);
            if (last < 0) {
                last = source.length();
            } else {
                found = true;
            }
            stringList.add(source.subSequence(pos, last));
            pos = last + separator.length();
        }
        if (found) {
            stringList.add("");
        }
        stringList.trimToSize();
        return stringList;
    }

    public static List grep(CharSequence[] source, CharSequence regexp) throws PatternSyntaxException {
        return Strings.grep(source, Pattern.compile(((Object)regexp).toString()));
    }

    public static List grep(CharSequence[] source, Pattern regexp) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (int i = 0; i < source.length; ++i) {
            Matcher matcher = regexp.matcher(source[i]);
            if (!matcher.find()) continue;
            result.add(source[i]);
        }
        result.trimToSize();
        return result;
    }

    public static String replace(CharSequence where, CharSequence oldSubstring, CharSequence newSubstring, boolean all) {
        int newPos;
        if (where == null) {
            return null;
        }
        if (oldSubstring == null || newSubstring == null) {
            return ((Object)where).toString();
        }
        StringBuffer out = new StringBuffer();
        int pos = 0;
        while ((newPos = Strings.indexOf(where, oldSubstring, pos)) >= 0) {
            out.append(where.subSequence(pos, newPos));
            out.append(newSubstring);
            pos = newPos + oldSubstring.length();
            if (all) continue;
        }
        out.append(where.subSequence(pos, where.length()));
        return out.toString();
    }

    public static String extractValue(CharSequence input, CharSequence name) {
        int iname = Strings.indexOf(input, name + "=\"");
        if (iname < 0) {
            return null;
        }
        int ivalue = iname + name.length() + 2;
        int ievalu = Strings.indexOf(input, '\"', ivalue);
        if (ievalu < 0) {
            return null;
        }
        return ((Object)input.subSequence(ivalue, ievalu)).toString();
    }

    public static String pack(byte[] from) {
        StringBuffer buffer = new StringBuffer((from.length + 1) / 2);
        char previous = '\u0000';
        for (int i = 0; i < from.length; ++i) {
            char byteValue = (char)(0xFF & from[i]);
            if (i % 2 != 0) {
                buffer.append((char)(previous + byteValue));
                continue;
            }
            previous = (char)(byteValue << 8);
        }
        if (from.length % 2 != 0) {
            buffer.append(previous);
        }
        return buffer.toString();
    }

    public static byte[] unpack(CharSequence data) {
        byte[] result = new byte[data.length() * 2];
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            result[i * 2] = (byte)(c >> 8);
            result[i * 2 + 1] = (byte)c;
        }
        return result;
    }

    public static String decodeJavaString(CharSequence string) {
        StringBuffer output = new StringBuffer(string.length() * 2);
        if (Strings.indexOf(string, '\\') < 0) {
            return ((Object)string).toString();
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '\\' && i < string.length() - 1) {
                int escapeIdx = ESCAPED.indexOf(string.charAt(i + 1));
                if (escapeIdx >= 0) {
                    ++i;
                    ch = ESCAPEE.charAt(escapeIdx);
                } else if (i < string.length() - 5 && string.charAt(i + 1) == 'u') {
                    try {
                        ch = (char)Integer.parseInt(((Object)string.subSequence(i + 2, i + 6)).toString(), 16);
                        i += 5;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static byte[] encode(CharSequence s, String encoding) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, encoding);
        Strings.write(osw, s);
        ((Writer)osw).close();
        return bos.toByteArray();
    }

    public static String decode(InputStream is, String encoding) throws IOException, UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader(is, encoding);
        StringBuffer result = new StringBuffer();
        char[] readBuffer = new char[4096];
        while (((Reader)isr).ready()) {
            int l = isr.read(readBuffer);
            result.append(readBuffer, 0, l);
        }
        return result.toString();
    }

    public static String decode(byte[] bytes, String encoding) throws IOException, UnsupportedEncodingException {
        return Strings.decode(new ByteArrayInputStream(bytes), encoding);
    }

    public static byte[] zip2bytes(CharSequence source) throws IOException, UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, new Deflater(9));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dos, "UTF-8");
        Strings.write(osw, source);
        ((Writer)osw).flush();
        dos.finish();
        bos.write(0);
        ((Writer)osw).close();
        byte[] result = bos.toByteArray();
        return result;
    }

    public static String zip8bit(CharSequence source) throws IOException, UnsupportedEncodingException {
        return new String(Strings.zip2bytes(source));
    }

    public static String zip(CharSequence source) throws IOException, UnsupportedEncodingException {
        return Strings.pack(Strings.zip2bytes(source));
    }

    public static String unzip(InputStream zippedStream) throws IOException, UnsupportedEncodingException {
        return Strings.decode(new InflaterInputStream(zippedStream), "UTF-8");
    }

    public static String unzip(byte[] zippedBytes) throws IOException, UnsupportedEncodingException {
        return Strings.unzip(new ByteArrayInputStream(zippedBytes));
    }

    public static String unzip(CharSequence zipped) throws IOException, UnsupportedEncodingException {
        return Strings.unzip(Strings.unpack(zipped));
    }

    public static long crc32(CharSequence data) throws IOException, UnsupportedEncodingException {
        return Strings.crc32(Strings.unpack(data));
    }

    public static String crcreport(byte[] data, int off, int len, int step) {
        StringBuffer buffer = new StringBuffer();
        int lastplus1 = Math.min(data.length, off + len);
        for (int i = off; i <= lastplus1; i += step) {
            buffer.append("[" + i + "]" + Long.toHexString(Strings.crc32(data, i, Math.min(lastplus1 - i, step))) + " ");
        }
        return buffer.toString();
    }

    public static String crcreport(byte[] data, int step) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= data.length; i += step) {
            buffer.append("[" + i + "]" + Long.toHexString(Strings.crc32(data, i, Math.min(data.length - i, step))) + " ");
        }
        return buffer.toString();
    }

    public static String[] toStrings(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Object[])) {
            return null;
        }
        Object[] array = (Object[])object;
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].toString();
        }
        return result;
    }

    public static String toString(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        return baos.toString();
    }

    public static String format(String fmtString, Object param1) {
        return MessageFormat.format(fmtString, param1);
    }

    public static String format(String fmtString, Object param1, Object param2) {
        return MessageFormat.format(fmtString, param1, param2);
    }

    public static String format(String fmtString, Object param1, Object param2, Object param3) {
        return MessageFormat.format(fmtString, param1, param2, param3);
    }

    public static Properties asProperties(String[] pairs) {
        if (pairs == null) {
            return null;
        }
        Properties result = new Properties();
        for (int i = 0; i < pairs.length - 1; i += 2) {
            result.setProperty(pairs[i], pairs[i + 1]);
        }
        return result;
    }

    public static int findDiff(CharSequence s1, CharSequence s2) {
        int i;
        if (Strings.isEmpty(s1) && Strings.isEmpty(s2)) {
            return -1;
        }
        if (Strings.isEmpty(s1) || Strings.isEmpty(s2)) {
            return 0;
        }
        for (i = 0; i < Math.min(s1.length(), s2.length()); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return s1.length() == s2.length() ? -1 : i;
    }

    public int isTrue(String string) {
        return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "1".equals(string) || "+".equals(string) ? 3 : ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "not".equalsIgnoreCase(string) || "0".equals(string) || "-".equals(string) ? 0 : 1);
    }

    public boolean toBoolean(String string, boolean defaultValue) {
        int result = this.isTrue(string);
        return result == 1 ? defaultValue : result == 3;
    }
}

