/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.search;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.search.AbstractSearcher;
import java.util.Vector;

public class DefaultTypeSearcher
extends AbstractSearcher {
    public static final String TYPE_NAME_FILTER = "typeNameFilter";
    private Type _rootType;
    private int _searchDirective = 0;
    public static final int ALL = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    private boolean _inclEdType = true;
    private boolean _choosenOnly = false;

    public DefaultTypeSearcher(Type aType) {
        this._rootType = aType;
    }

    public boolean search(String value) {
        this.initComparator();
        this._result = new Vector();
        if (this._rootType != null) {
            Type fromType = this._rootType;
            if (this._searchDirective == 0) {
                fromType = this._rootType.getDOM().getRootType();
            }
            this.searchType(fromType, -1, value, this._result, null);
        }
        this.setSearchValue(value);
        return this._result.size() > 0;
    }

    public void setSearchDirective(int directive) {
        this._searchDirective = directive;
    }

    private void searchType(Type currentType, int depth, String searchText, Vector foundNodes, String searchFilter) {
        String typeNameFilter = this.getProperty(TYPE_NAME_FILTER);
        if (typeNameFilter != null) {
            if (currentType.getParent(typeNameFilter) != null && this.getComparator().compare(currentType, searchText) > 0 && currentType.getStyle().isVisible()) {
                this.checkAdd(currentType, foundNodes);
            }
        } else if (this.getComparator().compare(currentType, searchText) > 0 && currentType.getStyle().isVisible()) {
            this.checkAdd(currentType, foundNodes);
        }
        if (depth != 0) {
            Vector<Type> directChildren = new Vector<Type>();
            if (currentType.isList()) {
                if (this._inclEdType) {
                    directChildren.add(((ListType)currentType).getEditingType());
                }
                directChildren.addAll(currentType.getDirectChildren());
            } else if (this._choosenOnly && currentType.isChoice()) {
                Type choosen = currentType.getChoosenType();
                if (choosen != null) {
                    directChildren.add(currentType.getChoosenType());
                }
            } else {
                directChildren.addAll(currentType.getDirectChildren());
            }
            for (int i = 0; i < directChildren.size(); ++i) {
                Type childType = (Type)directChildren.get(i);
                this.searchType(childType, depth - 1, searchText, foundNodes, searchFilter);
            }
        }
    }

    private void checkAdd(Type currentType, Vector foundNodes) {
        if (!this._inclEdType) {
            if (!currentType.isEditingType()) {
                foundNodes.add(currentType);
            }
        } else {
            foundNodes.add(currentType);
        }
    }

    public void setRootType(Type type) {
        this._rootType = type;
    }

    public static DefaultTypeSearcher getDefault(Type type, int dir) {
        DefaultTypeSearcher searcher = new DefaultTypeSearcher(type);
        searcher.setSearchDirective(dir);
        return searcher;
    }

    public boolean isInclEdType() {
        return this._inclEdType;
    }

    public void setInclEdType(boolean edType) {
        this._inclEdType = edType;
    }

    public boolean isChoosenOnly() {
        return this._choosenOnly;
    }

    public void setChoosenOnly(boolean only) {
        this._choosenOnly = only;
    }
}

