/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.sql;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.IConnectionManager;
import com.jaxfront.core.util.io.IDBInfo;
import com.jaxfront.core.util.sql.SQLHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SQLProcessor {
    private IDBInfo _dbInfo;
    private String _user;
    private int _batchSize = 200;
    private boolean _doBatch = false;
    private int _batchCount = 0;
    private String _batchStmntSQL;
    private List<Object> _statementWorkList;
    private boolean _doCommit = true;
    private int overallCount = 0;

    public SQLProcessor(String user, IDBInfo dbInfo, boolean doBatch) {
        this._user = user;
        this._dbInfo = dbInfo;
        this._doBatch = doBatch;
    }

    public IDBInfo getDBInfo() {
        return this._dbInfo;
    }

    public String getUser() {
        return this._user;
    }

    public boolean isDoBatch() {
        return this._doBatch;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int size) {
        this._batchSize = size;
    }

    public int getBatchCount() {
        return this._batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] doUpdateInsert(IConnectionManager conMan, String sql) throws SQLException {
        int[] changes = null;
        Connection con = null;
        try {
            ++this.overallCount;
            PreparedStatement pStmnt = null;
            if (this.isDoBatch()) {
                this.addToWorklist(sql);
                ++this._batchCount;
                if (this.getBatchCount() >= this.getBatchSize()) {
                    con = conMan.getConnection(this.getClass().getName());
                    changes = this.performBatch(con);
                }
            } else {
                con = conMan.getConnection(this.getClass().getName());
                boolean wasAutoCommit = con.getAutoCommit();
                pStmnt = (PreparedStatement)this.createBatchStmnt(con, sql);
                int res = pStmnt.executeUpdate();
                changes = new int[]{res};
                SQLProcessor.closeStatement(pStmnt);
                if (this._doCommit || wasAutoCommit) {
                    this.commit(con);
                }
            }
            conMan.close(con);
            return changes;
        }
        catch (SQLException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
            throw e;
            catch (Exception e2) {
                LogRegistry.getInstance().error(this.getClass(), e2);
                return changes;
            }
        }
        finally {
            conMan.close(con);
        }
    }

    public synchronized int[] doUpdateInsert(Connection con, String sql) throws SQLException {
        int[] changes = null;
        try {
            ++this.overallCount;
            PreparedStatement pStmnt = null;
            if (this.isDoBatch()) {
                this.addToWorklist(sql);
                ++this._batchCount;
                if (this.getBatchCount() >= this.getBatchSize()) {
                    changes = this.performBatch(con);
                }
            } else {
                boolean wasAutoCommit = con.getAutoCommit();
                pStmnt = (PreparedStatement)this.createBatchStmnt(con, sql);
                int res = pStmnt.executeUpdate();
                changes = new int[]{res};
                SQLProcessor.closeStatement(pStmnt);
                if (this._doCommit || wasAutoCommit) {
                    this.commit(con);
                }
            }
        }
        catch (SQLException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
            throw e;
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return changes;
    }

    public void addToWorklist(Object workVal) {
        this.getStatementWorkList().add(workVal);
    }

    public void doInsert(Connection con, Object[] sqlSTMNTValues) throws SQLException {
        this.doUpdateInsertForObjArray(con, sqlSTMNTValues);
    }

    public void doInsert(IConnectionManager conMan, Object[] sqlSTMNTValues) throws SQLException {
        this.doUpdateInsertForObjArray(conMan, sqlSTMNTValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] doUpdateInsertForObjArray(IConnectionManager conMan, Object[] sqlSTMNTValues) throws SQLException {
        Connection con = null;
        ++this.overallCount;
        int[] changes = null;
        PreparedStatement pStmnt = null;
        try {
            if (this.isDoBatch()) {
                this.addToWorklist(sqlSTMNTValues);
                ++this._batchCount;
                if (this.getBatchCount() >= this.getBatchSize()) {
                    con = conMan.getConnection("SQLProcessor.doUpdateInserForObjArr");
                    changes = this.performBatch(con);
                }
            } else {
                con = conMan.getConnection("SQLProcessor.doUpdateInserForObjArr");
                boolean wasAutoCommit = con.getAutoCommit();
                pStmnt = (PreparedStatement)this.createBatchStmnt(con, this.getBatchStmntSQL());
                SQLHelper.addGenericToSQLPreparedStatement(pStmnt, sqlSTMNTValues);
                int res = conMan.queryUpdate(pStmnt);
                changes = new int[]{res};
                SQLProcessor.closeStatement(pStmnt);
                if (this._doCommit || wasAutoCommit) {
                    this.commit(con);
                }
            }
            conMan.close(con);
            return changes;
        }
        catch (SQLException e) {
            try {
                LogRegistry.getInstance().error(this.getClass(), e);
                throw e;
                catch (Exception e2) {
                    LogRegistry.getInstance().error(this.getClass(), e2);
                    conMan.close(con);
                    return changes;
                }
            }
            catch (Throwable throwable) {
                conMan.close(con);
                throw throwable;
            }
        }
    }

    public synchronized int[] doUpdateInsertForObjArray(Connection con, Object[] sqlSTMNTValues) throws SQLException {
        int[] changes = null;
        try {
            ++this.overallCount;
            PreparedStatement pStmnt = null;
            if (this.isDoBatch()) {
                this.addToWorklist(sqlSTMNTValues);
                ++this._batchCount;
                if (this.getBatchCount() >= this.getBatchSize()) {
                    changes = this.performBatch(con);
                }
            } else {
                boolean wasAutoCommit = con.getAutoCommit();
                pStmnt = (PreparedStatement)this.createBatchStmnt(con, this.getBatchStmntSQL());
                SQLHelper.addGenericToSQLPreparedStatement(pStmnt, sqlSTMNTValues);
                int res = pStmnt.executeUpdate();
                changes = new int[]{res};
                SQLProcessor.closeStatement(pStmnt);
                if (this._doCommit || wasAutoCommit) {
                    this.commit(con);
                }
            }
        }
        catch (SQLException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
            throw e;
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] performBatch(Connection con) throws SQLException {
        Statement pStmnt = null;
        boolean wasAutoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        int[] changes = null;
        try {
            pStmnt = this.createBatchStmnt(con, this.getBatchStmntSQL());
            for (int i = 0; i < this.getStatementWorkList().size(); ++i) {
                Object sqlSTMNTValues = this.getStatementWorkList().get(i);
                if (sqlSTMNTValues instanceof Object[]) {
                    ((PreparedStatement)pStmnt).clearParameters();
                    SQLHelper.addGenericToSQLPreparedStatement((PreparedStatement)pStmnt, (Object[])sqlSTMNTValues);
                    ((PreparedStatement)pStmnt).addBatch();
                    continue;
                }
                if (!(sqlSTMNTValues instanceof String)) continue;
                pStmnt.addBatch((String)sqlSTMNTValues);
            }
            changes = this.executeBatch(pStmnt);
            if (wasAutoCommit || this._doCommit) {
                this.commit(con);
            }
        }
        finally {
            if (wasAutoCommit) {
                con.setAutoCommit(wasAutoCommit);
            }
            SQLProcessor.closeStatement(pStmnt);
        }
        return changes;
    }

    private void commit(Connection con) throws SQLException {
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }

    public void setDoCommit(boolean doCommit) {
        this._doCommit = doCommit;
    }

    public synchronized int[] executeBatch(Statement batchStmnt) throws SQLException {
        if (batchStmnt != null) {
            int[] changes = batchStmnt.executeBatch();
            this.getStatementWorkList().clear();
            this._batchCount = 0;
            return changes;
        }
        return null;
    }

    public int[] release(Connection con) throws SQLException {
        int[] changes = null;
        if (this._batchStmntSQL != null) {
            changes = this.performBatch(con);
            this._batchStmntSQL = null;
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] release(IConnectionManager conMan) throws SQLException {
        int[] changes = null;
        Connection con = conMan.getConnection("sqlProc");
        try {
            if (this._batchStmntSQL != null) {
                changes = this.performBatch(con);
                this._batchStmntSQL = null;
            }
        }
        finally {
            conMan.close(con);
        }
        return changes;
    }

    public Statement createBatchStmnt(Connection con, String sql) throws SQLException {
        if (sql != null) {
            return con.prepareStatement(sql);
        }
        return con.createStatement();
    }

    public String getBatchStmntSQL() {
        return this._batchStmntSQL;
    }

    public void setBatchStmntSQL(String stmnt) {
        this._batchStmntSQL = stmnt;
    }

    public static void closeStatement(Statement aStatement) {
        block4: {
            if (aStatement != null) {
                try {
                    if (JAXFrontProperties.LOG_ENABLED) {
                        LogRegistry.getInstance().log(SQLProcessor.class, "close statement:" + aStatement.hashCode());
                    }
                    aStatement.close();
                }
                catch (SQLException e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block4;
                    LogRegistry.getInstance().warn(SQLProcessor.class, e.getLocalizedMessage());
                }
            }
        }
    }

    public List getStatementWorkList() {
        if (this._statementWorkList == null) {
            this._statementWorkList = new ArrayList<Object>();
        }
        return this._statementWorkList;
    }

    public int getOverallCount() {
        return this.overallCount;
    }
}

