/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.stringSearch;

import com.jaxfront.core.util.stringSearch.CharIntMap;
import com.jaxfront.core.util.stringSearch.StringSearch;

public class ShiftOr
extends StringSearch {
    public Object processBytes(byte[] pattern) {
        int i;
        int j = -1;
        int end = Math.min(pattern.length, 31);
        int[] t = new int[256];
        for (i = 0; i < t.length; ++i) {
            t[i] = j;
        }
        for (i = 0; i < end; ++i) {
            int n = this.index(pattern[i]);
            t[n] = t[n] & ~(1 << i);
        }
        return t;
    }

    public Object processChars(char[] pattern) {
        int end = Math.min(pattern.length, 31);
        CharIntMap m = this.createCharIntMap(pattern, -1);
        for (int i = 0; i < end; ++i) {
            m.set(pattern[i], m.get(pattern[i]) & ~(1 << i));
        }
        return m;
    }

    public int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        if (StringSearch.useNative) {
            if (processed instanceof int[]) {
                return this.nativeSearchBytes(text, textStart, textEnd, pattern, (int[])processed, pattern.length);
            }
            Object[] params = (Object[])processed;
            int[] t = (int[])params[0];
            int l = (Integer)params[1];
            return this.nativeSearchBytes(text, textStart, textEnd, pattern, t, l);
        }
        return this.javaSearchBytes(text, textStart, textEnd, pattern, processed);
    }

    private int javaSearchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        int[] t;
        int l = pattern.length;
        if (processed instanceof int[]) {
            t = (int[])processed;
        } else {
            Object[] params = (Object[])processed;
            t = (int[])params[0];
            l = (Integer)params[1];
        }
        int lim = ~((1 << l - 1) - 1);
        int state = -1;
        for (int i = textStart; i < textEnd; ++i) {
            if ((state = state << 1 | t[this.index(text[i])]) >= lim) continue;
            return i - l + 1;
        }
        return -1;
    }

    private native int nativeSearchBytes(byte[] var1, int var2, int var3, byte[] var4, int[] var5, int var6);

    public int searchChars(char[] text, int textStart, int textEnd, char[] pattern, Object processed) {
        CharIntMap m;
        int l = pattern.length;
        if (processed instanceof CharIntMap) {
            m = (CharIntMap)processed;
        } else {
            Object[] params = (Object[])processed;
            m = (CharIntMap)params[0];
            l = (Integer)params[1];
        }
        int lim = ~((1 << l - 1) - 1);
        int state = -1;
        for (int i = textStart; i < textEnd; ++i) {
            if ((state = state << 1 | m.get(text[i])) >= lim) continue;
            return i - l + 1;
        }
        return -1;
    }
}

